/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.repository.legacy;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.profileservice.spi.DeploymentRepository;
import org.jboss.profileservice.spi.DeploymentRepositoryFactory;
import org.jboss.profileservice.spi.NoSuchProfileException;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileRepository;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;
import org.jboss.profileservice.spi.metadata.ProfileSourceMetaData;

public class TypedProfileRepository
implements ProfileRepository {
    private Map<String, DeploymentRepositoryFactory> repositoryFactories = new ConcurrentHashMap<String, DeploymentRepositoryFactory>();
    private Map<ProfileKey, DeploymentRepository> repositories = new ConcurrentHashMap<ProfileKey, DeploymentRepository>();

    public Collection<ProfileKey> getProfileKeys() {
        return this.repositories.keySet();
    }

    public DeploymentRepository getProfileDeploymentRepository(ProfileKey key) throws NoSuchProfileException {
        DeploymentRepository repository = this.repositories.get(key);
        if (repository == null) {
            throw new NoSuchProfileException("No such repository for profile: " + key);
        }
        return repository;
    }

    public DeploymentRepository createProfileDeploymentRepository(ProfileKey key, ProfileMetaData metaData) throws Exception {
        if (metaData == null) {
            throw new IllegalArgumentException("Null metaData");
        }
        if (metaData.getName() == null) {
            throw new IllegalArgumentException("Null metaData name");
        }
        DeploymentRepository repository = this.repositories.get(key);
        if (repository == null) {
            String type = null;
            if (metaData.getSource() == null) {
                throw new IllegalStateException("No profile source.");
            }
            repository = this.createProfileDeploymentRepository(key, type, null);
            if (repository != null) {
                this.repositories.put(key, repository);
            }
        }
        return repository;
    }

    protected DeploymentRepository createProfileDeploymentRepository(ProfileKey key, String repositoryType, ProfileSourceMetaData metaData) throws Exception {
        DeploymentRepositoryFactory factory = this.repositoryFactories.get(repositoryType);
        if (factory == null) {
            throw new IllegalStateException("No registered factory for repository type: " + repositoryType);
        }
        return factory.createDeploymentRepository(key, metaData);
    }

    public void removeProfileDeploymentRepository(ProfileKey key) throws Exception, NoSuchProfileException {
        DeploymentRepository repository = this.repositories.remove(key);
        if (repository == null) {
            throw new NoSuchProfileException("No such repository for profile: " + key);
        }
        repository.remove();
    }

    public void addRepositoryFactory(DeploymentRepositoryFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Null factory.");
        }
        if (factory.getTypes() == null) {
            throw new IllegalArgumentException("Empty factory type.");
        }
        for (String type : factory.getTypes()) {
            this.repositoryFactories.put(type, factory);
        }
    }

    public void removeRepositoryFactory(DeploymentRepositoryFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Null factory.");
        }
        if (factory.getTypes() == null) {
            throw new IllegalArgumentException("Empty factory type.");
        }
        for (String type : factory.getTypes()) {
            this.repositoryFactories.remove(type);
        }
    }
}

