/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.persistent;

import java.util.HashMap;
import java.util.Map;
import org.apache.catalina.LifecycleException;
import org.jboss.logging.Logger;
import org.jboss.metadata.web.jboss.ReplicationGranularity;
import org.jboss.metadata.web.jboss.ReplicationTrigger;
import org.jboss.metadata.web.jboss.SnapshotMode;
import org.jboss.web.tomcat.service.session.JBossCacheManager;
import org.jboss.web.tomcat.service.session.OutdatedSessionChecker;
import org.jboss.web.tomcat.service.session.OwnedSessionUpdate;
import org.jboss.web.tomcat.service.session.distributedcache.spi.IncomingDistributableSessionData;
import org.jboss.web.tomcat.service.session.distributedcache.spi.OutgoingDistributableSessionData;
import org.jboss.web.tomcat.service.session.persistent.ExtendedDistributedCacheManager;
import org.jboss.web.tomcat.service.session.persistent.PersistentStore;
import org.jboss.web.tomcat.service.session.persistent.PersistentStoreDistributedCacheManagerFactory;
import org.jboss.web.tomcat.service.session.persistent.RDBMSStoreBase;
import org.jboss.web.tomcat.service.session.persistent.VersionBasedOutdatedSessionChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPersistentManager<P extends RDBMSStoreBase, O extends OutgoingDistributableSessionData>
extends JBossCacheManager<O> {
    private static final String info = "AbstractPersistentManager/1.0";
    protected static String name = "AbstractPersistentManager";
    private final P store;
    private String connectionName = null;
    private String connectionPassword = null;
    private String sessionTable = null;
    private String sessionAppCol = null;
    private String sessionIdCol = null;
    private String sessionFullIdCol = null;
    private String sessionCreationTimeCol = null;
    private String sessionMaxInactiveCol = null;
    private String sessionVersionCol = null;
    private String sessionLastAccessedCol = null;
    private String sessionNewCol = null;
    private String sessionValidCol = null;
    private String sessionMetadataCol = null;
    private String sessionAttributeCol = null;
    private Integer cleanupInterval = null;
    private Logger log = Logger.getLogger(this.getClass());

    public AbstractPersistentManager(P store) {
        super(new PersistentStoreDistributedCacheManagerFactory((PersistentStore)store));
        this.store = store;
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public String getName() {
        return name;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public void setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
    }

    public String getSessionTable() {
        return this.sessionTable;
    }

    public void setSessionTable(String sessionTable) {
        this.sessionTable = sessionTable;
    }

    public String getSessionAppCol() {
        return this.sessionAppCol;
    }

    public void setSessionAppCol(String sessionAppCol) {
        this.sessionAppCol = sessionAppCol;
    }

    public String getSessionIdCol() {
        return this.sessionIdCol;
    }

    public void setSessionIdCol(String sessionIdCol) {
        this.sessionIdCol = sessionIdCol;
    }

    public String getSessionFullIdCol() {
        return this.sessionFullIdCol;
    }

    public void setSessionFullIdCol(String sessionFullIdCol) {
        this.sessionFullIdCol = sessionFullIdCol;
    }

    public String getSessionCreationTimeCol() {
        return this.sessionCreationTimeCol;
    }

    public void setSessionCreationTimeCol(String sessionCreationTimeCol) {
        this.sessionCreationTimeCol = sessionCreationTimeCol;
    }

    public String getSessionMaxInactiveCol() {
        return this.sessionMaxInactiveCol;
    }

    public void setSessionMaxInactiveCol(String sessionMaxInactiveCol) {
        this.sessionMaxInactiveCol = sessionMaxInactiveCol;
    }

    public String getSessionVersionCol() {
        return this.sessionVersionCol;
    }

    public void setSessionVersionCol(String sessionVersionCol) {
        this.sessionVersionCol = sessionVersionCol;
    }

    public String getSessionLastAccessedCol() {
        return this.sessionLastAccessedCol;
    }

    public void setSessionLastAccessedCol(String sessionLastAccessedCol) {
        this.sessionLastAccessedCol = sessionLastAccessedCol;
    }

    public String getSessionNewCol() {
        return this.sessionNewCol;
    }

    public void setSessionNewCol(String sessionNewCol) {
        this.sessionNewCol = sessionNewCol;
    }

    public String getSessionValidCol() {
        return this.sessionValidCol;
    }

    public void setSessionValidCol(String sessionValidCol) {
        this.sessionValidCol = sessionValidCol;
    }

    public String getSessionMetadataCol() {
        return this.sessionMetadataCol;
    }

    public void setSessionMetadataCol(String sessionMetadataCol) {
        this.sessionMetadataCol = sessionMetadataCol;
    }

    public String getSessionAttributeCol() {
        return this.sessionAttributeCol;
    }

    public void setSessionAttributeCol(String sessionAttributeCol) {
        this.sessionAttributeCol = sessionAttributeCol;
    }

    public Integer getCleanupInterval() {
        return this.cleanupInterval;
    }

    public void setCleanupInterval(Integer cleanupInterval) {
        this.cleanupInterval = cleanupInterval;
    }

    @Override
    public void setReplicationGranularity(ReplicationGranularity granularity) {
        switch (granularity) {
            case SESSION: {
                super.setReplicationGranularity(granularity);
                break;
            }
            default: {
                this.log.warn((Object)("Ignoring call to set replication granularity to " + granularity + " -- only " + ReplicationGranularity.SESSION + " is supported"));
            }
        }
    }

    @Override
    public void start() throws LifecycleException {
        this.configureStore();
        super.start();
    }

    protected P getPersistentStore() {
        return this.store;
    }

    @Override
    protected void configureUnembedded() throws LifecycleException {
        if (this.getReplicationGranularity() == null) {
            this.setReplicationGranularity(ReplicationGranularity.SESSION);
        }
        if (this.getReplicationTrigger() == null) {
            this.setReplicationTrigger(ReplicationTrigger.SET_AND_NON_PRIMITIVE_GET);
        }
        if (this.isReplicationFieldBatchMode() == null) {
            this.setReplicationFieldBatchMode(false);
        }
        if (this.getSnapshotMode() == null) {
            this.setSnapshotMode(SnapshotMode.INSTANT);
        }
    }

    protected void configureStore() {
        ((RDBMSStoreBase)this.store).setName(this.getContextName());
        ((RDBMSStoreBase)this.store).setMaxUnreplicatedInterval(this.getMaxUnreplicatedInterval());
        if (this.getConnectionName() != null) {
            ((RDBMSStoreBase)this.store).setConnectionName(this.getConnectionName());
        }
        if (this.getConnectionPassword() != null) {
            ((RDBMSStoreBase)this.store).setConnectionPassword(this.getConnectionPassword());
        }
        if (this.getSessionAppCol() != null) {
            ((RDBMSStoreBase)this.store).setSessionAppCol(this.getSessionAppCol());
        }
        if (this.getSessionAttributeCol() != null) {
            ((RDBMSStoreBase)this.store).setSessionAttributeCol(this.getSessionAttributeCol());
        }
        if (this.getSessionCreationTimeCol() != null) {
            ((RDBMSStoreBase)this.store).setSessionCreationTimeCol(this.getSessionCreationTimeCol());
        }
        if (this.getSessionFullIdCol() != null) {
            ((RDBMSStoreBase)this.store).setSessionFullIdCol(this.getSessionFullIdCol());
        }
        if (this.getSessionIdCol() != null) {
            ((RDBMSStoreBase)this.store).setSessionIdCol(this.getSessionIdCol());
        }
        if (this.getSessionLastAccessedCol() != null) {
            ((RDBMSStoreBase)this.store).setSessionLastAccessedCol(this.getSessionLastAccessedCol());
        }
        if (this.getSessionMaxInactiveCol() != null) {
            ((RDBMSStoreBase)this.store).setSessionMaxInactiveCol(this.getSessionMaxInactiveCol());
        }
        if (this.getSessionMetadataCol() != null) {
            ((RDBMSStoreBase)this.store).setSessionMetadataCol(this.getSessionMetadataCol());
        }
        if (this.getSessionNewCol() != null) {
            ((RDBMSStoreBase)this.store).setSessionNewCol(this.getSessionNewCol());
        }
        if (this.getSessionTable() != null) {
            ((RDBMSStoreBase)this.store).setSessionTable(this.getSessionTable());
        }
        if (this.getSessionValidCol() != null) {
            ((RDBMSStoreBase)this.store).setSessionValidCol(this.getSessionValidCol());
        }
        if (this.getSessionVersionCol() != null) {
            ((RDBMSStoreBase)this.store).setSessionVersionCol(this.getSessionVersionCol());
        }
        if (this.getCleanupInterval() != null) {
            ((RDBMSStoreBase)this.store).setCleanupInterval(this.getCleanupInterval());
        }
    }

    @Override
    protected Map<String, OwnedSessionUpdate> getUnloadedSessions() {
        Map<String, OwnedSessionUpdate> map = super.getUnloadedSessions();
        HashMap<String, OwnedSessionUpdate> processed = new HashMap<String, OwnedSessionUpdate>();
        for (Map.Entry<String, OwnedSessionUpdate> entry : map.entrySet()) {
            String realId = entry.getKey();
            OwnedSessionUpdate existing = entry.getValue();
            Long timestamp = ((RDBMSStoreBase)this.store).getSessionTimestamp(realId);
            if (timestamp != null && existing.getUpdateTime() != timestamp.longValue()) {
                IncomingDistributableSessionData data = ((RDBMSStoreBase)this.store).getSessionData(entry.getKey(), false);
                if (data != null) {
                    OwnedSessionUpdate updated = new OwnedSessionUpdate(existing.getOwner(), data.getTimestamp(), data.getMetadata().getMaxInactiveInterval(), existing.isPassivated());
                    processed.put(realId, updated);
                    continue;
                }
                processed.put(realId, existing);
                continue;
            }
            processed.put(realId, existing);
        }
        return processed;
    }

    @Override
    protected void initializeUnloadedSessions() {
    }

    @Override
    protected OutdatedSessionChecker initOutdatedSessionChecker() {
        return new VersionBasedOutdatedSessionChecker((ExtendedDistributedCacheManager)this.getDistributedCacheManager());
    }

    @Override
    protected void processExpirationPassivation() {
        super.processExpirationPassivation();
        ((RDBMSStoreBase)this.store).processExpires();
    }
}

