/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.spi.helpers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.logging.Logger;
import org.jboss.scanning.spi.ScanningHandle;
import org.jboss.scanning.spi.ScanningPlugin;
import org.jboss.scanning.spi.helpers.AbstractScanner;
import org.jboss.scanning.spi.helpers.AllResourceFilter;
import org.jboss.scanning.spi.helpers.ScanningPluginWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UrlScanner
extends AbstractScanner {
    private Logger log = Logger.getLogger(this.getClass());
    private URL[] roots;
    private boolean ignoreIndexedHandles;
    private boolean ignoreRuntimeScanning;

    protected UrlScanner(URL ... roots) {
        if (roots == null) {
            throw new IllegalArgumentException("Null roots");
        }
        this.roots = roots;
    }

    protected URL[] getRoots() {
        return this.roots;
    }

    public abstract boolean doScan();

    @Override
    public void scan() throws Exception {
        if (this.doScan()) {
            HashSet<ScanningPlugin> federatedPlugins = new HashSet<ScanningPlugin>();
            for (ScanningPlugin plugin : this.getPlugins()) {
                ScanningHandle handle = this.createHandle(plugin);
                ScanningPluginWrapper wrapper = new ScanningPluginWrapper(plugin);
                federatedPlugins.add(wrapper);
                if (this.ignoreIndexedHandles) continue;
                String fileName = plugin.getFileName();
                for (URL root : this.roots) {
                    InputStream is = this.getInputStream(root, "META-INF/" + fileName);
                    if (is == null) continue;
                    ScanningHandle pre = plugin.readHandle(is);
                    handle.merge(pre);
                    wrapper.addURL(root);
                }
            }
            if (!this.ignoreRuntimeScanning && !federatedPlugins.isEmpty()) {
                this.scan(federatedPlugins);
            }
        }
    }

    protected ResourceFilter[] getRecurseFilters(ScanningPlugin[] plugins) {
        boolean explicitFilter = false;
        ResourceFilter[] recurseFilters = new ResourceFilter[plugins.length];
        for (int i = 0; i < plugins.length; ++i) {
            ResourceFilter filter = plugins[i].getRecurseFilter();
            recurseFilters[i] = filter != null ? filter : AllResourceFilter.INSTANCE;
            explicitFilter |= filter != null;
        }
        return explicitFilter ? recurseFilters : null;
    }

    protected abstract void scan(Set<ScanningPlugin> var1) throws Exception;

    protected InputStream getInputStream(URL url, String key) {
        try {
            String urlString = url.toExternalForm();
            if (!urlString.endsWith("/")) {
                urlString = urlString + "/";
            }
            urlString = urlString + key;
            URL scanURL = new URL(urlString);
            return scanURL.openStream();
        }
        catch (IOException e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Cannot access scanning .mcs file: " + e));
            }
            return null;
        }
    }

    protected abstract ScanningHandle createHandle(ScanningPlugin var1);

    public void setIgnoreIndexedHandles(boolean ignoreIndexedHandles) {
        this.ignoreIndexedHandles = ignoreIndexedHandles;
    }

    public void setIgnoreRuntimeScanning(boolean ignoreRuntimeScanning) {
        this.ignoreRuntimeScanning = ignoreRuntimeScanning;
    }
}

