/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist.metrics;

import org.jboss.reflect.plugins.javassist.JavassistField;
import org.jboss.reflect.plugins.javassist.metrics.Metrics;

public class MetricsJavassistField
extends Metrics
implements JavassistField {
    private final JavassistField delegate;

    public MetricsJavassistField(JavassistField delegate, String sig) {
        super(sig + MetricsJavassistField.getDelegateType(delegate));
        if (delegate == null) {
            throw new IllegalArgumentException("Null delegate");
        }
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object target) throws Throwable {
        long start = System.currentTimeMillis();
        try {
            Object object = this.delegate.get(target);
            return object;
        }
        finally {
            this.recordTime(System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Object target, Object value) throws Throwable {
        long start = System.currentTimeMillis();
        try {
            this.delegate.set(target, value);
        }
        finally {
            this.recordTime(System.currentTimeMillis() - start);
        }
    }
}

