/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classpool.plugins.jbosscl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javassist.ClassPool;
import org.jboss.classloading.spi.dependency.ClassLoading;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classpool.scoped.ScopedClassPool;
import org.jboss.classpool.spi.ClassLoaderRegistryHandler;
import org.jboss.logging.Logger;

class JBossClRegistryHandler
implements ClassLoaderRegistryHandler {
    private final Logger log = Logger.getLogger(JBossClRegistryHandler.class);
    private ClassLoaderRegistryHandler successor;
    private static final JBossClRegistryHandler instance = new JBossClRegistryHandler();
    protected Map<Module, ScopedClassPool> registeredModules = Collections.synchronizedMap(new WeakHashMap());

    JBossClRegistryHandler() {
    }

    public static JBossClRegistryHandler getInstance() {
        return instance;
    }

    public ClassPool registerClassLoader(ClassLoader classLoader) {
        ScopedClassPool classPool = (ScopedClassPool)this.successor.registerClassLoader(classLoader);
        if (classPool == null) {
            this.successor.unregisterClassLoader(classLoader);
        } else {
            Module module = this.getModuleForClassLoader(classLoader);
            this.registeredModules.put(module, classPool);
        }
        return classPool;
    }

    public void unregisterClassLoader(ClassLoader classLoader, Module module) {
        ScopedClassPool classPool = this.registeredModules.remove(module);
        if (classLoader == null) {
            if (classPool == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.warn((Object)("Module " + module + " is not registered"));
                }
                return;
            }
            classPool.close();
        } else {
            this.unregisterClassLoader(classLoader);
        }
    }

    private Module getModuleForClassLoader(final ClassLoader classLoader) {
        return AccessController.doPrivileged(new PrivilegedAction<Module>(){

            @Override
            public Module run() {
                return ClassLoading.getModuleForClassLoader((ClassLoader)classLoader);
            }
        });
    }

    public void setSuccessor(ClassLoaderRegistryHandler handler) {
        this.successor = handler;
    }

    public void unregisterClassLoader(ClassLoader classLoader) {
        this.successor.unregisterClassLoader(classLoader);
    }
}

