/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.Pipe;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.Option;
import org.jboss.xnio.channels.StreamSinkChannel;
import org.jboss.xnio.nio.NioHandle;
import org.jboss.xnio.nio.NioXnio;
import org.jboss.xnio.nio.SelectorUtils;

final class NioPipeSinkChannel
implements StreamSinkChannel {
    private final Pipe.SinkChannel channel;
    private final NioHandle handle;
    private final NioXnio nioXnio;
    private final AtomicBoolean callFlag = new AtomicBoolean(false);
    private final AtomicLong bytes;
    private final AtomicLong messages;
    private final Closeable mbeanHandle;
    private volatile ChannelListener<? super StreamSinkChannel> writeListener = null;
    private volatile ChannelListener<? super StreamSinkChannel> closeListener = null;
    private static final AtomicReferenceFieldUpdater<NioPipeSinkChannel, ChannelListener> writeListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(NioPipeSinkChannel.class, ChannelListener.class, "writeListener");
    private static final AtomicReferenceFieldUpdater<NioPipeSinkChannel, ChannelListener> closeListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(NioPipeSinkChannel.class, ChannelListener.class, "closeListener");
    private final ChannelListener.Setter<StreamSinkChannel> writeSetter = IoUtils.getSetter((Object)this, writeListenerUpdater);
    private final ChannelListener.Setter<StreamSinkChannel> closeSetter = IoUtils.getSetter((Object)this, closeListenerUpdater);

    NioPipeSinkChannel(Pipe.SinkChannel channel, NioXnio nioXnio, AtomicLong bytes, AtomicLong messages, Closeable mbeanHandle) throws IOException {
        this.channel = channel;
        this.nioXnio = nioXnio;
        this.bytes = bytes;
        this.messages = messages;
        this.mbeanHandle = mbeanHandle;
        this.handle = nioXnio.addWriteHandler(channel, new Handler());
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, this.channel);
    }

    public ChannelListener.Setter<StreamSinkChannel> getWriteSetter() {
        return this.writeSetter;
    }

    public ChannelListener.Setter<StreamSinkChannel> getCloseSetter() {
        return this.closeSetter;
    }

    public boolean flush() throws IOException {
        return true;
    }

    public int write(ByteBuffer dst) throws IOException {
        int ret = this.channel.write(dst);
        if (ret > 0) {
            this.bytes.addAndGet(ret);
            this.messages.incrementAndGet();
        }
        return ret;
    }

    public long write(ByteBuffer[] dsts) throws IOException {
        long ret = this.channel.write(dsts);
        if (ret > 0L) {
            this.bytes.addAndGet(ret);
            this.messages.incrementAndGet();
        }
        return ret;
    }

    public long write(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long ret = this.channel.write(dsts, offset, length);
        if (ret > 0L) {
            this.bytes.addAndGet(ret);
            this.messages.incrementAndGet();
        }
        return ret;
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void close() throws IOException {
        if (!this.callFlag.getAndSet(true)) {
            this.nioXnio.removeManaged((Closeable)((Object)this));
            IoUtils.safeClose((Closeable)this.mbeanHandle);
            IoUtils.invokeChannelListener((Channel)((Object)this), this.closeListener);
            this.channel.close();
        }
    }

    public void suspendWrites() {
        try {
            this.handle.suspend();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void resumeWrites() {
        try {
            this.handle.resume(4);
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public boolean shutdownWrites() throws IOException {
        this.close();
        return true;
    }

    public void awaitWritable() throws IOException {
        SelectorUtils.await(this.nioXnio, this.channel, 4);
    }

    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.nioXnio, this.channel, 4, time, timeUnit);
    }

    public boolean supportsOption(Option<?> option) {
        return false;
    }

    public <T> T getOption(Option<T> option) throws IOException {
        return null;
    }

    public <T> NioPipeSinkChannel setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return this;
    }

    public String toString() {
        return String.format("pipe sink channel (NIO) <%s>", Integer.toString(this.hashCode(), 16));
    }

    private final class Handler
    implements Runnable {
        private Handler() {
        }

        @Override
        public void run() {
            IoUtils.invokeChannelListener((Channel)((Object)NioPipeSinkChannel.this), (ChannelListener)NioPipeSinkChannel.this.writeListener);
        }
    }
}

