/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.heks.businessobject;

import java.io.Serializable;
import org.jboss.ejb3.core.businessobject.BusinessObjectFactory;
import org.jboss.ejb3.heks.businessobject.ViewType;
import org.jboss.ejb3.session.SessionContainer;

public abstract class AbstractBusinessObjectFactory
implements BusinessObjectFactory {
    public <B> B createBusinessObject(SessionContainer container, Serializable sessionId, Class<B> businessInterface) throws IllegalStateException {
        ViewType type = this.getViewType(container, businessInterface);
        switch (type) {
            case NO_INTERFACE: {
                return this.createNoInterfaceView(container, sessionId, businessInterface);
            }
            case LOCAL: 
            case REMOTE: {
                return this.createLegacyBusinessObject(container, sessionId, businessInterface, type);
            }
        }
        throw new IllegalStateException("Can't find a view for interface " + businessInterface + " on " + container);
    }

    protected abstract <B> B createLegacyBusinessObject(SessionContainer var1, Serializable var2, Class<B> var3, ViewType var4);

    protected abstract <B> B createNoInterfaceView(SessionContainer var1, Serializable var2, Class<B> var3);

    protected abstract ViewType getViewType(SessionContainer var1, Class<?> var2);
}

