/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.myfaces.shared_impl.renderkit.RendererUtils;
import org.apache.myfaces.shared_impl.util.MyFacesObjectInputStream;

class DefaultFaceletsStateManagementHelper {
    private static final Logger log = Logger.getLogger(DefaultFaceletsStateManagementHelper.class.getName());
    private static final String SERIALIZED_VIEW_SESSION_ATTR = DefaultFaceletsStateManagementHelper.class.getName() + ".SERIALIZED_VIEW";
    public static final String SERIALIZED_VIEW_REQUEST_ATTR = DefaultFaceletsStateManagementHelper.class.getName() + ".SERIALIZED_VIEW";
    private static final String RESTORED_SERIALIZED_VIEW_REQUEST_ATTR = DefaultFaceletsStateManagementHelper.class.getName() + ".RESTORED_SERIALIZED_VIEW";
    private static final String NUMBER_OF_VIEWS_IN_SESSION_PARAM = "org.apache.myfaces.NUMBER_OF_VIEWS_IN_SESSION";
    private static final int DEFAULT_NUMBER_OF_VIEWS_IN_SESSION = 20;
    private static final String SERIALIZE_STATE_IN_SESSION_PARAM = "org.apache.myfaces.SERIALIZE_STATE_IN_SESSION";
    private static final String COMPRESS_SERVER_STATE_PARAM = "org.apache.myfaces.COMPRESS_STATE_IN_SESSION";
    private static final boolean DEFAULT_COMPRESS_SERVER_STATE_PARAM = true;
    private static final boolean DEFAULT_SERIALIZE_STATE_IN_SESSION = true;
    private static final String CACHE_OLD_VIEWS_IN_SESSION_MODE = "org.apache.myfaces.CACHE_OLD_VIEWS_IN_SESSION_MODE";
    private static final String CACHE_OLD_VIEWS_IN_SESSION_MODE_HARD_SOFT = "hard-soft";
    private static final String CACHE_OLD_VIEWS_IN_SESSION_MODE_SOFT = "soft";
    private static final String CACHE_OLD_VIEWS_IN_SESSION_MODE_SOFT_WEAK = "soft-weak";
    private static final String CACHE_OLD_VIEWS_IN_SESSION_MODE_WEAK = "weak";
    private static final String CACHE_OLD_VIEWS_IN_SESSION_MODE_OFF = "off";
    private static final int UNCOMPRESSED_FLAG = 0;
    private static final int COMPRESSED_FLAG = 1;
    private static final int JSF_SEQUENCE_INDEX = 0;

    DefaultFaceletsStateManagementHelper() {
    }

    protected Integer getServerStateId(Object[] state) {
        Object serverStateId;
        if (state != null && (serverStateId = state[0]) != null) {
            return Integer.valueOf((String)serverStateId, 36);
        }
        return null;
    }

    protected void saveSerializedViewInServletSession(FacesContext context, Object serializedView) {
        Map sessionMap = context.getExternalContext().getSessionMap();
        SerializedViewCollection viewCollection = (SerializedViewCollection)sessionMap.get(SERIALIZED_VIEW_SESSION_ATTR);
        if (viewCollection == null) {
            viewCollection = new SerializedViewCollection();
            sessionMap.put(SERIALIZED_VIEW_SESSION_ATTR, viewCollection);
        }
        viewCollection.add(context, this.serializeView(context, serializedView));
        sessionMap.put(SERIALIZED_VIEW_SESSION_ATTR, viewCollection);
    }

    protected Object getSerializedViewFromServletSession(FacesContext context, String viewId, Integer sequence) {
        ExternalContext externalContext = context.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        Object serializedView = null;
        if (requestMap.containsKey(RESTORED_SERIALIZED_VIEW_REQUEST_ATTR)) {
            serializedView = requestMap.get(RESTORED_SERIALIZED_VIEW_REQUEST_ATTR);
        } else {
            Object state;
            SerializedViewCollection viewCollection = (SerializedViewCollection)externalContext.getSessionMap().get(SERIALIZED_VIEW_SESSION_ATTR);
            if (viewCollection != null && sequence != null && (state = viewCollection.get(sequence, viewId)) != null) {
                serializedView = this.deserializeView(state);
            }
            requestMap.put(RESTORED_SERIALIZED_VIEW_REQUEST_ATTR, serializedView);
            this.nextViewSequence(context);
        }
        return serializedView;
    }

    protected int getNextViewSequence(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        if (!externalContext.getRequestMap().containsKey("jsf_sequence")) {
            this.nextViewSequence(context);
        }
        Integer sequence = (Integer)externalContext.getRequestMap().get("jsf_sequence");
        return sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void nextViewSequence(FacesContext facescontext) {
        Object sessionObj;
        ExternalContext externalContext = facescontext.getExternalContext();
        Object object = sessionObj = externalContext.getSession(true);
        synchronized (object) {
            Map map = externalContext.getSessionMap();
            Integer sequence = (Integer)map.get("jsf_sequence");
            sequence = sequence == null || sequence == Integer.MAX_VALUE ? Integer.valueOf(1) : Integer.valueOf(sequence + 1);
            map.put("jsf_sequence", sequence);
            externalContext.getRequestMap().put("jsf_sequence", sequence);
        }
    }

    protected Object serializeView(FacesContext context, Object serializedView) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Entering serializeView");
        }
        if (this.isSerializeStateInSession(context)) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Processing serializeView - serialize state in session");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            try {
                OutputStream os = baos;
                if (this.isCompressStateInSession(context)) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Processing serializeView - serialize compressed");
                    }
                    ((OutputStream)os).write(1);
                    os = new GZIPOutputStream(os, 1024);
                } else {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Processing serializeView - serialize uncompressed");
                    }
                    ((OutputStream)os).write(0);
                }
                Object[] stateArray = (Object[])serializedView;
                ObjectOutputStream out = new ObjectOutputStream(os);
                out.writeObject(stateArray[0]);
                out.writeObject(stateArray[1]);
                out.close();
                baos.close();
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Exiting serializeView - serialized. Bytes : " + baos.size());
                }
                return baos.toByteArray();
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Exiting serializeView - Could not serialize state: " + e.getMessage(), e);
                return null;
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Exiting serializeView - do not serialize state in session.");
        }
        return serializedView;
    }

    protected boolean isSerializeStateInSession(FacesContext context) {
        String value = context.getExternalContext().getInitParameter(SERIALIZE_STATE_IN_SESSION_PARAM);
        boolean serialize = true;
        if (value != null) {
            serialize = Boolean.valueOf(value);
        }
        return serialize;
    }

    protected boolean isCompressStateInSession(FacesContext context) {
        String value = context.getExternalContext().getInitParameter(COMPRESS_SERVER_STATE_PARAM);
        boolean compress = true;
        if (value != null) {
            compress = Boolean.valueOf(value);
        }
        return compress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object deserializeView(Object state) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Entering deserializeView");
        }
        if (state instanceof byte[]) {
            Object[] objectArray;
            block15: {
                ByteArrayInputStream bais;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Processing deserializeView - deserializing serialized state. Bytes : " + ((byte[])state).length);
                }
                InputStream is = bais = new ByteArrayInputStream((byte[])state);
                if (((InputStream)is).read() == 1) {
                    is = new GZIPInputStream(is);
                }
                MyFacesObjectInputStream ois = null;
                try {
                    MyFacesObjectInputStream in;
                    ois = in = new MyFacesObjectInputStream(is);
                    Object[] object = null;
                    object = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedExceptionAction<Object[]>(){

                        @Override
                        public Object[] run() throws PrivilegedActionException, IOException, ClassNotFoundException {
                            return new Object[]{in.readObject(), in.readObject()};
                        }
                    }) : new Object[]{in.readObject(), in.readObject()};
                    objectArray = object;
                    if (ois == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (ois != null) {
                            ois.close();
                            ois = null;
                        }
                        throw throwable;
                    }
                    catch (PrivilegedActionException e) {
                        log.log(Level.SEVERE, "Exiting deserializeView - Could not deserialize state: " + e.getMessage(), e);
                        return null;
                    }
                    catch (IOException e) {
                        log.log(Level.SEVERE, "Exiting deserializeView - Could not deserialize state: " + e.getMessage(), e);
                        return null;
                    }
                    catch (ClassNotFoundException e) {
                        log.log(Level.SEVERE, "Exiting deserializeView - Could not deserialize state: " + e.getMessage(), e);
                        return null;
                    }
                }
                ois.close();
                ois = null;
            }
            return objectArray;
        }
        if (state instanceof Object[]) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Exiting deserializeView - state not serialized.");
            }
            return state;
        }
        if (state == null) {
            log.severe("Exiting deserializeView - this method should not be called with a null-state.");
            return null;
        }
        log.severe("Exiting deserializeView - this method should not be called with a state of type : " + state.getClass());
        return null;
    }

    protected static class SerializedViewKey
    implements Serializable {
        private static final long serialVersionUID = -1170697124386063642L;
        private final String _viewId;
        private final Integer _sequenceId;

        public SerializedViewKey(String viewId, Integer sequence) {
            this._sequenceId = sequence;
            this._viewId = viewId;
        }

        public SerializedViewKey(FacesContext context) {
            this._sequenceId = RendererUtils.getViewSequence(context);
            this._viewId = context.getViewRoot().getViewId();
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this._sequenceId == null ? 0 : this._sequenceId.hashCode());
            result = 31 * result + (this._viewId == null ? 0 : this._viewId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SerializedViewKey other = (SerializedViewKey)obj;
            if (this._sequenceId == null ? other._sequenceId != null : !this._sequenceId.equals(other._sequenceId)) {
                return false;
            }
            return !(this._viewId == null ? other._viewId != null : !this._viewId.equals(other._viewId));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SerializedViewCollection
    implements Serializable {
        private static final long serialVersionUID = -3734849062185115847L;
        private final List<Object> _keys = new ArrayList<Object>(20);
        private final Map<Object, Object> _serializedViews = new HashMap<Object, Object>();
        private transient Map<Object, Object> _oldSerializedViews = null;

        protected SerializedViewCollection() {
        }

        public synchronized void add(FacesContext context, Object state) {
            Object key = new SerializedViewKey(context);
            this._serializedViews.put(key, state);
            while (this._keys.remove(key)) {
            }
            this._keys.add(key);
            int views = this.getNumberOfViewsInSession(context);
            while (this._keys.size() > views) {
                key = this._keys.remove(0);
                Object oldView = this._serializedViews.remove(key);
                if (oldView == null || DefaultFaceletsStateManagementHelper.CACHE_OLD_VIEWS_IN_SESSION_MODE_OFF.equals(this.getCacheOldViewsInSessionMode(context))) continue;
                this.getOldSerializedViewsMap().put(key, oldView);
            }
        }

        protected int getNumberOfViewsInSession(FacesContext context) {
            String value = context.getExternalContext().getInitParameter(DefaultFaceletsStateManagementHelper.NUMBER_OF_VIEWS_IN_SESSION_PARAM);
            int views = 20;
            if (value != null) {
                try {
                    views = Integer.parseInt(value);
                    if (views <= 0) {
                        log.severe("Configured value for org.apache.myfaces.NUMBER_OF_VIEWS_IN_SESSION is not valid, must be an value > 0, using default value (20");
                        views = 20;
                    }
                }
                catch (Throwable e) {
                    log.log(Level.SEVERE, "Error determining the value for org.apache.myfaces.NUMBER_OF_VIEWS_IN_SESSION, expected an integer value > 0, using default value (20): " + e.getMessage(), e);
                }
            }
            return views;
        }

        protected Map<Object, Object> getOldSerializedViewsMap() {
            FacesContext context = FacesContext.getCurrentInstance();
            if (this._oldSerializedViews == null && context != null) {
                String cacheMode = this.getCacheOldViewsInSessionMode(context);
                if (DefaultFaceletsStateManagementHelper.CACHE_OLD_VIEWS_IN_SESSION_MODE_WEAK.equals(cacheMode)) {
                    this._oldSerializedViews = new ReferenceMap(2, 2, true);
                } else if (DefaultFaceletsStateManagementHelper.CACHE_OLD_VIEWS_IN_SESSION_MODE_SOFT_WEAK.equals(cacheMode)) {
                    this._oldSerializedViews = new ReferenceMap(1, 2, true);
                } else if (DefaultFaceletsStateManagementHelper.CACHE_OLD_VIEWS_IN_SESSION_MODE_SOFT.equals(cacheMode)) {
                    this._oldSerializedViews = new ReferenceMap(1, 1, true);
                } else if (DefaultFaceletsStateManagementHelper.CACHE_OLD_VIEWS_IN_SESSION_MODE_HARD_SOFT.equals(cacheMode)) {
                    this._oldSerializedViews = new ReferenceMap(0, 1);
                }
            }
            return this._oldSerializedViews;
        }

        protected String getCacheOldViewsInSessionMode(FacesContext context) {
            String value = context.getExternalContext().getInitParameter(DefaultFaceletsStateManagementHelper.CACHE_OLD_VIEWS_IN_SESSION_MODE);
            if (value == null) {
                return DefaultFaceletsStateManagementHelper.CACHE_OLD_VIEWS_IN_SESSION_MODE_OFF;
            }
            if (value.equalsIgnoreCase(DefaultFaceletsStateManagementHelper.CACHE_OLD_VIEWS_IN_SESSION_MODE_SOFT)) {
                return DefaultFaceletsStateManagementHelper.CACHE_OLD_VIEWS_IN_SESSION_MODE_SOFT;
            }
            if (value.equalsIgnoreCase(DefaultFaceletsStateManagementHelper.CACHE_OLD_VIEWS_IN_SESSION_MODE_SOFT_WEAK)) {
                return DefaultFaceletsStateManagementHelper.CACHE_OLD_VIEWS_IN_SESSION_MODE_SOFT_WEAK;
            }
            if (value.equalsIgnoreCase(DefaultFaceletsStateManagementHelper.CACHE_OLD_VIEWS_IN_SESSION_MODE_WEAK)) {
                return DefaultFaceletsStateManagementHelper.CACHE_OLD_VIEWS_IN_SESSION_MODE_WEAK;
            }
            if (value.equalsIgnoreCase(DefaultFaceletsStateManagementHelper.CACHE_OLD_VIEWS_IN_SESSION_MODE_HARD_SOFT)) {
                return DefaultFaceletsStateManagementHelper.CACHE_OLD_VIEWS_IN_SESSION_MODE_HARD_SOFT;
            }
            return DefaultFaceletsStateManagementHelper.CACHE_OLD_VIEWS_IN_SESSION_MODE_OFF;
        }

        public Object get(Integer sequence, String viewId) {
            Map<Object, Object> oldSerializedViewMap;
            SerializedViewKey key = new SerializedViewKey(viewId, sequence);
            Object value = this._serializedViews.get(key);
            if (value == null && (oldSerializedViewMap = this.getOldSerializedViewsMap()) != null) {
                value = oldSerializedViewMap.get(key);
            }
            return value;
        }
    }
}

