/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;

public final class ServiceURI {
    public static final String SCHEME = "jrs";
    private static final Pattern VALID_SERVICE_TYPE = Pattern.compile("^(?:[_a-z][_a-z0-9]*)(?:\\.[_a-z][_a-z0-9]*)*$", 2);
    private static final Pattern VALID_GROUP_NAME = Pattern.compile("^(?:[_a-z0-9]+)(?:\\.[_a-z0-9]+)*$", 2);
    private static final Pattern VALID_ENDPOINT_NAME = VALID_SERVICE_TYPE;

    private ServiceURI() {
    }

    public static boolean isRemotingServiceUri(URI uri) {
        return SCHEME.equals(uri.getScheme()) && uri.isOpaque();
    }

    public static String getServiceType(URI uri) throws IllegalArgumentException {
        if (!ServiceURI.isRemotingServiceUri(uri)) {
            throw new IllegalArgumentException("Not a valid remoting service URI");
        }
        String ssp = uri.getSchemeSpecificPart();
        int firstColon = ssp.indexOf(58);
        String serviceType = firstColon == -1 ? ssp : ssp.substring(0, firstColon);
        return serviceType.toLowerCase();
    }

    public static String getGroupName(URI uri) throws IllegalArgumentException {
        if (!ServiceURI.isRemotingServiceUri(uri)) {
            throw new IllegalArgumentException("Not a valid remoting service URI");
        }
        String ssp = uri.getSchemeSpecificPart();
        int firstColon = ssp.indexOf(58);
        if (firstColon == -1) {
            return "";
        }
        int secondColon = ssp.indexOf(58, firstColon + 1);
        String groupName = secondColon == -1 ? ssp.substring(firstColon + 1) : ssp.substring(firstColon + 1, secondColon);
        return groupName.toLowerCase();
    }

    public static String getEndpointName(URI uri) throws IllegalArgumentException {
        if (!ServiceURI.isRemotingServiceUri(uri)) {
            throw new IllegalArgumentException("Not a valid remoting service URI");
        }
        String ssp = uri.getSchemeSpecificPart();
        int firstColon = ssp.indexOf(58);
        if (firstColon == -1) {
            return "";
        }
        int secondColon = ssp.indexOf(58, firstColon + 1);
        if (secondColon == -1) {
            return "";
        }
        int thirdColon = ssp.indexOf(58, secondColon + 1);
        String endpointName = thirdColon == -1 ? ssp.substring(secondColon + 1) : ssp.substring(secondColon + 1, thirdColon);
        return endpointName.toLowerCase();
    }

    public static URI create(String serviceType, String groupName, String endpointName) {
        try {
            StringBuilder builder = new StringBuilder(32);
            if (serviceType != null && serviceType.length() > 0) {
                builder.append(serviceType);
            }
            builder.append(':');
            if (groupName != null && groupName.length() > 0) {
                builder.append(groupName);
            }
            builder.append(':');
            if (endpointName != null && endpointName.length() > 0) {
                builder.append(endpointName);
            }
            return new URI(SCHEME, builder.toString(), null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("URI syntax exception should not be possible here", e);
        }
    }

    public static void validateServiceType(CharSequence serviceType) {
        if (serviceType == null) {
            throw new NullPointerException("serviceType is null");
        }
        if (!VALID_SERVICE_TYPE.matcher(serviceType).matches()) {
            throw new IllegalArgumentException("Service type \"" + serviceType + "\" is not valid");
        }
    }

    public static void validateGroupName(CharSequence groupName) {
        if (groupName == null) {
            throw new NullPointerException("groupName is null");
        }
        if (!VALID_GROUP_NAME.matcher(groupName).matches()) {
            throw new IllegalArgumentException("Group name \"" + groupName + "\" is not valid");
        }
    }

    public static void validateEndpointName(String endpointName) {
        if (endpointName == null) {
            throw new NullPointerException("endpointName is null");
        }
        if (!VALID_ENDPOINT_NAME.matcher(endpointName).matches()) {
            throw new IllegalArgumentException("Endpoint name \"" + endpointName + "\" is not valid");
        }
    }
}

