/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.spi.beans;

import java.io.ByteArrayInputStream;
import java.util.jar.JarOutputStream;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.spi.DConfigBean;
import javax.enterprise.deploy.spi.DConfigBeanRoot;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import org.jboss.deployment.spi.DeploymentMetaData;
import org.jboss.deployment.spi.JarUtils;
import org.jboss.deployment.spi.beans.AbstractJBossConfigBean;
import org.jboss.deployment.spi.beans.ConfigBeanXPaths;
import org.jboss.deployment.spi.beans.JBossConfigBeanProxy;

public class WarConfigBeanRoot
extends JBossConfigBeanProxy
implements DConfigBeanRoot {
    public static final String jbossWebXml = "jboss-web";
    public static final String jbossWebLocation = "!/WEB-INF/jboss-web.xml";
    public static final String jbossWebLocationTrimmed = "jboss-web.xml";
    public static final String deployPlanElement = "deployPlan";
    public static final String contextRoot = "context-root";
    public static final String archiveName = "archive-name";

    public WarConfigBeanRoot(DDBeanRoot standard, DeployableObject deployable) {
        WarConfigBean bean = new WarConfigBean((DDBean)standard, this, null);
        this.setBean(bean, deployable);
    }

    public DConfigBean getDConfigBean(DDBeanRoot arg0) {
        return null;
    }

    public class JbossWebConfigBean
    extends AbstractJBossConfigBean {
        private String stringPath;

        public JbossWebConfigBean(DDBean bean, DConfigBeanRoot root, ConfigBeanXPaths cPath) {
            super(bean, root, cPath);
        }

        protected ConfigBeanXPaths buildXPathList() {
            ConfigBeanXPaths pathRoot = new ConfigBeanXPaths("", null);
            if (this.myPath.getPath().equals(WarConfigBeanRoot.jbossWebXml)) {
                new ConfigBeanXPaths(WarConfigBeanRoot.contextRoot, pathRoot);
            } else if (this.myPath.getPath().equals(WarConfigBeanRoot.deployPlanElement)) {
                new ConfigBeanXPaths(WarConfigBeanRoot.archiveName, pathRoot);
            }
            return pathRoot;
        }
    }

    private class WarConfigBean
    extends AbstractJBossConfigBean {
        public WarConfigBean(DDBean bean, DConfigBeanRoot root, ConfigBeanXPaths path) {
            super(bean, root, path);
        }

        protected ConfigBeanXPaths buildXPathList() {
            ConfigBeanXPaths pathRoot = new ConfigBeanXPaths("", null);
            new ConfigBeanXPaths(WarConfigBeanRoot.jbossWebXml, pathRoot);
            new ConfigBeanXPaths(WarConfigBeanRoot.deployPlanElement, pathRoot);
            return pathRoot;
        }

        public DConfigBean getDConfigBean(DDBean bean) throws ConfigurationException {
            String path = bean.getXpath();
            ConfigBeanXPaths cPath = (ConfigBeanXPaths)this.xpaths.get(path);
            if (cPath == null) {
                throw new ConfigurationException("Config Bean Not Found");
            }
            JbossWebConfigBean retBean = new JbossWebConfigBean(bean, this.myRoot, cPath);
            this.children.add(retBean);
            return retBean;
        }

        public void save(JarOutputStream jos, DeploymentMetaData metaData) {
            System.out.println("saving WarConfigBean");
            DDBean[] jbossWeb = this.myBean.getChildBean(WarConfigBeanRoot.jbossWebXml);
            DDBean[] deploymentPlan = this.myBean.getChildBean(WarConfigBeanRoot.deployPlanElement);
            if (jbossWeb.length == 0) {
                return;
            }
            if (deploymentPlan.length == 0) {
                return;
            }
            DDBean plan = deploymentPlan[0];
            String[] planNames = plan.getText(WarConfigBeanRoot.archiveName);
            if (planNames.length == 0) {
                return;
            }
            String warFileName = planNames[0];
            String webXml = jbossWeb[0].getText();
            System.out.println("name: " + warFileName);
            metaData.setDeploymentName(warFileName);
            ByteArrayInputStream stream = new ByteArrayInputStream(webXml.getBytes());
            try {
                JarUtils.addJarEntry(jos, WarConfigBeanRoot.jbossWebLocation, stream);
                metaData.addEntry(metaData.getDeploymentName(), WarConfigBeanRoot.jbossWebLocationTrimmed);
            }
            catch (Exception e) {
                System.out.println("ERROR HERE in SAVE: " + e.getMessage());
            }
        }
    }
}

