/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common.servlet;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.management.ObjectName;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.WebServiceException;
import org.jboss.wsf.common.ObjectNameFactory;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.EndpointAssociation;
import org.jboss.wsf.spi.invocation.RequestHandler;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointRegistryFactory;
import org.jboss.wsf.spi.management.EndpointResolver;

public abstract class AbstractEndpointServlet
extends HttpServlet {
    private final SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
    protected Endpoint endpoint;
    private EndpointRegistry epRegistry;

    protected AbstractEndpointServlet() {
    }

    public final void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.initRegistry();
        this.initServiceEndpoint(servletConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            EndpointAssociation.setEndpoint((Endpoint)this.endpoint);
            RequestHandler requestHandler = this.endpoint.getRequestHandler();
            requestHandler.handleHttpRequest(this.endpoint, req, res, this.getServletContext());
        }
        finally {
            this.postService();
            EndpointAssociation.removeEndpoint();
        }
    }

    protected void postService() {
    }

    protected void postInit(ServletConfig cfg) {
    }

    protected abstract EndpointResolver newEndpointResolver(String var1, String var2);

    private void initServiceEndpoint(ServletConfig servletConfig) {
        this.initEndpoint(servletConfig.getServletContext().getContextPath(), this.getServletName());
        this.setRuntimeLoader();
        this.postInit(servletConfig);
    }

    private void initRegistry() {
        this.epRegistry = ((EndpointRegistryFactory)this.spiProvider.getSPI(EndpointRegistryFactory.class)).getEndpointRegistry();
    }

    private void initEndpoint(String contextPath, String servletName) {
        EndpointResolver resolver = this.newEndpointResolver(contextPath, servletName);
        this.endpoint = this.epRegistry.resolve(resolver);
        if (this.endpoint == null) {
            ObjectName oname = ObjectNameFactory.create("jboss.ws:context=" + contextPath + "," + "endpoint" + "=" + servletName);
            throw new WebServiceException("Cannot obtain endpoint for: " + oname);
        }
    }

    private void setRuntimeLoader() {
        boolean isJaxwsJse;
        Deployment dep = this.endpoint.getService().getDeployment();
        boolean isJaxrpcJse = dep.getType() == Deployment.DeploymentType.JAXRPC_JSE;
        boolean bl = isJaxwsJse = dep.getType() == Deployment.DeploymentType.JAXWS_JSE;
        if (isJaxrpcJse || isJaxwsJse) {
            ClassLoader classLoader = AbstractEndpointServlet.getContextClassLoader();
            dep.setRuntimeClassLoader(classLoader);
        }
    }

    private static ClassLoader getContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }
}

