/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import org.jboss.wsf.common.integration.AbstractDeploymentAspect;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.LifecycleHandler;
import org.jboss.wsf.spi.deployment.LifecycleHandlerFactory;
import org.jboss.wsf.spi.invocation.InvocationHandler;
import org.jboss.wsf.spi.invocation.InvocationHandlerFactory;
import org.jboss.wsf.spi.invocation.InvocationType;
import org.jboss.wsf.spi.invocation.RequestHandler;
import org.jboss.wsf.spi.invocation.RequestHandlerFactory;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBMetaData;
import org.jboss.wsf.spi.metadata.j2ee.MDBMetaData;

public class EndpointHandlerDeploymentAspect
extends AbstractDeploymentAspect {
    private SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();

    public void start(Deployment dep) {
        for (Endpoint ep : dep.getService().getEndpoints()) {
            ep.setRequestHandler(this.getRequestHandler(dep));
            ep.setLifecycleHandler(this.getLifecycleHandler(dep));
            InvocationHandler invocationHandler = this.getInvocationHandler(ep);
            if (invocationHandler == null) continue;
            ep.setInvocationHandler(invocationHandler);
        }
    }

    private RequestHandler getRequestHandler(Deployment dep) {
        return ((RequestHandlerFactory)this.spiProvider.getSPI(RequestHandlerFactory.class)).newRequestHandler();
    }

    private LifecycleHandler getLifecycleHandler(Deployment dep) {
        return ((LifecycleHandlerFactory)this.spiProvider.getSPI(LifecycleHandlerFactory.class)).newLifecycleHandler();
    }

    private InvocationHandler getInvocationHandler(Endpoint ep) {
        Deployment dep = ep.getService().getDeployment();
        Deployment.DeploymentType depType = dep.getType();
        String key = depType.toString();
        EJBArchiveMetaData uapp = (EJBArchiveMetaData)dep.getAttachment(EJBArchiveMetaData.class);
        if (uapp != null) {
            EJBMetaData bmd = uapp.getBeanByEjbName(ep.getShortName());
            if (depType == Deployment.DeploymentType.JAXRPC_EJB21 && bmd instanceof MDBMetaData) {
                key = InvocationType.JAXRPC_MDB21.toString();
            } else if (depType == Deployment.DeploymentType.JAXWS_EJB3 && bmd instanceof MDBMetaData) {
                key = InvocationType.JAXWS_MDB3.toString();
            }
        }
        InvocationType type = InvocationType.valueOf((String)key);
        InvocationHandler invocationHandler = ((InvocationHandlerFactory)this.spiProvider.getSPI(InvocationHandlerFactory.class)).newInvocationHandler(type);
        return invocationHandler;
    }
}

