/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.aop.AbstractInterceptor;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ejb3.stateful.StatefulContainerInvocation;
import org.jboss.ejb3.tx.TxUtil;
import org.jboss.logging.Logger;
import org.jboss.tm.TxUtils;

public class StatefulRemoveInterceptor
extends AbstractInterceptor {
    private static final Logger log = Logger.getLogger(StatefulRemoveInterceptor.class);
    protected boolean retainIfException;

    public StatefulRemoveInterceptor(boolean removeOnException) {
        this.retainIfException = removeOnException;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Object rtn = null;
        try {
            rtn = invocation.invokeNext();
        }
        catch (Throwable t) {
            if (StatefulRemoveInterceptor.retainIfException(this.retainIfException, t, (MethodInvocation)invocation)) {
                throw t;
            }
            this.removeSession(invocation, true);
            throw t;
        }
        this.removeSession(invocation, false);
        return rtn;
    }

    protected static boolean retainIfException(boolean retainIfException, Throwable t, MethodInvocation invocation) {
        return retainIfException && StatefulRemoveInterceptor.isApplicationException(t, invocation);
    }

    public static boolean isApplicationException(Throwable t, MethodInvocation invocation) {
        return ((EJBContainer)StatefulRemoveInterceptor.getEJBContainer((Invocation)invocation)).getApplicationException(t.getClass(), invocation.getMethod()) != null;
    }

    protected void removeSession(Invocation invocation, boolean exceptionThrown) throws Throwable {
        StatefulContainerInvocation ejb = (StatefulContainerInvocation)invocation;
        StatefulBeanContext ctx = (StatefulBeanContext)ejb.getBeanContext();
        if (ctx == null || ctx.isDiscarded() || ctx.isRemoved()) {
            return;
        }
        Object id = ejb.getId();
        StatefulContainer container = (StatefulContainer)StatefulRemoveInterceptor.getEJBContainer(invocation);
        Transaction tx = null;
        try {
            tx = TxUtil.getTransactionManager().getTransaction();
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
        if (tx != null && TxUtils.isActive((Transaction)tx)) {
            try {
                ctx.registerSynchronization(tx, new RemoveSynchronization(container, id, !exceptionThrown && this.retainIfException));
            }
            catch (RollbackException e) {
                throw new RuntimeException(e);
            }
            catch (SystemException e) {
                throw new RuntimeException(e);
            }
        } else {
            container.getCache().remove(id);
        }
    }

    private static class RemoveSynchronization
    implements Synchronization {
        protected boolean retainIfException;
        private StatefulContainer container;
        private Object id;

        public RemoveSynchronization(StatefulContainer container, Object id, boolean retainIfException) {
            this.container = container;
            this.id = id;
            this.retainIfException = retainIfException;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            try {
                this.container.getCache().remove(this.id);
            }
            catch (Throwable t) {
                log.error((Object)("Removing bean " + this.id + " from " + this.container + " failed"), t);
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException(t);
            }
        }
    }
}

