/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.processor.internal.jaxws.generator;

import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.java2wsdl.processor.internal.jaxws.generator.AbstractJaxwsGenerator;

public class JaxwsClientGenerator
extends AbstractJaxwsGenerator {
    private static final String CLIENT_TEMPLATE = "org/apache/cxf/tools/java2wsdl/processor/internal/jaxws/generator/template/javafirst-client.vm";

    public boolean passthrough() {
        return !this.env.optionSet("client");
    }

    public void generate(ToolContext penv) throws ToolException {
        this.env = penv;
        JavaModel javaModel = (JavaModel)this.env.get(JavaModel.class);
        if (this.passthrough()) {
            return;
        }
        Map interfaces = javaModel.getInterfaces();
        QName service = (QName)this.env.get("serviceName");
        QName port = (QName)this.env.get("portName");
        for (JavaInterface intf : interfaces.values()) {
            this.clearAttributes();
            this.setAttributes("intf", intf);
            this.setAttributes("service", service);
            this.setAttributes("port", port);
            this.setAttributes("address", (String)penv.get("address"));
            this.setAttributes("seiClass", (String)this.env.get("seiClass"));
            this.setCommonAttributes();
            this.doWrite(CLIENT_TEMPLATE, this.parseOutputName(intf.getPackageName(), intf.getName() + "Client"));
        }
    }
}

