/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.tx;

import java.lang.reflect.Method;
import javax.ejb.ApplicationException;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.jboss.aop.Advisor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aspects.currentinvocation.CurrentInvocation;
import org.jboss.ejb3.interceptors.container.BeanContext;
import org.jboss.ejb3.interceptors.container.InvocationHelper;
import org.jboss.ejb3.tx.AbstractInterceptor;
import org.jboss.ejb3.tx.UserTransactionImpl;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionManagerLocator;

public class TxUtil {
    private static final Logger log = Logger.getLogger(TxUtil.class);

    private static void check(String publicMethod, String specReferenceTxAttr) {
        Invocation currentInvocation = CurrentInvocation.getCurrentInvocation();
        if (currentInvocation == null) {
            throw new IllegalStateException("It's not allowed to do " + publicMethod + " during construction and injection");
        }
        Advisor advisor = currentInvocation.getAdvisor();
        String containerName = advisor.getName();
        TransactionManagementType type = TxUtil.getTransactionManagementType(advisor);
        if (type != TransactionManagementType.CONTAINER) {
            throw new IllegalStateException("Container " + containerName + ": it is illegal to call " + publicMethod + " from BMT: " + type);
        }
        if (TxUtil.isLifecycleCallback(currentInvocation)) {
            throw new IllegalStateException(containerName + ": " + publicMethod + " not allowed during lifecycle callbacks (EJB3 4.4.1 & 4.5.2)");
        }
        if (TxUtil.getTxType(currentInvocation) == TransactionAttributeType.SUPPORTS) {
            throw new IllegalStateException(containerName + ": " + publicMethod + " not allowed with TransactionAttributeType.SUPPORTS (" + specReferenceTxAttr + ")");
        }
    }

    public static TransactionManager getTransactionManager() {
        return TransactionManagerLocator.getInstance().locate();
    }

    public static TransactionManagementType getTransactionManagementType(Advisor advisor) {
        TransactionManagement transactionManagement = (TransactionManagement)advisor.resolveAnnotation(TransactionManagement.class);
        if (transactionManagement == null) {
            return TransactionManagementType.CONTAINER;
        }
        return transactionManagement.value();
    }

    public static ApplicationException getApplicationException(Class<?> exceptionClass, Invocation invocation) {
        return AbstractInterceptor.resolveAnnotation(invocation, exceptionClass, ApplicationException.class);
    }

    public static boolean getRollbackOnly() {
        TxUtil.check("getRollbackOnly", "EJB 3.0 FR 13.6.2.9");
        try {
            TransactionManager tm = TxUtil.getTransactionManager();
            if (tm.getTransaction() == null) {
                throw new IllegalStateException("getRollbackOnly() not allowed without a transaction.");
            }
            int status = tm.getStatus();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Current transaction status is " + status));
            }
            switch (status) {
                case 3: 
                case 4: {
                    throw new IllegalStateException("getRollbackOnly() not allowed after transaction is completed (EJBTHREE-1445)");
                }
                case 1: 
                case 9: {
                    return true;
                }
            }
            return false;
        }
        catch (SystemException e) {
            log.warn((Object)"failed to get tx manager status; ignoring", (Throwable)e);
            return true;
        }
    }

    protected static TransactionAttributeType getTxType(Advisor advisor, Method method) {
        TransactionAttribute tx = null;
        if (method != null) {
            tx = (TransactionAttribute)advisor.resolveAnnotation(method, TransactionAttribute.class);
        }
        if (tx == null) {
            tx = (TransactionAttribute)advisor.resolveAnnotation(TransactionAttribute.class);
        }
        TransactionAttributeType value = TransactionAttributeType.REQUIRED;
        if (tx != null && tx.value() != null) {
            value = tx.value();
        }
        return value;
    }

    private static TransactionAttributeType getTxType(Invocation invocation) {
        Method method = null;
        if (invocation instanceof MethodInvocation) {
            method = ((MethodInvocation)invocation).getActualMethod();
        }
        return TxUtil.getTxType(invocation.getAdvisor(), method);
    }

    public static UserTransaction getUserTransaction(BeanContext<?> ctx) {
        Invocation invocation = CurrentInvocation.getCurrentInvocation();
        if (InvocationHelper.isInjection((Invocation)invocation)) {
            throw new IllegalStateException("getUserTransaction() not allowed during injection (EJB3 4.4.1 & 4.5.2)");
        }
        Advisor advisor = invocation.getAdvisor();
        TransactionManagementType type = TxUtil.getTransactionManagementType(advisor);
        if (type != TransactionManagementType.BEAN) {
            throw new IllegalStateException("Container " + advisor.getName() + ": it is illegal to inject UserTransaction into a CMT bean");
        }
        return new UserTransactionImpl();
    }

    private static boolean isLifecycleCallback(Invocation inv) {
        return InvocationHelper.isLifecycleCallback((Invocation)inv);
    }

    public static void setRollbackOnly() {
        TxUtil.check("setRollbackOnly", "EJB 3.0 FR 13.6.2.8");
        try {
            TransactionManager tm = TxUtil.getTransactionManager();
            if (tm.getTransaction() == null) {
                throw new IllegalStateException("setRollbackOnly() not allowed without a transaction.");
            }
            tm.setRollbackOnly();
        }
        catch (SystemException e) {
            log.warn((Object)"failed to set rollback only; ignoring", (Throwable)e);
        }
    }
}

