/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.metadata;

import java.io.Serializable;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.dependency.spi.dispatch.AttributeDispatchContext;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.system.metadata.AbstractMetaDataVisitorNode;
import org.jboss.system.metadata.ServiceMetaDataVisitor;
import org.jboss.system.metadata.ServiceValueContext;
import org.jboss.system.metadata.ServiceValueMetaData;
import org.jboss.system.microcontainer.ServiceControllerContext;

public class ServiceInjectionValueMetaData
extends AbstractMetaDataVisitorNode
implements ServiceValueMetaData,
Serializable {
    private static final long serialVersionUID = 2L;
    private Object dependency;
    private String property;
    private ControllerState dependentState = ControllerState.INSTALLED;
    private ServiceControllerContext underlyingContext;

    public ServiceInjectionValueMetaData() {
    }

    public ServiceInjectionValueMetaData(Object dependency) {
        this(dependency, null);
    }

    public ServiceInjectionValueMetaData(Object dependency, String property) {
        this(dependency, property, ControllerState.INSTALLED);
    }

    public ServiceInjectionValueMetaData(Object dependency, String property, ControllerState dependentState) {
        this.setDependency(dependency);
        this.setProperty(property);
        this.setDependentState(dependentState);
    }

    public Object getDependency() {
        return this.dependency;
    }

    public void setDependency(Object dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException("Null dependency");
        }
        this.dependency = dependency;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public ControllerState getDependentState() {
        return this.dependentState;
    }

    public void setDependentState(ControllerState dependentState) {
        this.dependentState = dependentState;
    }

    public Object getValue(ServiceValueContext valueContext) throws Throwable {
        ControllerContext context;
        KernelController controller = valueContext.getController();
        ControllerState state = this.dependentState;
        if (state == null) {
            state = ControllerState.INSTALLED;
        }
        if ((context = controller.getContext(this.dependency, state)) == null) {
            throw new Error("Should not be here - dependency failed! " + this);
        }
        if (this.property != null && this.property.length() > 0) {
            if (context instanceof AttributeDispatchContext) {
                AttributeDispatchContext adc = (AttributeDispatchContext)context;
                return adc.get(this.property);
            }
            throw new IllegalArgumentException("Cannot use property attribute, context is not AttributeDispatchContext: " + context + ", metadata: " + this);
        }
        return ServiceInjectionValueMetaData.getTarget((ControllerContext)this.underlyingContext, context);
    }

    public Object ungetValue(ServiceValueContext valueContext) throws Throwable {
        if (this.property == null || this.property.length() == 0) {
            ControllerContext context;
            KernelController controller = valueContext.getController();
            ControllerState state = this.dependentState;
            if (state == null) {
                state = ControllerState.INSTALLED;
            }
            if ((context = controller.getContext(this.dependency, state)) != null) {
                ServiceInjectionValueMetaData.ungetTarget((ControllerContext)this.underlyingContext, context);
                return null;
            }
        }
        return super.ungetValue(valueContext);
    }

    public void visit(ServiceMetaDataVisitor visitor) {
        ServiceControllerContext context;
        this.underlyingContext = context = visitor.getControllerContext();
        Object name = context.getName();
        ControllerState whenRequired = visitor.getContextState();
        AbstractDependencyItem item = new AbstractDependencyItem(name, this.dependency, whenRequired, this.dependentState);
        visitor.addDependency((DependencyItem)item);
        visitor.visit(this);
    }
}

