/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.protocols.FD_SOCK;
import org.jgroups.protocols.MERGE2;
import org.jgroups.protocols.pbcast.NAKACK;
import org.jgroups.protocols.pbcast.STABLE;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"broken"})
public class MergeStressTest
extends ChannelTestBase {
    CyclicBarrier start_connecting = null;
    CyclicBarrier received_all_views = null;
    CyclicBarrier disconnected = null;
    static final int NUM = 10;
    final MyThread[] threads = new MyThread[10];
    static String groupname = "MergeStressTest";

    static void log(String msg) {
        System.out.println("-- [" + Thread.currentThread().getName() + "] " + msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentStartupAndMerging() throws Exception {
        this.start_connecting = new CyclicBarrier(11);
        this.received_all_views = new CyclicBarrier(11);
        this.disconnected = new CyclicBarrier(11);
        JChannel first = null;
        for (int i = 0; i < this.threads.length; ++i) {
            JChannel tmp = i == 0 ? (first = this.createChannel(true, this.threads.length)) : this.createChannel(first);
            MergeStressTest.modifyStack(tmp);
            this.threads[i] = new MyThread(i, tmp);
            this.threads[i].start();
        }
        Util.sleep(1000L);
        this.start_connecting.await();
        long start = System.currentTimeMillis();
        try {
            this.received_all_views.await(45L, TimeUnit.SECONDS);
            long stop = System.currentTimeMillis();
            System.out.println("-- took " + (stop - start) + " msecs for all " + 10 + " threads to see all views");
            System.out.print("checking that all views have 10 members: ");
            for (int i = 0; i < this.threads.length; ++i) {
                MyThread t = this.threads[i];
                int num_members = t.numMembers();
                Assert.assertEquals((int)num_members, (int)10);
            }
            System.out.println("SUCCESSFUL");
        }
        catch (TimeoutException timeoutOnReceiveViews) {
            for (MyThread channel : this.threads) {
                channel.interrupt();
            }
        }
        catch (Exception ex) {
            assert (false) : ex.toString();
        }
        finally {
            this.disconnected.await();
        }
    }

    private static void modifyStack(JChannel ch) {
        ProtocolStack stack = ch.getProtocolStack();
        Protocol prot = stack.findProtocol((Class<?>)MERGE2.class);
        if (prot != null) {
            MERGE2 merge = (MERGE2)prot;
            merge.setMinInterval(3000L);
            merge.setMaxInterval(5000L);
        }
        if ((prot = stack.findProtocol((Class<?>)STABLE.class)) != null) {
            STABLE stable = (STABLE)prot;
            stable.setDesiredAverageGossip(5000L);
        }
        if ((prot = stack.findProtocol((Class<?>)NAKACK.class)) != null) {
            ((NAKACK)prot).setLogDiscardMessages(false);
        }
        if ((prot = stack.findProtocol((Class<?>)FD_SOCK.class)) != null) {
            ((FD_SOCK)prot).setLogSuspectedMessages(false);
        }
    }

    public class MyThread
    extends ReceiverAdapter
    implements Runnable {
        int index = -1;
        long total_connect_time = 0L;
        long total_disconnect_time = 0L;
        private final Channel ch;
        private Address my_addr = null;
        private View current_view;
        private Thread thread;
        private int num_members = 0;

        public MyThread(int i, Channel ch) {
            this.ch = ch;
            this.thread = new Thread((Runnable)this, "thread #" + i);
            this.index = i;
        }

        public void start() {
            this.thread.start();
        }

        public void interrupt() {
            this.thread.interrupt();
        }

        public void closeChannel() {
            Util.close(this.ch);
        }

        public int numMembers() {
            return this.ch.getView().size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void viewAccepted(View new_view) {
            this.current_view = new_view;
            MergeStressTest.log("accepted " + new_view);
            this.num_members = this.current_view.getMembers().size();
            if (this.num_members == 10) {
                MyThread myThread = this;
                synchronized (myThread) {
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                MergeStressTest.this.start_connecting.await();
                this.ch.setReceiver(this);
                MergeStressTest.log("connecting to channel");
                long start = System.currentTimeMillis();
                this.ch.connect(groupname);
                long stop = System.currentTimeMillis();
                this.total_connect_time = stop - start;
                View view = this.ch.getView();
                this.my_addr = this.ch.getAddress();
                MergeStressTest.log(this.my_addr + " connected in " + this.total_connect_time + " msecs (" + view.getMembers().size() + " members). VID=" + this.ch.getView());
                MyThread myThread = this;
                synchronized (myThread) {
                    while (this.num_members < 10 && !Thread.currentThread().isInterrupted()) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                MergeStressTest.log("reached " + this.num_members + " members");
                try {
                    MergeStressTest.this.received_all_views.await();
                    Util.shutdown(this.ch);
                    MergeStressTest.this.disconnected.await();
                }
                catch (Exception exception) {}
            }
        }
    }
}

