/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component.behavior;

import java.util.ArrayList;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.UIComponentBase;
import javax.faces.component.behavior.Behavior;
import javax.faces.component.behavior._AttachedDeltaWrapper;
import javax.faces.component.behavior._DeltaList;
import javax.faces.context.FacesContext;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.BehaviorListener;

public class BehaviorBase
implements Behavior,
PartialStateHolder {
    private _DeltaList<BehaviorListener> _behaviorListeners;
    private boolean _initialState;
    private transient boolean _transient;

    public void broadcast(BehaviorEvent event) {
        if (event == null) {
            throw new NullPointerException("event");
        }
        if (this._behaviorListeners != null) {
            for (BehaviorListener listener : this._behaviorListeners) {
                if (!event.isAppropriateListener(listener)) continue;
                event.processListener(listener);
            }
        }
    }

    public void clearInitialState() {
        this._initialState = false;
        if (this._behaviorListeners != null) {
            this._behaviorListeners.clearInitialState();
        }
    }

    public boolean initialStateMarked() {
        return this._initialState;
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void markInitialState() {
        this._initialState = true;
        if (this._behaviorListeners != null) {
            this._behaviorListeners.markInitialState();
        }
    }

    public void restoreState(FacesContext context, Object state) {
        if (state == null) {
            return;
        }
        if (state instanceof _AttachedDeltaWrapper) {
            this._behaviorListeners.restoreState(context, ((_AttachedDeltaWrapper)state).getWrappedStateObject());
        } else {
            this._behaviorListeners = (_DeltaList)UIComponentBase.restoreAttachedState(context, state);
        }
    }

    public Object saveState(FacesContext context) {
        return this.saveBehaviorListenersList(context);
    }

    private Object saveBehaviorListenersList(FacesContext facesContext) {
        _DeltaList<BehaviorListener> holder = this._behaviorListeners;
        if (this.initialStateMarked() && this._behaviorListeners != null && holder.initialStateMarked()) {
            Object attachedState = holder.saveState(facesContext);
            if (attachedState != null) {
                return new _AttachedDeltaWrapper(this._behaviorListeners.getClass(), attachedState);
            }
            return null;
        }
        return UIComponentBase.saveAttachedState(facesContext, this._behaviorListeners);
    }

    public void setTransient(boolean newTransientValue) {
        this._transient = newTransientValue;
    }

    protected void addBehaviorListener(BehaviorListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this._behaviorListeners == null) {
            this._behaviorListeners = new _DeltaList(new ArrayList());
        }
        this._behaviorListeners.add(listener);
    }

    protected void removeBehaviorListener(BehaviorListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this._behaviorListeners != null) {
            this._behaviorListeners.remove(listener);
        }
    }
}

