/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;

public abstract class AbstractProcessor<MD>
extends AbstractFinderUser {
    private Map<Class<?>, List<Processor<Object, Class<?>>>> typeProcessors;
    private Map<Class<?>, List<Processor<Object, Field>>> fieldProcessors;
    private Map<Class<?>, List<Processor<Object, Method>>> methodProcessors;
    private Map<Scope, Set<Class<? extends Annotation>>> processedAnnotations;
    private Set<Class<?>> processedTypes = new HashSet();
    private static final Logger log = Logger.getLogger(AbstractProcessor.class);

    public AbstractProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
        this.typeProcessors = new HashMap();
        this.fieldProcessors = new HashMap();
        this.methodProcessors = new HashMap();
        this.processedAnnotations = new HashMap<Scope, Set<Class<? extends Annotation>>>();
    }

    public void addFieldProcessor(Processor processor) {
        List<Processor<Object, Field>> processors;
        Class<?> processorType = this.getProcessorMetaDataType(processor, Scope.FIELD);
        if (log.isTraceEnabled()) {
            log.trace((Object)("addFieldProcessor: " + processor + ", for type: " + processorType));
        }
        if ((processors = this.fieldProcessors.get(processorType)) == null) {
            processors = new ArrayList<Processor<Object, Field>>();
            this.fieldProcessors.put(processorType, processors);
        }
        processors.add(processor);
    }

    public void addMethodProcessor(Processor processor) {
        List<Processor<Object, Method>> processors;
        Class<?> processorType = this.getProcessorMetaDataType(processor, Scope.METHOD);
        if (log.isTraceEnabled()) {
            log.trace((Object)("addMethodProcessor: " + processor + ", for type: " + processorType));
        }
        if ((processors = this.methodProcessors.get(processorType)) == null) {
            processors = new ArrayList<Processor<Object, Method>>();
            this.methodProcessors.put(processorType, processors);
        }
        processors.add(processor);
    }

    public void addTypeProcessor(Processor processor) {
        List<Processor<Object, Class<?>>> processors;
        Class<?> processorType = this.getProcessorMetaDataType(processor, Scope.TYPE);
        if (log.isTraceEnabled()) {
            log.trace((Object)("addTypeProcessor: " + processor + ", for type: " + processorType));
        }
        if ((processors = this.typeProcessors.get(processorType)) == null) {
            processors = new ArrayList();
            this.typeProcessors.put(processorType, processors);
        }
        processors.add(processor);
    }

    public void process(MD metaData, Class<?> type) {
        this.processClass(metaData, type);
    }

    protected <T> void processClass(T metaData, Class<?> cls) {
        boolean trace = log.isTraceEnabled();
        for (Class<?> type = metaData.getClass(); type != Object.class; type = type.getSuperclass()) {
            if (!this.processedTypes.contains(type)) continue;
            int processorCount = this.processClass(metaData, cls, type);
            if (!trace) continue;
            log.trace((Object)("Found " + processorCount + " processors for type: " + type));
        }
        for (Class<?> iface : metaData.getClass().getInterfaces()) {
            if (this.processedTypes.contains(iface)) {
                // empty if block
            }
            this.processClass(metaData, cls, iface);
        }
    }

    protected <T> int processClass(T metaData, Class<?> cls, Class processorType) {
        List<Processor<Object, Method>> mps;
        List<Processor<Object, Field>> fps;
        List<Processor<Object, Class<?>>> tps;
        boolean trace = log.isTraceEnabled();
        int processorCount = 0;
        if (trace) {
            log.trace((Object)("processClass for metaData: " + processorType + ", class: " + cls));
        }
        if ((tps = this.typeProcessors.get(processorType)) != null) {
            processorCount += tps.size();
            if (trace) {
                log.trace((Object)("typeProcessors(" + tps.size() + ") for metaData: " + tps));
            }
            for (Processor<Object, Class<?>> processor : tps) {
                processor.process(metaData, cls);
            }
            for (Class<?> intf : cls.getInterfaces()) {
                for (Processor<Object, Class<?>> processor : tps) {
                    processor.process(metaData, intf);
                }
            }
        }
        if ((fps = this.fieldProcessors.get(processorType)) != null) {
            processorCount += fps.size();
            if (trace) {
                log.trace((Object)("fieldProcessors(" + fps.size() + ") for metaData: " + fps));
            }
            Field[] fields = new Field[]{};
            try {
                fields = cls.getDeclaredFields();
            }
            catch (Throwable e) {
                log.debug((Object)("Failed to get DeclaredFields for: " + cls), e);
            }
            for (Field field : fields) {
                for (Processor<Object, Field> processor : fps) {
                    processor.process(metaData, field);
                }
            }
        }
        if ((mps = this.methodProcessors.get(processorType)) != null) {
            processorCount += mps.size();
            if (trace) {
                log.trace((Object)("methodProcessors(" + mps.size() + ") for metaData: " + mps));
            }
            Method[] methods = new Method[]{};
            try {
                methods = cls.getDeclaredMethods();
            }
            catch (Throwable e) {
                log.debug((Object)("Failed to get DeclaredMethods for: " + cls), e);
            }
            for (Method method : methods) {
                if (trace) {
                    log.trace((Object)("process method " + method));
                }
                for (Processor<Object, Method> processor : mps) {
                    processor.process(metaData, method);
                }
            }
        }
        if (cls.getSuperclass() != null && cls.getSuperclass() != Object.class) {
            processorCount += this.processClass(metaData, cls.getSuperclass(), processorType);
        }
        return processorCount;
    }

    private Class<?> getProcessorMetaDataType(Processor processor, Scope scope) {
        Type[] interfaces = processor.getClass().getGenericInterfaces();
        Type processorType = null;
        for (Type t : interfaces) {
            ParameterizedType pt = (ParameterizedType)t;
            Type rawType = pt.getRawType();
            if (!(rawType instanceof Class) || !((Class)rawType).getName().equals(Processor.class.getName())) continue;
            processorType = t;
            break;
        }
        if (processorType == null) {
            throw new IllegalStateException("No generic Processor interface found on: " + processor);
        }
        ParameterizedType pt = (ParameterizedType)processorType;
        Type t0 = pt.getActualTypeArguments()[0];
        Class t = null;
        if (t0 instanceof Class) {
            t = (Class)t0;
        } else if (t0 instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)t0;
            t = (Class)tv.getBounds()[0];
        }
        this.addProcessedAnnotations(scope, processor.getAnnotationTypes());
        if (!this.processedTypes.contains(t)) {
            this.processedTypes.add(t);
        }
        return t;
    }

    private void addProcessedAnnotations(Scope scope, Collection<Class<? extends Annotation>> annotations) {
        if (annotations != null && annotations.size() > 0) {
            if (this.processedAnnotations.get((Object)scope) == null) {
                this.processedAnnotations.put(scope, new HashSet());
            }
            this.processedAnnotations.get((Object)scope).addAll(annotations);
        }
    }

    public Collection<Class<? extends Annotation>> getProcessedAnnotations(Scope scope) {
        return this.processedAnnotations.get((Object)scope);
    }

    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        HashSet<Class<? extends Annotation>> set = new HashSet<Class<? extends Annotation>>();
        if (this.getProcessedAnnotations(Scope.TYPE) != null) {
            set.addAll(this.getProcessedAnnotations(Scope.TYPE));
        }
        if (this.getProcessedAnnotations(Scope.METHOD) != null) {
            set.addAll(this.getProcessedAnnotations(Scope.METHOD));
        }
        if (this.getProcessedAnnotations(Scope.FIELD) != null) {
            set.addAll(this.getProcessedAnnotations(Scope.FIELD));
        }
        return set;
    }

    public static enum Scope {
        TYPE,
        METHOD,
        FIELD;

    }
}

