/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.spec;

import javax.ejb.TransactionManagementType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jboss.metadata.common.ejb.ITimeoutTarget;
import org.jboss.metadata.ejb.spec.ActivationConfigMetaData;
import org.jboss.metadata.ejb.spec.AroundInvokesMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.MessageDrivenDestinationMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.metadata.ejb.spec.SubscriptionDurability;
import org.jboss.metadata.javaee.spec.TransactionManagementTypeAdapter;
import org.jboss.xb.annotations.JBossXmlType;

@XmlType(name="message-driven-beanType", propOrder={"descriptionGroup", "ejbName", "mappedName", "ejbClass", "transactionType", "messageSelector", "acknowledgeMode", "messageDrivenDestination", "messagingType", "timeoutMethod", "transactionType", "messageDestinationType", "messageDestinationLink", "activationConfig", "aroundInvokes", "environmentRefsGroup", "securityIdentity"})
@JBossXmlType(modelGroup="unordered_sequence")
public class MessageDrivenBeanMetaData
extends EnterpriseBeanMetaData
implements ITimeoutTarget {
    private static final long serialVersionUID = -7353017099819838715L;
    private String messagingType;
    private NamedMethodMetaData timeoutMethod;
    private TransactionManagementType transactionType;
    private String messageDestinationType;
    private String messageDestinationLink;
    private ActivationConfigMetaData activationConfig;
    private AroundInvokesMetaData aroundInvokes;
    private String messageSelector;
    private String acknowledgeMode;
    private SubscriptionDurability subscriptionDurability;

    @Override
    public boolean isMessageDriven() {
        return true;
    }

    public String getMessagingType() {
        return this.messagingType;
    }

    public boolean isJMS() {
        String messagingType = this.getMessagingType();
        return messagingType == null || "javax.jms.MessageListener".equals(messagingType);
    }

    public void setMessagingType(String messagingType) {
        if (messagingType == null) {
            throw new IllegalArgumentException("Null messagingType");
        }
        this.messagingType = messagingType;
    }

    @Override
    public NamedMethodMetaData getTimeoutMethod() {
        return this.timeoutMethod;
    }

    @Override
    @XmlElement(required=false)
    public void setTimeoutMethod(NamedMethodMetaData timeoutMethod) {
        if (timeoutMethod == null) {
            throw new IllegalArgumentException("Null timeoutMethod");
        }
        this.timeoutMethod = timeoutMethod;
    }

    @Override
    public TransactionManagementType getTransactionType() {
        return this.transactionType;
    }

    @XmlJavaTypeAdapter(value=TransactionManagementTypeAdapter.class)
    public void setTransactionType(TransactionManagementType transactionType) {
        if (transactionType == null) {
            throw new IllegalArgumentException("Null transactionType");
        }
        this.transactionType = transactionType;
    }

    public String getMessageDestinationType() {
        return this.messageDestinationType;
    }

    public void setMessageDestinationType(String messageDestinationType) {
        if (messageDestinationType == null) {
            throw new IllegalArgumentException("Null messageDestinationType");
        }
        this.messageDestinationType = messageDestinationType;
    }

    public AroundInvokesMetaData getAroundInvokes() {
        return this.aroundInvokes;
    }

    @XmlElement(name="around-invoke", required=false)
    public void setAroundInvokes(AroundInvokesMetaData aroundInvokes) {
        if (aroundInvokes == null) {
            throw new IllegalArgumentException("Null aroundInvokes");
        }
        this.aroundInvokes = aroundInvokes;
    }

    public String getMessageDestinationLink() {
        return this.messageDestinationLink;
    }

    public void setMessageDestinationLink(String messageDestinationLink) {
        if (messageDestinationLink == null) {
            throw new IllegalArgumentException("Null messageDestinationLink");
        }
        this.messageDestinationLink = messageDestinationLink;
    }

    public ActivationConfigMetaData getActivationConfig() {
        return this.activationConfig;
    }

    public void setActivationConfig(ActivationConfigMetaData activationConfig) {
        if (activationConfig == null) {
            throw new IllegalArgumentException("Null activationConfig");
        }
        this.activationConfig = activationConfig;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    @XmlElement(required=false)
    public void setMessageSelector(String messageSelector) {
        if (messageSelector == null) {
            throw new IllegalArgumentException("Null messageSelector");
        }
        this.messageSelector = messageSelector;
    }

    public String getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    @XmlElement(required=false)
    public void setAcknowledgeMode(String acknowledgeMode) {
        if (acknowledgeMode == null) {
            throw new IllegalArgumentException("Null acknowledgeMode");
        }
        this.acknowledgeMode = acknowledgeMode;
    }

    public SubscriptionDurability getSubscriptionDurability() {
        return this.subscriptionDurability;
    }

    @XmlElement(required=false)
    public void setSubscriptionDurability(SubscriptionDurability subscriptionDurability) {
        if (subscriptionDurability == null) {
            throw new IllegalArgumentException("Null subscriptionDurability");
        }
        this.subscriptionDurability = subscriptionDurability;
    }

    @XmlElement(name="message-driven-destination", required=false)
    public void setMessageDrivenDestination(MessageDrivenDestinationMetaData mdd) {
        this.setMessageDestinationType(mdd.getDestinationType());
        String durability = mdd.getSubscriptionDurability();
        SubscriptionDurability sd = SubscriptionDurability.NonDurable;
        if (durability != null && durability.equalsIgnoreCase("Durable")) {
            sd = SubscriptionDurability.Durable;
        }
        this.setSubscriptionDurability(sd);
    }

    @Override
    public void merge(EnterpriseBeanMetaData override, EnterpriseBeanMetaData original) {
        this.merge((MessageDrivenBeanMetaData)override, (MessageDrivenBeanMetaData)original);
    }

    public void merge(MessageDrivenBeanMetaData override, MessageDrivenBeanMetaData original) {
        super.merge(override, original);
        if (override != null && override.acknowledgeMode != null) {
            this.acknowledgeMode = override.acknowledgeMode;
        } else if (original != null) {
            this.acknowledgeMode = original.acknowledgeMode;
        }
        if (override != null && override.activationConfig != null || original != null && original.activationConfig != null) {
            this.activationConfig = new ActivationConfigMetaData();
            this.activationConfig.merge(override != null ? override.activationConfig : null, original != null ? original.activationConfig : null);
        }
        if (override != null && override.aroundInvokes != null || original != null && original.aroundInvokes != null) {
            this.aroundInvokes = new AroundInvokesMetaData();
            this.aroundInvokes.merge(override != null ? override.aroundInvokes : null, original != null ? original.aroundInvokes : null);
        }
        if (override != null && override.messageDestinationLink != null) {
            this.messageDestinationLink = override.messageDestinationLink;
        } else if (original != null) {
            this.messageDestinationLink = original.messageDestinationLink;
        }
        if (override != null && override.messageDestinationType != null) {
            this.messageDestinationType = override.messageDestinationType;
        } else if (original != null) {
            this.messageDestinationType = original.messageDestinationType;
        }
        if (override != null && override.messageSelector != null) {
            this.messageSelector = override.messageSelector;
        } else if (original != null) {
            this.messageSelector = original.messageSelector;
        }
        if (override != null && override.messagingType != null) {
            this.messagingType = override.messagingType;
        } else if (original != null) {
            this.messagingType = original.messagingType;
        }
        if (override != null && override.subscriptionDurability != null) {
            this.subscriptionDurability = override.subscriptionDurability;
        } else if (original != null) {
            this.subscriptionDurability = original.subscriptionDurability;
        }
        if (override != null && override.timeoutMethod != null) {
            this.timeoutMethod = override.timeoutMethod;
        } else if (original != null) {
            this.timeoutMethod = original.timeoutMethod;
        }
        if (override != null && override.transactionType != null) {
            this.transactionType = override.transactionType;
        } else if (original != null) {
            this.transactionType = original.transactionType;
        }
    }
}

