/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mc.servlet.vdf.api;

import java.io.IOException;
import java.util.UUID;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.mc.servlet.vdf.api.KernelControllerVDFConnector;

public class MicrocontainerServlet
implements Servlet {
    private Servlet delegate;
    private KernelController controller;
    private String name;
    private ServletConfig config;

    public void init(ServletConfig config) throws ServletException {
        KernelControllerVDFConnector connector = new KernelControllerVDFConnector(config.getServletContext());
        if (!connector.isValid()) {
            throw new ServletException("Invalid VDF connector: " + connector);
        }
        String className = config.getInitParameter("servlet-class");
        if (className == null) {
            throw new ServletException("Missing 'servlet-class' init parameter.");
        }
        this.controller = (KernelController)connector.getUtility();
        this.name = UUID.randomUUID().toString();
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)this.name, (String)className);
        builder.ignoreDestroy();
        try {
            KernelControllerContext context = this.controller.install(builder.getBeanMetaData());
            if (!ControllerState.INSTALLED.equals((Object)context.getState())) {
                throw new IllegalArgumentException("Servlet [" + className + "] not fully installed, missing dependency? - " + context.getDependencyInfo().getUnresolvedDependencies(null), context.getError());
            }
            Object result = context.getTarget();
            if (!Servlet.class.isInstance(result)) {
                throw new ServletException("Classname [" + className + "] doesn't map Servlet instance: " + result);
            }
            this.delegate = (Servlet)result;
        }
        catch (ServletException t) {
            throw t;
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
        this.config = config;
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        this.delegate.service(req, res);
    }

    public String getServletInfo() {
        return this.delegate.getServletInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            if (this.delegate != null) {
                this.delegate.destroy();
                this.delegate = null;
            }
        }
        finally {
            if (this.controller != null) {
                this.controller.uninstall((Object)this.name);
                this.controller = null;
            }
        }
    }
}

