/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop.util.dwt;

import com.openstego.desktop.util.ImageUtil;
import com.openstego.desktop.util.dwt.DWTUtil;
import com.openstego.desktop.util.dwt.FilterGH;
import com.openstego.desktop.util.dwt.FilterXMLReader;
import com.openstego.desktop.util.dwt.Image;
import com.openstego.desktop.util.dwt.ImageTree;
import java.util.Map;

public class DWT {
    private static Map<Integer, FilterGH> filterGHMap = null;
    private String filterFile = "/dwt/filters.xml";
    private FilterGH[] filters = null;
    private int method = 0;
    private int cols = 0;
    private int rows = 0;
    private int level = 0;

    public DWT(int cols, int rows, int filterID, int level, int method) {
        if (filterGHMap == null) {
            filterGHMap = FilterXMLReader.parse(this.filterFile);
        }
        this.filters = new FilterGH[level + 1];
        for (int i = 0; i <= level; ++i) {
            this.filters[i] = filterGHMap.get(filterID);
        }
        this.level = level;
        this.method = method;
        this.cols = cols;
        this.rows = rows;
    }

    public ImageTree forwardDWT(int[][] pixels) {
        Image image = null;
        ImageTree tree = null;
        image = new Image(this.cols, this.rows);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                DWTUtil.setPixel(image, j, i, pixels[i][j]);
            }
        }
        tree = DWTUtil.waveletTransform(image, this.level, this.filters, this.method);
        return tree;
    }

    public ImageTree forwardDWTwp(int[][] pixels) {
        Image image = null;
        ImageTree tree = null;
        image = new Image(this.cols, this.rows);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                DWTUtil.setPixel(image, j, i, pixels[i][j]);
            }
        }
        tree = DWTUtil.waveletTransformWp(image, 0, this.level, this.filters, this.method);
        return tree;
    }

    public void inverseDWT(ImageTree dwts, int[][] pixels) {
        Image image = null;
        image = DWTUtil.inverseTransform(dwts, this.filters, this.method + 1);
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                pixels[i][j] = ImageUtil.pixelRange((int)(DWTUtil.getPixel(image, j, i) + 0.5));
            }
        }
    }
}

