/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop;

import com.openstego.desktop.OpenStegoException;
import java.security.AlgorithmParameters;
import java.security.Key;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class OpenStegoCrypto {
    public static final String ALGO_DES = "DES";
    public static final String ALGO_AES128 = "AES128";
    public static final String ALGO_AES256 = "AES256";
    private final byte[] SALT = new byte[]{40, 95, 113, -55, 30, 53, 10, 98};
    private final int ITER_COUNT = 7;
    private SecretKey secretKey = null;

    public OpenStegoCrypto(String password, String algorithm) throws OpenStegoException {
        PBEKeySpec keySpec = null;
        try {
            if (algorithm == null || algorithm.trim().equals("") || ALGO_AES128.equalsIgnoreCase(algorithm)) {
                algorithm = "PBEWithHmacSHA256AndAES_128";
            } else if (ALGO_AES256.equalsIgnoreCase(algorithm)) {
                algorithm = "PBEWithHmacSHA256AndAES_256";
            } else if (ALGO_DES.equalsIgnoreCase(algorithm)) {
                System.out.println("Warning: Using insecure algorithm: " + algorithm);
                algorithm = "PBEWithMD5AndDES";
            } else {
                throw new OpenStegoException(null, "OpenStego", 16, algorithm);
            }
            keySpec = new PBEKeySpec(password.toCharArray(), this.SALT, this.ITER_COUNT);
            this.secretKey = SecretKeyFactory.getInstance(algorithm).generateSecret(keySpec);
        }
        catch (Exception ex) {
            throw new OpenStegoException(ex);
        }
    }

    public byte[] encrypt(byte[] input) throws OpenStegoException {
        try {
            Cipher encryptCipher = Cipher.getInstance(this.secretKey.getAlgorithm());
            PBEParameterSpec algoParamSpec = new PBEParameterSpec(this.SALT, this.ITER_COUNT);
            encryptCipher.init(1, (Key)this.secretKey, algoParamSpec);
            byte[] algoParams = encryptCipher.getParameters().getEncoded();
            byte[] msg = encryptCipher.doFinal(input);
            byte paramLen = Byte.parseByte(Integer.toString(algoParams.length));
            byte[] out = new byte[1 + paramLen + msg.length];
            out[0] = paramLen;
            System.arraycopy(algoParams, 0, out, 1, paramLen);
            System.arraycopy(msg, 0, out, paramLen + 1, msg.length);
            return out;
        }
        catch (Exception ex) {
            throw new OpenStegoException(ex);
        }
    }

    public byte[] decrypt(byte[] input) throws OpenStegoException {
        try {
            byte paramLen = input[0];
            byte[] algoParamData = new byte[paramLen];
            System.arraycopy(input, 1, algoParamData, 0, paramLen);
            byte[] msg = new byte[input.length - paramLen - 1];
            System.arraycopy(input, paramLen + 1, msg, 0, msg.length);
            AlgorithmParameters algoParams = AlgorithmParameters.getInstance(this.secretKey.getAlgorithm());
            algoParams.init(algoParamData);
            Cipher decryptCipher = Cipher.getInstance(this.secretKey.getAlgorithm());
            decryptCipher.init(2, (Key)this.secretKey, algoParams);
            return decryptCipher.doFinal(msg);
        }
        catch (BadPaddingException bpEx) {
            throw new OpenStegoException(bpEx, "OpenStego", 1);
        }
        catch (Exception ex) {
            throw new OpenStegoException(ex);
        }
    }
}

