/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.brainstorm;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Cursor;

public class FeatureBaseFigure
extends Figure
implements PropertyChangeListener {
    private static Rectangle RECTANGLE = new Rectangle();
    private Viewport viewport = null;
    private Point lastViewportBottomRight = new Point();
    private Point startLocation;
    private Rectangle figureBounds;
    private boolean moveOrResize;
    private int position = 0;

    public FeatureBaseFigure() {
        this.setRequestFocusEnabled(true);
    }

    public void setOffTopRightPosition(Point p) {
    }

    protected void layout() {
        if (this.viewport != null) {
            this.layout(this.viewport.getClientArea(RECTANGLE));
        }
        super.layout();
    }

    private Viewport findViewport() {
        IFigure p = this.getParent();
        while (p != null) {
            if (p instanceof Viewport) {
                return (Viewport)p;
            }
            p = p.getParent();
        }
        return null;
    }

    public void addNotify() {
        this.viewport = this.findViewport();
        if (this.viewport != null) {
            this.viewport.getHorizontalRangeModel().addPropertyChangeListener((PropertyChangeListener)this);
            this.viewport.getVerticalRangeModel().addPropertyChangeListener((PropertyChangeListener)this);
        }
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.viewport != null) {
            this.viewport.getHorizontalRangeModel().removePropertyChangeListener((PropertyChangeListener)this);
            this.viewport.getVerticalRangeModel().removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.revalidate();
    }

    private void layout(Rectangle viewportClientArea) {
        Point bottomRight = viewportClientArea.getBottomRight();
        if (!bottomRight.equals((Object)this.lastViewportBottomRight)) {
            Rectangle bounds = this.getBounds().getCopy();
            Dimension preferredSize = this.getPreferredSize();
            if (this.lastViewportBottomRight.x == 0 && this.lastViewportBottomRight.y == 0) {
                bounds.x = bottomRight.x - preferredSize.width;
                bounds.y = bottomRight.y - preferredSize.height;
                bounds.width = preferredSize.width;
                bounds.height = preferredSize.height;
            } else {
                bounds.x -= this.lastViewportBottomRight.x - bottomRight.x;
                bounds.y -= this.lastViewportBottomRight.y - bottomRight.y;
            }
            this.lastViewportBottomRight = bottomRight;
            this.setBounds(bounds);
        }
    }

    protected Object doHandleMouseDown(Point p) {
        this.requestFocus();
        this.startLocation = p;
        this.figureBounds = this.getBounds().getCopy();
        return true;
    }

    protected Object doHandleMouseDrag(Point p) {
        if (this.startLocation == null) {
            return true;
        }
        if (this.position == 0) {
            return true;
        }
        int dx = 0;
        int dy = 0;
        int dw = 0;
        int dh = 0;
        if (this.figureBounds == null) {
            this.figureBounds = this.getBounds().getCopy();
        }
        Rectangle rect = this.figureBounds.getCopy();
        Dimension diff = p.getDifference(this.startLocation);
        if ((this.position & 1) == 1) {
            dy = diff.height;
            if (this.moveOrResize) {
                dx = diff.width;
            } else {
                dh = -diff.height;
            }
        }
        if ((this.position & 8) == 8) {
            dx = diff.width;
            dx = rect.x + dx > rect.x + rect.width - 5 ? rect.width - 5 : dx;
            dw = -diff.width;
        }
        if ((this.position & 0x10) == 16) {
            dw = diff.width;
        }
        if ((this.position & 4) == 4) {
            dh = diff.height;
        }
        rect.x += dx;
        rect.y += dy;
        rect.width += dw;
        rect.width = rect.width < 150 ? 150 : rect.width;
        rect.height += dh;
        rect.height = rect.height < 150 ? 150 : rect.height;
        this.setBounds(rect);
        this.revalidate();
        return true;
    }

    protected Object doHandleMouseMove(Point p) {
        int pos;
        Rectangle rect = this.getBounds().getCopy();
        this.position = rect.shrink(10, 10).getPosition(p);
        if (this.position == 0 && (pos = rect.shrink(0, 20).getPosition(p)) == 1) {
            this.position = pos;
        }
        this.moveOrResize = false;
        Cursor newCursor = null;
        switch (this.position) {
            case 0: {
                break;
            }
            case 20: {
                newCursor = Cursors.SIZESE;
                break;
            }
            case 4: {
                newCursor = Cursors.SIZES;
                break;
            }
            case 16: {
                newCursor = Cursors.SIZEE;
                break;
            }
            case 17: {
                newCursor = Cursors.SIZENE;
                break;
            }
            case 9: {
                newCursor = Cursors.SIZENW;
                break;
            }
            case 12: {
                newCursor = Cursors.SIZESW;
                break;
            }
            case 1: {
                if (p.y > this.getBounds().y + 10 && p.y < this.getBounds().y + 40) {
                    this.moveOrResize = true;
                    break;
                }
                newCursor = Cursors.SIZEN;
                break;
            }
            case 8: {
                newCursor = Cursors.SIZEW;
            }
        }
        return newCursor;
    }

    protected Object doHandleMouseUp(Point p) {
        this.startLocation = null;
        this.position = 0;
        this.moveOrResize = false;
        return true;
    }
}

