/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.security;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.xmind.core.CoreException;
import org.xmind.core.IChecksumStream;
import org.xmind.core.internal.security.Base64;

public class ChecksumInputStream
extends FilterInputStream
implements IChecksumStream {
    private Digest digest = new MD5Digest();
    private String checksum = null;

    public ChecksumInputStream(InputStream in) throws CoreException {
        super(in);
    }

    public int read() throws IOException {
        int b = super.read();
        this.digest.update((byte)b);
        return b;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int num = super.read(b, off, len);
        this.digest.update(b, off, num);
        return num;
    }

    public String getChecksum() {
        if (this.checksum == null) {
            byte[] checksumBytes = new byte[this.digest.getDigestSize()];
            this.digest.doFinal(checksumBytes, 0);
            this.checksum = Base64.byteArrayToBase64(checksumBytes);
        }
        return this.checksum;
    }
}

