/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.resourcemanager;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.osgi.framework.Bundle;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.e4models.IContextRunnable;
import org.xmind.ui.internal.e4models.IModelPartContext;
import org.xmind.ui.internal.e4models.ModelPart;
import org.xmind.ui.internal.resourcemanager.IResourceManagerDialogPage;
import org.xmind.ui.internal.resourcemanager.ResourceManagerStyleProvider;
import org.xmind.ui.tabfolder.MTabFolder;
import org.xmind.ui.tabfolder.MTabItem;
import org.xmind.ui.util.IStyleProvider;

public class ResourceManagerDialogPart
extends ModelPart
implements IModelPartContext {
    private static final int TITLE_AREA_LABEL_MARGIN = 10;
    private static final String RESOURCE_MANAGER_EXTENSION_ID = "org.xmind.ui.resourceManager";
    private static final String DATA_ID = "org.xmind.ui.resourceManager.itemId";
    private static final String ATTR_LABEL = "label";
    private static final String ATTR_ICON_URI = "iconURI";
    private static final String ATTR_CONTRIBUTION_URI = "contributionURI";
    private static final String ATTR_ID = "id";
    private static final String TITLE_IMAGE_PATH = "platform:/plugin/org.xmind.ui.mindmap/icons/title.png";
    private MTabFolder tabFolder;
    private ResourceManager resourceManagerForPart;
    private ArrayList<IResourceManagerDialogPage> registedPages;

    protected void createContent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).applyTo(composite);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setBackground(parent.getBackground());
        this.resourceManagerForPart = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.createTitleComposite(composite);
        this.createContentComposite(composite);
        parent.layout(true, true);
    }

    private void createTitleComposite(Composite parent) {
        Composite title = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).margins(0, 0).spacing(0, 0).extendedMargins(0, 0, 0, 0).applyTo(title);
        title.setBackground(parent.getDisplay().getSystemColor(1));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)title);
        ((GridData)title.getLayoutData()).heightHint = 70;
        Composite labelsComposite = new Composite(title, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(true).margins(0, 0).spacing(0, 0).extendedMargins(10, 0, 0, 0).applyTo(labelsComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)labelsComposite);
        Label text = new Label(labelsComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 1024).applyTo((Control)text);
        text.setFont(JFaceResources.getBannerFont());
        text.setText(MindMapMessages.ResourceManagerPart_title);
        Label message = new Label(labelsComposite, 64);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 0x1000000).applyTo((Control)message);
        message.setFont(JFaceResources.getDialogFont());
        message.setText(MindMapMessages.ResourceManagerPart_message);
        Composite imageComposite = new Composite(title, 0);
        imageComposite.setLayout((Layout)new GridLayout(1, true));
        Label titleImageLabel = new Label(imageComposite, 0x1000000);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)titleImageLabel);
        ImageDescriptor imageDescriptor = null;
        try {
            imageDescriptor = ImageDescriptor.createFromURL((URL)new URL(TITLE_IMAGE_PATH));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        if (imageDescriptor != null) {
            Image img = this.resourceManagerForPart.createImage(imageDescriptor);
            titleImageLabel.setImage(img);
        } else {
            titleImageLabel.setImage(JFaceResources.getImage((String)"dialog_title_banner_image"));
        }
    }

    private void createContentComposite(Composite composite) {
        Composite content = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).margins(0, 0).spacing(0, 0).applyTo(content);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)content);
        this.tabFolder = new MTabFolder(content, 2048);
        this.tabFolder.setStyleProvider((IStyleProvider)new ResourceManagerStyleProvider(this.resourceManagerForPart));
        this.tabFolder.setBackground(composite.getDisplay().getSystemColor(37));
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tabFolder.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ResourceManagerDialogPart.this.showPage((MTabItem)event.item);
            }
        });
        final Map persistedState = ((MPart)this.getAdapter(MPart.class)).getPersistedState();
        this.tabFolder.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                MTabItem item = ResourceManagerDialogPart.this.tabFolder.getSelection();
                String pageId = (String)item.getData(ResourceManagerDialogPart.DATA_ID);
                if (pageId != null) {
                    persistedState.put("org.xmind.ui.modelPart.currentPageId", pageId);
                }
            }
        });
        String persistedSelectedPageId = (String)persistedState.get("org.xmind.ui.modelPart.currentPageId");
        MTabItem selectedItem = null;
        for (final IResourceManagerDialogPage page : this.registedPages) {
            MTabItem item = new MTabItem(this.tabFolder, 16);
            item.setText(page.getTitle());
            item.setImage(page.getImage());
            item.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    Control pageControl = page.getControl();
                    if (pageControl != null) {
                        pageControl.dispose();
                    }
                    page.dispose();
                }
            });
            item.setData((Object)page);
            item.setData(DATA_ID, (Object)page.getId());
            if (!page.getId().equals(persistedSelectedPageId)) continue;
            selectedItem = item;
        }
        if (selectedItem == null && this.tabFolder.getItemCount() > 0) {
            selectedItem = this.tabFolder.getItem(0);
        }
        this.tabFolder.setSelection(selectedItem);
        this.showPage(selectedItem);
    }

    protected void init() {
        IConfigurationElement[] elements;
        super.init();
        this.registedPages = new ArrayList();
        IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(RESOURCE_MANAGER_EXTENSION_ID);
        IConfigurationElement[] iConfigurationElementArray = elements = extPoint.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ele = iConfigurationElementArray[n2];
            try {
                IResourceManagerDialogPage page = this.readPage(ele);
                if (page != null) {
                    this.registedPages.add(page);
                }
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        ((MPart)this.getAdapter(MPart.class)).getContext().set("org.xmind.ui.modelPart.refreshPage", (Object)new IContextRunnable(){

            public void run() {
                Object page;
                if (ResourceManagerDialogPart.this.tabFolder != null && !ResourceManagerDialogPart.this.tabFolder.isDisposed() && (page = ResourceManagerDialogPart.this.tabFolder.getSelection().getData()) instanceof IResourceManagerDialogPage) {
                    ((IResourceManagerDialogPage)page).refresh();
                }
            }
        });
    }

    private IResourceManagerDialogPage readPage(IConfigurationElement element) throws InstantiationException, IllegalAccessException, MalformedURLException {
        Class cls;
        String id = element.getAttribute(ATTR_ID);
        if (id == null || "".equals(id)) {
            throw new IllegalArgumentException("No id for page.");
        }
        String contributionURI = element.getAttribute(ATTR_CONTRIBUTION_URI);
        if (contributionURI == null || !contributionURI.startsWith("bundleclass://")) {
            throw new IllegalArgumentException("Invalid contributionURI: " + contributionURI);
        }
        String[] contributionPaths = contributionURI.substring(14).split("/");
        if (contributionPaths.length != 2) {
            throw new IllegalArgumentException("Invalid contributionURI: " + contributionURI);
        }
        String bundleId = contributionPaths[0];
        String className = contributionPaths[1];
        try {
            Bundle bundle = Platform.getBundle((String)bundleId);
            if (bundle == null) {
                throw new ClassNotFoundException();
            }
            cls = bundle.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        Object contribution = ContextInjectionFactory.make((Class)cls, (IEclipseContext)((MPart)this.getAdapter(MPart.class)).getContext());
        if (!(contribution instanceof IResourceManagerDialogPage)) {
            return null;
        }
        IResourceManagerDialogPage page = (IResourceManagerDialogPage)contribution;
        page.setId(id);
        String label = element.getAttribute(ATTR_LABEL);
        page.setTitle(label);
        ImageDescriptor icon = this.readIcon(element);
        page.setImageDescriptor(icon);
        return page;
    }

    private ImageDescriptor readIcon(IConfigurationElement element) throws MalformedURLException {
        String iconURI = element.getAttribute(ATTR_ICON_URI);
        ImageDescriptor icon = iconURI == null || "".equals(iconURI) ? null : ImageDescriptor.createFromURL((URL)new URL(iconURI));
        return icon;
    }

    protected void handleBringToTop() {
        super.handleBringToTop();
        if (this.tabFolder != null && !this.tabFolder.isDisposed()) {
            MTabItem[] items;
            String pageId = (String)((MPart)this.getAdapter(MPart.class)).getPersistedState().get("org.xmind.ui.modelPart.currentPageId");
            MTabItem itemToShow = null;
            MTabItem[] mTabItemArray = items = this.tabFolder.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                MTabItem item = mTabItemArray[n2];
                if (item.getData(DATA_ID).equals(pageId)) {
                    itemToShow = item;
                    break;
                }
                ++n2;
            }
            if (itemToShow == null && this.tabFolder.getItemCount() > 0) {
                itemToShow = this.tabFolder.getItem(0);
            }
            this.tabFolder.setSelection(itemToShow);
            this.showPage(itemToShow);
        }
    }

    private void showPage(MTabItem item) {
        Object resourcePage = item.getData();
        if (resourcePage instanceof IResourceManagerDialogPage) {
            IResourceManagerDialogPage page = (IResourceManagerDialogPage)resourcePage;
            Control control = page.getControl();
            if (control == null || control.isDisposed()) {
                page.createControl(this.tabFolder.getBody());
                item.setControl(page.getControl());
            }
            this.setSelectionProvider((ISelectionProvider)page.getAdapter(ISelectionProvider.class));
            MPart part = (MPart)this.getAdapter(MPart.class);
            part.getPersistedState().put("org.xmind.ui.modelPart.currentPageId", page.getId());
            part.getContext().set("org.xmind.ui.modelPart.currentPageId", (Object)page.getId());
        }
    }
}

