/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.handlers;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.xmind.core.Core;
import org.xmind.core.IWorkbook;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.editor.PreLoadedWorkbookRef;
import org.xmind.ui.mindmap.IWorkbookRef;
import org.xmind.ui.mindmap.MindMapUI;

public class SaveAsTemplateHandler
extends AbstractHandler {
    private static final int MAX_TITLE_LENGTH = 50;
    private File tempFolder;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.saveAsTemplate(HandlerUtil.getActiveEditorChecked((ExecutionEvent)event));
        return null;
    }

    private void saveAsTemplate(IEditorPart editor) throws ExecutionException {
        InputDialog dialog;
        if (editor == null) {
            return;
        }
        Display display = Display.getCurrent();
        if (display == null || display.isDisposed()) {
            return;
        }
        IWorkbookRef workbookRef = (IWorkbookRef)editor.getAdapter(IWorkbookRef.class);
        if (workbookRef == null) {
            return;
        }
        IWorkbook workbook = workbookRef.getWorkbook();
        if (workbook == null) {
            return;
        }
        String initialName = workbookRef.getName();
        if (initialName == null) {
            initialName = "";
        }
        if ((dialog = new InputDialog(editor.getSite().getShell(), MindMapMessages.SaveAsTemplateHandler_inputDialog_title, MindMapMessages.SaveAsTemplateHandler_inputDialog_message, initialName, null)).open() != 0) {
            return;
        }
        String name = dialog.getValue();
        this.importCustomTemplate(display, editor, workbook, name.length() > 50 ? name.substring(0, 50) : name);
    }

    /*
     * Unable to fully structure code
     */
    private void importCustomTemplate(Display display, IEditorPart editor, final IWorkbook workbook, String name) throws ExecutionException {
        block34: {
            if (this.tempFolder == null) {
                this.tempFolder = new File(Core.getWorkspace().getTempDir("transient-templates"));
                this.tempFolder.mkdirs();
            }
            if (!(tempFile = new File(this.tempFolder, String.valueOf(name) + ".xmt")).exists()) {
                try {
                    tempFile.createNewFile();
                }
                catch (IOException v0) {}
            }
            tempWorkbookRef = MindMapUIPlugin.getDefault().getWorkbookRefFactory().createWorkbookRef(tempFile.toURI(), null);
            if (tempWorkbookRef == null) {
                return;
            }
            context = (IWorkbenchSiteProgressService)editor.getSite().getService(IWorkbenchSiteProgressService.class);
            Assert.isTrue((boolean)(context != null));
            try {
                context.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        IWorkbookRef sourceWorkbookRef = PreLoadedWorkbookRef.createFromLoadedWorkbook(workbook, null);
                        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        sourceWorkbookRef.open((IProgressMonitor)subMonitor.newChild(30));
                        try {
                            tempWorkbookRef.importFrom((IProgressMonitor)subMonitor.newChild(60), sourceWorkbookRef);
                            tempWorkbookRef.open(monitor);
                            tempWorkbookRef.save(monitor);
                        }
                        finally {
                            sourceWorkbookRef.close((IProgressMonitor)subMonitor.newChild(10));
                        }
                    }
                });
                template = MindMapUI.getResourceManager().addUserTemplateFromWorkbookURI(tempWorkbookRef.getURI());
            }
            catch (InterruptedException v1) {
                if (tempFile.exists()) {
                    tempFile.delete();
                }
                if (tempWorkbookRef != null) {
                    try {
                        tempWorkbookRef.close((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (InvocationTargetException e) {
                        cause = e.getTargetException();
                        if (cause == null) {
                            cause = e;
                        }
                        throw new ExecutionException(cause.getMessage(), cause);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                return;
            }
            catch (InvocationTargetException e) {
                cause = e.getTargetException();
                if (cause == null) {
                    cause = e;
                }
                throw new ExecutionException(cause.getMessage(), cause);
            }
            ** try [egrp 7[TRYBLOCK] [7 : 371->409)] { 
lbl-1000:
            // 1 sources

            {
                editor.getSite().getPage().openEditor(MindMapUI.getEditorInputFactory().createEditorInput(template.getSourceWorkbookURI()), "org.xmind.ui.MindMapEditor");
                break block34;
            }
lbl47:
            // 1 sources

            catch (PartInitException e) {
                throw new ExecutionException(e.getMessage(), (Throwable)e);
            }
            finally {
                if (tempFile.exists()) {
                    tempFile.delete();
                }
                if (tempWorkbookRef != null) {
                    try {
                        tempWorkbookRef.close((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (InvocationTargetException e) {
                        cause = e.getTargetException();
                        if (cause == null) {
                            cause = e;
                        }
                        throw new ExecutionException(cause.getMessage(), cause);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

