/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.xmind.core.ITopic;
import org.xmind.ui.mindmap.IInfoItemContributor;
import org.xmind.ui.mindmap.IInfoItemPart;
import org.xmind.ui.mindmap.IInfoPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.util.Logger;

public class InfoItemContributorProxy
implements IInfoItemContributor {
    private static final IInfoItemContributor NULL_CONTRIBUTOR = new NullInfoItemContributor();
    private IConfigurationElement element;
    private String id;
    private ImageDescriptor icon;
    private String label;
    private String tooltip;
    private String defaultMode;
    private String availableModes;
    private String cardLabel;
    private IInfoItemContributor implementation;

    public InfoItemContributorProxy(IConfigurationElement element) throws CoreException {
        this.element = element;
        this.id = element.getAttribute("id");
        this.label = element.getAttribute("label");
        this.tooltip = element.getAttribute("tooltip");
        this.defaultMode = element.getAttribute("defaultMode");
        this.availableModes = element.getAttribute("availableModes");
        this.cardLabel = element.getAttribute("cardLabel");
        if (RegistryReader.getClassValue((IConfigurationElement)element, (String)"contributorClass") == null) {
            throw new CoreException((IStatus)new Status(4, element.getNamespaceIdentifier(), 0, "Invalid extension (missing class name): " + this.id, null));
        }
    }

    @Override
    public IAction createAction(ITopicPart topicPart, ITopic topic) {
        IAction action = this.getImplementation().createAction(topicPart, topic);
        if (action != null) {
            if (action.getImageDescriptor() == null) {
                action.setImageDescriptor(this.getIcon());
            }
            if (action.getText() == null) {
                action.setText(this.getLabel());
            }
            if (action.getToolTipText() == null) {
                action.setToolTipText(this.getTooltip());
            }
        }
        return action;
    }

    @Override
    public String getContent(ITopic topic) {
        return this.getImplementation().getContent(topic);
    }

    public ImageDescriptor getIcon() {
        if (this.icon == null) {
            this.icon = this.createIcon();
        }
        return this.icon;
    }

    public String getLabel() {
        return this.label;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDefaultMode() {
        return this.defaultMode;
    }

    @Override
    public String getAvailableModes() {
        return this.availableModes;
    }

    @Override
    public String getCardLabel() {
        return this.cardLabel;
    }

    @Override
    public String getSVGFilePath(ITopic topic, IAction action) {
        return this.getImplementation().getSVGFilePath(topic, action);
    }

    @Override
    public boolean isCardModeAvailable(ITopic topic, ITopicPart topicPart) {
        return this.getImplementation().isCardModeAvailable(topic, topicPart);
    }

    private ImageDescriptor createIcon() {
        String iconName = this.element.getAttribute("icon");
        if (iconName != null) {
            String plugId = this.element.getNamespaceIdentifier();
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)plugId, (String)iconName);
        }
        return null;
    }

    public IInfoItemContributor getImplementation() {
        if (this.implementation == null) {
            try {
                this.implementation = (IInfoItemContributor)this.element.createExecutableExtension("contributorClass");
            }
            catch (CoreException e) {
                Logger.log(e, "Failed to create icon tip contributor from class: " + RegistryReader.getClassValue((IConfigurationElement)this.element, (String)"contributorClass"));
                this.implementation = NULL_CONTRIBUTOR;
            }
        }
        return this.implementation;
    }

    @Override
    public void fillContextMenu(IInfoItemPart part) {
        this.getImplementation().fillContextMenu(part);
    }

    @Override
    public void topicActivated(IInfoPart infoPart) {
        this.getImplementation().topicActivated(infoPart);
    }

    @Override
    public void topicDeactivated(IInfoPart infoPart) {
        this.getImplementation().topicDeactivated(infoPart);
    }

    @Override
    public void topicActivated(ITopicPart topicPart) {
        this.getImplementation().topicActivated(topicPart);
    }

    @Override
    public void topicDeactivated(ITopicPart topicPart) {
        this.getImplementation().topicDeactivated(topicPart);
    }

    @Override
    public List<IAction> getPopupMenuActions(ITopicPart topicPart, ITopic topic) {
        return this.getImplementation().getPopupMenuActions(topicPart, topic);
    }

    @Override
    public boolean isModified(ITopicPart topicPart, ITopic topic, IAction action) {
        return this.getImplementation().isModified(topicPart, topic, action);
    }

    private static class NullInfoItemContributor
    implements IInfoItemContributor {
        private NullInfoItemContributor() {
        }

        @Override
        public IAction createAction(ITopicPart topicPart, ITopic topic) {
            return null;
        }

        @Override
        public String getContent(ITopic topic) {
            return null;
        }

        @Override
        public void fillContextMenu(IInfoItemPart part) {
        }

        @Override
        public void topicActivated(ITopicPart topicPart) {
        }

        @Override
        public void topicDeactivated(ITopicPart topicPart) {
        }

        @Override
        public void topicActivated(IInfoPart infoPart) {
        }

        @Override
        public void topicDeactivated(IInfoPart infoPart) {
        }

        @Override
        public String getId() {
            return null;
        }

        @Override
        public String getDefaultMode() {
            return null;
        }

        @Override
        public String getAvailableModes() {
            return null;
        }

        @Override
        public String getCardLabel() {
            return null;
        }

        @Override
        public String getSVGFilePath(ITopic topic, IAction action) {
            return null;
        }

        @Override
        public boolean isCardModeAvailable(ITopic topic, ITopicPart topicPart) {
            return false;
        }

        @Override
        public List<IAction> getPopupMenuActions(ITopicPart topicPart, ITopic topic) {
            return Collections.emptyList();
        }

        @Override
        public boolean isModified(ITopicPart topicPart, ITopic topic, IAction action) {
            return true;
        }
    }
}

