/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import org.xmind.core.IAdaptable;
import org.xmind.core.IRevision;
import org.xmind.core.IRevisionManager;
import org.xmind.core.IWorkbook;
import org.xmind.core.plain.RevisionManager;
import org.xmind.core.plain.Workbook;

public class Revision
implements IRevision {
    private final Workbook ownerWorkbook;
    private final RevisionManager manager;
    private final int number;
    private final long timestamp;
    private final IAdaptable content;
    private boolean orphan;

    public Revision(Workbook ownerWorkbook, RevisionManager manager, int number, long timestamp, IAdaptable content) {
        this.ownerWorkbook = ownerWorkbook;
        this.manager = manager;
        this.number = number;
        this.timestamp = timestamp;
        this.content = content;
        this.orphan = true;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IWorkbook.class.equals(adapter)) {
            return adapter.cast(this.getOwnedWorkbook());
        }
        return null;
    }

    public IWorkbook getOwnedWorkbook() {
        return this.ownerWorkbook;
    }

    public boolean isOrphan() {
        return this.orphan;
    }

    public int compareTo(IRevision that) {
        int c = this.getRevisionNumber() - that.getRevisionNumber();
        if (c == 0) {
            c = (int)(this.getTimestamp() - that.getTimestamp());
        }
        return c;
    }

    public String getContentType() {
        return this.manager.getContentType();
    }

    public String getResourceId() {
        return this.manager.getResourceId();
    }

    public int getRevisionNumber() {
        return this.number;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public IAdaptable getContent() {
        return this.content;
    }

    public IRevisionManager getOwnedManager() {
        return this.manager;
    }

    protected void onOrphan() {
        this.orphan = true;
    }

    protected void onParented() {
        this.orphan = false;
    }
}

