/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.exports.opml;

import java.lang.reflect.InvocationTargetException;
import net.xmind.verify.ui.VerifyUI20141031;
import net.xmind.verify.ui.VerifyWizardPage20141031;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.exports.ExportMessages;
import org.xmind.ui.internal.exports.opml.OpmlExporter;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.wizards.AbstractMindMapExportPage;
import org.xmind.ui.wizards.DocumentExportWizard;
import org.xmind.ui.wizards.IExporter;

public class OpmlExportWizard
extends DocumentExportWizard {
    private static String DIALOG_SETTINGS_SECTION_ID = "org.xmind.ui.export.opml";
    private static String OPML_EXPORT_PAGE_NAME = "opmlExportPage";
    private static String FILTER_OPML = "*.opml";
    private static String EXT_OPML_FILE = ".opml";

    public OpmlExportWizard() {
        this.setWindowTitle(ExportMessages.OpmlExportWizard_windowTitle);
        this.setDefaultPageImageDescriptor(MindMapUI.getImages().getWizBan("export_wiz.png"));
        this.setDialogSettings(MindMapUIPlugin.getDefault().getDialogSettings(DIALOG_SETTINGS_SECTION_ID));
    }

    protected void addValidPages() {
        this.addPage((IWizardPage)new VerifyWizardPage20141031("ExportToOPML", ExportMessages.OpmlExportWizard_Export_To_OPML));
        this.addPage((IWizardPage)new OpmlExportPage());
    }

    public IExporter createExporter() {
        IMindMap mindMap = this.getSourceMindMap();
        ISheet sheet = mindMap.getSheet();
        ITopic centralTopic = mindMap.getCentralTopic();
        OpmlExporter exporter = new OpmlExporter(sheet, centralTopic, this.getTargetPath());
        exporter.setDialogSettings(this.getDialogSettings());
        exporter.init();
        return exporter;
    }

    protected String getFormatName() {
        return ExportMessages.OpmlExportWizard_formatName;
    }

    protected String getSuggestedFileName() {
        return String.valueOf(super.getSuggestedFileName()) + EXT_OPML_FILE;
    }

    protected void doExport(IProgressMonitor monitor, Display display, Shell parentShell) throws InvocationTargetException, InterruptedException {
        VerifyUI20141031.getUsageDataCollector().increase("ExportToOPMLCount");
        super.doExport(monitor, display, parentShell);
    }

    private class OpmlExportPage
    extends AbstractMindMapExportPage {
        public OpmlExportPage() {
            super(OPML_EXPORT_PAGE_NAME, ExportMessages.OpmlExportPage_title);
            this.setDescription(ExportMessages.OpmlExportPage_description);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.verticalSpacing = 15;
            composite.setLayout((Layout)layout);
            this.setControl((Control)composite);
            Control fileGroup = this.createFileControls(composite);
            fileGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        }

        protected FileDialog createBrowseDialog() {
            FileDialog fileDialog = super.createBrowseDialog();
            fileDialog.setFilterNames(new String[]{ExportMessages.OpmlExportPage_FileDialog_OPMLFile, ExportMessages.OpmlExportWizard_File_All});
            fileDialog.setFilterExtensions(new String[]{FILTER_OPML, EXT_OPML_FILE});
            return fileDialog;
        }
    }
}

