/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.xmind.gef.ISelectionStack;
import org.xmind.gef.command.CommandStackEvent;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.command.ICommandStackListener;

public class SelectionStack
implements ISelectionStack,
ICommandStackListener {
    private ISelectionProvider selectionProvider = null;
    private ICommandStack commandStack = null;
    private List<ISelection> selections = null;
    private int cursor = 0;

    public void setSelectionProvider(ISelectionProvider selectionProvider) {
        if (selectionProvider == this.selectionProvider) {
            return;
        }
        this.selectionProvider = selectionProvider;
        this.selections = null;
        this.cursor = 0;
    }

    public void setCommandStack(ICommandStack commandStack) {
        ICommandStack oldCS = this.commandStack;
        if (commandStack == oldCS) {
            return;
        }
        if (oldCS != null) {
            oldCS.removeCSListener(this);
        }
        this.commandStack = commandStack;
        if (commandStack != null) {
            commandStack.addCSListener(this);
        }
    }

    public void handleCommandStackEvent(CommandStackEvent event) {
        if (this.selectionProvider == null) {
            return;
        }
        if (this.selections == null) {
            this.selections = new ArrayList<ISelection>(30);
        }
        if ((event.getStatus() & 1) != 0) {
            this.preExecute();
        } else if ((event.getStatus() & 4) != 0) {
            this.preUndo();
        } else if ((event.getStatus() & 2) != 0) {
            this.preRedo();
        } else if ((event.getStatus() & 8) != 0) {
            this.postExecute();
        } else if ((event.getStatus() & 0x20) != 0) {
            this.postUndo();
        } else if ((event.getStatus() & 0x10) != 0) {
            this.postRedo();
        }
    }

    protected void preExecute() {
        this.clearFromCursor();
        if (this.cursor >= 0 && this.cursor <= this.selections.size()) {
            ISelection selection = this.selectionProvider.getSelection();
            this.selections.add(this.cursor, selection);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void clearFromCursor() {
        block1: {
            if (this.cursor > 0) ** GOTO lbl6
            this.selections.clear();
            break block1;
lbl-1000:
            // 1 sources

            {
                this.selections.remove(this.selections.size() - 1);
lbl6:
                // 2 sources

                ** while (this.cursor < this.selections.size())
            }
        }
    }

    protected void postExecute() {
        this.restoreSelection();
        ++this.cursor;
    }

    protected void preUndo() {
        ISelection selection = this.selectionProvider.getSelection();
        if (this.cursor == this.selections.size()) {
            this.selections.add(this.cursor, selection);
        } else if (this.cursor >= 0 && this.cursor < this.selections.size()) {
            this.selections.set(this.cursor, selection);
        }
    }

    protected void postUndo() {
        --this.cursor;
        this.restoreSelection();
    }

    protected void preRedo() {
        if (this.cursor >= 0 && this.cursor < this.selections.size()) {
            ISelection selection = this.selectionProvider.getSelection();
            this.selections.set(this.cursor, selection);
        } else if (this.cursor == this.selections.size()) {
            ISelection selection = this.selectionProvider.getSelection();
            this.selections.add(this.cursor, selection);
        }
    }

    protected void postRedo() {
        ++this.cursor;
        this.restoreSelection();
    }

    protected void restoreSelection() {
        ISelection selection;
        if (this.cursor >= 0 && this.cursor < this.selections.size() && (selection = this.selections.get(this.cursor)) != null) {
            this.selectionProvider.setSelection(selection);
        }
    }
}

