/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;
import org.xmind.ui.gantt2.viewer.Colors;
import org.xmind.ui.gantt2.viewer.TaskTreeItemPart;

public class ChevronFigure
extends Figure {
    private static final int FLAG_FOLDED = MAX_FLAG << 1;

    public ChevronFigure() {
        this.setPreferredSize(14, TaskTreeItemPart.HEIGHT);
        this.setForegroundColor(Colors.chevron());
        this.setOpaque(false);
    }

    public boolean isFolded() {
        return this.getFlag(FLAG_FOLDED);
    }

    public void setFolded(boolean folded) {
        if (folded == this.isFolded()) {
            return;
        }
        this.setFlag(FLAG_FOLDED, folded);
        this.repaint();
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        Rectangle r = this.getClientArea();
        Path path = new Path((Device)Display.getCurrent());
        float x = r.x;
        float y = r.y;
        if (this.isFolded()) {
            path.moveTo(x + 5.0f, y + 1.0f);
            path.lineTo(x + 11.0f, y + 5.0f);
            path.lineTo(x + 5.0f, y + 9.0f);
        } else {
            path.moveTo(x + 3.0f, y + 3.0f);
            path.lineTo(x + 11.0f, y + 3.0f);
            path.lineTo(x + 7.0f, y + 9.0f);
        }
        path.close();
        graphics.setBackgroundColor(graphics.getForegroundColor());
        graphics.fillPath(path);
    }
}

