/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.IAdaptable;
import org.xmind.core.IResourceRef;
import org.xmind.core.IWorkbook;
import org.xmind.core.IWorkbookExtensionElement;
import org.xmind.core.internal.WorkbookExtension;
import org.xmind.core.internal.dom.INodeAdaptableProvider;
import org.xmind.core.internal.dom.NS;
import org.xmind.core.internal.dom.ResourceRefImpl;
import org.xmind.core.internal.dom.WorkbookExtensionElementImpl;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.util.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkbookExtensionImpl
extends WorkbookExtension
implements INodeAdaptableProvider {
    private Map<Element, WorkbookExtensionElementImpl> eleMap = new HashMap<Element, WorkbookExtensionElementImpl>();
    private Document implementation;
    private WorkbookImpl workbook;
    private WorkbookExtensionElementImpl content;

    public WorkbookExtensionImpl(Document implementation, WorkbookImpl workbook) {
        this.implementation = implementation;
        this.workbook = workbook;
        this.init();
    }

    private void init() {
        Element e = this.getExtensionElement();
        NS[] nSArray = NS.values();
        int n = nSArray.length;
        int n2 = 0;
        while (n2 < n) {
            NS ns = nSArray[n2];
            if (ns.getPrefix().equals(e.getTagName())) {
                NS.setNS(ns, e, new NS[0]);
            }
            ++n2;
        }
    }

    private Element getExtensionElement() {
        return this.implementation.getDocumentElement();
    }

    protected void addNotify(WorkbookImpl workbook) {
        for (IResourceRef ref : this.getResourceRefs()) {
            ((ResourceRefImpl)ref).addNotify(workbook);
        }
    }

    protected void removeNotify(WorkbookImpl workbook) {
        for (IResourceRef ref : this.getResourceRefs()) {
            ((ResourceRefImpl)ref).removeNotify(workbook);
        }
    }

    public Document getImplementation() {
        return this.implementation;
    }

    @Override
    public String getProviderName() {
        return this.getExtensionElement().getAttribute("provider");
    }

    @Override
    public IWorkbookExtensionElement getContent() {
        if (this.content == null) {
            this.content = new WorkbookExtensionElementImpl(this.getContentElement(), this.workbook, this);
            this.registerElement(this.content);
        }
        return this.content;
    }

    private Element getContentElement() {
        return DOMUtils.ensureChildElement(this.getExtensionElement(), "content");
    }

    @Override
    public List<IResourceRef> getResourceRefs() {
        Element refsEle = this.getRefsElement();
        if (refsEle != null) {
            return DOMUtils.getChildList(refsEle, "resource-ref", this.workbook.getAdaptableRegistry());
        }
        return EMPTY_REFS;
    }

    @Override
    public IResourceRef getResourceRef(String resourceId) {
        if (resourceId != null && !"".equals(resourceId)) {
            for (IResourceRef ref : this.getResourceRefs()) {
                if (!resourceId.equals(ref.getResourceId())) continue;
                return ref;
            }
        }
        return null;
    }

    @Override
    public void addResourceRef(IResourceRef ref) {
        this.importResourceRef(ref);
        Element refEle = ((ResourceRefImpl)ref).getImplementation();
        Element refsEle = DOMUtils.ensureChildElement(this.getExtensionElement(), "resource-refs");
        Node n = refsEle.appendChild(refEle);
        if (n != null && !this.isOrphan()) {
            ((ResourceRefImpl)ref).addNotify(this.workbook);
        }
        this.workbook.updateModificationInfo();
    }

    private void importResourceRef(IResourceRef ref) {
        Element oldValue = ((ResourceRefImpl)ref).getImplementation();
        Element newValue = this.implementation.createElement(oldValue.getTagName());
        newValue.setAttribute("resource-id", ref.getResourceId());
        newValue.setAttribute("type", ref.getType());
        ((ResourceRefImpl)ref).setImplementation(newValue);
    }

    @Override
    public void removeResourceRef(IResourceRef ref) {
        Element refsEle = this.getRefsElement();
        if (refsEle == null) {
            return;
        }
        Element refEle = ((ResourceRefImpl)ref).getImplementation();
        if (refEle.getParentNode() == refsEle) {
            ((ResourceRefImpl)ref).removeNotify(this.workbook);
            Node n = refsEle.removeChild(refEle);
            if (!refsEle.hasChildNodes()) {
                this.getExtensionElement().removeChild(refsEle);
            }
            if (n != null) {
                this.workbook.updateModificationInfo();
            }
        }
    }

    private Element getRefsElement() {
        return DOMUtils.getFirstChildElementByTag(this.getExtensionElement(), "resource-refs");
    }

    @Override
    public IWorkbook getOwnedWorkbook() {
        return this.workbook;
    }

    @Override
    public IAdaptable getAdaptable(Node node) {
        if (node instanceof Element) {
            return this.getElement((Element)node);
        }
        return null;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(Element.class)) {
            return adapter.cast(this.getImplementation());
        }
        return super.getAdapter(adapter);
    }

    protected WorkbookExtensionElementImpl getElement(Element impl) {
        if (impl == this.getExtensionElement()) {
            return null;
        }
        WorkbookExtensionElementImpl ele = this.eleMap.get(impl);
        if (ele == null) {
            ele = new WorkbookExtensionElementImpl(impl, this.workbook, this);
            this.registerElement(ele);
        }
        return ele;
    }

    protected void registerElement(WorkbookExtensionElementImpl element) {
        this.eleMap.put(element.getImplementation(), element);
    }

    protected void unregisterElement(WorkbookExtensionElementImpl element) {
        this.eleMap.remove(element.getImplementation());
    }

    @Override
    public boolean isOrphan() {
        return DOMUtils.isOrphanNode(this.implementation);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof WorkbookExtensionImpl)) {
            return false;
        }
        WorkbookExtensionImpl that = (WorkbookExtensionImpl)obj;
        return this.implementation == that.implementation;
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    public String toString() {
        return "{workbook-extension:" + this.getProviderName() + "}";
    }
}

