/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gallery;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.xmind.gef.GraphicalViewer;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.service.GraphicalViewerService;
import org.xmind.ui.gallery.NavigationContentPart;
import org.xmind.ui.gallery.NavigationItemFigure;

public class NavigationAnimationService
extends GraphicalViewerService
implements ISelectionChangedListener {
    private static final int DURATION = 100;

    public NavigationAnimationService(IGraphicalViewer viewer) {
        super(viewer);
    }

    protected void activate() {
        this.getViewer().addFocusedPartChangedListener((ISelectionChangedListener)this);
    }

    protected void deactivate() {
        this.getViewer().removeFocusedPartChangedListener((ISelectionChangedListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!this.isActive()) {
            return;
        }
        ItemStates sourceStates = this.captureStates();
        if (!this.applySelectionChanges(event.getSelection())) {
            return;
        }
        UpdateManager updateManager = ((GraphicalViewer)this.getViewer()).getLightweightSystem().getUpdateManager();
        updateManager.performValidation();
        ItemStates targetStates = this.captureStates();
        new Transition(updateManager, sourceStates, targetStates).start();
    }

    private boolean applySelectionChanges(ISelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        IPart part = this.getViewer().findPart(((IStructuredSelection)selection).getFirstElement());
        if (part == null) {
            return false;
        }
        IPart parent = this.getViewer().getRootPart().getContents();
        for (IPart child : parent.getChildren()) {
            NavigationItemFigure childFigure = (NavigationItemFigure)((IGraphicalPart)child).getFigure();
            if (child == part) {
                childFigure.setState(1.0);
                childFigure.getParent().setConstraint((IFigure)childFigure, (Object)childFigure);
                continue;
            }
            childFigure.setState(0.0);
        }
        ((NavigationContentPart)this.getViewer().getRootPart().getContents()).resetScrollOffset();
        return true;
    }

    public ItemStates captureStates() {
        IGraphicalPart contentPart = (IGraphicalPart)this.getViewer().getRootPart().getContents();
        return new ItemStates(contentPart.getContentPane(), contentPart.getFigure());
    }

    private static double seg(double min, double max, double ratio) {
        return min + (max - min) * ratio;
    }

    private static class ItemState {
        public double state;
        public Rectangle bounds;

        public ItemState(NavigationItemFigure figure) {
            this.state = figure.getState();
            this.bounds = new Rectangle(figure.getBounds());
        }
    }

    private static class ItemStates {
        private Map<IFigure, ItemState> states = new HashMap<IFigure, ItemState>();
        public IFigure itemParent;
        public IFigure content;
        public IFigure contentParent;
        public Rectangle contentBounds;

        public ItemStates(IFigure parent, IFigure content) {
            this.itemParent = parent;
            List children = parent.getChildren();
            int i = 0;
            while (i < children.size()) {
                IFigure child = (IFigure)children.get(i);
                this.states.put(child, new ItemState((NavigationItemFigure)child));
                ++i;
            }
            this.content = content;
            this.contentParent = content.getParent();
            this.contentBounds = new Rectangle(content.getBounds());
        }

        public Iterator<IFigure> figures() {
            return this.states.keySet().iterator();
        }

        public ItemState getState(IFigure figure) {
            return this.states.get(figure);
        }

        public void apply() {
            Iterator<IFigure> it = this.figures();
            while (it.hasNext()) {
                IFigure figure = it.next();
                ItemState state = this.getState(figure);
                ((NavigationItemFigure)figure).setState(state.state);
                figure.setBounds(state.bounds);
            }
            this.content.setBounds(this.contentBounds);
        }
    }

    private class Transition
    extends LayoutListener.Stub
    implements Runnable {
        private UpdateManager updateManager;
        private ItemStates sourceStates;
        private ItemStates targetStates;
        private long start = 0L;
        private long end = 0L;

        public Transition(UpdateManager updateManager, ItemStates sourceStates, ItemStates targetStates) {
            this.updateManager = updateManager;
            this.sourceStates = sourceStates;
            this.targetStates = targetStates;
        }

        public void start() {
            this.sourceStates.itemParent.addLayoutListener((LayoutListener)this);
            this.sourceStates.contentParent.addLayoutListener((LayoutListener)this);
            this.start = System.currentTimeMillis();
            this.end = this.start + 100L;
            this.sourceStates.apply();
            try {
                while (System.currentTimeMillis() < this.end) {
                    this.run();
                }
            }
            catch (IllegalStateException illegalStateException) {}
            this.targetStates.apply();
        }

        private double getRatio() {
            double time = System.currentTimeMillis();
            if (time > (double)this.end) {
                return -1.0;
            }
            double ratio = (time - (double)this.start) / 100.0;
            return Math.max(0.0, Math.min(1.0, ratio));
        }

        public boolean layout(IFigure container) {
            double r = this.getRatio();
            if (r < 0.0) {
                return false;
            }
            if (container == this.sourceStates.itemParent) {
                Rectangle b = new Rectangle();
                List children = container.getChildren();
                int i = 0;
                while (i < children.size()) {
                    IFigure child = (IFigure)children.get(i);
                    ItemState s1 = this.sourceStates.getState(child);
                    ItemState s2 = this.targetStates.getState(child);
                    int x = (int)NavigationAnimationService.seg(s1.bounds.x, s2.bounds.x, r);
                    int y = (int)NavigationAnimationService.seg(s1.bounds.y, s2.bounds.y, r);
                    int w = (int)NavigationAnimationService.seg(s1.bounds.width, s2.bounds.width, r);
                    int h = (int)NavigationAnimationService.seg(s1.bounds.height, s2.bounds.height, r);
                    b.setBounds(x, y, w, h);
                    child.setBounds(b);
                    ++i;
                }
            } else if (container == this.sourceStates.contentParent) {
                Rectangle b = new Rectangle();
                Rectangle r1 = this.sourceStates.contentBounds;
                Rectangle r2 = this.targetStates.contentBounds;
                b.x = (int)NavigationAnimationService.seg(r1.x, r2.x, r);
                b.y = (int)NavigationAnimationService.seg(r1.y, r2.y, r);
                b.width = (int)NavigationAnimationService.seg(r1.width, r2.width, r);
                b.height = (int)NavigationAnimationService.seg(r1.height, r2.height, r);
                this.sourceStates.content.setBounds(b);
            }
            return true;
        }

        @Override
        public void run() {
            double r = this.getRatio();
            if (r < 0.0) {
                throw new IllegalStateException("Animation is finished.");
            }
            this.changeState(r);
            this.sourceStates.itemParent.revalidate();
            this.updateManager.performUpdate();
        }

        private void changeState(double r) {
            Iterator<IFigure> it = this.sourceStates.figures();
            while (it.hasNext()) {
                NavigationItemFigure figure = (NavigationItemFigure)it.next();
                ItemState s1 = this.sourceStates.getState((IFigure)figure);
                ItemState s2 = this.targetStates.getState((IFigure)figure);
                figure.setState(NavigationAnimationService.seg(s1.state, s2.state, r));
            }
        }
    }
}

