/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.aspose.exports.project;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.xmind.ui.internal.aspose.AsposePlugin;
import org.xmind.ui.internal.aspose.exports.ExportMessages;
import org.xmind.ui.internal.aspose.exports.MSExportConstants;
import org.xmind.ui.mindmap.MindMapUI;

public class PriorityMappingDialog
extends Dialog {
    private static final int MAX_VALUE = 1000;
    private static final int MIN_VALUE = 0;
    private static final int INCREAMENT = 20;
    private List<Spinner> spinners = null;
    private Label imageLabel = null;
    private Label warningLabel = null;

    protected PriorityMappingDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ExportMessages.PriorityMappingDialog_Title);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return AsposePlugin.getDefault().getPreferenceStore();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(composite);
        this.createContentArea(composite);
        return composite;
    }

    private void createContentArea(Composite parent) {
        Composite body = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 10).numColumns(2).equalWidth(true).applyTo(body);
        this.createDescription(body);
        this.createMappings(body);
        this.createWarningMessage(body);
    }

    private void createMappings(Composite parent) {
        if (this.spinners == null) {
            this.spinners = new ArrayList<Spinner>();
        }
        int i = 0;
        while (i < 9) {
            Label label = new Label(parent, 0x1000000);
            label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
            Image image = null;
            try {
                image = new Image(null, Platform.getBundle((String)"org.xmind.ui.aspose").getEntry("icons/priority_" + (i + 1) + ".png").openStream());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            label.setImage(image);
            Spinner spinner = new Spinner(parent, 2048);
            spinner.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
            this.setSpinnerValues(spinner, i);
            spinner.setRedraw(true);
            spinner.setVisible(true);
            spinner.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PriorityMappingDialog.this.checkPriorityMap();
                }
            });
            spinner.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    PriorityMappingDialog.this.checkPriorityMap();
                }

                public void focusGained(FocusEvent e) {
                    PriorityMappingDialog.this.checkPriorityMap();
                }
            });
            this.spinners.add(spinner);
            ++i;
        }
        Label default_priority = new Label(parent, 0x1000000);
        default_priority.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        default_priority.setText(ExportMessages.Default_Priority);
        Spinner spinner = new Spinner(parent, 2048);
        spinner.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.setSpinnerValues(spinner, 9);
        spinner.setVisible(true);
        this.spinners.add(spinner);
    }

    private void createDescription(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().spacing(10, 5).extendedMargins(10, 10, 20, 20).applyTo(composite);
        GridDataFactory.fillDefaults().span(2, 2).grab(true, true).applyTo((Control)composite);
        composite.setBackground(parent.getDisplay().getSystemColor(1));
        Label descriptionLabel = new Label(composite, 0);
        descriptionLabel.setLayoutData((Object)new GridData(1, 128, false, false, 2, 2));
        descriptionLabel.setText(ExportMessages.PriorityPage_Text);
        Label xmindLabel = new Label(parent, 0x1000000);
        FontData fontData = xmindLabel.getFont().getFontData()[0];
        Font font = new Font((Device)parent.getDisplay(), new FontData(fontData.getName(), fontData.getHeight(), 1));
        xmindLabel.setFont(font);
        xmindLabel.setLayoutData((Object)new GridData(0x1000000, 128, false, false, 1, 1));
        xmindLabel.setText(ExportMessages.XMind_Priority_Text);
        Label msprojectLabel = new Label(parent, 0x1000000);
        msprojectLabel.setFont(font);
        msprojectLabel.setLayoutData((Object)new GridData(0x1000000, 128, false, false, 1, 1));
        msprojectLabel.setText(ExportMessages.MSProject_Priority_Text);
    }

    private void checkPriorityMap() {
        if (this.imageLabel != null && !this.imageLabel.isDisposed() && this.warningLabel != null && !this.warningLabel.isDisposed()) {
            this.imageLabel.setVisible(!this.isAllPriorityValid());
            this.warningLabel.setVisible(!this.isAllPriorityValid());
        }
    }

    private boolean isAllPriorityValid() {
        int i = 0;
        while (i < 8) {
            if (this.comparePriority(this.spinners.get(i), this.spinners.get(i + 1))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean comparePriority(Spinner preSpinner, Spinner nextSpinner) {
        return preSpinner.getSelection() <= nextSpinner.getSelection();
    }

    private void setSpinnerValues(Spinner spinner, int i) {
        spinner.setMinimum(0);
        spinner.setMaximum(1000);
        spinner.setIncrement(20);
        if (!this.doGetPreferenceStore().contains("org.xmind.ui.aspose.exports.project.priority9")) {
            this.initPriorityMap();
            this.setDefaultSpinner(spinner, i);
        } else {
            spinner.setSelection(this.doGetPreferenceStore().getInt("org.xmind.ui.aspose.exports.project.priority" + i));
        }
    }

    private void setDefaultSpinner(Spinner spinner, int i) {
        if (9 == i) {
            spinner.setSelection(500);
        } else {
            spinner.setSelection(MSExportConstants.DEFAULT_PRIORITYS[i]);
        }
    }

    private void initPriorityMap() {
        int i = 0;
        while (i < 9) {
            this.doGetPreferenceStore().setValue("org.xmind.ui.aspose.exports.project.priority" + i, MSExportConstants.DEFAULT_PRIORITYS[i]);
            ++i;
        }
        this.doGetPreferenceStore().setValue("org.xmind.ui.aspose.exports.project.priority9", 500);
    }

    private void createWarningMessage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().spacing(10, 5).numColumns(2).extendedMargins(0, 10, 5, 5).applyTo(composite);
        GridDataFactory.fillDefaults().span(2, 2).grab(true, true).align(0x1000000, 0x1000000).applyTo((Control)composite);
        this.imageLabel = new Label(composite, 0);
        ImageDescriptor img = MindMapUI.getImages().get("icons/misc/warning.png");
        if (img != null) {
            this.imageLabel.setImage(img.createImage());
        }
        this.warningLabel = new Label(composite, 0);
        this.warningLabel.setText(ExportMessages.Priority_warningMessage);
        this.warningLabel.setForeground(parent.getDisplay().getSystemColor(3));
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 10, 5).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        composite.setBackground(parent.getDisplay().getSystemColor(1));
        Composite buttonBar = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().applyTo(buttonBar);
        GridDataFactory.fillDefaults().grab(true, true).align(0x1000008, 0x1000008).applyTo((Control)buttonBar);
        buttonBar.setBackground(composite.getBackground());
        this.createButtonsForButtonBar(buttonBar);
        return buttonBar;
    }

    protected void okPressed() {
        this.saveChange();
        super.okPressed();
    }

    private void saveChange() {
        int i = 0;
        while (i < 10) {
            this.doGetPreferenceStore().setValue("org.xmind.ui.aspose.exports.project.priority" + i, this.spinners.get(i).getSelection());
            ++i;
        }
    }
}

