/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind.handlers;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.xmind.seawind.internal.core.SeawindWorkbook;
import org.xmind.ui.internal.seawind.SeawindLibrary;
import org.xmind.ui.internal.seawind.SeawindMessages;
import org.xmind.ui.internal.seawind.SeawindUIPlugin;
import org.xmind.ui.internal.seawind.URIUtils;
import org.xmind.ui.mindmap.IWorkbookRef;

public class DuplicateCloudMapHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object element;
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && URIUtils.isSeawindWorkbookRef(element = ((IStructuredSelection)selection).getFirstElement())) {
            this.duplicateSeawindWorkbookRef(window, (IWorkbookRef)element);
        }
        return null;
    }

    private void duplicateSeawindWorkbookRef(IWorkbenchWindow window, final IWorkbookRef sourceWorkbookRef) throws ExecutionException {
        URI newWorkbookURI;
        String sourceName = sourceWorkbookRef.getName();
        String newName = NLS.bind((String)SeawindMessages.DuplicatedWorkbookName_withOldWorkbookName, (Object)sourceName);
        SeawindLibrary library = SeawindUIPlugin.getSeawindLibrary();
        final IWorkbookRef newWorkbookRef = library.createWorkbookRef(newWorkbookURI = library.createNewWorkbookRefURI(newName, false), null, false);
        Assert.isTrue((newWorkbookRef != null ? 1 : 0) != 0);
        try {
            window.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    sourceWorkbookRef.open((IProgressMonitor)subMonitor.newChild(39));
                    try {
                        newWorkbookRef.importFrom((IProgressMonitor)subMonitor.newChild(60), sourceWorkbookRef);
                        ((SeawindWorkbook)newWorkbookRef.getAdapter(SeawindWorkbook.class)).setModificationTime(System.currentTimeMillis());
                    }
                    finally {
                        subMonitor.setWorkRemaining(1);
                        sourceWorkbookRef.close((IProgressMonitor)subMonitor.newChild(1));
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause == null) {
                cause = e;
            }
            throw new ExecutionException(cause.getMessage(), cause);
        }
    }
}

