/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.json.JSONObject;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;
import org.xmind.seawind.internal.core.JSON;
import org.xmind.seawind.internal.core.MonitoredOutputTarget;
import org.xmind.seawind.internal.core.SPath;
import org.xmind.seawind.internal.core.SeawindFile;
import org.xmind.seawind.internal.core.SeawindFolder;
import org.xmind.seawind.internal.core.SeawindWorkbook;
import org.xmind.seawind.internal.core.SeawindWorkingSet;

public class SeawindFolderManager {
    private SeawindFolder seawindFolderRoot;
    private String currentFolderPath;
    private IStorage storage;
    private String path;

    public SeawindFolderManager(JSONObject json) {
        this.seawindFolderRoot = new SeawindFolder(json);
    }

    public void init(SeawindWorkingSet workingSet) {
        Set<SeawindFile> managedLeafs = SeawindFolderManager.collectLeafs(this.seawindFolderRoot, new HashSet<SeawindFile>());
        HashSet<String> managedLeafIds = new HashSet<String>();
        for (SeawindFile sf : managedLeafs) {
            managedLeafIds.add(sf.getIdentifier());
        }
        List workbooks = workingSet.getWorkbooks();
        for (SeawindWorkbook workbook : workbooks) {
            if (managedLeafIds.contains(workbook.getId())) continue;
            SeawindFile seawindFile = new SeawindFile(workbook.getId());
            this.seawindFolderRoot.addFile(seawindFile);
        }
    }

    public SeawindFolder getRootSeawindFolder() {
        return this.seawindFolderRoot;
    }

    public void replaceRoot(SeawindFolder folder) {
        this.seawindFolderRoot = folder;
    }

    public String getCurrentFolderPath() {
        if (this.currentFolderPath == null) {
            this.currentFolderPath = this.getRootSeawindFolder().getPath();
        }
        return this.currentFolderPath;
    }

    public void setCurrentFolderPath(String currentFolderPath) {
        if (!this.getCurrentFolderPath().equals(currentFolderPath)) {
            this.currentFolderPath = currentFolderPath;
        }
    }

    public SeawindFolder getSeawindFolder(String folderPath) {
        if (folderPath == null) {
            return this.seawindFolderRoot;
        }
        HashSet<SeawindFolder> folders = new HashSet<SeawindFolder>();
        SeawindFolder rootFolder = this.getRootSeawindFolder();
        folders.add(rootFolder);
        SeawindFolderManager.collectFolders(rootFolder, folders);
        for (SeawindFolder folder : folders) {
            if (!folder.getPath().equals(folderPath)) continue;
            return folder;
        }
        return this.seawindFolderRoot;
    }

    public SeawindFile getSeawindFile(String identifier) {
        if (identifier == null) {
            return null;
        }
        HashSet<SeawindFile> files = new HashSet<SeawindFile>();
        SeawindFolderManager.collectLeafs(this.getRootSeawindFolder(), files);
        for (SeawindFile file : files) {
            if (!file.getIdentifier().equals(identifier)) continue;
            return file;
        }
        return null;
    }

    public SeawindFolder newFolder(SeawindFolder parent, String title) {
        SeawindFolder seawindFolder = new SeawindFolder(title);
        seawindFolder.setCreationTime(System.currentTimeMillis());
        this.updateFolderModificationTime(seawindFolder);
        parent.addFolder(seawindFolder);
        return seawindFolder;
    }

    public void removeFolder(SeawindFolder folder) {
        SeawindFolder ownedParent = folder.getOwnedParent();
        if (ownedParent != null) {
            ownedParent.removeFolder(folder);
            this.updateFolderModificationTime(ownedParent);
        }
    }

    public void renameFolder(SeawindFolder folder, String newTitle) {
        if (!folder.getTitle().equals(newTitle)) {
            folder.setTitle(newTitle);
        }
    }

    public void moveFolder(SeawindFolder source, SeawindFolder target) {
        Assert.isTrue((source.getOwnedParent() != null ? 1 : 0) != 0);
        Assert.isTrue((!target.getPath().startsWith(source.getPath()) ? 1 : 0) != 0);
        source.getOwnedParent().removeFolder(source);
        this.checkTitle(source, target);
        target.addFolder(source);
        this.setCurrentFolderPath(target.getPath());
        this.updateFolderModificationTime(target);
        this.updateFolderModificationTime(source);
    }

    private void updateFolderModificationTime(SeawindFolder target) {
        target.setModificationTime(System.currentTimeMillis());
    }

    private void checkTitle(SeawindFolder source, SeawindFolder target) {
        String sourceTitle;
        ArrayList<String> titles = new ArrayList<String>();
        Set folders = target.getFolders();
        for (SeawindFolder folder : folders) {
            titles.add(folder.getTitle());
        }
        String newTitle = sourceTitle = source.getTitle();
        int index = 2;
        while (titles.contains(newTitle)) {
            newTitle = String.valueOf(sourceTitle) + " " + index;
            ++index;
        }
        if (!newTitle.equals(sourceTitle)) {
            source.setTitle(newTitle);
        }
    }

    public void removeFile(SeawindFile file) {
        SeawindFolder ownedParent = file.getOwnedParent();
        if (ownedParent != null) {
            ownedParent.removeFile(file);
            this.updateFolderModificationTime(ownedParent);
        }
    }

    public void moveFile(SeawindFile source, SeawindFolder target) {
        source.getOwnedParent().removeFile(source);
        target.addFile(source);
        this.updateFolderModificationTime(target);
        this.setCurrentFolderPath(target.getPath());
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public void setStorage(IStorage storage) {
        this.storage = storage;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean save(IProgressMonitor monitor) throws InterruptedException, IOException {
        if (this.storage == null || this.path == null) {
            return false;
        }
        try {
            JSON.writeObject((JSONObject)this.seawindFolderRoot.toJSON(), (IOutputTarget)new MonitoredOutputTarget(this.storage.getOutputTarget(), monitor), (String)this.path);
        }
        catch (OperationCanceledException operationCanceledException) {
            throw new InterruptedException();
        }
        return true;
    }

    public String toString() {
        return this.getRootSeawindFolder().toJSON().toString(4);
    }

    public static Set<SPath> collectPaths(SeawindFolder folder, Set<SPath> paths) {
        paths.addAll(folder.getFiles());
        paths.addAll(folder.getFolders());
        for (SeawindFolder fd : folder.getFolders()) {
            SeawindFolderManager.collectPaths(fd, paths);
        }
        return paths;
    }

    public static Set<SeawindFile> collectLeafs(SeawindFolder folder, Set<SeawindFile> leafs) {
        leafs.addAll(folder.getFiles());
        for (SeawindFolder fd : folder.getFolders()) {
            SeawindFolderManager.collectLeafs(fd, leafs);
        }
        return leafs;
    }

    public static Set<SeawindFolder> collectFolders(SeawindFolder tf, Set<SeawindFolder> result) {
        result.addAll(tf.getFolders());
        for (SeawindFolder fd : tf.getFolders()) {
            SeawindFolderManager.collectFolders(fd, result);
        }
        return result;
    }

    public static void toSeawindFolder(SeawindFolder root, Set<SPath> paths) {
        HashMap<String, SeawindFolder> registeredFolders = new HashMap<String, SeawindFolder>();
        HashMap<String, SeawindFile> registeredFiles = new HashMap<String, SeawindFile>();
        for (SPath path : paths) {
            SeawindFolderManager.toSeawindFolder(root, path, registeredFolders, registeredFiles);
        }
    }

    public static void toSeawindFolder(SeawindFolder root, SPath path, Map<String, SeawindFolder> registeredFolders, Map<String, SeawindFile> registeredFiles) {
        boolean isContainer = path.isContainer();
        String[] subPaths = path.getPath().split("/");
        int dirSize = isContainer ? subPaths.length : subPaths.length - 1;
        int begin = 2;
        SeawindFolder parent = root;
        int i = begin;
        while (i < dirSize) {
            String title = "";
            try {
                title = URLDecoder.decode(subPaths[i], "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            SeawindFolder newSeawindFolder = new SeawindFolder(title);
            newSeawindFolder.setOwnedParent(parent);
            SeawindFolder seawindFolder = registeredFolders.get(newSeawindFolder.getPath());
            if (seawindFolder != null) {
                parent = seawindFolder;
            } else {
                parent.addFolder(newSeawindFolder);
                registeredFolders.put(newSeawindFolder.getPath(), newSeawindFolder);
                parent = newSeawindFolder;
            }
            ++i;
        }
        if (!isContainer) {
            SeawindFile newSeawindFile = new SeawindFile(subPaths[subPaths.length - 1]);
            newSeawindFile.setOwnedParent(parent);
            SeawindFile seawindFile = registeredFiles.get(newSeawindFile.getPath());
            if (seawindFile == null) {
                parent.addFile(newSeawindFile);
                registeredFiles.put(newSeawindFile.getPath(), newSeawindFile);
            }
        }
    }

    public static void mergeFolders(SeawindFolder newRoot, SeawindFolder baseRoot, SeawindFolder remoteRoot, SeawindFolder resultRoot) {
        HashSet<SPath> newPaths = new HashSet<SPath>();
        SeawindFolderManager.collectPaths(newRoot, newPaths);
        HashSet<SPath> basePaths = new HashSet<SPath>();
        SeawindFolderManager.collectPaths(baseRoot, basePaths);
        HashSet<SPath> remotePaths = new HashSet<SPath>();
        SeawindFolderManager.collectPaths(remoteRoot, remotePaths);
        HashSet<SPath> resultPaths = new HashSet<SPath>();
        SeawindFolderManager.mergePaths(newPaths, basePaths, remotePaths, resultPaths);
        SeawindFolderManager.toSeawindFolder(resultRoot, resultPaths);
        HashSet<SeawindFile> allLeafs = new HashSet<SeawindFile>();
        SeawindFolderManager.collectLeafs(resultRoot, allLeafs);
        HashSet<String> subLeafIds = new HashSet<String>();
        for (SeawindFile leaf : allLeafs) {
            if (leaf.getOwnedParent() == resultRoot) continue;
            subLeafIds.add(leaf.getIdentifier());
        }
        HashSet rootLeafs = new HashSet();
        rootLeafs.addAll(resultRoot.getFiles());
        for (SeawindFile rl : rootLeafs) {
            if (!subLeafIds.contains(rl.getIdentifier())) continue;
            resultRoot.removeFile(rl);
        }
        SeawindFolderManager.fillProperties(resultRoot, newRoot, remoteRoot);
    }

    private static void fillProperties(SeawindFolder sampleFolder, SeawindFolder localFolder, SeawindFolder remoteFolder) {
        HashSet<SeawindFolder> sampleFolders = new HashSet<SeawindFolder>();
        SeawindFolderManager.collectFolders(sampleFolder, sampleFolders);
        HashMap<SeawindFolder, SeawindFolder> localFoldersMap = new HashMap<SeawindFolder, SeawindFolder>();
        SeawindFolderManager.collectFoldersMap(localFolder, localFoldersMap);
        HashMap<SeawindFolder, SeawindFolder> remoteFoldersMap = new HashMap<SeawindFolder, SeawindFolder>();
        SeawindFolderManager.collectFoldersMap(remoteFolder, remoteFoldersMap);
        for (SeawindFolder sf : sampleFolders) {
            SeawindFolder lf = localFoldersMap.get(sf);
            SeawindFolder rf = remoteFoldersMap.get(sf);
            sf.setCreationTime(Math.max(lf != null ? lf.getCreationTime() : 0L, rf != null ? rf.getCreationTime() : 0L));
            sf.setModificationTime(Math.max(lf != null ? lf.getModificationTime() : 0L, rf != null ? rf.getModificationTime() : 0L));
        }
    }

    private static void collectFoldersMap(SeawindFolder tf, HashMap<SeawindFolder, SeawindFolder> folders) {
        folders.put(tf, tf);
        Set fds = tf.getFolders();
        for (SeawindFolder sf : fds) {
            SeawindFolderManager.collectFoldersMap(sf, folders);
        }
    }

    public static void mergePaths(HashSet<SPath> newPaths, HashSet<SPath> basePaths, HashSet<SPath> remotePaths, HashSet<SPath> result) {
        HashSet<SPath> toMergePaths = new HashSet<SPath>();
        toMergePaths.addAll(newPaths);
        toMergePaths.addAll(basePaths);
        toMergePaths.addAll(remotePaths);
        for (SPath path : toMergePaths) {
            boolean baseContains = basePaths.contains(path);
            boolean remoteContains = remotePaths.contains(path);
            boolean newContains = newPaths.contains(path);
            if ((!baseContains || !remoteContains || !newContains) && (baseContains || !newContains && !remoteContains)) continue;
            result.add(path);
        }
    }

    public static SeawindFolder createRootFolder() {
        return new SeawindFolder("Root");
    }
}

