/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.portfolio;

import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.currency.Currency;
import org.yccheok.jstock.gui.treetable.DefaultSortableMutableTreeTableNode;
import org.yccheok.jstock.portfolio.Commentable;
import org.yccheok.jstock.portfolio.PortfolioRealTimeInfo;
import org.yccheok.jstock.portfolio.Transaction;
import org.yccheok.jstock.portfolio.TransactionSummary;
import org.yccheok.jstock.portfolio.Utils;

public class Portfolio
extends DefaultSortableMutableTreeTableNode
implements Commentable {
    private PortfolioRealTimeInfo portfolioRealTimeInfo = new PortfolioRealTimeInfo();
    private String comment = "";
    private transient TreeTableModel treeTableModel = null;

    public void bind(PortfolioRealTimeInfo portfolioRealTimeInfo) {
        this.portfolioRealTimeInfo = portfolioRealTimeInfo;
    }

    public double getNetTotal(Currency localCurrency) {
        double result = 0.0;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            TreeTableNode o = this.getChildAt(i);
            assert (o instanceof TransactionSummary);
            TransactionSummary transactionSummary = (TransactionSummary)o;
            Transaction transaction = (Transaction)transactionSummary.getChildAt(0);
            Code code = transaction.getStockInfo().code;
            double exchangeRate = Utils.getExchangeRate(this.portfolioRealTimeInfo, localCurrency, code);
            result += transactionSummary.getNetTotal() * exchangeRate;
        }
        return result;
    }

    public double getTotal(Currency localCurrency) {
        double result = 0.0;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            TreeTableNode o = this.getChildAt(i);
            assert (o instanceof TransactionSummary);
            TransactionSummary transactionSummary = (TransactionSummary)o;
            Transaction transaction = (Transaction)transactionSummary.getChildAt(0);
            Code code = transaction.getStockInfo().code;
            double exchangeRate = Utils.getExchangeRate(this.portfolioRealTimeInfo, localCurrency, code);
            result += transactionSummary.getTotal() * exchangeRate;
        }
        return result;
    }

    public double getNetReferenceTotal(Currency localCurrency) {
        double result = 0.0;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            TreeTableNode o = this.getChildAt(i);
            assert (o instanceof TransactionSummary);
            TransactionSummary transactionSummary = (TransactionSummary)o;
            Transaction transaction = (Transaction)transactionSummary.getChildAt(0);
            Code code = transaction.getStockInfo().code;
            double exchangeRate = Utils.getExchangeRate(this.portfolioRealTimeInfo, localCurrency, code);
            result += transactionSummary.getNetReferenceTotal() * exchangeRate;
        }
        return result;
    }

    public double getReferenceTotal(Currency localCurrency) {
        double result = 0.0;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            TreeTableNode o = this.getChildAt(i);
            assert (o instanceof TransactionSummary);
            TransactionSummary transactionSummary = (TransactionSummary)o;
            Transaction transaction = (Transaction)transactionSummary.getChildAt(0);
            Code code = transaction.getStockInfo().code;
            double exchangeRate = Utils.getExchangeRate(this.portfolioRealTimeInfo, localCurrency, code);
            result += transactionSummary.getReferenceTotal() * exchangeRate;
        }
        return result;
    }

    public double getBroker() {
        double result = 0.0;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            TreeTableNode o = this.getChildAt(i);
            assert (o instanceof TransactionSummary);
            TransactionSummary transactionSummary = (TransactionSummary)o;
            result += transactionSummary.getBroker();
        }
        return result;
    }

    public double getClearingFee() {
        double result = 0.0;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            TreeTableNode o = this.getChildAt(i);
            assert (o instanceof TransactionSummary);
            TransactionSummary transactionSummary = (TransactionSummary)o;
            result += transactionSummary.getClearingFee();
        }
        return result;
    }

    public double getStampDuty() {
        double result = 0.0;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            TreeTableNode o = this.getChildAt(i);
            assert (o instanceof TransactionSummary);
            TransactionSummary transactionSummary = (TransactionSummary)o;
            result += transactionSummary.getStampDuty();
        }
        return result;
    }

    public String toString() {
        return "Portfolio";
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    private Object readResolve() {
        if (this.comment == null) {
            this.comment = "";
        }
        this.setSortable(true);
        return this;
    }

    public void setTreeTableModel(TreeTableModel treeTableModel) {
        this.treeTableModel = treeTableModel;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            TreeTableNode o = this.getChildAt(i);
            assert (o instanceof TransactionSummary);
            TransactionSummary transactionSummary = (TransactionSummary)o;
            transactionSummary.setTreeTableModel(treeTableModel);
        }
    }

    @Override
    public Object getValueAt(int column) {
        return this.treeTableModel.getValueAt((Object)this, column);
    }
}

