/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.trading;

import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.controlsfx.validation.Severity;
import org.controlsfx.validation.ValidationResult;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import org.yccheok.jstock.engine.Pair;
import org.yccheok.jstock.gui.trading.GUIUtils;
import org.yccheok.jstock.gui.trading.TradingView;
import org.yccheok.jstock.gui.trading.UsernameField;
import org.yccheok.jstock.internationalization.DriveWealthBundle;
import org.yccheok.jstock.trading.api.AccountManager;
import org.yccheok.jstock.trading.api.ApiError;
import org.yccheok.jstock.trading.api.SessionManager;

public class SignUp {
    private static final Log log = LogFactory.getLog(SignUp.class);
    private static final SignUp INSTANCE = new SignUp();
    private Dialog dialog;
    private GridPane grid;
    private int row;
    private ButtonType okBtnType;
    private TextField emailTxt;
    private TextField firstNameTxt;
    private TextField lastNameTxt;
    private TextField usernameTxt;
    private UsernameField usernameField;
    private PasswordField pwdTxt;
    private Label pwdNote;
    private Label pwdError;
    private Label errorLabel;
    private ValidationSupport vs;

    public static SignUp getInstance() {
        return INSTANCE;
    }

    public Dialog show() {
        this.initUI();
        this.openAccHandler();
        return this.dialog;
    }

    public static boolean isValidEmailAddress(String email) {
        boolean result = true;
        try {
            InternetAddress emailAddr = new InternetAddress(email);
            emailAddr.validate();
        }
        catch (AddressException ex) {
            result = false;
        }
        return result;
    }

    private void initUI() {
        this.row = 0;
        this.dialog = new Dialog();
        this.grid = new GridPane();
        this.grid.setPadding(new Insets(0.0, 10.0, 0.0, 10.0));
        ColumnConstraints col1 = new ColumnConstraints();
        col1.setHalignment(HPos.RIGHT);
        ColumnConstraints col2 = new ColumnConstraints();
        this.grid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{col1, col2});
        this.grid.setVgap(5.0);
        this.grid.setHgap(25.0);
        this.firstNameTxt = this.addField(DriveWealthBundle.getString("First_name") + " :");
        this.lastNameTxt = this.addField(DriveWealthBundle.getString("Last_name") + " :");
        this.emailTxt = this.addField(DriveWealthBundle.getString("Email") + " :");
        this.addUsernameFields();
        this.addPasswordFields();
        this.errorLabel = new Label();
        this.errorLabel.setWrapText(true);
        this.errorLabel.getStyleClass().addAll((Object[])new String[]{"note-small", "red-txt"});
        this.errorLabel.setVisible(false);
        this.grid.add((Node)this.errorLabel, 1, this.row++);
        GridPane.setMargin((Node)this.errorLabel, (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
        GridPane.setHgrow((Node)this.errorLabel, (Priority)Priority.ALWAYS);
        String title = DriveWealthBundle.getString("Open_account");
        String header = DriveWealthBundle.getString("Get_started");
        GUIUtils.setDlgTitleHeader(this.dialog, title, header);
        GUIUtils.setDlgContent(this.dialog, (Node)this.grid, null, null);
        this.vs = new ValidationSupport();
        this.vs.initInitialDecoration();
        Platform.runLater(() -> {
            this.vs.registerValidator((Control)this.firstNameTxt, Validator.createEmptyValidator((String)DriveWealthBundle.getString("First_name_required")));
            this.vs.registerValidator((Control)this.lastNameTxt, Validator.createEmptyValidator((String)DriveWealthBundle.getString("Last_name_required")));
            this.vs.registerValidator((Control)this.usernameTxt, Validator.createEmptyValidator((String)DriveWealthBundle.getString("Username_required")));
            this.vs.registerValidator((Control)this.pwdTxt, Validator.createRegexValidator((String)DriveWealthBundle.getString("Password_valid_pattern"), (String)"^(?=.*[0-9])(?=.*[A-Za-z]).{8,90}$", (Severity)Severity.ERROR));
            this.vs.registerValidator((Control)this.emailTxt, (c, email) -> ValidationResult.fromErrorIf((Control)this.emailTxt, (String)DriveWealthBundle.getString("Email_invalid"), (!SignUp.isValidEmailAddress(email) ? 1 : 0) != 0));
        });
        this.okBtnType = new ButtonType(DriveWealthBundle.getString("Open_account"), ButtonBar.ButtonData.OK_DONE);
        DialogPane dlgPane = this.dialog.getDialogPane();
        dlgPane.getButtonTypes().addAll((Object[])new ButtonType[]{this.okBtnType, ButtonType.CANCEL});
        this.okBtnDisableProperty();
        this.dialog.setOnCloseRequest(event -> this.usernameField.stop());
    }

    private void okBtnDisableProperty() {
        Node okBtn = this.dialog.getDialogPane().lookupButton(this.okBtnType);
        okBtn.disableProperty().unbind();
        okBtn.disableProperty().bind((ObservableValue)this.vs.invalidProperty().or((ObservableBooleanValue)this.usernameField.validProperty.not()));
    }

    private TextField addField(String labelTxt) {
        RowConstraints constn = new RowConstraints();
        this.grid.getRowConstraints().add((Object)constn);
        Label label = new Label(labelTxt);
        this.grid.add((Node)label, 0, this.row);
        GridPane.setHgrow((Node)label, (Priority)Priority.ALWAYS);
        TextField txtField = new TextField();
        GridPane.setHgrow((Node)txtField, (Priority)Priority.ALWAYS);
        this.grid.add((Node)txtField, 1, this.row++);
        GridPane.setMargin((Node)txtField, (Insets)new Insets(10.0, 0.0, 10.0, 0.0));
        return txtField;
    }

    private void addUsernameFields() {
        this.usernameField = new UsernameField();
        this.usernameTxt = this.usernameField.txtField;
        StackPane stackNote = this.usernameField.stackNote;
        RowConstraints constn = new RowConstraints();
        this.grid.getRowConstraints().add((Object)constn);
        Label label = new Label(DriveWealthBundle.getString("Pick_username"));
        this.grid.add((Node)label, 0, this.row);
        GridPane.setHgrow((Node)label, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.usernameTxt, (Priority)Priority.ALWAYS);
        this.grid.add((Node)this.usernameTxt, 1, this.row++);
        GridPane.setMargin((Node)this.usernameTxt, (Insets)new Insets(10.0, 0.0, 5.0, 0.0));
        RowConstraints rowCon = new RowConstraints(20.0);
        this.grid.getRowConstraints().add((Object)rowCon);
        this.grid.add((Node)stackNote, 1, this.row++);
        GridPane.setMargin((Node)stackNote, (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
        GridPane.setHgrow((Node)stackNote, (Priority)Priority.ALWAYS);
    }

    private void addPasswordFields() {
        RowConstraints rowCons = new RowConstraints();
        this.grid.getRowConstraints().add((Object)rowCons);
        this.grid.add((Node)new Label(DriveWealthBundle.getString("Password") + " :"), 0, this.row);
        this.pwdTxt = new PasswordField();
        GridPane.setHgrow((Node)this.pwdTxt, (Priority)Priority.ALWAYS);
        GridPane.setMargin((Node)this.pwdTxt, (Insets)new Insets(10.0, 0.0, 5.0, 0.0));
        this.grid.add((Node)this.pwdTxt, 1, this.row++);
        RowConstraints rowCon = new RowConstraints(20.0);
        this.grid.getRowConstraints().add((Object)rowCon);
        this.pwdNote = new Label(DriveWealthBundle.getString("Password_valid_pattern"));
        this.pwdNote.getStyleClass().add((Object)"note-small");
        this.pwdError = new Label();
        this.pwdError.getStyleClass().addAll((Object[])new String[]{"note-small", "red-txt"});
        StackPane stackNote = new StackPane();
        stackNote.setAlignment(Pos.CENTER_LEFT);
        stackNote.getChildren().addAll((Object[])new Node[]{this.pwdNote, this.pwdError});
        this.grid.add((Node)stackNote, 1, this.row++);
        GridPane.setMargin((Node)stackNote, (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
        GridPane.setHgrow((Node)stackNote, (Priority)Priority.ALWAYS);
        this.showPwdNote();
    }

    private void showPwdNote() {
        this.pwdNote.setVisible(true);
        this.pwdError.setVisible(false);
    }

    private void showPwdError(String error) {
        this.pwdNote.setVisible(false);
        this.pwdError.setText(error);
        this.pwdError.setVisible(true);
    }

    private void clearErrorMsg() {
        this.usernameField.showNote();
        this.showPwdNote();
        this.errorLabel.setText(null);
        this.errorLabel.setVisible(false);
    }

    private void openAccHandler() {
        Node okBtn = this.dialog.getDialogPane().lookupButton(this.okBtnType);
        okBtn.addEventFilter(ActionEvent.ACTION, event -> {
            event.consume();
            this.clearErrorMsg();
            GUIUtils.dlgShowProgressIn(this.dialog);
            Task<Pair<Boolean, String>> task = new Task<Pair<Boolean, String>>(){

                protected Pair<Boolean, String> call() {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("emailAddress1", SignUp.this.emailTxt.getText().trim());
                    params.put("firstName", SignUp.this.firstNameTxt.getText().trim());
                    params.put("lastName", SignUp.this.lastNameTxt.getText().trim());
                    params.put("username", SignUp.this.usernameTxt.getText().trim());
                    params.put("password", SignUp.this.pwdTxt.getText().trim());
                    Pair<Map<String, Object>, String> result = AccountManager.createPracticeAcc(params);
                    Map accMap = (Map)result.first;
                    String accError = (String)result.second;
                    if (accMap == null) {
                        return new Pair<Boolean, String>(false, accError);
                    }
                    String username = accMap.get("username").toString();
                    String password = accMap.get("password").toString();
                    Pair<String, String> login = SessionManager.getInstance().login(username, password, null);
                    String error = (String)login.second;
                    if (error != null) {
                        return new Pair<Boolean, String>(false, error);
                    }
                    return new Pair<Boolean, Object>(true, null);
                }
            };
            new Thread((Runnable)task).start();
            task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

                public void handle(WorkerStateEvent workerStateEvent) {
                    Pair result = (Pair)workerStateEvent.getSource().getValue();
                    Boolean status = (Boolean)result.first;
                    String error = (String)result.second;
                    if (status.booleanValue()) {
                        SignUp.this.dialog.close();
                        TradingView.getInstance().showPortfolio();
                        return;
                    }
                    log.error((Object)("create practice account failed, error: " + error));
                    if (error.matches("(?i)(Duplicate username).+")) {
                        SignUp.this.usernameField.showStatus(error, true);
                    } else if (error.matches("(?i)(Password must contain).+")) {
                        SignUp.this.showPwdError(error);
                    } else {
                        SignUp.this.errorLabel.setText(error);
                        SignUp.this.errorLabel.setVisible(true);
                    }
                    SignUp.this.showOriginalDlg();
                }
            });
            task.setOnCancelled(ev -> {
                log.error((Object)"Create practice account task is cancelled");
                this.showGenericError();
            });
            task.setOnFailed(ev -> {
                log.error((Object)"Create practice account task has failed");
                this.showGenericError();
            });
        });
    }

    private void showOriginalDlg() {
        GUIUtils.dlgRemoveProgressIn(this.dialog);
        this.okBtnDisableProperty();
    }

    private void showGenericError() {
        this.errorLabel.setText(ApiError.commonMsg());
        this.errorLabel.setVisible(true);
        this.showOriginalDlg();
    }
}

