/*
 * Decompiled with CFR 0.152.
 */
package com.tictactec.ta.lib;

import com.tictactec.ta.lib.CandleSetting;
import com.tictactec.ta.lib.CandleSettingType;
import com.tictactec.ta.lib.Compatibility;
import com.tictactec.ta.lib.FuncUnstId;
import com.tictactec.ta.lib.MAType;
import com.tictactec.ta.lib.MInteger;
import com.tictactec.ta.lib.MoneyFlow;
import com.tictactec.ta.lib.RangeType;
import com.tictactec.ta.lib.RetCode;

public class Core {
    private int[] unstablePeriod;
    private CandleSetting[] candleSettings;
    private Compatibility compatibility;
    private final CandleSetting[] TA_CandleDefaultSettings = new CandleSetting[]{new CandleSetting(CandleSettingType.BodyLong, RangeType.RealBody, 10, 1.0), new CandleSetting(CandleSettingType.BodyVeryLong, RangeType.RealBody, 10, 3.0), new CandleSetting(CandleSettingType.BodyShort, RangeType.RealBody, 10, 1.0), new CandleSetting(CandleSettingType.BodyDoji, RangeType.HighLow, 10, 0.1), new CandleSetting(CandleSettingType.ShadowLong, RangeType.RealBody, 0, 1.0), new CandleSetting(CandleSettingType.ShadowVeryLong, RangeType.RealBody, 0, 2.0), new CandleSetting(CandleSettingType.ShadowShort, RangeType.Shadows, 10, 1.0), new CandleSetting(CandleSettingType.ShadowVeryShort, RangeType.HighLow, 10, 0.1), new CandleSetting(CandleSettingType.Near, RangeType.HighLow, 5, 0.2), new CandleSetting(CandleSettingType.Far, RangeType.HighLow, 5, 0.6), new CandleSetting(CandleSettingType.Equal, RangeType.HighLow, 5, 0.05)};

    public Core() {
        this.unstablePeriod = new int[FuncUnstId.All.ordinal()];
        this.compatibility = Compatibility.Default;
        this.candleSettings = new CandleSetting[CandleSettingType.AllCandleSettings.ordinal()];
        int i = 0;
        while (i < this.candleSettings.length) {
            this.candleSettings[i] = new CandleSetting(this.TA_CandleDefaultSettings[i]);
            ++i;
        }
    }

    public RetCode SetCandleSettings(CandleSettingType settingType, RangeType rangeType, int avgPeriod, double factor) {
        if (settingType.ordinal() >= CandleSettingType.AllCandleSettings.ordinal()) {
            return RetCode.BadParam;
        }
        this.candleSettings[settingType.ordinal()].settingType = settingType;
        this.candleSettings[settingType.ordinal()].rangeType = rangeType;
        this.candleSettings[settingType.ordinal()].avgPeriod = avgPeriod;
        this.candleSettings[settingType.ordinal()].factor = factor;
        return RetCode.Success;
    }

    public RetCode RestoreCandleDefaultSettings(CandleSettingType settingType) {
        if (settingType.ordinal() > CandleSettingType.AllCandleSettings.ordinal()) {
            return RetCode.BadParam;
        }
        if (settingType == CandleSettingType.AllCandleSettings) {
            int i = 0;
            while (i < CandleSettingType.AllCandleSettings.ordinal()) {
                this.candleSettings[i].CopyFrom(this.TA_CandleDefaultSettings[i]);
                ++i;
            }
        } else {
            this.candleSettings[settingType.ordinal()].CopyFrom(this.TA_CandleDefaultSettings[settingType.ordinal()]);
        }
        return RetCode.Success;
    }

    public RetCode SetUnstablePeriod(FuncUnstId id, int period) {
        if (id.ordinal() >= FuncUnstId.All.ordinal()) {
            return RetCode.BadParam;
        }
        this.unstablePeriod[id.ordinal()] = period;
        return RetCode.Success;
    }

    public int GetUnstablePeriod(FuncUnstId id) {
        return this.unstablePeriod[id.ordinal()];
    }

    public void SetCompatibility(Compatibility compatibility) {
        this.compatibility = compatibility;
    }

    public Compatibility getCompatibility() {
        return this.compatibility;
    }

    public int acosLookback() {
        return 0;
    }

    public RetCode acos(int startIdx, int endIdx, double[] inReal, MInteger outBegIdx, MInteger outNBElement, double[] outReal) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        int i = startIdx;
        int outIdx = 0;
        while (i <= endIdx) {
            outReal[outIdx] = Math.acos(inReal[i]);
            ++i;
            ++outIdx;
        }
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public RetCode acos(int startIdx, int endIdx, float[] inReal, MInteger outBegIdx, MInteger outNBElement, double[] outReal) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        int i = startIdx;
        int outIdx = 0;
        while (i <= endIdx) {
            outReal[outIdx] = Math.acos(inReal[i]);
            ++i;
            ++outIdx;
        }
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int adLookback() {
        return 0;
    }

    public RetCode ad(int startIdx, int endIdx, double[] inHigh, double[] inLow, double[] inClose, double[] inVolume, MInteger outBegIdx, MInteger outNBElement, double[] outReal) {
        int nbBar;
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        outNBElement.value = nbBar = endIdx - startIdx + 1;
        outBegIdx.value = startIdx;
        int currentBar = startIdx;
        int outIdx = 0;
        double ad = 0.0;
        while (nbBar != 0) {
            double high = inHigh[currentBar];
            double low = inLow[currentBar];
            double tmp = high - low;
            double close = inClose[currentBar];
            if (tmp > 0.0) {
                ad += (close - low - (high - close)) / tmp * inVolume[currentBar];
            }
            outReal[outIdx++] = ad;
            ++currentBar;
            --nbBar;
        }
        return RetCode.Success;
    }

    public RetCode ad(int startIdx, int endIdx, float[] inHigh, float[] inLow, float[] inClose, float[] inVolume, MInteger outBegIdx, MInteger outNBElement, double[] outReal) {
        int nbBar;
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        outNBElement.value = nbBar = endIdx - startIdx + 1;
        outBegIdx.value = startIdx;
        int currentBar = startIdx;
        int outIdx = 0;
        double ad = 0.0;
        while (nbBar != 0) {
            double high = inHigh[currentBar];
            double low = inLow[currentBar];
            double tmp = high - low;
            double close = inClose[currentBar];
            if (tmp > 0.0) {
                ad += (close - low - (high - close)) / tmp * (double)inVolume[currentBar];
            }
            outReal[outIdx++] = ad;
            ++currentBar;
            --nbBar;
        }
        return RetCode.Success;
    }

    public int addLookback() {
        return 0;
    }

    public RetCode add(int startIdx, int endIdx, double[] inReal0, double[] inReal1, MInteger outBegIdx, MInteger outNBElement, double[] outReal) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        int i = startIdx;
        int outIdx = 0;
        while (i <= endIdx) {
            outReal[outIdx] = inReal0[i] + inReal1[i];
            ++i;
            ++outIdx;
        }
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public RetCode add(int startIdx, int endIdx, float[] inReal0, float[] inReal1, MInteger outBegIdx, MInteger outNBElement, double[] outReal) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        int i = startIdx;
        int outIdx = 0;
        while (i <= endIdx) {
            outReal[outIdx] = inReal0[i] + inReal1[i];
            ++i;
            ++outIdx;
        }
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int adOscLookback(int optInFastPeriod, int optInSlowPeriod) {
        if (optInFastPeriod == Integer.MIN_VALUE) {
            optInFastPeriod = 3;
        } else if (optInFastPeriod < 2 || optInFastPeriod > 100000) {
            return -1;
        }
        if (optInSlowPeriod == Integer.MIN_VALUE) {
            optInSlowPeriod = 10;
        } else if (optInSlowPeriod < 2 || optInSlowPeriod > 100000) {
            return -1;
        }
        int slowestPeriod = optInFastPeriod < optInSlowPeriod ? optInSlowPeriod : optInFastPeriod;
        return this.emaLookback(slowestPeriod);
    }

    public RetCode adOsc(int startIdx, int endIdx, double[] inHigh, double[] inLow, double[] inClose, double[] inVolume, int optInFastPeriod, int optInSlowPeriod, MInteger outBegIdx, MInteger outNBElement, double[] outReal) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInFastPeriod == Integer.MIN_VALUE) {
            optInFastPeriod = 3;
        } else if (optInFastPeriod < 2 || optInFastPeriod > 100000) {
            return RetCode.BadParam;
        }
        if (optInSlowPeriod == Integer.MIN_VALUE) {
            optInSlowPeriod = 10;
        } else if (optInSlowPeriod < 2 || optInSlowPeriod > 100000) {
            return RetCode.BadParam;
        }
        int slowestPeriod = optInFastPeriod < optInSlowPeriod ? optInSlowPeriod : optInFastPeriod;
        int lookbackTotal = this.emaLookback(slowestPeriod);
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        outBegIdx.value = startIdx;
        int today = startIdx - lookbackTotal;
        double ad = 0.0;
        double fastk = 2.0 / (double)(optInFastPeriod + 1);
        double one_minus_fastk = 1.0 - fastk;
        double slowk = 2.0 / (double)(optInSlowPeriod + 1);
        double one_minus_slowk = 1.0 - slowk;
        double high = inHigh[today];
        double low = inLow[today];
        double tmp = high - low;
        double close = inClose[today];
        if (tmp > 0.0) {
            ad += (close - low - (high - close)) / tmp * inVolume[today];
        }
        ++today;
        double fastEMA = ad;
        double slowEMA = ad;
        while (today < startIdx) {
            high = inHigh[today];
            low = inLow[today];
            tmp = high - low;
            close = inClose[today];
            if (tmp > 0.0) {
                ad += (close - low - (high - close)) / tmp * inVolume[today];
            }
            ++today;
            fastEMA = fastk * ad + one_minus_fastk * fastEMA;
            slowEMA = slowk * ad + one_minus_slowk * slowEMA;
        }
        int outIdx = 0;
        while (today <= endIdx) {
            high = inHigh[today];
            low = inLow[today];
            tmp = high - low;
            close = inClose[today];
            if (tmp > 0.0) {
                ad += (close - low - (high - close)) / tmp * inVolume[today];
            }
            ++today;
            fastEMA = fastk * ad + one_minus_fastk * fastEMA;
            slowEMA = slowk * ad + one_minus_slowk * slowEMA;
            outReal[outIdx++] = fastEMA - slowEMA;
        }
        outNBElement.value = outIdx;
        return RetCode.Success;
    }

    public RetCode adOsc(int startIdx, int endIdx, float[] inHigh, float[] inLow, float[] inClose, float[] inVolume, int optInFastPeriod, int optInSlowPeriod, MInteger outBegIdx, MInteger outNBElement, double[] outReal) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInFastPeriod == Integer.MIN_VALUE) {
            optInFastPeriod = 3;
        } else if (optInFastPeriod < 2 || optInFastPeriod > 100000) {
            return RetCode.BadParam;
        }
        if (optInSlowPeriod == Integer.MIN_VALUE) {
            optInSlowPeriod = 10;
        } else if (optInSlowPeriod < 2 || optInSlowPeriod > 100000) {
            return RetCode.BadParam;
        }
        int slowestPeriod = optInFastPeriod < optInSlowPeriod ? optInSlowPeriod : optInFastPeriod;
        int lookbackTotal = this.emaLookback(slowestPeriod);
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        outBegIdx.value = startIdx;
        int today = startIdx - lookbackTotal;
        double ad = 0.0;
        double fastk = 2.0 / (double)(optInFastPeriod + 1);
        double one_minus_fastk = 1.0 - fastk;
        double slowk = 2.0 / (double)(optInSlowPeriod + 1);
        double one_minus_slowk = 1.0 - slowk;
        double high = inHigh[today];
        double low = inLow[today];
        double tmp = high - low;
        double close = inClose[today];
        if (tmp > 0.0) {
            ad += (close - low - (high - close)) / tmp * (double)inVolume[today];
        }
        ++today;
        double fastEMA = ad;
        double slowEMA = ad;
        while (today < startIdx) {
            high = inHigh[today];
            low = inLow[today];
            tmp = high - low;
            close = inClose[today];
            if (tmp > 0.0) {
                ad += (close - low - (high - close)) / tmp * (double)inVolume[today];
            }
            ++today;
            fastEMA = fastk * ad + one_minus_fastk * fastEMA;
            slowEMA = slowk * ad + one_minus_slowk * slowEMA;
        }
        int outIdx = 0;
        while (today <= endIdx) {
            high = inHigh[today];
            low = inLow[today];
            tmp = high - low;
            close = inClose[today];
            if (tmp > 0.0) {
                ad += (close - low - (high - close)) / tmp * (double)inVolume[today];
            }
            ++today;
            fastEMA = fastk * ad + one_minus_fastk * fastEMA;
            slowEMA = slowk * ad + one_minus_slowk * slowEMA;
            outReal[outIdx++] = fastEMA - slowEMA;
        }
        outNBElement.value = outIdx;
        return RetCode.Success;
    }

    public int adxLookback(int optInTimePeriod) {
        if (optInTimePeriod == Integer.MIN_VALUE) {
            optInTimePeriod = 14;
        } else if (optInTimePeriod < 2 || optInTimePeriod > 100000) {
            return -1;
        }
        return 2 * optInTimePeriod + this.unstablePeriod[FuncUnstId.Adx.ordinal()] - 1;
    }

    public RetCode adx(int startIdx, int endIdx, double[] inHigh, double[] inLow, double[] inClose, int optInTimePeriod, MInteger outBegIdx, MInteger outNBElement, double[] outReal) {
        double plusDI;
        double minusDI;
        double tempReal2;
        double diffM;
        double diffP;
        double tempReal;
        int today;
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInTimePeriod == Integer.MIN_VALUE) {
            optInTimePeriod = 14;
        } else if (optInTimePeriod < 2 || optInTimePeriod > 100000) {
            return RetCode.BadParam;
        }
        int lookbackTotal = 2 * optInTimePeriod + this.unstablePeriod[FuncUnstId.Adx.ordinal()] - 1;
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        int outIdx = 0;
        outBegIdx.value = today = startIdx;
        double prevMinusDM = 0.0;
        double prevPlusDM = 0.0;
        double prevTR = 0.0;
        today = startIdx - lookbackTotal;
        double prevHigh = inHigh[today];
        double prevLow = inLow[today];
        double prevClose = inClose[today];
        int i = optInTimePeriod - 1;
        while (i-- > 0) {
            tempReal = inHigh[++today];
            diffP = tempReal - prevHigh;
            prevHigh = tempReal;
            tempReal = inLow[today];
            diffM = prevLow - tempReal;
            prevLow = tempReal;
            if (diffM > 0.0 && diffP < diffM) {
                prevMinusDM += diffM;
            } else if (diffP > 0.0 && diffP > diffM) {
                prevPlusDM += diffP;
            }
            tempReal = prevHigh - prevLow;
            tempReal2 = Math.abs(prevHigh - prevClose);
            if (tempReal2 > tempReal) {
                tempReal = tempReal2;
            }
            if ((tempReal2 = Math.abs(prevLow - prevClose)) > tempReal) {
                tempReal = tempReal2;
            }
            prevTR += tempReal;
            prevClose = inClose[today];
        }
        double sumDX = 0.0;
        i = optInTimePeriod;
        while (i-- > 0) {
            tempReal = inHigh[++today];
            diffP = tempReal - prevHigh;
            prevHigh = tempReal;
            tempReal = inLow[today];
            diffM = prevLow - tempReal;
            prevLow = tempReal;
            prevMinusDM -= prevMinusDM / (double)optInTimePeriod;
            prevPlusDM -= prevPlusDM / (double)optInTimePeriod;
            if (diffM > 0.0 && diffP < diffM) {
                prevMinusDM += diffM;
            } else if (diffP > 0.0 && diffP > diffM) {
                prevPlusDM += diffP;
            }
            tempReal = prevHigh - prevLow;
            tempReal2 = Math.abs(prevHigh - prevClose);
            if (tempReal2 > tempReal) {
                tempReal = tempReal2;
            }
            if ((tempReal2 = Math.abs(prevLow - prevClose)) > tempReal) {
                tempReal = tempReal2;
            }
            prevTR = prevTR - prevTR / (double)optInTimePeriod + tempReal;
            prevClose = inClose[today];
            if (-1.0E-8 < prevTR && prevTR < 1.0E-8 || -1.0E-8 < (tempReal = (minusDI = 100.0 * (prevMinusDM / prevTR)) + (plusDI = 100.0 * (prevPlusDM / prevTR))) && tempReal < 1.0E-8) continue;
            sumDX += 100.0 * (Math.abs(minusDI - plusDI) / tempReal);
        }
        double prevADX = sumDX / (double)optInTimePeriod;
        i = this.unstablePeriod[FuncUnstId.Adx.ordinal()];
        while (i-- > 0) {
            tempReal = inHigh[++today];
            diffP = tempReal - prevHigh;
            prevHigh = tempReal;
            tempReal = inLow[today];
            diffM = prevLow - tempReal;
            prevLow = tempReal;
            prevMinusDM -= prevMinusDM / (double)optInTimePeriod;
            prevPlusDM -= prevPlusDM / (double)optInTimePeriod;
            if (diffM > 0.0 && diffP < diffM) {
                prevMinusDM += diffM;
            } else if (diffP > 0.0 && diffP > diffM) {
                prevPlusDM += diffP;
            }
            tempReal = prevHigh - prevLow;
            tempReal2 = Math.abs(prevHigh - prevClose);
            if (tempReal2 > tempReal) {
                tempReal = tempReal2;
            }
            if ((tempReal2 = Math.abs(prevLow - prevClose)) > tempReal) {
                tempReal = tempReal2;
            }
            prevTR = prevTR - prevTR / (double)optInTimePeriod + tempReal;
            prevClose = inClose[today];
            if (-1.0E-8 < prevTR && prevTR < 1.0E-8 || -1.0E-8 < (tempReal = (minusDI = 100.0 * (prevMinusDM / prevTR)) + (plusDI = 100.0 * (prevPlusDM / prevTR))) && tempReal < 1.0E-8) continue;
            tempReal = 100.0 * (Math.abs(minusDI - plusDI) / tempReal);
            prevADX = (prevADX * (double)(optInTimePeriod - 1) + tempReal) / (double)optInTimePeriod;
        }
        outReal[0] = prevADX;
        outIdx = 1;
        while (today < endIdx) {
            tempReal = inHigh[++today];
            diffP = tempReal - prevHigh;
            prevHigh = tempReal;
            tempReal = inLow[today];
            diffM = prevLow - tempReal;
            prevLow = tempReal;
            prevMinusDM -= prevMinusDM / (double)optInTimePeriod;
            prevPlusDM -= prevPlusDM / (double)optInTimePeriod;
            if (diffM > 0.0 && diffP < diffM) {
                prevMinusDM += diffM;
            } else if (diffP > 0.0 && diffP > diffM) {
                prevPlusDM += diffP;
            }
            tempReal = prevHigh - prevLow;
            tempReal2 = Math.abs(prevHigh - prevClose);
            if (tempReal2 > tempReal) {
                tempReal = tempReal2;
            }
            if ((tempReal2 = Math.abs(prevLow - prevClose)) > tempReal) {
                tempReal = tempReal2;
            }
            prevTR = prevTR - prevTR / (double)optInTimePeriod + tempReal;
            prevClose = inClose[today];
            if (!(-1.0E-8 < prevTR && prevTR < 1.0E-8 || -1.0E-8 < (tempReal = (minusDI = 100.0 * (prevMinusDM / prevTR)) + (plusDI = 100.0 * (prevPlusDM / prevTR))) && tempReal < 1.0E-8)) {
                tempReal = 100.0 * (Math.abs(minusDI - plusDI) / tempReal);
                prevADX = (prevADX * (double)(optInTimePeriod - 1) + tempReal) / (double)optInTimePeriod;
            }
            outReal[outIdx++] = prevADX;
        }
        outNBElement.value = outIdx;
        return RetCode.Success;
    }

    public RetCode adx(int startIdx, int endIdx, float[] inHigh, float[] inLow, float[] inClose, int optInTimePeriod, MInteger outBegIdx, MInteger outNBElement, double[] outReal) {
        double plusDI;
        double minusDI;
        double tempReal2;
        double diffM;
        double diffP;
        double tempReal;
        int today;
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInTimePeriod == Integer.MIN_VALUE) {
            optInTimePeriod = 14;
        } else if (optInTimePeriod < 2 || optInTimePeriod > 100000) {
            return RetCode.BadParam;
        }
        int lookbackTotal = 2 * optInTimePeriod + this.unstablePeriod[FuncUnstId.Adx.ordinal()] - 1;
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        int outIdx = 0;
        outBegIdx.value = today = startIdx;
        double prevMinusDM = 0.0;
        double prevPlusDM = 0.0;
        double prevTR = 0.0;
        today = startIdx - lookbackTotal;
        double prevHigh = inHigh[today];
        double prevLow = inLow[today];
        double prevClose = inClose[today];
        int i = optInTimePeriod - 1;
        while (i-- > 0) {
            tempReal = inHigh[++today];
            diffP = tempReal - prevHigh;
            prevHigh = tempReal;
            tempReal = inLow[today];
            diffM = prevLow - tempReal;
            prevLow = tempReal;
            if (diffM > 0.0 && diffP < diffM) {
                prevMinusDM += diffM;
            } else if (diffP > 0.0 && diffP > diffM) {
                prevPlusDM += diffP;
            }
            tempReal = prevHigh - prevLow;
            tempReal2 = Math.abs(prevHigh - prevClose);
            if (tempReal2 > tempReal) {
                tempReal = tempReal2;
            }
            if ((tempReal2 = Math.abs(prevLow - prevClose)) > tempReal) {
                tempReal = tempReal2;
            }
            prevTR += tempReal;
            prevClose = inClose[today];
        }
        double sumDX = 0.0;
        i = optInTimePeriod;
        while (i-- > 0) {
            tempReal = inHigh[++today];
            diffP = tempReal - prevHigh;
            prevHigh = tempReal;
            tempReal = inLow[today];
            diffM = prevLow - tempReal;
            prevLow = tempReal;
            prevMinusDM -= prevMinusDM / (double)optInTimePeriod;
            prevPlusDM -= prevPlusDM / (double)optInTimePeriod;
            if (diffM > 0.0 && diffP < diffM) {
                prevMinusDM += diffM;
            } else if (diffP > 0.0 && diffP > diffM) {
                prevPlusDM += diffP;
            }
            tempReal = prevHigh - prevLow;
            tempReal2 = Math.abs(prevHigh - prevClose);
            if (tempReal2 > tempReal) {
                tempReal = tempReal2;
            }
            if ((tempReal2 = Math.abs(prevLow - prevClose)) > tempReal) {
                tempReal = tempReal2;
            }
            prevTR = prevTR - prevTR / (double)optInTimePeriod + tempReal;
            prevClose = inClose[today];
            if (-1.0E-8 < prevTR && prevTR < 1.0E-8 || -1.0E-8 < (tempReal = (minusDI = 100.0 * (prevMinusDM / prevTR)) + (plusDI = 100.0 * (prevPlusDM / prevTR))) && tempReal < 1.0E-8) continue;
            sumDX += 100.0 * (Math.abs(minusDI - plusDI) / tempReal);
        }
        double prevADX = sumDX / (double)optInTimePeriod;
        i = this.unstablePeriod[FuncUnstId.Adx.ordinal()];
        while (i-- > 0) {
            tempReal = inHigh[++today];
            diffP = tempReal - prevHigh;
            prevHigh = tempReal;
            tempReal = inLow[today];
            diffM = prevLow - tempReal;
            prevLow = tempReal;
            prevMinusDM -= prevMinusDM / (double)optInTimePeriod;
            prevPlusDM -= prevPlusDM / (double)optInTimePeriod;
            if (diffM > 0.0 && diffP < diffM) {
                prevMinusDM += diffM;
            } else if (diffP > 0.0 && diffP > diffM) {
                prevPlusDM += diffP;
            }
            tempReal = prevHigh - prevLow;
            tempReal2 = Math.abs(prevHigh - prevClose);
            if (tempReal2 > tempReal) {
                tempReal = tempReal2;
            }
            if ((tempReal2 = Math.abs(prevLow - prevClose)) > tempReal) {
                tempReal = tempReal2;
            }
            prevTR = prevTR - prevTR / (double)optInTimePeriod + tempReal;
            prevClose = inClose[today];
            if (-1.0E-8 < prevTR && prevTR < 1.0E-8 || -1.0E-8 < (tempReal = (minusDI = 100.0 * (prevMinusDM / prevTR)) + (plusDI = 100.0 * (prevPlusDM / prevTR))) && tempReal < 1.0E-8) continue;
            tempReal = 100.0 * (Math.abs(minusDI - plusDI) / tempReal);
            prevADX = (prevADX * (double)(optInTimePeriod - 1) + tempReal) / (double)optInTimePeriod;
        }
        outReal[0] = prevADX;
        outIdx = 1;
        while (today < endIdx) {
            tempReal = inHigh[++today];
            diffP = tempReal - prevHigh;
            prevHigh = tempReal;
            tempReal = inLow[today];
            diffM = prevLow - tempReal;
            prevLow = tempReal;
            prevMinusDM -= prevMinusDM / (double)optInTimePeriod;
            prevPlusDM -= prevPlusDM / (double)optInTimePeriod;
            if (diffM > 0.0 && diffP < diffM) {
                prevMinusDM += diffM;
            } else if (diffP > 0.0 && diffP > diffM) {
                prevPlusDM += diffP;
            }
            tempReal = prevHigh - prevLow;
            tempReal2 = Math.abs(prevHigh - prevClose);
            if (tempReal2 > tempReal) {
                tempReal = tempReal2;
            }
            if ((tempReal2 = Math.abs(prevLow - prevClose)) > tempReal) {
                tempReal = tempReal2;
            }
            prevTR = prevTR - prevTR / (double)optInTimePeriod + tempReal;
            prevClose = inClose[today];
            if (!(-1.0E-8 < prevTR && prevTR < 1.0E-8 || -1.0E-8 < (tempReal = (minusDI = 100.0 * (prevMinusDM / prevTR)) + (plusDI = 100.0 * (prevPlusDM / prevTR))) && tempReal < 1.0E-8)) {
                tempReal = 100.0 * (Math.abs(minusDI - plusDI) / tempReal);
                prevADX = (prevADX * (double)(optInTimePeriod - 1) + tempReal) / (double)optInTimePeriod;
            }
            outReal[outIdx++] = prevADX;
        }
        outNBElement.value = outIdx;
        return RetCode.Success;
    }

    public int adxrLookback(int optInTimePeriod) {
        if (optInTimePeriod == Integer.MIN_VALUE) {
            optInTimePeriod = 14;
        } else if (optInTimePeriod < 2 || optInTimePeriod > 100000) {
            return -1;
        }
        if (optInTimePeriod > 1) {
            return optInTimePeriod + this.adxLookback(optInTimePeriod) - 1;
        }
        return 3;
    }

    public RetCode adxr(int startIdx, int endIdx, double[] inHigh, double[] inLow, double[] inClose, int optInTimePeriod, MInteger outBegIdx, MInteger outNBElement, double[] outReal) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInTimePeriod == Integer.MIN_VALUE) {
            optInTimePeriod = 14;
        } else if (optInTimePeriod < 2 || optInTimePeriod > 100000) {
            return RetCode.BadParam;
        }
        int adxrLookback = this.adxrLookback(optInTimePeriod);
        if (startIdx < adxrLookback) {
            startIdx = adxrLookback;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        double[] adx = new double[endIdx - startIdx + optInTimePeriod];
        RetCode retCode = this.adx(startIdx - (optInTimePeriod - 1), endIdx, inHigh, inLow, inClose, optInTimePeriod, outBegIdx, outNBElement, adx);
        if (retCode != RetCode.Success) {
            return retCode;
        }
        int i = optInTimePeriod - 1;
        int j = 0;
        int outIdx = 0;
        int nbElement = endIdx - startIdx + 2;
        while (--nbElement != 0) {
            outReal[outIdx++] = (adx[i++] + adx[j++]) / 2.0;
        }
        outBegIdx.value = startIdx;
        outNBElement.value = outIdx;
        return RetCode.Success;
    }

    public RetCode adxr(int startIdx, int endIdx, float[] inHigh, float[] inLow, float[] inClose, int optInTimePeriod, MInteger outBegIdx, MInteger outNBElement, double[] outReal) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInTimePeriod == Integer.MIN_VALUE) {
            optInTimePeriod = 14;
        } else if (optInTimePeriod < 2 || optInTimePeriod > 100000) {
            return RetCode.BadParam;
        }
        int adxrLookback = this.adxrLookback(optInTimePeriod);
        if (startIdx < adxrLookback) {
            startIdx = adxrLookback;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        double[] adx = new double[endIdx - startIdx + optInTimePeriod];
        RetCode retCode = this.adx(startIdx - (optInTimePeriod - 1), endIdx, inHigh, inLow, inClose, optInTimePeriod, outBegIdx, outNBElement, adx);
        if (retCode != RetCode.Success) {
            return retCode;
        }
        int i = optInTimePeriod - 1;
        int j = 0;
        int outIdx = 0;
        int nbElement = endIdx - startIdx + 2;
        while (--nbElement != 0) {
            outReal[outIdx++] = (adx[i++] + adx[j++]) / 2.0;
        }
        outBegIdx.value = startIdx;
        outNBElement.value = outIdx;
        return RetCode.Success;
    }

    public int apoLookback(int optInFastPeriod, int optInSlowPeriod, MAType optInMAType) {
        if (optInFastPeriod == Integer.MIN_VALUE) {
            optInFastPeriod = 12;
        } else if (optInFastPeriod < 2 || optInFastPeriod > 100000) {
            return -1;
        }
        if (optInSlowPeriod == Integer.MIN_VALUE) {
            optInSlowPeriod = 26;
        } else if (optInSlowPeriod < 2 || optInSlowPeriod > 100000) {
            return -1;
        }
        return this.movingAverageLookback(optInSlowPeriod > optInFastPeriod ? optInSlowPeriod : optInFastPeriod, optInMAType);
    }

    public RetCode apo(int startIdx, int endIdx, double[] inReal, int optInFastPeriod, int optInSlowPeriod, MAType optInMAType, MInteger outBegIdx, MInteger outNBElement, double[] outReal) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInFastPeriod == Integer.MIN_VALUE) {
            optInFastPeriod = 12;
        } else if (optInFastPeriod < 2 || optInFastPeriod > 100000) {
            return RetCode.BadParam;
        }
        if (optInSlowPeriod == Integer.MIN_VALUE) {
            optInSlowPeriod = 26;
        } else if (optInSlowPeriod < 2 || optInSlowPeriod > 100000) {
            return RetCode.BadParam;
        }
        double[] tempBuffer = new double[endIdx - startIdx + 1];
        RetCode retCode = this.TA_INT_PO(startIdx, endIdx, inReal, optInFastPeriod, optInSlowPeriod, optInMAType, outBegIdx, outNBElement, outReal, tempBuffer, 0);
        return retCode;
    }

    RetCode TA_INT_PO(int startIdx, int endIdx, double[] inReal, int optInFastPeriod, int optInSlowPeriod, MAType optInMethod_2, MInteger outBegIdx, MInteger outNBElement, double[] outReal, double[] tempBuffer, int doPercentageOutput) {
        RetCode retCode;
        int tempInteger;
        MInteger outBegIdx1 = new MInteger();
        MInteger outNbElement1 = new MInteger();
        MInteger outBegIdx2 = new MInteger();
        MInteger outNbElement2 = new MInteger();
        if (optInSlowPeriod < optInFastPeriod) {
            tempInteger = optInSlowPeriod;
            optInSlowPeriod = optInFastPeriod;
            optInFastPeriod = tempInteger;
        }
        if ((retCode = this.movingAverage(startIdx, endIdx, inReal, optInFastPeriod, optInMethod_2, outBegIdx2, outNbElement2, tempBuffer)) == RetCode.Success && (retCode = this.movingAverage(startIdx, endIdx, inReal, optInSlowPeriod, optInMethod_2, outBegIdx1, outNbElement1, outReal)) == RetCode.Success) {
            tempInteger = outBegIdx1.value - outBegIdx2.value;
            if (doPercentageOutput != 0) {
                int i = 0;
                int j = tempInteger;
                while (i < outNbElement1.value) {
                    double tempReal = outReal[i];
                    outReal[i] = !(-1.0E-8 < tempReal) || !(tempReal < 1.0E-8) ? (tempBuffer[j] - tempReal) / tempReal * 100.0 : 0.0;
                    ++i;
                    ++j;
                }
            } else {
                int i = 0;
                int j = tempInteger;
                while (i < outNbElement1.value) {
                    outReal[i] = tempBuffer[j] - outReal[i];
                    ++i;
                    ++j;
                }
            }
            outBegIdx.value = outBegIdx1.value;
            outNBElement.value = outNbElement1.value;
        }
        if (retCode != RetCode.Success) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
        }
        return retCode;
    }

    public RetCode apo(int startIdx, int endIdx, float[] inReal, int optInFastPeriod, int optInSlowPeriod, MAType optInMAType, MInteger outBegIdx, MInteger outNBElement, double[] outReal) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInFastPeriod == Integer.MIN_VALUE) {
            optInFastPeriod = 12;
        } else if (optInFastPeriod < 2 || optInFastPeriod > 100000) {
            return RetCode.BadParam;
        }
        if (optInSlowPeriod == Integer.MIN_VALUE) {
            optInSlowPeriod = 26;
        } else if (optInSlowPeriod < 2 || optInSlowPeriod > 100000) {
            return RetCode.BadParam;
        }
        double[] tempBuffer = new double[endIdx - startIdx + 1];
        RetCode retCode = this.TA_INT_PO(startIdx, endIdx, inReal, optInFastPeriod, optInSlowPeriod, optInMAType, outBegIdx, outNBElement, outReal, tempBuffer, 0);
        return retCode;
    }

    RetCode TA_INT_PO(int startIdx, int endIdx, float[] inReal, int optInFastPeriod, int optInSlowPeriod, MAType optInMethod_2, MInteger outBegIdx, MInteger outNBElement, double[] outReal, double[] tempBuffer, int doPercentageOutput) {
        RetCode retCode;
        int tempInteger;
        MInteger outBegIdx1 = new MInteger();
        MInteger outNbElement1 = new MInteger();
        MInteger outBegIdx2 = new MInteger();
        MInteger outNbElement2 = new MInteger();
        if (optInSlowPeriod < optInFastPeriod) {
            tempInteger = optInSlowPeriod;
            optInSlowPeriod = optInFastPeriod;
            optInFastPeriod = tempInteger;
        }
        if ((retCode = this.movingAverage(startIdx, endIdx, inReal, optInFastPeriod, optInMethod_2, outBegIdx2, outNbElement2, tempBuffer)) == RetCode.Success && (retCode = this.movingAverage(startIdx, endIdx, inReal, optInSlowPeriod, optInMethod_2, outBegIdx1, outNbElement1, outReal)) == RetCode.Success) {
            tempInteger = outBegIdx1.value - outBegIdx2.value;
            if (doPercentageOutput != 0) {
                int i = 0;
                int j = tempInteger;
                while (i < outNbElement1.value) {
                    double tempReal = outReal[i];
                    outReal[i] = !(-1.0E-8 < tempReal) || !(tempReal < 1.0E-8) ? (tempBuffer[j] - tempReal) / tempReal * 100.0 : 0.0;
                    ++i;
                    ++j;
                }
            } else {
                int i = 0;
                int j = tempInteger;
                while (i < outNbElement1.value) {
                    outReal[i] = tempBuffer[j] - outReal[i];
                    ++i;
                    ++j;
                }
            }
            outBegIdx.value = outBegIdx1.value;
            outNBElement.value = outNbElement1.value;
        }
        if (retCode != RetCode.Success) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
        }
        return retCode;
    }

    public int aroonLookback(int optInTimePeriod) {
        if (optInTimePeriod == Integer.MIN_VALUE) {
            optInTimePeriod = 14;
        } else if (optInTimePeriod < 2 || optInTimePeriod > 100000) {
            return -1;
        }
        return optInTimePeriod;
    }

    public RetCode aroon(int startIdx, int endIdx, double[] inHigh, double[] inLow, int optInTimePeriod, MInteger outBegIdx, MInteger outNBElement, double[] outAroonDown, double[] outAroonUp) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInTimePeriod == Integer.MIN_VALUE) {
            optInTimePeriod = 14;
        } else if (optInTimePeriod < 2 || optInTimePeriod > 100000) {
            return RetCode.BadParam;
        }
        if (startIdx < optInTimePeriod) {
            startIdx = optInTimePeriod;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        int outIdx = 0;
        int today = startIdx;
        int trailingIdx = startIdx - optInTimePeriod;
        int lowestIdx = -1;
        int highestIdx = -1;
        double lowest = 0.0;
        double highest = 0.0;
        double factor = 100.0 / (double)optInTimePeriod;
        while (today <= endIdx) {
            int i;
            double tmp = inLow[today];
            if (lowestIdx < trailingIdx) {
                lowestIdx = trailingIdx;
                lowest = inLow[lowestIdx];
                i = lowestIdx;
                while (++i <= today) {
                    tmp = inLow[i];
                    if (!(tmp <= lowest)) continue;
                    lowestIdx = i;
                    lowest = tmp;
                }
            } else if (tmp <= lowest) {
                lowestIdx = today;
                lowest = tmp;
            }
            tmp = inHigh[today];
            if (highestIdx < trailingIdx) {
                highestIdx = trailingIdx;
                highest = inHigh[highestIdx];
                i = highestIdx;
                while (++i <= today) {
                    tmp = inHigh[i];
                    if (!(tmp >= highest)) continue;
                    highestIdx = i;
                    highest = tmp;
                }
            } else if (tmp >= highest) {
                highestIdx = today;
                highest = tmp;
            }
            outAroonUp[outIdx] = factor * (double)(optInTimePeriod - (today - highestIdx));
            outAroonDown[outIdx] = factor * (double)(optInTimePeriod - (today - lowestIdx));
            ++outIdx;
            ++trailingIdx;
            ++today;
        }
        outBegIdx.value = startIdx;
        outNBElement.value = outIdx;
        return RetCode.Success;
    }

    public RetCode aroon(int startIdx, int endIdx, float[] inHigh, float[] inLow, int optInTimePeriod, MInteger outBegIdx, MInteger outNBElement, double[] outAroonDown, double[] outAroonUp) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInTimePeriod == Integer.MIN_VALUE) {
            optInTimePeriod = 14;
        } else if (optInTimePeriod < 2 || optInTimePeriod > 100000) {
            return RetCode.BadParam;
        }
        if (startIdx < optInTimePeriod) {
            startIdx = optInTimePeriod;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        int outIdx = 0;
        int today = startIdx;
        int trailingIdx = startIdx - optInTimePeriod;
        int lowestIdx = -1;
        int highestIdx = -1;
        double lowest = 0.0;
        double highest = 0.0;
        double factor = 100.0 / (double)optInTimePeriod;
        while (today <= endIdx) {
            int i;
            double tmp = inLow[today];
            if (lowestIdx < trailingIdx) {
                lowestIdx = trailingIdx;
                lowest = inLow[lowestIdx];
                i = lowestIdx;
                while (++i <= today) {
                    tmp = inLow[i];
                    if (!(tmp <= lowest)) continue;
                    lowestIdx = i;
                    lowest = tmp;
                }
            } else if (tmp <= lowest) {
                lowestIdx = today;
                lowest = tmp;
            }
            tmp = inHigh[today];
            if (highestIdx < trailingIdx) {
                highestIdx = trailingIdx;
                highest = inHigh[highestIdx];
                i = highestIdx;
                while (++i <= today) {
                    tmp = inHigh[i];
                    if (!(tmp >= highest)) continue;
                    highestIdx = i;
                    highest = tmp;
                }
            } else if (tmp >= highest) {
                highestIdx = today;
                highest = tmp;
            }
            outAroonUp[outIdx] = factor * (double)(optInTimePeriod - (today - highestIdx));
            outAroonDown[outIdx] = factor * (double)(optInTimePeriod - (today - lowestIdx));
            ++outIdx;
            ++trailingIdx;
            ++today;
        }
        outBegIdx.value = startIdx;
        outNBElement.value = outIdx;
        return RetCode.Success;
    }

    public int aroonOscLookback(int optInTimePeriod) {
        if (optInTimePeriod == Integer.MIN_VALUE) {
            optInTimePeriod = 14;
        } else if (optInTimePeriod < 2 || optInTimePeriod > 100000) {
            return -1;
        }
        return optInTimePeriod;
    }

    public RetCode aroonOsc(int startIdx, int endIdx, double[] inHigh, double[] inLow, int optInTimePeriod, MInteger outBegIdx, MInteger outNBElement, double[] outReal) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInTimePeriod == Integer.MIN_VALUE) {
            optInTimePeriod = 14;
        } else if (optInTimePeriod < 2 || optInTimePeriod > 100000) {
            return RetCode.BadParam;
        }
        if (startIdx < optInTimePeriod) {
            startIdx = optInTimePeriod;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        int outIdx = 0;
        int today = startIdx;
        int trailingIdx = startIdx - optInTimePeriod;
        int lowestIdx = -1;
        int highestIdx = -1;
        double lowest = 0.0;
        double highest = 0.0;
        double factor = 100.0 / (double)optInTimePeriod;
        while (today <= endIdx) {
            double aroon;
            int i;
            double tmp = inLow[today];
            if (lowestIdx < trailingIdx) {
                lowestIdx = trailingIdx;
                lowest = inLow[lowestIdx];
                i = lowestIdx;
                while (++i <= today) {
                    tmp = inLow[i];
                    if (!(tmp <= lowest)) continue;
                    lowestIdx = i;
                    lowest = tmp;
                }
            } else if (tmp <= lowest) {
                lowestIdx = today;
                lowest = tmp;
            }
            tmp = inHigh[today];
            if (highestIdx < trailingIdx) {
                highestIdx = trailingIdx;
                highest = inHigh[highestIdx];
                i = highestIdx;
                while (++i <= today) {
                    tmp = inHigh[i];
                    if (!(tmp >= highest)) continue;
                    highestIdx = i;
                    highest = tmp;
                }
            } else if (tmp >= highest) {
                highestIdx = today;
                highest = tmp;
            }
            outReal[outIdx] = aroon = factor * (double)(highestIdx - lowestIdx);
            ++outIdx;
            ++trailingIdx;
            ++today;
        }
        outBegIdx.value = startIdx;
        outNBElement.value = outIdx;
        return RetCode.Success;
    }

    public RetCode aroonOsc(int startIdx, int endIdx, float[] inHigh, float[] inLow, int optInTimePeriod, MInteger outBegIdx, MInteger outNBElement, double[] outReal) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInTimePeriod == Integer.MIN_VALUE) {
            optInTimePeriod = 14;
        } else if (optInTimePeriod < 2 || optInTimePeriod > 100000) {
            return RetCode.BadParam;
        }
        if (startIdx < optInTimePeriod) {
            startIdx = optInTimePeriod;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        int outIdx = 0;
        int today = startIdx;
        int trailingIdx = startIdx - optInTimePeriod;
        int lowestIdx = -1;
        int highestIdx = -1;
        double lowest = 0.0;
        double highest = 0.0;
        double factor = 100.0 / (double)optInTimePeriod;
        while (today <= endIdx) {
            double aroon;
            int i;
            double tmp = inLow[today];
            if (lowestIdx < trailingIdx) {
                lowestIdx = trailingIdx;
                lowest = inLow[lowestIdx];
                i = lowestIdx;
                while (++i <= today) {
                    tmp = inLow[i];
                    if (!(tmp <= lowest)) continue;
                    lowestIdx = i;
                    lowest = tmp;
                }
            } else if (tmp <= lowest) {
                lowestIdx = today;
                lowest = tmp;
            }
            tmp = inHigh[today];
            if (highestIdx < trailingIdx) {
                highestIdx = trailingIdx;
                highest = inHigh[highestIdx];
                i = highestIdx;
                while (++i <= today) {
                    tmp = inHigh[i];
                    if (!(tmp >= highest)) continue;
                    highestIdx = i;
                    highest = tmp;
                }
            } else if (tmp >= highest) {
                highestIdx = today;
                highest = tmp;
            }
            outReal[outIdx] = aroon = factor * (double)(highestIdx - lowestIdx);
            ++outIdx;
            ++trailingIdx;
            ++today;
        }
        outBegIdx.value = startIdx;
        outNBElement.value = outIdx;
        return RetCode.Success;
    }

    public int asinLookback() {
        return 0;
    }

    public RetCode asin(int startIdx, int endIdx, double[] inReal, MInteger outBegIdx, MInteger outNBElement, double[] outReal) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        int i = startIdx;
        int outIdx = 0;
        while (i <= endIdx) {
            outReal[outIdx] = Math.asin(inReal[i]);
            ++i;
            ++outIdx;
        }
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public RetCode asin(int startIdx, int endIdx, float[] inReal, MInteger outBegIdx, MInteger outNBElement, double[] outReal) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        int i = startIdx;
        int outIdx = 0;
        while (i <= endIdx) {
            outReal[outIdx] = Math.asin(inReal[i]);
            ++i;
            ++outIdx;
        }
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int atanLookback() {
        return 0;
    }

    public RetCode atan(int startIdx, int endIdx, double[] inReal, MInteger outBegIdx, MInteger outNBElement, double[] outReal) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        int i = startIdx;
        int outIdx = 0;
        while (i <= endIdx) {
            outReal[outIdx] = Math.atan(inReal[i]);
            ++i;
            ++outIdx;
        }
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public RetCode atan(int startIdx, int endIdx, float[] inReal, MInteger outBegIdx, MInteger outNBElement, double[] outReal) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        int i = startIdx;
        int outIdx = 0;
        while (i <= endIdx) {
            outReal[outIdx] = Math.atan(inReal[i]);
            ++i;
            ++outIdx;
        }
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int atrLookback(int optInTimePeriod) {
        if (optInTimePeriod == Integer.MIN_VALUE) {
            optInTimePeriod = 14;
        } else if (optInTimePeriod < 1 || optInTimePeriod > 100000) {
            return -1;
        }
        return optInTimePeriod + this.unstablePeriod[FuncUnstId.Atr.ordinal()];
    }

    public RetCode atr(int startIdx, int endIdx, double[] inHigh, double[] inLow, double[] inClose, int optInTimePeriod, MInteger outBegIdx, MInteger outNBElement, double[] outReal) {
        MInteger outBegIdx1 = new MInteger();
        MInteger outNbElement1 = new MInteger();
        double[] prevATRTemp = new double[1];
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInTimePeriod == Integer.MIN_VALUE) {
            optInTimePeriod = 14;
        } else if (optInTimePeriod < 1 || optInTimePeriod > 100000) {
            return RetCode.BadParam;
        }
        outBegIdx.value = 0;
        outNBElement.value = 0;
        int lookbackTotal = this.atrLookback(optInTimePeriod);
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            return RetCode.Success;
        }
        if (optInTimePeriod <= 1) {
            return this.trueRange(startIdx, endIdx, inHigh, inLow, inClose, outBegIdx, outNBElement, outReal);
        }
        double[] tempBuffer = new double[lookbackTotal + (endIdx - startIdx) + 1];
        RetCode retCode = this.trueRange(startIdx - lookbackTotal + 1, endIdx, inHigh, inLow, inClose, outBegIdx1, outNbElement1, tempBuffer);
        if (retCode != RetCode.Success) {
            return retCode;
        }
        retCode = this.TA_INT_SMA(optInTimePeriod - 1, optInTimePeriod - 1, tempBuffer, optInTimePeriod, outBegIdx1, outNbElement1, prevATRTemp);
        if (retCode != RetCode.Success) {
            return retCode;
        }
        double prevATR = prevATRTemp[0];
        int today = optInTimePeriod;
        int outIdx = this.unstablePeriod[FuncUnstId.Atr.ordinal()];
        while (outIdx != 0) {
            prevATR *= (double)(optInTimePeriod - 1);
            prevATR += tempBuffer[today++];
            prevATR /= (double)optInTimePeriod;
            --outIdx;
        }
        outIdx = 1;
        outReal[0] = prevATR;
        int nbATR = endIdx - startIdx + 1;
        while (--nbATR != 0) {
            prevATR *= (double)(optInTimePeriod - 1);
            prevATR += tempBuffer[today++];
            outReal[outIdx++] = prevATR /= (double)optInTimePeriod;
        }
        outBegIdx.value = startIdx;
        outNBElement.value = outIdx;
        return retCode;
    }

    public RetCode atr(int startIdx, int endIdx, float[] inHigh, float[] inLow, float[] inClose, int optInTimePeriod, MInteger outBegIdx, MInteger outNBElement, double[] outReal) {
        MInteger outBegIdx1 = new MInteger();
        MInteger outNbElement1 = new MInteger();
        double[] prevATRTemp = new double[1];
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInTimePeriod == Integer.MIN_VALUE) {
            optInTimePeriod = 14;
        } else if (optInTimePeriod < 1 || optInTimePeriod > 100000) {
            return RetCode.BadParam;
        }
        outBegIdx.value = 0;
        outNBElement.value = 0;
        int lookbackTotal = this.atrLookback(optInTimePeriod);
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            return RetCode.Success;
        }
        if (optInTimePeriod <= 1) {
            return this.trueRange(startIdx, endIdx, inHigh, inLow, inClose, outBegIdx, outNBElement, outReal);
        }
        double[] tempBuffer = new double[lookbackTotal + (endIdx - startIdx) + 1];
        RetCode retCode = this.trueRange(startIdx - lookbackTotal + 1, endIdx, inHigh, inLow, inClose, outBegIdx1, outNbElement1, tempBuffer);
        if (retCode != RetCode.Success) {
            return retCode;
        }
        retCode = this.TA_INT_SMA(optInTimePeriod - 1, optInTimePeriod - 1, tempBuffer, optInTimePeriod, outBegIdx1, outNbElement1, prevATRTemp);
        if (retCode != RetCode.Success) {
            return retCode;
        }
        double prevATR = prevATRTemp[0];
        int today = optInTimePeriod;
        int outIdx = this.unstablePeriod[FuncUnstId.Atr.ordinal()];
        while (outIdx != 0) {
            prevATR *= (double)(optInTimePeriod - 1);
            prevATR += tempBuffer[today++];
            prevATR /= (double)optInTimePeriod;
            --outIdx;
        }
        outIdx = 1;
        outReal[0] = prevATR;
        int nbATR = endIdx - startIdx + 1;
        while (--nbATR != 0) {
            prevATR *= (double)(optInTimePeriod - 1);
            prevATR += tempBuffer[today++];
            outReal[outIdx++] = prevATR /= (double)optInTimePeriod;
        }
        outBegIdx.value = startIdx;
        outNBElement.value = outIdx;
        return retCode;
    }

    public int avgPriceLookback() {
        return 0;
    }

    public RetCode avgPrice(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, double[] outReal) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        int outIdx = 0;
        int i = startIdx;
        while (i <= endIdx) {
            outReal[outIdx++] = (inHigh[i] + inLow[i] + inClose[i] + inOpen[i]) / 4.0;
            ++i;
        }
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public RetCode avgPrice(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, double[] outReal) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        int outIdx = 0;
        int i = startIdx;
        while (i <= endIdx) {
            outReal[outIdx++] = (inHigh[i] + inLow[i] + inClose[i] + inOpen[i]) / 4.0f;
            ++i;
        }
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int bbandsLookback(int optInTimePeriod, double optInNbDevUp, double optInNbDevDn, MAType optInMAType) {
        if (optInTimePeriod == Integer.MIN_VALUE) {
            optInTimePeriod = 5;
        } else if (optInTimePeriod < 2 || optInTimePeriod > 100000) {
            return -1;
        }
        if (optInNbDevUp == -4.0E37) {
            optInNbDevUp = 2.0;
        } else if (optInNbDevUp < -3.0E37 || optInNbDevUp > 3.0E37) {
            return -1;
        }
        if (optInNbDevDn == -4.0E37) {
            optInNbDevDn = 2.0;
        } else if (optInNbDevDn < -3.0E37 || optInNbDevDn > 3.0E37) {
            return -1;
        }
        return this.movingAverageLookback(optInTimePeriod, optInMAType);
    }

    public RetCode bbands(int startIdx, int endIdx, double[] inReal, int optInTimePeriod, double optInNbDevUp, double optInNbDevDn, MAType optInMAType, MInteger outBegIdx, MInteger outNBElement, double[] outRealUpperBand, double[] outRealMiddleBand, double[] outRealLowerBand) {
        double[] tempBuffer2;
        double[] tempBuffer1;
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInTimePeriod == Integer.MIN_VALUE) {
            optInTimePeriod = 5;
        } else if (optInTimePeriod < 2 || optInTimePeriod > 100000) {
            return RetCode.BadParam;
        }
        if (optInNbDevUp == -4.0E37) {
            optInNbDevUp = 2.0;
        } else if (optInNbDevUp < -3.0E37 || optInNbDevUp > 3.0E37) {
            return RetCode.BadParam;
        }
        if (optInNbDevDn == -4.0E37) {
            optInNbDevDn = 2.0;
        } else if (optInNbDevDn < -3.0E37 || optInNbDevDn > 3.0E37) {
            return RetCode.BadParam;
        }
        if (inReal == outRealUpperBand) {
            tempBuffer1 = outRealMiddleBand;
            tempBuffer2 = outRealLowerBand;
        } else if (inReal == outRealLowerBand) {
            tempBuffer1 = outRealMiddleBand;
            tempBuffer2 = outRealUpperBand;
        } else if (inReal == outRealMiddleBand) {
            tempBuffer1 = outRealLowerBand;
            tempBuffer2 = outRealUpperBand;
        } else {
            tempBuffer1 = outRealMiddleBand;
            tempBuffer2 = outRealUpperBand;
        }
        if (tempBuffer1 == inReal || tempBuffer2 == inReal) {
            return RetCode.BadParam;
        }
        RetCode retCode = this.movingAverage(startIdx, endIdx, inReal, optInTimePeriod, optInMAType, outBegIdx, outNBElement, tempBuffer1);
        if (retCode != RetCode.Success || outNBElement.value == 0) {
            outNBElement.value = 0;
            return retCode;
        }
        if (optInMAType == MAType.Sma) {
            this.TA_INT_stddev_using_precalc_ma(inReal, tempBuffer1, outBegIdx.value, outNBElement.value, optInTimePeriod, tempBuffer2);
        } else {
            retCode = this.stdDev(outBegIdx.value, endIdx, inReal, optInTimePeriod, 1.0, outBegIdx, outNBElement, tempBuffer2);
            if (retCode != RetCode.Success) {
                outNBElement.value = 0;
                return retCode;
            }
        }
        if (tempBuffer1 != outRealMiddleBand) {
            System.arraycopy(tempBuffer1, 0, outRealMiddleBand, 0, outNBElement.value);
        }
        if (optInNbDevUp == optInNbDevDn) {
            if (optInNbDevUp == 1.0) {
                int i = 0;
                while (i < outNBElement.value) {
                    double tempReal = tempBuffer2[i];
                    double tempReal2 = outRealMiddleBand[i];
                    outRealUpperBand[i] = tempReal2 + tempReal;
                    outRealLowerBand[i] = tempReal2 - tempReal;
                    ++i;
                }
            } else {
                int i = 0;
                while (i < outNBElement.value) {
                    double tempReal = tempBuffer2[i] * optInNbDevUp;
                    double tempReal2 = outRealMiddleBand[i];
                    outRealUpperBand[i] = tempReal2 + tempReal;
                    outRealLowerBand[i] = tempReal2 - tempReal;
                    ++i;
                }
            }
        } else if (optInNbDevUp == 1.0) {
            int i = 0;
            while (i < outNBElement.value) {
                double tempReal = tempBuffer2[i];
                double tempReal2 = outRealMiddleBand[i];
                outRealUpperBand[i] = tempReal2 + tempReal;
                outRealLowerBand[i] = tempReal2 - tempReal * optInNbDevDn;
                ++i;
            }
        } else if (optInNbDevDn == 1.0) {
            int i = 0;
            while (i < outNBElement.value) {
                double tempReal = tempBuffer2[i];
                double tempReal2 = outRealMiddleBand[i];
                outRealLowerBand[i] = tempReal2 - tempReal;
                outRealUpperBand[i] = tempReal2 + tempReal * optInNbDevUp;
                ++i;
            }
        } else {
            int i = 0;
            while (i < outNBElement.value) {
                double tempReal = tempBuffer2[i];
                double tempReal2 = outRealMiddleBand[i];
                outRealUpperBand[i] = tempReal2 + tempReal * optInNbDevUp;
                outRealLowerBand[i] = tempReal2 - tempReal * optInNbDevDn;
                ++i;
            }
        }
        return RetCode.Success;
    }

    public RetCode bbands(int startIdx, int endIdx, float[] inReal, int optInTimePeriod, double optInNbDevUp, double optInNbDevDn, MAType optInMAType, MInteger outBegIdx, MInteger outNBElement, double[] outRealUpperBand, double[] outRealMiddleBand, double[] outRealLowerBand) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInTimePeriod == Integer.MIN_VALUE) {
            optInTimePeriod = 5;
        } else if (optInTimePeriod < 2 || optInTimePeriod > 100000) {
            return RetCode.BadParam;
        }
        if (optInNbDevUp == -4.0E37) {
            optInNbDevUp = 2.0;
        } else if (optInNbDevUp < -3.0E37 || optInNbDevUp > 3.0E37) {
            return RetCode.BadParam;
        }
        if (optInNbDevDn == -4.0E37) {
            optInNbDevDn = 2.0;
        } else if (optInNbDevDn < -3.0E37 || optInNbDevDn > 3.0E37) {
            return RetCode.BadParam;
        }
        double[] tempBuffer1 = outRealMiddleBand;
        double[] tempBuffer2 = outRealLowerBand;
        RetCode retCode = this.movingAverage(startIdx, endIdx, inReal, optInTimePeriod, optInMAType, outBegIdx, outNBElement, tempBuffer1);
        if (retCode != RetCode.Success || outNBElement.value == 0) {
            outNBElement.value = 0;
            return retCode;
        }
        if (optInMAType == MAType.Sma) {
            this.TA_INT_stddev_using_precalc_ma(inReal, tempBuffer1, outBegIdx.value, outNBElement.value, optInTimePeriod, tempBuffer2);
        } else {
            retCode = this.stdDev(outBegIdx.value, endIdx, inReal, optInTimePeriod, 1.0, outBegIdx, outNBElement, tempBuffer2);
            if (retCode != RetCode.Success) {
                outNBElement.value = 0;
                return retCode;
            }
        }
        if (optInNbDevUp == optInNbDevDn) {
            if (optInNbDevUp == 1.0) {
                int i = 0;
                while (i < outNBElement.value) {
                    double tempReal = tempBuffer2[i];
                    double tempReal2 = outRealMiddleBand[i];
                    outRealUpperBand[i] = tempReal2 + tempReal;
                    outRealLowerBand[i] = tempReal2 - tempReal;
                    ++i;
                }
            } else {
                int i = 0;
                while (i < outNBElement.value) {
                    double tempReal = tempBuffer2[i] * optInNbDevUp;
                    double tempReal2 = outRealMiddleBand[i];
                    outRealUpperBand[i] = tempReal2 + tempReal;
                    outRealLowerBand[i] = tempReal2 - tempReal;
                    ++i;
                }
            }
        } else if (optInNbDevUp == 1.0) {
            int i = 0;
            while (i < outNBElement.value) {
                double tempReal = tempBuffer2[i];
                double tempReal2 = outRealMiddleBand[i];
                outRealUpperBand[i] = tempReal2 + tempReal;
                outRealLowerBand[i] = tempReal2 - tempReal * optInNbDevDn;
                ++i;
            }
        } else if (optInNbDevDn == 1.0) {
            int i = 0;
            while (i < outNBElement.value) {
                double tempReal = tempBuffer2[i];
                double tempReal2 = outRealMiddleBand[i];
                outRealLowerBand[i] = tempReal2 - tempReal;
                outRealUpperBand[i] = tempReal2 + tempReal * optInNbDevUp;
                ++i;
            }
        } else {
            int i = 0;
            while (i < outNBElement.value) {
                double tempReal = tempBuffer2[i];
                double tempReal2 = outRealMiddleBand[i];
                outRealUpperBand[i] = tempReal2 + tempReal * optInNbDevUp;
                outRealLowerBand[i] = tempReal2 - tempReal * optInNbDevDn;
                ++i;
            }
        }
        return RetCode.Success;
    }

    public int betaLookback(int optInTimePeriod) {
        if (optInTimePeriod == Integer.MIN_VALUE) {
            optInTimePeriod = 5;
        } else if (optInTimePeriod < 1 || optInTimePeriod > 100000) {
            return -1;
        }
        return optInTimePeriod;
    }

    public RetCode beta(int startIdx, int endIdx, double[] inReal0, double[] inReal1, int optInTimePeriod, MInteger outBegIdx, MInteger outNBElement, double[] outReal) {
        double y;
        double x;
        double S_xx = 0.0;
        double S_xy = 0.0;
        double S_x = 0.0;
        double S_y = 0.0;
        double last_price_x = 0.0;
        double last_price_y = 0.0;
        double trailing_last_price_x = 0.0;
        double trailing_last_price_y = 0.0;
        double tmp_real = 0.0;
        double n = 0.0;
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInTimePeriod == Integer.MIN_VALUE) {
            optInTimePeriod = 5;
        } else if (optInTimePeriod < 1 || optInTimePeriod > 100000) {
            return RetCode.BadParam;
        }
        int nbInitialElementNeeded = optInTimePeriod;
        if (startIdx < nbInitialElementNeeded) {
            startIdx = nbInitialElementNeeded;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        int trailingIdx = startIdx - nbInitialElementNeeded;
        last_price_x = trailing_last_price_x = inReal0[trailingIdx];
        last_price_y = trailing_last_price_y = inReal1[trailingIdx];
        int i = ++trailingIdx;
        while (i < startIdx) {
            tmp_real = inReal0[i];
            x = !(-1.0E-8 < last_price_x) || !(last_price_x < 1.0E-8) ? (tmp_real - last_price_x) / last_price_x : 0.0;
            last_price_x = tmp_real;
            tmp_real = inReal1[i++];
            y = !(-1.0E-8 < last_price_y) || !(last_price_y < 1.0E-8) ? (tmp_real - last_price_y) / last_price_y : 0.0;
            last_price_y = tmp_real;
            S_xx += x * x;
            S_xy += x * y;
            S_x += x;
            S_y += y;
        }
        int outIdx = 0;
        n = optInTimePeriod;
        do {
            tmp_real = inReal0[i];
            x = !(-1.0E-8 < last_price_x) || !(last_price_x < 1.0E-8) ? (tmp_real - last_price_x) / last_price_x : 0.0;
            last_price_x = tmp_real;
            tmp_real = inReal1[i++];
            y = !(-1.0E-8 < last_price_y) || !(last_price_y < 1.0E-8) ? (tmp_real - last_price_y) / last_price_y : 0.0;
            last_price_y = tmp_real;
            S_xx += x * x;
            S_xy += x * y;
            S_x += x;
            S_y += y;
            tmp_real = inReal0[trailingIdx];
            x = !(-1.0E-8 < trailing_last_price_x) || !(trailing_last_price_x < 1.0E-8) ? (tmp_real - trailing_last_price_x) / trailing_last_price_x : 0.0;
            trailing_last_price_x = tmp_real;
            tmp_real = inReal1[trailingIdx++];
            y = !(-1.0E-8 < trailing_last_price_y) || !(trailing_last_price_y < 1.0E-8) ? (tmp_real - trailing_last_price_y) / trailing_last_price_y : 0.0;
            trailing_last_price_y = tmp_real;
            tmp_real = n * S_xx - S_x * S_x;
            outReal[outIdx++] = !(-1.0E-8 < tmp_real) || !(tmp_real < 1.0E-8) ? (n * S_xy - S_x * S_y) / tmp_real : 0.0;
            S_xx -= x * x;
            S_xy -= x * y;
            S_x -= x;
            S_y -= y;
        } while (i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public RetCode beta(int startIdx, int endIdx, float[] inReal0, float[] inReal1, int optInTimePeriod, MInteger outBegIdx, MInteger outNBElement, double[] outReal) {
        double y;
        double x;
        double S_xx = 0.0;
        double S_xy = 0.0;
        double S_x = 0.0;
        double S_y = 0.0;
        double last_price_x = 0.0;
        double last_price_y = 0.0;
        double trailing_last_price_x = 0.0;
        double trailing_last_price_y = 0.0;
        double tmp_real = 0.0;
        double n = 0.0;
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInTimePeriod == Integer.MIN_VALUE) {
            optInTimePeriod = 5;
        } else if (optInTimePeriod < 1 || optInTimePeriod > 100000) {
            return RetCode.BadParam;
        }
        int nbInitialElementNeeded = optInTimePeriod;
        if (startIdx < nbInitialElementNeeded) {
            startIdx = nbInitialElementNeeded;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        int trailingIdx = startIdx - nbInitialElementNeeded;
        last_price_x = trailing_last_price_x = (double)inReal0[trailingIdx];
        last_price_y = trailing_last_price_y = (double)inReal1[trailingIdx];
        int i = ++trailingIdx;
        while (i < startIdx) {
            tmp_real = inReal0[i];
            x = !(-1.0E-8 < last_price_x) || !(last_price_x < 1.0E-8) ? (tmp_real - last_price_x) / last_price_x : 0.0;
            last_price_x = tmp_real;
            tmp_real = inReal1[i++];
            y = !(-1.0E-8 < last_price_y) || !(last_price_y < 1.0E-8) ? (tmp_real - last_price_y) / last_price_y : 0.0;
            last_price_y = tmp_real;
            S_xx += x * x;
            S_xy += x * y;
            S_x += x;
            S_y += y;
        }
        int outIdx = 0;
        n = optInTimePeriod;
        do {
            tmp_real = inReal0[i];
            x = !(-1.0E-8 < last_price_x) || !(last_price_x < 1.0E-8) ? (tmp_real - last_price_x) / last_price_x : 0.0;
            last_price_x = tmp_real;
            tmp_real = inReal1[i++];
            y = !(-1.0E-8 < last_price_y) || !(last_price_y < 1.0E-8) ? (tmp_real - last_price_y) / last_price_y : 0.0;
            last_price_y = tmp_real;
            S_xx += x * x;
            S_xy += x * y;
            S_x += x;
            S_y += y;
            tmp_real = inReal0[trailingIdx];
            x = !(-1.0E-8 < trailing_last_price_x) || !(trailing_last_price_x < 1.0E-8) ? (tmp_real - trailing_last_price_x) / trailing_last_price_x : 0.0;
            trailing_last_price_x = tmp_real;
            tmp_real = inReal1[trailingIdx++];
            y = !(-1.0E-8 < trailing_last_price_y) || !(trailing_last_price_y < 1.0E-8) ? (tmp_real - trailing_last_price_y) / trailing_last_price_y : 0.0;
            trailing_last_price_y = tmp_real;
            tmp_real = n * S_xx - S_x * S_x;
            outReal[outIdx++] = !(-1.0E-8 < tmp_real) || !(tmp_real < 1.0E-8) ? (n * S_xy - S_x * S_y) / tmp_real : 0.0;
            S_xx -= x * x;
            S_xy -= x * y;
            S_x -= x;
            S_y -= y;
        } while (i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int bopLookback() {
        return 0;
    }

    public RetCode bop(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, double[] outReal) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        int outIdx = 0;
        int i = startIdx;
        while (i <= endIdx) {
            double tempReal = inHigh[i] - inLow[i];
            outReal[outIdx++] = tempReal < 1.0E-8 ? 0.0 : (inClose[i] - inOpen[i]) / tempReal;
            ++i;
        }
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public RetCode bop(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, double[] outReal) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        int outIdx = 0;
        int i = startIdx;
        while (i <= endIdx) {
            double tempReal = inHigh[i] - inLow[i];
            outReal[outIdx++] = tempReal < 1.0E-8 ? 0.0 : (double)(inClose[i] - inOpen[i]) / tempReal;
            ++i;
        }
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cciLookback(int optInTimePeriod) {
        if (optInTimePeriod == Integer.MIN_VALUE) {
            optInTimePeriod = 14;
        } else if (optInTimePeriod < 2 || optInTimePeriod > 100000) {
            return -1;
        }
        return optInTimePeriod - 1;
    }

    public RetCode cci(int startIdx, int endIdx, double[] inHigh, double[] inLow, double[] inClose, int optInTimePeriod, MInteger outBegIdx, MInteger outNBElement, double[] outReal) {
        int circBuffer_Idx = 0;
        int maxIdx_circBuffer = 29;
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInTimePeriod == Integer.MIN_VALUE) {
            optInTimePeriod = 14;
        } else if (optInTimePeriod < 2 || optInTimePeriod > 100000) {
            return RetCode.BadParam;
        }
        int lookbackTotal = optInTimePeriod - 1;
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        if (optInTimePeriod <= 0) {
            return RetCode.AllocErr;
        }
        double[] circBuffer = new double[optInTimePeriod];
        maxIdx_circBuffer = optInTimePeriod - 1;
        int i = startIdx - lookbackTotal;
        if (optInTimePeriod > 1) {
            while (i < startIdx) {
                circBuffer[circBuffer_Idx] = (inHigh[i] + inLow[i] + inClose[i]) / 3.0;
                ++i;
                if (++circBuffer_Idx <= maxIdx_circBuffer) continue;
                circBuffer_Idx = 0;
            }
        }
        int outIdx = 0;
        do {
            double lastValue;
            circBuffer[circBuffer_Idx] = lastValue = (inHigh[i] + inLow[i] + inClose[i]) / 3.0;
            double theAverage = 0.0;
            int j = 0;
            while (j < optInTimePeriod) {
                theAverage += circBuffer[j];
                ++j;
            }
            theAverage /= (double)optInTimePeriod;
            double tempReal2 = 0.0;
            j = 0;
            while (j < optInTimePeriod) {
                tempReal2 += Math.abs(circBuffer[j] - theAverage);
                ++j;
            }
            double tempReal = lastValue - theAverage;
            outReal[outIdx++] = tempReal != 0.0 && tempReal2 != 0.0 ? tempReal / (0.015 * (tempReal2 / (double)optInTimePeriod)) : 0.0;
            if (++circBuffer_Idx <= maxIdx_circBuffer) continue;
            circBuffer_Idx = 0;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public RetCode cci(int startIdx, int endIdx, float[] inHigh, float[] inLow, float[] inClose, int optInTimePeriod, MInteger outBegIdx, MInteger outNBElement, double[] outReal) {
        int circBuffer_Idx = 0;
        int maxIdx_circBuffer = 29;
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInTimePeriod == Integer.MIN_VALUE) {
            optInTimePeriod = 14;
        } else if (optInTimePeriod < 2 || optInTimePeriod > 100000) {
            return RetCode.BadParam;
        }
        int lookbackTotal = optInTimePeriod - 1;
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        if (optInTimePeriod <= 0) {
            return RetCode.AllocErr;
        }
        double[] circBuffer = new double[optInTimePeriod];
        maxIdx_circBuffer = optInTimePeriod - 1;
        int i = startIdx - lookbackTotal;
        if (optInTimePeriod > 1) {
            while (i < startIdx) {
                circBuffer[circBuffer_Idx] = (inHigh[i] + inLow[i] + inClose[i]) / 3.0f;
                ++i;
                if (++circBuffer_Idx <= maxIdx_circBuffer) continue;
                circBuffer_Idx = 0;
            }
        }
        int outIdx = 0;
        do {
            double lastValue;
            circBuffer[circBuffer_Idx] = lastValue = (double)((inHigh[i] + inLow[i] + inClose[i]) / 3.0f);
            double theAverage = 0.0;
            int j = 0;
            while (j < optInTimePeriod) {
                theAverage += circBuffer[j];
                ++j;
            }
            theAverage /= (double)optInTimePeriod;
            double tempReal2 = 0.0;
            j = 0;
            while (j < optInTimePeriod) {
                tempReal2 += Math.abs(circBuffer[j] - theAverage);
                ++j;
            }
            double tempReal = lastValue - theAverage;
            outReal[outIdx++] = tempReal != 0.0 && tempReal2 != 0.0 ? tempReal / (0.015 * (tempReal2 / (double)optInTimePeriod)) : 0.0;
            if (++circBuffer_Idx <= maxIdx_circBuffer) continue;
            circBuffer_Idx = 0;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdl2CrowsLookback() {
        return this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod + 2;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdl2Crows(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdl2CrowsLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        i = BodyLongTrailingIdx = startIdx - 2 - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        while (i < startIdx - 2) {
            BodyLongPeriodTotal += this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) != 1) ** GOTO lbl-1000
            v0 = Math.abs(inClose[i - 2] - inOpen[i - 2]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2) || (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != -1) ** GOTO lbl-1000
            v3 = inOpen[i - 1] < inClose[i - 1] ? inOpen[i - 1] : inClose[i - 1];
            v4 = inOpen[i - 2] > inClose[i - 2] ? inOpen[i - 2] : inClose[i - 2];
            if (v3 > v4 && (inClose[i] >= inOpen[i] ? 1 : -1) == -1 && inOpen[i] < inOpen[i - 1] && inOpen[i] > inClose[i - 1] && inClose[i] > inOpen[i - 2] && inClose[i] < inClose[i - 2]) {
                outInteger[outIdx++] = -100;
            } else lbl-1000:
            // 3 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyLongPeriodTotal += (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx] - inOpen[BodyLongTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx] - inLow[BodyLongTrailingIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx] - (inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inClose[BodyLongTrailingIdx] : inOpen[BodyLongTrailingIdx]) + ((inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inOpen[BodyLongTrailingIdx] : inClose[BodyLongTrailingIdx]) - inLow[BodyLongTrailingIdx]) : 0.0)));
            ++BodyLongTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdl2Crows(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdl2CrowsLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        i = BodyLongTrailingIdx = startIdx - 2 - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        while (i < startIdx - 2) {
            BodyLongPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) != 1) ** GOTO lbl-1000
            v0 = Math.abs(inClose[i - 2] - inOpen[i - 2]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2) || (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != -1) ** GOTO lbl-1000
            v3 = inOpen[i - 1] < inClose[i - 1] ? inOpen[i - 1] : inClose[i - 1];
            v4 = inOpen[i - 2] > inClose[i - 2] ? inOpen[i - 2] : inClose[i - 2];
            if (v3 > v4 && (inClose[i] >= inOpen[i] ? 1 : -1) == -1 && inOpen[i] < inOpen[i - 1] && inOpen[i] > inClose[i - 1] && inClose[i] > inOpen[i - 2] && inClose[i] < inClose[i - 2]) {
                outInteger[outIdx++] = -100;
            } else lbl-1000:
            // 3 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyLongPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx] - inOpen[BodyLongTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx] - inLow[BodyLongTrailingIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx] - (inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inClose[BodyLongTrailingIdx] : inOpen[BodyLongTrailingIdx]) + ((inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inOpen[BodyLongTrailingIdx] : inClose[BodyLongTrailingIdx]) - inLow[BodyLongTrailingIdx]) : 0.0f))));
            ++BodyLongTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdl3BlackCrowsLookback() {
        return this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod + 3;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdl3BlackCrows(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        ShadowVeryShortPeriodTotal = new double[3];
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdl3BlackCrowsLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        ShadowVeryShortPeriodTotal[2] = 0.0;
        ShadowVeryShortPeriodTotal[1] = 0.0;
        ShadowVeryShortPeriodTotal[0] = 0.0;
        i = ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal[2] = ShadowVeryShortPeriodTotal[2] + (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0)));
            ShadowVeryShortPeriodTotal[1] = ShadowVeryShortPeriodTotal[1] + (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0)));
            ShadowVeryShortPeriodTotal[0] = ShadowVeryShortPeriodTotal[0] + (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 3] >= inOpen[i - 3] ? 1 : -1) != 1 || (inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) != -1) ** GOTO lbl-1000
            v0 = (inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2];
            v1 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[2] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 < v1 / v2) || (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != -1) ** GOTO lbl-1000
            v3 = (inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1];
            v4 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v5 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 < v4 / v5) || (inClose[i] >= inOpen[i] ? 1 : -1) != -1) ** GOTO lbl-1000
            v6 = (inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i];
            v7 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[0] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v8 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v6 < v7 / v8 && inOpen[i - 1] < inOpen[i - 2] && inOpen[i - 1] > inClose[i - 2] && inOpen[i] < inOpen[i - 1] && inOpen[i] > inClose[i - 1] && inHigh[i - 3] > inClose[i - 2] && inClose[i - 2] > inClose[i - 1] && inClose[i - 1] > inClose[i]) {
                outInteger[outIdx++] = -100;
            } else lbl-1000:
            // 4 sources

            {
                outInteger[outIdx++] = 0;
            }
            totIdx = 2;
            while (totIdx >= 0) {
                v9 = totIdx;
                ShadowVeryShortPeriodTotal[v9] = ShadowVeryShortPeriodTotal[v9] + ((this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx - totIdx] - inOpen[ShadowVeryShortTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx - totIdx] - inLow[ShadowVeryShortTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx - totIdx] - (inClose[ShadowVeryShortTrailingIdx - totIdx] >= inOpen[ShadowVeryShortTrailingIdx - totIdx] ? inClose[ShadowVeryShortTrailingIdx - totIdx] : inOpen[ShadowVeryShortTrailingIdx - totIdx]) + ((inClose[ShadowVeryShortTrailingIdx - totIdx] >= inOpen[ShadowVeryShortTrailingIdx - totIdx] ? inOpen[ShadowVeryShortTrailingIdx - totIdx] : inClose[ShadowVeryShortTrailingIdx - totIdx]) - inLow[ShadowVeryShortTrailingIdx - totIdx]) : 0.0))));
                --totIdx;
            }
            ++ShadowVeryShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdl3BlackCrows(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        ShadowVeryShortPeriodTotal = new double[3];
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdl3BlackCrowsLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        ShadowVeryShortPeriodTotal[2] = 0.0;
        ShadowVeryShortPeriodTotal[1] = 0.0;
        ShadowVeryShortPeriodTotal[0] = 0.0;
        i = ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal[2] = ShadowVeryShortPeriodTotal[2] + (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f)));
            ShadowVeryShortPeriodTotal[1] = ShadowVeryShortPeriodTotal[1] + (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)));
            ShadowVeryShortPeriodTotal[0] = ShadowVeryShortPeriodTotal[0] + (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 3] >= inOpen[i - 3] ? 1 : -1) != 1 || (inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) != -1) ** GOTO lbl-1000
            v0 = (inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2];
            v1 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[2] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 < v1 / v2) || (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != -1) ** GOTO lbl-1000
            v3 = (inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1];
            v4 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v5 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 < v4 / v5) || (inClose[i] >= inOpen[i] ? 1 : -1) != -1) ** GOTO lbl-1000
            v6 = (inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i];
            v7 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[0] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v8 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v6 < v7 / v8 && inOpen[i - 1] < inOpen[i - 2] && inOpen[i - 1] > inClose[i - 2] && inOpen[i] < inOpen[i - 1] && inOpen[i] > inClose[i - 1] && inHigh[i - 3] > inClose[i - 2] && inClose[i - 2] > inClose[i - 1] && inClose[i - 1] > inClose[i]) {
                outInteger[outIdx++] = -100;
            } else lbl-1000:
            // 4 sources

            {
                outInteger[outIdx++] = 0;
            }
            totIdx = 2;
            while (totIdx >= 0) {
                v9 = totIdx;
                ShadowVeryShortPeriodTotal[v9] = ShadowVeryShortPeriodTotal[v9] + (double)((this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0f))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx - totIdx] - inOpen[ShadowVeryShortTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx - totIdx] - inLow[ShadowVeryShortTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx - totIdx] - (inClose[ShadowVeryShortTrailingIdx - totIdx] >= inOpen[ShadowVeryShortTrailingIdx - totIdx] ? inClose[ShadowVeryShortTrailingIdx - totIdx] : inOpen[ShadowVeryShortTrailingIdx - totIdx]) + ((inClose[ShadowVeryShortTrailingIdx - totIdx] >= inOpen[ShadowVeryShortTrailingIdx - totIdx] ? inOpen[ShadowVeryShortTrailingIdx - totIdx] : inClose[ShadowVeryShortTrailingIdx - totIdx]) - inLow[ShadowVeryShortTrailingIdx - totIdx]) : 0.0f))));
                --totIdx;
            }
            ++ShadowVeryShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdl3InsideLookback() {
        return (this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod) + 2;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdl3Inside(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdl3InsideLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        BodyShortPeriodTotal = 0.0;
        BodyLongTrailingIdx = startIdx - 2 - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        BodyShortTrailingIdx = startIdx - 1 - this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod;
        i = BodyLongTrailingIdx;
        while (i < startIdx - 2) {
            BodyLongPeriodTotal += this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = BodyShortTrailingIdx;
        while (i < startIdx - 1) {
            BodyShortPeriodTotal += this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i - 2] - inOpen[i - 2]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2)) ** GOTO lbl-1000
            v3 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v4 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyShortPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v5 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 <= v4 / v5)) ** GOTO lbl-1000
            v6 = inClose[i - 1] > inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1];
            v7 = inClose[i - 2] > inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2];
            if (!(v6 < v7)) ** GOTO lbl-1000
            v8 = inClose[i - 1] < inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1];
            v9 = inClose[i - 2] < inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2];
            if (v8 > v9 && ((inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) == 1 && (inClose[i] >= inOpen[i] ? 1 : -1) == -1 && inClose[i] < inOpen[i - 2] || (inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) == -1 && (inClose[i] >= inOpen[i] ? 1 : -1) == 1 && inClose[i] > inOpen[i - 2])) {
                outInteger[outIdx++] = -(inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) * 100;
            } else lbl-1000:
            // 4 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyLongPeriodTotal += (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx] - inOpen[BodyLongTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx] - inLow[BodyLongTrailingIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx] - (inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inClose[BodyLongTrailingIdx] : inOpen[BodyLongTrailingIdx]) + ((inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inOpen[BodyLongTrailingIdx] : inClose[BodyLongTrailingIdx]) - inLow[BodyLongTrailingIdx]) : 0.0)));
            BodyShortPeriodTotal += (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyShortTrailingIdx] - inOpen[BodyShortTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyShortTrailingIdx] - inLow[BodyShortTrailingIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyShortTrailingIdx] - (inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inClose[BodyShortTrailingIdx] : inOpen[BodyShortTrailingIdx]) + ((inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inOpen[BodyShortTrailingIdx] : inClose[BodyShortTrailingIdx]) - inLow[BodyShortTrailingIdx]) : 0.0)));
            ++BodyLongTrailingIdx;
            ++BodyShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdl3Inside(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdl3InsideLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        BodyShortPeriodTotal = 0.0;
        BodyLongTrailingIdx = startIdx - 2 - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        BodyShortTrailingIdx = startIdx - 1 - this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod;
        i = BodyLongTrailingIdx;
        while (i < startIdx - 2) {
            BodyLongPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = BodyShortTrailingIdx;
        while (i < startIdx - 1) {
            BodyShortPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i - 2] - inOpen[i - 2]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2)) ** GOTO lbl-1000
            v3 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v4 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyShortPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v5 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 <= v4 / v5)) ** GOTO lbl-1000
            v6 = inClose[i - 1] > inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1];
            v7 = inClose[i - 2] > inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2];
            if (!(v6 < v7)) ** GOTO lbl-1000
            v8 = inClose[i - 1] < inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1];
            v9 = inClose[i - 2] < inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2];
            if (v8 > v9 && ((inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) == 1 && (inClose[i] >= inOpen[i] ? 1 : -1) == -1 && inClose[i] < inOpen[i - 2] || (inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) == -1 && (inClose[i] >= inOpen[i] ? 1 : -1) == 1 && inClose[i] > inOpen[i - 2])) {
                outInteger[outIdx++] = -(inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) * 100;
            } else lbl-1000:
            // 4 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyLongPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx] - inOpen[BodyLongTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx] - inLow[BodyLongTrailingIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx] - (inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inClose[BodyLongTrailingIdx] : inOpen[BodyLongTrailingIdx]) + ((inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inOpen[BodyLongTrailingIdx] : inClose[BodyLongTrailingIdx]) - inLow[BodyLongTrailingIdx]) : 0.0f))));
            BodyShortPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyShortTrailingIdx] - inOpen[BodyShortTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyShortTrailingIdx] - inLow[BodyShortTrailingIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyShortTrailingIdx] - (inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inClose[BodyShortTrailingIdx] : inOpen[BodyShortTrailingIdx]) + ((inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inOpen[BodyShortTrailingIdx] : inClose[BodyShortTrailingIdx]) - inLow[BodyShortTrailingIdx]) : 0.0f))));
            ++BodyLongTrailingIdx;
            ++BodyShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdl3LineStrikeLookback() {
        return this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod + 3;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdl3LineStrike(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        NearPeriodTotal = new double[4];
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdl3LineStrikeLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        NearPeriodTotal[3] = 0.0;
        NearPeriodTotal[2] = 0.0;
        i = NearTrailingIdx = startIdx - this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod;
        while (i < startIdx) {
            NearPeriodTotal[3] = NearPeriodTotal[3] + (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 3] - inOpen[i - 3]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 3] - inLow[i - 3] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 3] - (inClose[i - 3] >= inOpen[i - 3] ? inClose[i - 3] : inOpen[i - 3]) + ((inClose[i - 3] >= inOpen[i - 3] ? inOpen[i - 3] : inClose[i - 3]) - inLow[i - 3]) : 0.0)));
            NearPeriodTotal[2] = NearPeriodTotal[2] + (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 3] >= inOpen[i - 3] ? 1 : -1) != (inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) || (inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) != (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) || (inClose[i] >= inOpen[i] ? 1 : -1) != -(inClose[i - 1] >= inOpen[i - 1] ? 1 : -1)) ** GOTO lbl-1000
            v0 = inOpen[i - 2];
            v1 = inOpen[i - 3] < inClose[i - 3] ? inOpen[i - 3] : inClose[i - 3];
            v2 = this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal[3] / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 3] - inOpen[i - 3]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 3] - inLow[i - 3] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 3] - (inClose[i - 3] >= inOpen[i - 3] ? inClose[i - 3] : inOpen[i - 3]) + ((inClose[i - 3] >= inOpen[i - 3] ? inOpen[i - 3] : inClose[i - 3]) - inLow[i - 3]) : 0.0))));
            v3 = this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 >= v1 - v2 / v3)) ** GOTO lbl-1000
            v4 = inOpen[i - 2];
            v5 = inOpen[i - 3] > inClose[i - 3] ? inOpen[i - 3] : inClose[i - 3];
            v6 = this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal[3] / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 3] - inOpen[i - 3]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 3] - inLow[i - 3] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 3] - (inClose[i - 3] >= inOpen[i - 3] ? inClose[i - 3] : inOpen[i - 3]) + ((inClose[i - 3] >= inOpen[i - 3] ? inOpen[i - 3] : inClose[i - 3]) - inLow[i - 3]) : 0.0))));
            v7 = this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v4 <= v5 + v6 / v7)) ** GOTO lbl-1000
            v8 = inOpen[i - 1];
            v9 = inOpen[i - 2] < inClose[i - 2] ? inOpen[i - 2] : inClose[i - 2];
            v10 = this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal[2] / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))));
            v11 = this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v8 >= v9 - v10 / v11)) ** GOTO lbl-1000
            v12 = inOpen[i - 1];
            v13 = inOpen[i - 2] > inClose[i - 2] ? inOpen[i - 2] : inClose[i - 2];
            v14 = this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal[2] / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))));
            v15 = this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v12 <= v13 + v14 / v15 && ((inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) == 1 && inClose[i - 1] > inClose[i - 2] && inClose[i - 2] > inClose[i - 3] && inOpen[i] > inClose[i - 1] && inClose[i] < inOpen[i - 3] || (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) == -1 && inClose[i - 1] < inClose[i - 2] && inClose[i - 2] < inClose[i - 3] && inOpen[i] < inClose[i - 1] && inClose[i] > inOpen[i - 3])) {
                outInteger[outIdx++] = (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) * 100;
            } else lbl-1000:
            // 5 sources

            {
                outInteger[outIdx++] = 0;
            }
            totIdx = 3;
            while (totIdx >= 2) {
                v16 = totIdx;
                NearPeriodTotal[v16] = NearPeriodTotal[v16] + ((this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0))) - (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[NearTrailingIdx - totIdx] - inOpen[NearTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[NearTrailingIdx - totIdx] - inLow[NearTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[NearTrailingIdx - totIdx] - (inClose[NearTrailingIdx - totIdx] >= inOpen[NearTrailingIdx - totIdx] ? inClose[NearTrailingIdx - totIdx] : inOpen[NearTrailingIdx - totIdx]) + ((inClose[NearTrailingIdx - totIdx] >= inOpen[NearTrailingIdx - totIdx] ? inOpen[NearTrailingIdx - totIdx] : inClose[NearTrailingIdx - totIdx]) - inLow[NearTrailingIdx - totIdx]) : 0.0))));
                --totIdx;
            }
            ++NearTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdl3LineStrike(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        NearPeriodTotal = new double[4];
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdl3LineStrikeLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        NearPeriodTotal[3] = 0.0;
        NearPeriodTotal[2] = 0.0;
        i = NearTrailingIdx = startIdx - this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod;
        while (i < startIdx) {
            NearPeriodTotal[3] = NearPeriodTotal[3] + (double)(this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 3] - inOpen[i - 3]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 3] - inLow[i - 3] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 3] - (inClose[i - 3] >= inOpen[i - 3] ? inClose[i - 3] : inOpen[i - 3]) + ((inClose[i - 3] >= inOpen[i - 3] ? inOpen[i - 3] : inClose[i - 3]) - inLow[i - 3]) : 0.0f)));
            NearPeriodTotal[2] = NearPeriodTotal[2] + (double)(this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 3] >= inOpen[i - 3] ? 1 : -1) != (inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) || (inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) != (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) || (inClose[i] >= inOpen[i] ? 1 : -1) != -(inClose[i - 1] >= inOpen[i - 1] ? 1 : -1)) ** GOTO lbl-1000
            v0 = inOpen[i - 2];
            v1 = inOpen[i - 3] < inClose[i - 3] ? inOpen[i - 3] : inClose[i - 3];
            v2 = this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal[3] / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 3] - inOpen[i - 3]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 3] - inLow[i - 3] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 3] - (inClose[i - 3] >= inOpen[i - 3] ? inClose[i - 3] : inOpen[i - 3]) + ((inClose[i - 3] >= inOpen[i - 3] ? inOpen[i - 3] : inClose[i - 3]) - inLow[i - 3]) : 0.0f))));
            v3 = this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 >= v1 - v2 / v3)) ** GOTO lbl-1000
            v4 = inOpen[i - 2];
            v5 = inOpen[i - 3] > inClose[i - 3] ? inOpen[i - 3] : inClose[i - 3];
            v6 = this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal[3] / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 3] - inOpen[i - 3]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 3] - inLow[i - 3] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 3] - (inClose[i - 3] >= inOpen[i - 3] ? inClose[i - 3] : inOpen[i - 3]) + ((inClose[i - 3] >= inOpen[i - 3] ? inOpen[i - 3] : inClose[i - 3]) - inLow[i - 3]) : 0.0f))));
            v7 = this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v4 <= v5 + v6 / v7)) ** GOTO lbl-1000
            v8 = inOpen[i - 1];
            v9 = inOpen[i - 2] < inClose[i - 2] ? inOpen[i - 2] : inClose[i - 2];
            v10 = this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal[2] / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))));
            v11 = this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v8 >= v9 - v10 / v11)) ** GOTO lbl-1000
            v12 = inOpen[i - 1];
            v13 = inOpen[i - 2] > inClose[i - 2] ? inOpen[i - 2] : inClose[i - 2];
            v14 = this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal[2] / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))));
            v15 = this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v12 <= v13 + v14 / v15 && ((inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) == 1 && inClose[i - 1] > inClose[i - 2] && inClose[i - 2] > inClose[i - 3] && inOpen[i] > inClose[i - 1] && inClose[i] < inOpen[i - 3] || (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) == -1 && inClose[i - 1] < inClose[i - 2] && inClose[i - 2] < inClose[i - 3] && inOpen[i] < inClose[i - 1] && inClose[i] > inOpen[i - 3])) {
                outInteger[outIdx++] = (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) * 100;
            } else lbl-1000:
            // 5 sources

            {
                outInteger[outIdx++] = 0;
            }
            totIdx = 3;
            while (totIdx >= 2) {
                v16 = totIdx;
                NearPeriodTotal[v16] = NearPeriodTotal[v16] + (double)((this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0f))) - (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[NearTrailingIdx - totIdx] - inOpen[NearTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[NearTrailingIdx - totIdx] - inLow[NearTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[NearTrailingIdx - totIdx] - (inClose[NearTrailingIdx - totIdx] >= inOpen[NearTrailingIdx - totIdx] ? inClose[NearTrailingIdx - totIdx] : inOpen[NearTrailingIdx - totIdx]) + ((inClose[NearTrailingIdx - totIdx] >= inOpen[NearTrailingIdx - totIdx] ? inOpen[NearTrailingIdx - totIdx] : inClose[NearTrailingIdx - totIdx]) - inLow[NearTrailingIdx - totIdx]) : 0.0f))));
                --totIdx;
            }
            ++NearTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdl3OutsideLookback() {
        return 3;
    }

    public RetCode cdl3Outside(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        int lookbackTotal = this.cdl3OutsideLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        int i = startIdx;
        int outIdx = 0;
        do {
            outInteger[outIdx++] = (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) == 1 && (inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) == -1 && inClose[i - 1] > inOpen[i - 2] && inOpen[i - 1] < inClose[i - 2] && inClose[i] > inClose[i - 1] || (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) == -1 && (inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) == 1 && inOpen[i - 1] > inClose[i - 2] && inClose[i - 1] < inOpen[i - 2] && inClose[i] < inClose[i - 1] ? (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) * 100 : 0;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public RetCode cdl3Outside(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        int lookbackTotal = this.cdl3OutsideLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        int i = startIdx;
        int outIdx = 0;
        do {
            outInteger[outIdx++] = (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) == 1 && (inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) == -1 && inClose[i - 1] > inOpen[i - 2] && inOpen[i - 1] < inClose[i - 2] && inClose[i] > inClose[i - 1] || (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) == -1 && (inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) == 1 && inOpen[i - 1] > inClose[i - 2] && inClose[i - 1] < inOpen[i - 2] && inClose[i] < inClose[i - 1] ? (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) * 100 : 0;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdl3StarsInSouthLookback() {
        return ((this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod) > (this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod) ? (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod)) + 2;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdl3StarsInSouth(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        ShadowVeryShortPeriodTotal = new double[2];
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdl3StarsInSouthLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        BodyLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        ShadowLongPeriodTotal = 0.0;
        ShadowLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod;
        ShadowVeryShortPeriodTotal[1] = 0.0;
        ShadowVeryShortPeriodTotal[0] = 0.0;
        ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        BodyShortPeriodTotal = 0.0;
        BodyShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod;
        i = BodyLongTrailingIdx;
        while (i < startIdx) {
            BodyLongPeriodTotal += this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0));
            ++i;
        }
        i = ShadowLongTrailingIdx;
        while (i < startIdx) {
            ShadowLongPeriodTotal += this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0));
            ++i;
        }
        i = ShadowVeryShortTrailingIdx;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal[1] = ShadowVeryShortPeriodTotal[1] + (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0)));
            ShadowVeryShortPeriodTotal[0] = ShadowVeryShortPeriodTotal[0] + (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0)));
            ++i;
        }
        i = BodyShortTrailingIdx;
        while (i < startIdx) {
            BodyShortPeriodTotal += this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) != -1 || (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != -1 || (inClose[i] >= inOpen[i] ? 1 : -1) != -1) ** GOTO lbl-1000
            v0 = Math.abs(inClose[i - 2] - inOpen[i - 2]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2)) ** GOTO lbl-1000
            v3 = (inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2];
            v4 = this.candleSettings[CandleSettingType.ShadowLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod != 0.0 ? ShadowLongPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))));
            v5 = this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 > v4 / v5) || !(Math.abs(inClose[i - 1] - inOpen[i - 1]) < Math.abs(inClose[i - 2] - inOpen[i - 2])) || !(inOpen[i - 1] > inClose[i - 2]) || !(inOpen[i - 1] <= inHigh[i - 2]) || !(inLow[i - 1] < inClose[i - 2]) || !(inLow[i - 1] >= inLow[i - 2])) ** GOTO lbl-1000
            v6 = (inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1];
            v7 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v8 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v6 > v7 / v8)) ** GOTO lbl-1000
            v9 = Math.abs(inClose[i] - inOpen[i]);
            v10 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyShortPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v11 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v9 < v10 / v11)) ** GOTO lbl-1000
            v12 = (inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i];
            v13 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[0] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v14 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v12 < v13 / v14)) ** GOTO lbl-1000
            v15 = inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]);
            v16 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[0] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v17 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v15 < v16 / v17 && inLow[i] > inLow[i - 1] && inHigh[i] < inHigh[i - 1]) {
                outInteger[outIdx++] = 100;
            } else lbl-1000:
            // 7 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyLongPeriodTotal += (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx - 2] - inOpen[BodyLongTrailingIdx - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx - 2] - inLow[BodyLongTrailingIdx - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx - 2] - (inClose[BodyLongTrailingIdx - 2] >= inOpen[BodyLongTrailingIdx - 2] ? inClose[BodyLongTrailingIdx - 2] : inOpen[BodyLongTrailingIdx - 2]) + ((inClose[BodyLongTrailingIdx - 2] >= inOpen[BodyLongTrailingIdx - 2] ? inOpen[BodyLongTrailingIdx - 2] : inClose[BodyLongTrailingIdx - 2]) - inLow[BodyLongTrailingIdx - 2]) : 0.0)));
            ShadowLongPeriodTotal += (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))) - (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowLongTrailingIdx - 2] - inOpen[ShadowLongTrailingIdx - 2]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowLongTrailingIdx - 2] - inLow[ShadowLongTrailingIdx - 2] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowLongTrailingIdx - 2] - (inClose[ShadowLongTrailingIdx - 2] >= inOpen[ShadowLongTrailingIdx - 2] ? inClose[ShadowLongTrailingIdx - 2] : inOpen[ShadowLongTrailingIdx - 2]) + ((inClose[ShadowLongTrailingIdx - 2] >= inOpen[ShadowLongTrailingIdx - 2] ? inOpen[ShadowLongTrailingIdx - 2] : inClose[ShadowLongTrailingIdx - 2]) - inLow[ShadowLongTrailingIdx - 2]) : 0.0)));
            totIdx = 1;
            while (totIdx >= 0) {
                v18 = totIdx;
                ShadowVeryShortPeriodTotal[v18] = ShadowVeryShortPeriodTotal[v18] + ((this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx - totIdx] - inOpen[ShadowVeryShortTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx - totIdx] - inLow[ShadowVeryShortTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx - totIdx] - (inClose[ShadowVeryShortTrailingIdx - totIdx] >= inOpen[ShadowVeryShortTrailingIdx - totIdx] ? inClose[ShadowVeryShortTrailingIdx - totIdx] : inOpen[ShadowVeryShortTrailingIdx - totIdx]) + ((inClose[ShadowVeryShortTrailingIdx - totIdx] >= inOpen[ShadowVeryShortTrailingIdx - totIdx] ? inOpen[ShadowVeryShortTrailingIdx - totIdx] : inClose[ShadowVeryShortTrailingIdx - totIdx]) - inLow[ShadowVeryShortTrailingIdx - totIdx]) : 0.0))));
                --totIdx;
            }
            BodyShortPeriodTotal += (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyShortTrailingIdx] - inOpen[BodyShortTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyShortTrailingIdx] - inLow[BodyShortTrailingIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyShortTrailingIdx] - (inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inClose[BodyShortTrailingIdx] : inOpen[BodyShortTrailingIdx]) + ((inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inOpen[BodyShortTrailingIdx] : inClose[BodyShortTrailingIdx]) - inLow[BodyShortTrailingIdx]) : 0.0)));
            ++BodyLongTrailingIdx;
            ++ShadowLongTrailingIdx;
            ++ShadowVeryShortTrailingIdx;
            ++BodyShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdl3StarsInSouth(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        ShadowVeryShortPeriodTotal = new double[2];
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdl3StarsInSouthLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        BodyLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        ShadowLongPeriodTotal = 0.0;
        ShadowLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod;
        ShadowVeryShortPeriodTotal[1] = 0.0;
        ShadowVeryShortPeriodTotal[0] = 0.0;
        ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        BodyShortPeriodTotal = 0.0;
        BodyShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod;
        i = BodyLongTrailingIdx;
        while (i < startIdx) {
            BodyLongPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f)));
            ++i;
        }
        i = ShadowLongTrailingIdx;
        while (i < startIdx) {
            ShadowLongPeriodTotal += (double)(this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f)));
            ++i;
        }
        i = ShadowVeryShortTrailingIdx;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal[1] = ShadowVeryShortPeriodTotal[1] + (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)));
            ShadowVeryShortPeriodTotal[0] = ShadowVeryShortPeriodTotal[0] + (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = BodyShortTrailingIdx;
        while (i < startIdx) {
            BodyShortPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) != -1 || (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != -1 || (inClose[i] >= inOpen[i] ? 1 : -1) != -1) ** GOTO lbl-1000
            v0 = Math.abs(inClose[i - 2] - inOpen[i - 2]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2)) ** GOTO lbl-1000
            v3 = (inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2];
            v4 = this.candleSettings[CandleSettingType.ShadowLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod != 0.0 ? ShadowLongPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))));
            v5 = this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 > v4 / v5) || !(Math.abs(inClose[i - 1] - inOpen[i - 1]) < Math.abs(inClose[i - 2] - inOpen[i - 2])) || !(inOpen[i - 1] > inClose[i - 2]) || !(inOpen[i - 1] <= inHigh[i - 2]) || !(inLow[i - 1] < inClose[i - 2]) || !(inLow[i - 1] >= inLow[i - 2])) ** GOTO lbl-1000
            v6 = (inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1];
            v7 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v8 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v6 > v7 / v8)) ** GOTO lbl-1000
            v9 = Math.abs(inClose[i] - inOpen[i]);
            v10 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyShortPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v11 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v9 < v10 / v11)) ** GOTO lbl-1000
            v12 = (inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i];
            v13 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[0] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v14 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v12 < v13 / v14)) ** GOTO lbl-1000
            v15 = inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]);
            v16 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[0] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v17 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v15 < v16 / v17 && inLow[i] > inLow[i - 1] && inHigh[i] < inHigh[i - 1]) {
                outInteger[outIdx++] = 100;
            } else lbl-1000:
            // 7 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyLongPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx - 2] - inOpen[BodyLongTrailingIdx - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx - 2] - inLow[BodyLongTrailingIdx - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx - 2] - (inClose[BodyLongTrailingIdx - 2] >= inOpen[BodyLongTrailingIdx - 2] ? inClose[BodyLongTrailingIdx - 2] : inOpen[BodyLongTrailingIdx - 2]) + ((inClose[BodyLongTrailingIdx - 2] >= inOpen[BodyLongTrailingIdx - 2] ? inOpen[BodyLongTrailingIdx - 2] : inClose[BodyLongTrailingIdx - 2]) - inLow[BodyLongTrailingIdx - 2]) : 0.0f))));
            ShadowLongPeriodTotal += (double)((this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))) - (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowLongTrailingIdx - 2] - inOpen[ShadowLongTrailingIdx - 2]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowLongTrailingIdx - 2] - inLow[ShadowLongTrailingIdx - 2] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowLongTrailingIdx - 2] - (inClose[ShadowLongTrailingIdx - 2] >= inOpen[ShadowLongTrailingIdx - 2] ? inClose[ShadowLongTrailingIdx - 2] : inOpen[ShadowLongTrailingIdx - 2]) + ((inClose[ShadowLongTrailingIdx - 2] >= inOpen[ShadowLongTrailingIdx - 2] ? inOpen[ShadowLongTrailingIdx - 2] : inClose[ShadowLongTrailingIdx - 2]) - inLow[ShadowLongTrailingIdx - 2]) : 0.0f))));
            totIdx = 1;
            while (totIdx >= 0) {
                v18 = totIdx;
                ShadowVeryShortPeriodTotal[v18] = ShadowVeryShortPeriodTotal[v18] + (double)((this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0f))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx - totIdx] - inOpen[ShadowVeryShortTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx - totIdx] - inLow[ShadowVeryShortTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx - totIdx] - (inClose[ShadowVeryShortTrailingIdx - totIdx] >= inOpen[ShadowVeryShortTrailingIdx - totIdx] ? inClose[ShadowVeryShortTrailingIdx - totIdx] : inOpen[ShadowVeryShortTrailingIdx - totIdx]) + ((inClose[ShadowVeryShortTrailingIdx - totIdx] >= inOpen[ShadowVeryShortTrailingIdx - totIdx] ? inOpen[ShadowVeryShortTrailingIdx - totIdx] : inClose[ShadowVeryShortTrailingIdx - totIdx]) - inLow[ShadowVeryShortTrailingIdx - totIdx]) : 0.0f))));
                --totIdx;
            }
            BodyShortPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyShortTrailingIdx] - inOpen[BodyShortTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyShortTrailingIdx] - inLow[BodyShortTrailingIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyShortTrailingIdx] - (inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inClose[BodyShortTrailingIdx] : inOpen[BodyShortTrailingIdx]) + ((inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inOpen[BodyShortTrailingIdx] : inClose[BodyShortTrailingIdx]) - inLow[BodyShortTrailingIdx]) : 0.0f))));
            ++BodyLongTrailingIdx;
            ++ShadowLongTrailingIdx;
            ++ShadowVeryShortTrailingIdx;
            ++BodyShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdl3WhiteSoldiersLookback() {
        return ((this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod) > (this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod) ? (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod) : (this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod)) + 2;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdl3WhiteSoldiers(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        ShadowVeryShortPeriodTotal = new double[3];
        NearPeriodTotal = new double[3];
        FarPeriodTotal = new double[3];
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdl3WhiteSoldiersLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        ShadowVeryShortPeriodTotal[2] = 0.0;
        ShadowVeryShortPeriodTotal[1] = 0.0;
        ShadowVeryShortPeriodTotal[0] = 0.0;
        ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        NearPeriodTotal[2] = 0.0;
        NearPeriodTotal[1] = 0.0;
        NearPeriodTotal[0] = 0.0;
        NearTrailingIdx = startIdx - this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod;
        FarPeriodTotal[2] = 0.0;
        FarPeriodTotal[1] = 0.0;
        FarPeriodTotal[0] = 0.0;
        FarTrailingIdx = startIdx - this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod;
        BodyShortPeriodTotal = 0.0;
        BodyShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod;
        i = ShadowVeryShortTrailingIdx;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal[2] = ShadowVeryShortPeriodTotal[2] + (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0)));
            ShadowVeryShortPeriodTotal[1] = ShadowVeryShortPeriodTotal[1] + (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0)));
            ShadowVeryShortPeriodTotal[0] = ShadowVeryShortPeriodTotal[0] + (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0)));
            ++i;
        }
        i = NearTrailingIdx;
        while (i < startIdx) {
            NearPeriodTotal[2] = NearPeriodTotal[2] + (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0)));
            NearPeriodTotal[1] = NearPeriodTotal[1] + (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0)));
            ++i;
        }
        i = FarTrailingIdx;
        while (i < startIdx) {
            FarPeriodTotal[2] = FarPeriodTotal[2] + (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0)));
            FarPeriodTotal[1] = FarPeriodTotal[1] + (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0)));
            ++i;
        }
        i = BodyShortTrailingIdx;
        while (i < startIdx) {
            BodyShortPeriodTotal += this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) != 1) ** GOTO lbl-1000
            v0 = inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]);
            v1 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[2] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 < v1 / v2) || (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != 1) ** GOTO lbl-1000
            v3 = inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]);
            v4 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v5 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 < v4 / v5) || (inClose[i] >= inOpen[i] ? 1 : -1) != 1) ** GOTO lbl-1000
            v6 = inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]);
            v7 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[0] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v8 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v6 < v7 / v8) || !(inClose[i] > inClose[i - 1]) || !(inClose[i - 1] > inClose[i - 2]) || !(inOpen[i - 1] > inOpen[i - 2])) ** GOTO lbl-1000
            v9 = inOpen[i - 1];
            v10 = inClose[i - 2];
            v11 = this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal[2] / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))));
            v12 = this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v9 <= v10 + v11 / v12) || !(inOpen[i] > inOpen[i - 1])) ** GOTO lbl-1000
            v13 = inOpen[i];
            v14 = inClose[i - 1];
            v15 = this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v16 = this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v13 <= v14 + v15 / v16)) ** GOTO lbl-1000
            v17 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v18 = Math.abs(inClose[i - 2] - inOpen[i - 2]);
            v19 = this.candleSettings[CandleSettingType.Far.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod != 0.0 ? FarPeriodTotal[2] / (double)this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))));
            v20 = this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v17 > v18 - v19 / v20)) ** GOTO lbl-1000
            v21 = Math.abs(inClose[i] - inOpen[i]);
            v22 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v23 = this.candleSettings[CandleSettingType.Far.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod != 0.0 ? FarPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v24 = this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v21 > v22 - v23 / v24)) ** GOTO lbl-1000
            v25 = Math.abs(inClose[i] - inOpen[i]);
            v26 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyShortPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v27 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v25 > v26 / v27) {
                outInteger[outIdx++] = 100;
            } else lbl-1000:
            // 9 sources

            {
                outInteger[outIdx++] = 0;
            }
            totIdx = 2;
            while (totIdx >= 0) {
                v28 = totIdx;
                ShadowVeryShortPeriodTotal[v28] = ShadowVeryShortPeriodTotal[v28] + ((this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx - totIdx] - inOpen[ShadowVeryShortTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx - totIdx] - inLow[ShadowVeryShortTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx - totIdx] - (inClose[ShadowVeryShortTrailingIdx - totIdx] >= inOpen[ShadowVeryShortTrailingIdx - totIdx] ? inClose[ShadowVeryShortTrailingIdx - totIdx] : inOpen[ShadowVeryShortTrailingIdx - totIdx]) + ((inClose[ShadowVeryShortTrailingIdx - totIdx] >= inOpen[ShadowVeryShortTrailingIdx - totIdx] ? inOpen[ShadowVeryShortTrailingIdx - totIdx] : inClose[ShadowVeryShortTrailingIdx - totIdx]) - inLow[ShadowVeryShortTrailingIdx - totIdx]) : 0.0))));
                --totIdx;
            }
            totIdx = 2;
            while (totIdx >= 1) {
                v29 = totIdx;
                FarPeriodTotal[v29] = FarPeriodTotal[v29] + ((this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0))) - (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[FarTrailingIdx - totIdx] - inOpen[FarTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.HighLow ? inHigh[FarTrailingIdx - totIdx] - inLow[FarTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? inHigh[FarTrailingIdx - totIdx] - (inClose[FarTrailingIdx - totIdx] >= inOpen[FarTrailingIdx - totIdx] ? inClose[FarTrailingIdx - totIdx] : inOpen[FarTrailingIdx - totIdx]) + ((inClose[FarTrailingIdx - totIdx] >= inOpen[FarTrailingIdx - totIdx] ? inOpen[FarTrailingIdx - totIdx] : inClose[FarTrailingIdx - totIdx]) - inLow[FarTrailingIdx - totIdx]) : 0.0))));
                v30 = totIdx;
                NearPeriodTotal[v30] = NearPeriodTotal[v30] + ((this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0))) - (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[NearTrailingIdx - totIdx] - inOpen[NearTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[NearTrailingIdx - totIdx] - inLow[NearTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[NearTrailingIdx - totIdx] - (inClose[NearTrailingIdx - totIdx] >= inOpen[NearTrailingIdx - totIdx] ? inClose[NearTrailingIdx - totIdx] : inOpen[NearTrailingIdx - totIdx]) + ((inClose[NearTrailingIdx - totIdx] >= inOpen[NearTrailingIdx - totIdx] ? inOpen[NearTrailingIdx - totIdx] : inClose[NearTrailingIdx - totIdx]) - inLow[NearTrailingIdx - totIdx]) : 0.0))));
                --totIdx;
            }
            BodyShortPeriodTotal += (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyShortTrailingIdx] - inOpen[BodyShortTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyShortTrailingIdx] - inLow[BodyShortTrailingIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyShortTrailingIdx] - (inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inClose[BodyShortTrailingIdx] : inOpen[BodyShortTrailingIdx]) + ((inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inOpen[BodyShortTrailingIdx] : inClose[BodyShortTrailingIdx]) - inLow[BodyShortTrailingIdx]) : 0.0)));
            ++ShadowVeryShortTrailingIdx;
            ++NearTrailingIdx;
            ++FarTrailingIdx;
            ++BodyShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdl3WhiteSoldiers(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        ShadowVeryShortPeriodTotal = new double[3];
        NearPeriodTotal = new double[3];
        FarPeriodTotal = new double[3];
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdl3WhiteSoldiersLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        ShadowVeryShortPeriodTotal[2] = 0.0;
        ShadowVeryShortPeriodTotal[1] = 0.0;
        ShadowVeryShortPeriodTotal[0] = 0.0;
        ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        NearPeriodTotal[2] = 0.0;
        NearPeriodTotal[1] = 0.0;
        NearPeriodTotal[0] = 0.0;
        NearTrailingIdx = startIdx - this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod;
        FarPeriodTotal[2] = 0.0;
        FarPeriodTotal[1] = 0.0;
        FarPeriodTotal[0] = 0.0;
        FarTrailingIdx = startIdx - this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod;
        BodyShortPeriodTotal = 0.0;
        BodyShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod;
        i = ShadowVeryShortTrailingIdx;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal[2] = ShadowVeryShortPeriodTotal[2] + (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f)));
            ShadowVeryShortPeriodTotal[1] = ShadowVeryShortPeriodTotal[1] + (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)));
            ShadowVeryShortPeriodTotal[0] = ShadowVeryShortPeriodTotal[0] + (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = NearTrailingIdx;
        while (i < startIdx) {
            NearPeriodTotal[2] = NearPeriodTotal[2] + (double)(this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f)));
            NearPeriodTotal[1] = NearPeriodTotal[1] + (double)(this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)));
            ++i;
        }
        i = FarTrailingIdx;
        while (i < startIdx) {
            FarPeriodTotal[2] = FarPeriodTotal[2] + (double)(this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f)));
            FarPeriodTotal[1] = FarPeriodTotal[1] + (double)(this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)));
            ++i;
        }
        i = BodyShortTrailingIdx;
        while (i < startIdx) {
            BodyShortPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) != 1) ** GOTO lbl-1000
            v0 = inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]);
            v1 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[2] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 < v1 / v2) || (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != 1) ** GOTO lbl-1000
            v3 = inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]);
            v4 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v5 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 < v4 / v5) || (inClose[i] >= inOpen[i] ? 1 : -1) != 1) ** GOTO lbl-1000
            v6 = inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]);
            v7 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[0] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v8 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v6 < v7 / v8) || !(inClose[i] > inClose[i - 1]) || !(inClose[i - 1] > inClose[i - 2]) || !(inOpen[i - 1] > inOpen[i - 2])) ** GOTO lbl-1000
            v9 = inOpen[i - 1];
            v10 = inClose[i - 2];
            v11 = this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal[2] / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))));
            v12 = this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v9 <= v10 + v11 / v12) || !(inOpen[i] > inOpen[i - 1])) ** GOTO lbl-1000
            v13 = inOpen[i];
            v14 = inClose[i - 1];
            v15 = this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v16 = this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v13 <= v14 + v15 / v16)) ** GOTO lbl-1000
            v17 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v18 = Math.abs(inClose[i - 2] - inOpen[i - 2]);
            v19 = this.candleSettings[CandleSettingType.Far.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod != 0.0 ? FarPeriodTotal[2] / (double)this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))));
            v20 = this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v17 > v18 - v19 / v20)) ** GOTO lbl-1000
            v21 = Math.abs(inClose[i] - inOpen[i]);
            v22 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v23 = this.candleSettings[CandleSettingType.Far.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod != 0.0 ? FarPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v24 = this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v21 > v22 - v23 / v24)) ** GOTO lbl-1000
            v25 = Math.abs(inClose[i] - inOpen[i]);
            v26 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyShortPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v27 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v25 > v26 / v27) {
                outInteger[outIdx++] = 100;
            } else lbl-1000:
            // 9 sources

            {
                outInteger[outIdx++] = 0;
            }
            totIdx = 2;
            while (totIdx >= 0) {
                v28 = totIdx;
                ShadowVeryShortPeriodTotal[v28] = ShadowVeryShortPeriodTotal[v28] + (double)((this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0f))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx - totIdx] - inOpen[ShadowVeryShortTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx - totIdx] - inLow[ShadowVeryShortTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx - totIdx] - (inClose[ShadowVeryShortTrailingIdx - totIdx] >= inOpen[ShadowVeryShortTrailingIdx - totIdx] ? inClose[ShadowVeryShortTrailingIdx - totIdx] : inOpen[ShadowVeryShortTrailingIdx - totIdx]) + ((inClose[ShadowVeryShortTrailingIdx - totIdx] >= inOpen[ShadowVeryShortTrailingIdx - totIdx] ? inOpen[ShadowVeryShortTrailingIdx - totIdx] : inClose[ShadowVeryShortTrailingIdx - totIdx]) - inLow[ShadowVeryShortTrailingIdx - totIdx]) : 0.0f))));
                --totIdx;
            }
            totIdx = 2;
            while (totIdx >= 1) {
                v29 = totIdx;
                FarPeriodTotal[v29] = FarPeriodTotal[v29] + (double)((this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0f))) - (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[FarTrailingIdx - totIdx] - inOpen[FarTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.HighLow ? inHigh[FarTrailingIdx - totIdx] - inLow[FarTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? inHigh[FarTrailingIdx - totIdx] - (inClose[FarTrailingIdx - totIdx] >= inOpen[FarTrailingIdx - totIdx] ? inClose[FarTrailingIdx - totIdx] : inOpen[FarTrailingIdx - totIdx]) + ((inClose[FarTrailingIdx - totIdx] >= inOpen[FarTrailingIdx - totIdx] ? inOpen[FarTrailingIdx - totIdx] : inClose[FarTrailingIdx - totIdx]) - inLow[FarTrailingIdx - totIdx]) : 0.0f))));
                v30 = totIdx;
                NearPeriodTotal[v30] = NearPeriodTotal[v30] + (double)((this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0f))) - (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[NearTrailingIdx - totIdx] - inOpen[NearTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[NearTrailingIdx - totIdx] - inLow[NearTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[NearTrailingIdx - totIdx] - (inClose[NearTrailingIdx - totIdx] >= inOpen[NearTrailingIdx - totIdx] ? inClose[NearTrailingIdx - totIdx] : inOpen[NearTrailingIdx - totIdx]) + ((inClose[NearTrailingIdx - totIdx] >= inOpen[NearTrailingIdx - totIdx] ? inOpen[NearTrailingIdx - totIdx] : inClose[NearTrailingIdx - totIdx]) - inLow[NearTrailingIdx - totIdx]) : 0.0f))));
                --totIdx;
            }
            BodyShortPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyShortTrailingIdx] - inOpen[BodyShortTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyShortTrailingIdx] - inLow[BodyShortTrailingIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyShortTrailingIdx] - (inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inClose[BodyShortTrailingIdx] : inOpen[BodyShortTrailingIdx]) + ((inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inOpen[BodyShortTrailingIdx] : inClose[BodyShortTrailingIdx]) - inLow[BodyShortTrailingIdx]) : 0.0f))));
            ++ShadowVeryShortTrailingIdx;
            ++NearTrailingIdx;
            ++FarTrailingIdx;
            ++BodyShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlAbandonedBabyLookback(double optInPenetration) {
        if (optInPenetration == -4.0E37) {
            optInPenetration = 0.3;
        } else if (optInPenetration < 0.0 || optInPenetration > 3.0E37) {
            return -1;
        }
        return ((this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod) > this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod ? (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod) : this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod) + 2;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlAbandonedBaby(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, double optInPenetration, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInPenetration == -4.0E37) {
            optInPenetration = 0.3;
        } else if (optInPenetration < 0.0 || optInPenetration > 3.0E37) {
            return RetCode.BadParam;
        }
        lookbackTotal = this.cdlAbandonedBabyLookback(optInPenetration);
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        BodyDojiPeriodTotal = 0.0;
        BodyShortPeriodTotal = 0.0;
        BodyLongTrailingIdx = startIdx - 2 - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        BodyDojiTrailingIdx = startIdx - 1 - this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod;
        BodyShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod;
        i = BodyLongTrailingIdx;
        while (i < startIdx - 2) {
            BodyLongPeriodTotal += this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = BodyDojiTrailingIdx;
        while (i < startIdx - 1) {
            BodyDojiPeriodTotal += this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = BodyShortTrailingIdx;
        while (i < startIdx) {
            BodyShortPeriodTotal += this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i - 2] - inOpen[i - 2]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2)) ** GOTO lbl-1000
            v3 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v4 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod != 0.0 ? BodyDojiPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v5 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 <= v4 / v5)) ** GOTO lbl-1000
            v6 = Math.abs(inClose[i] - inOpen[i]);
            v7 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyShortPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v8 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v6 > v7 / v8 && ((inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) == 1 && (inClose[i] >= inOpen[i] ? 1 : -1) == -1 && inClose[i] < inClose[i - 2] - Math.abs(inClose[i - 2] - inOpen[i - 2]) * optInPenetration && inLow[i - 1] > inHigh[i - 2] && inHigh[i] < inLow[i - 1] || (inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) == -1 && (inClose[i] >= inOpen[i] ? 1 : -1) == 1 && inClose[i] > inClose[i - 2] + Math.abs(inClose[i - 2] - inOpen[i - 2]) * optInPenetration && inHigh[i - 1] < inLow[i - 2] && inLow[i] > inHigh[i - 1])) {
                outInteger[outIdx++] = (inClose[i] >= inOpen[i] ? 1 : -1) * 100;
            } else lbl-1000:
            // 3 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyLongPeriodTotal += (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx] - inOpen[BodyLongTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx] - inLow[BodyLongTrailingIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx] - (inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inClose[BodyLongTrailingIdx] : inOpen[BodyLongTrailingIdx]) + ((inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inOpen[BodyLongTrailingIdx] : inClose[BodyLongTrailingIdx]) - inLow[BodyLongTrailingIdx]) : 0.0)));
            BodyDojiPeriodTotal += (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyDojiTrailingIdx] - inOpen[BodyDojiTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyDojiTrailingIdx] - inLow[BodyDojiTrailingIdx] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyDojiTrailingIdx] - (inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inClose[BodyDojiTrailingIdx] : inOpen[BodyDojiTrailingIdx]) + ((inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inOpen[BodyDojiTrailingIdx] : inClose[BodyDojiTrailingIdx]) - inLow[BodyDojiTrailingIdx]) : 0.0)));
            BodyShortPeriodTotal += (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyShortTrailingIdx] - inOpen[BodyShortTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyShortTrailingIdx] - inLow[BodyShortTrailingIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyShortTrailingIdx] - (inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inClose[BodyShortTrailingIdx] : inOpen[BodyShortTrailingIdx]) + ((inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inOpen[BodyShortTrailingIdx] : inClose[BodyShortTrailingIdx]) - inLow[BodyShortTrailingIdx]) : 0.0)));
            ++BodyLongTrailingIdx;
            ++BodyDojiTrailingIdx;
            ++BodyShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlAbandonedBaby(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, double optInPenetration, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInPenetration == -4.0E37) {
            optInPenetration = 0.3;
        } else if (optInPenetration < 0.0 || optInPenetration > 3.0E37) {
            return RetCode.BadParam;
        }
        lookbackTotal = this.cdlAbandonedBabyLookback(optInPenetration);
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        BodyDojiPeriodTotal = 0.0;
        BodyShortPeriodTotal = 0.0;
        BodyLongTrailingIdx = startIdx - 2 - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        BodyDojiTrailingIdx = startIdx - 1 - this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod;
        BodyShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod;
        i = BodyLongTrailingIdx;
        while (i < startIdx - 2) {
            BodyLongPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = BodyDojiTrailingIdx;
        while (i < startIdx - 1) {
            BodyDojiPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = BodyShortTrailingIdx;
        while (i < startIdx) {
            BodyShortPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i - 2] - inOpen[i - 2]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2)) ** GOTO lbl-1000
            v3 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v4 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod != 0.0 ? BodyDojiPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v5 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 <= v4 / v5)) ** GOTO lbl-1000
            v6 = Math.abs(inClose[i] - inOpen[i]);
            v7 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyShortPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v8 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v6 > v7 / v8 && ((inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) == 1 && (inClose[i] >= inOpen[i] ? 1 : -1) == -1 && (double)inClose[i] < (double)inClose[i - 2] - (double)Math.abs(inClose[i - 2] - inOpen[i - 2]) * optInPenetration && inLow[i - 1] > inHigh[i - 2] && inHigh[i] < inLow[i - 1] || (inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) == -1 && (inClose[i] >= inOpen[i] ? 1 : -1) == 1 && (double)inClose[i] > (double)inClose[i - 2] + (double)Math.abs(inClose[i - 2] - inOpen[i - 2]) * optInPenetration && inHigh[i - 1] < inLow[i - 2] && inLow[i] > inHigh[i - 1])) {
                outInteger[outIdx++] = (inClose[i] >= inOpen[i] ? 1 : -1) * 100;
            } else lbl-1000:
            // 3 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyLongPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx] - inOpen[BodyLongTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx] - inLow[BodyLongTrailingIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx] - (inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inClose[BodyLongTrailingIdx] : inOpen[BodyLongTrailingIdx]) + ((inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inOpen[BodyLongTrailingIdx] : inClose[BodyLongTrailingIdx]) - inLow[BodyLongTrailingIdx]) : 0.0f))));
            BodyDojiPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyDojiTrailingIdx] - inOpen[BodyDojiTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyDojiTrailingIdx] - inLow[BodyDojiTrailingIdx] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyDojiTrailingIdx] - (inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inClose[BodyDojiTrailingIdx] : inOpen[BodyDojiTrailingIdx]) + ((inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inOpen[BodyDojiTrailingIdx] : inClose[BodyDojiTrailingIdx]) - inLow[BodyDojiTrailingIdx]) : 0.0f))));
            BodyShortPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyShortTrailingIdx] - inOpen[BodyShortTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyShortTrailingIdx] - inLow[BodyShortTrailingIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyShortTrailingIdx] - (inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inClose[BodyShortTrailingIdx] : inOpen[BodyShortTrailingIdx]) + ((inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inOpen[BodyShortTrailingIdx] : inClose[BodyShortTrailingIdx]) - inLow[BodyShortTrailingIdx]) : 0.0f))));
            ++BodyLongTrailingIdx;
            ++BodyDojiTrailingIdx;
            ++BodyShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlAdvanceBlockLookback() {
        return (((this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod) > (this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod) ? (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod) : (this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod)) > this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod ? ((this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod) > (this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod) ? (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod) : (this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod)) : this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod) + 2;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlAdvanceBlock(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        ShadowShortPeriodTotal = new double[3];
        ShadowLongPeriodTotal = new double[2];
        NearPeriodTotal = new double[3];
        FarPeriodTotal = new double[3];
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlAdvanceBlockLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        ShadowShortPeriodTotal[2] = 0.0;
        ShadowShortPeriodTotal[1] = 0.0;
        ShadowShortPeriodTotal[0] = 0.0;
        ShadowShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod;
        ShadowLongPeriodTotal[1] = 0.0;
        ShadowLongPeriodTotal[0] = 0.0;
        ShadowLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod;
        NearPeriodTotal[2] = 0.0;
        NearPeriodTotal[1] = 0.0;
        NearPeriodTotal[0] = 0.0;
        NearTrailingIdx = startIdx - this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod;
        FarPeriodTotal[2] = 0.0;
        FarPeriodTotal[1] = 0.0;
        FarPeriodTotal[0] = 0.0;
        FarTrailingIdx = startIdx - this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod;
        BodyLongPeriodTotal = 0.0;
        BodyLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        i = ShadowShortTrailingIdx;
        while (i < startIdx) {
            ShadowShortPeriodTotal[2] = ShadowShortPeriodTotal[2] + (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0)));
            ShadowShortPeriodTotal[1] = ShadowShortPeriodTotal[1] + (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0)));
            ShadowShortPeriodTotal[0] = ShadowShortPeriodTotal[0] + (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0)));
            ++i;
        }
        i = ShadowLongTrailingIdx;
        while (i < startIdx) {
            ShadowLongPeriodTotal[1] = ShadowLongPeriodTotal[1] + (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0)));
            ShadowLongPeriodTotal[0] = ShadowLongPeriodTotal[0] + (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0)));
            ++i;
        }
        i = NearTrailingIdx;
        while (i < startIdx) {
            NearPeriodTotal[2] = NearPeriodTotal[2] + (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0)));
            NearPeriodTotal[1] = NearPeriodTotal[1] + (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0)));
            ++i;
        }
        i = FarTrailingIdx;
        while (i < startIdx) {
            FarPeriodTotal[2] = FarPeriodTotal[2] + (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0)));
            FarPeriodTotal[1] = FarPeriodTotal[1] + (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0)));
            ++i;
        }
        i = BodyLongTrailingIdx;
        while (i < startIdx) {
            BodyLongPeriodTotal += this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) != 1 || (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != 1 || (inClose[i] >= inOpen[i] ? 1 : -1) != 1 || !(inClose[i] > inClose[i - 1]) || !(inClose[i - 1] > inClose[i - 2]) || !(inOpen[i - 1] > inOpen[i - 2])) ** GOTO lbl-1000
            v0 = inOpen[i - 1];
            v1 = inClose[i - 2];
            v2 = this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal[2] / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))));
            v3 = this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 <= v1 + v2 / v3) || !(inOpen[i] > inOpen[i - 1])) ** GOTO lbl-1000
            v4 = inOpen[i];
            v5 = inClose[i - 1];
            v6 = this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v7 = this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v4 <= v5 + v6 / v7)) ** GOTO lbl-1000
            v8 = Math.abs(inClose[i - 2] - inOpen[i - 2]);
            v9 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))));
            v10 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v8 > v9 / v10)) ** GOTO lbl-1000
            v11 = inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]);
            v12 = this.candleSettings[CandleSettingType.ShadowShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod != 0.0 ? ShadowShortPeriodTotal[2] / (double)this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))));
            v13 = this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v11 < v12 / v13)) ** GOTO lbl-1000
            if (Math.abs(inClose[i - 1] - inOpen[i - 1]) < Math.abs(inClose[i - 2] - inOpen[i - 2]) - this.candleSettings[CandleSettingType.Far.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod != 0.0 ? FarPeriodTotal[2] / (double)this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0)))) / (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0) && Math.abs(inClose[i] - inOpen[i]) < Math.abs(inClose[i - 1] - inOpen[i - 1]) + this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0)))) / (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0) || Math.abs(inClose[i] - inOpen[i]) < Math.abs(inClose[i - 1] - inOpen[i - 1]) - this.candleSettings[CandleSettingType.Far.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod != 0.0 ? FarPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0)))) / (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0) || Math.abs(inClose[i] - inOpen[i]) < Math.abs(inClose[i - 1] - inOpen[i - 1]) && Math.abs(inClose[i - 1] - inOpen[i - 1]) < Math.abs(inClose[i - 2] - inOpen[i - 2]) && (inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) > this.candleSettings[CandleSettingType.ShadowShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod != 0.0 ? ShadowShortPeriodTotal[0] / (double)this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0)))) / (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0) || inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) > this.candleSettings[CandleSettingType.ShadowShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod != 0.0 ? ShadowShortPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0)))) / (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0))) ** GOTO lbl-1000
            if (Math.abs(inClose[i] - inOpen[i]) < Math.abs(inClose[i - 1] - inOpen[i - 1])) {
                v14 = inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]);
                v15 = this.candleSettings[CandleSettingType.ShadowLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod != 0.0 ? ShadowLongPeriodTotal[0] / (double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
                v16 = this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
                ** if (!(v14 > v15 / v16)) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                outInteger[outIdx++] = -100;
                ** GOTO lbl95
            }
lbl-1000:
            // 7 sources

            {
                outInteger[outIdx++] = 0;
            }
lbl95:
            // 2 sources

            totIdx = 2;
            while (totIdx >= 0) {
                v17 = totIdx;
                ShadowShortPeriodTotal[v17] = ShadowShortPeriodTotal[v17] + ((this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0))) - (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowShortTrailingIdx - totIdx] - inOpen[ShadowShortTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowShortTrailingIdx - totIdx] - inLow[ShadowShortTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowShortTrailingIdx - totIdx] - (inClose[ShadowShortTrailingIdx - totIdx] >= inOpen[ShadowShortTrailingIdx - totIdx] ? inClose[ShadowShortTrailingIdx - totIdx] : inOpen[ShadowShortTrailingIdx - totIdx]) + ((inClose[ShadowShortTrailingIdx - totIdx] >= inOpen[ShadowShortTrailingIdx - totIdx] ? inOpen[ShadowShortTrailingIdx - totIdx] : inClose[ShadowShortTrailingIdx - totIdx]) - inLow[ShadowShortTrailingIdx - totIdx]) : 0.0))));
                --totIdx;
            }
            totIdx = 1;
            while (totIdx >= 0) {
                v18 = totIdx;
                ShadowLongPeriodTotal[v18] = ShadowLongPeriodTotal[v18] + ((this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0))) - (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowLongTrailingIdx - totIdx] - inOpen[ShadowLongTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowLongTrailingIdx - totIdx] - inLow[ShadowLongTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowLongTrailingIdx - totIdx] - (inClose[ShadowLongTrailingIdx - totIdx] >= inOpen[ShadowLongTrailingIdx - totIdx] ? inClose[ShadowLongTrailingIdx - totIdx] : inOpen[ShadowLongTrailingIdx - totIdx]) + ((inClose[ShadowLongTrailingIdx - totIdx] >= inOpen[ShadowLongTrailingIdx - totIdx] ? inOpen[ShadowLongTrailingIdx - totIdx] : inClose[ShadowLongTrailingIdx - totIdx]) - inLow[ShadowLongTrailingIdx - totIdx]) : 0.0))));
                --totIdx;
            }
            totIdx = 2;
            while (totIdx >= 1) {
                v19 = totIdx;
                FarPeriodTotal[v19] = FarPeriodTotal[v19] + ((this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0))) - (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[FarTrailingIdx - totIdx] - inOpen[FarTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.HighLow ? inHigh[FarTrailingIdx - totIdx] - inLow[FarTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? inHigh[FarTrailingIdx - totIdx] - (inClose[FarTrailingIdx - totIdx] >= inOpen[FarTrailingIdx - totIdx] ? inClose[FarTrailingIdx - totIdx] : inOpen[FarTrailingIdx - totIdx]) + ((inClose[FarTrailingIdx - totIdx] >= inOpen[FarTrailingIdx - totIdx] ? inOpen[FarTrailingIdx - totIdx] : inClose[FarTrailingIdx - totIdx]) - inLow[FarTrailingIdx - totIdx]) : 0.0))));
                v20 = totIdx;
                NearPeriodTotal[v20] = NearPeriodTotal[v20] + ((this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0))) - (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[NearTrailingIdx - totIdx] - inOpen[NearTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[NearTrailingIdx - totIdx] - inLow[NearTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[NearTrailingIdx - totIdx] - (inClose[NearTrailingIdx - totIdx] >= inOpen[NearTrailingIdx - totIdx] ? inClose[NearTrailingIdx - totIdx] : inOpen[NearTrailingIdx - totIdx]) + ((inClose[NearTrailingIdx - totIdx] >= inOpen[NearTrailingIdx - totIdx] ? inOpen[NearTrailingIdx - totIdx] : inClose[NearTrailingIdx - totIdx]) - inLow[NearTrailingIdx - totIdx]) : 0.0))));
                --totIdx;
            }
            BodyLongPeriodTotal += (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx - 2] - inOpen[BodyLongTrailingIdx - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx - 2] - inLow[BodyLongTrailingIdx - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx - 2] - (inClose[BodyLongTrailingIdx - 2] >= inOpen[BodyLongTrailingIdx - 2] ? inClose[BodyLongTrailingIdx - 2] : inOpen[BodyLongTrailingIdx - 2]) + ((inClose[BodyLongTrailingIdx - 2] >= inOpen[BodyLongTrailingIdx - 2] ? inOpen[BodyLongTrailingIdx - 2] : inClose[BodyLongTrailingIdx - 2]) - inLow[BodyLongTrailingIdx - 2]) : 0.0)));
            ++i;
            ++ShadowShortTrailingIdx;
            ++ShadowLongTrailingIdx;
            ++NearTrailingIdx;
            ++FarTrailingIdx;
            ++BodyLongTrailingIdx;
        } while (i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlAdvanceBlock(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        ShadowShortPeriodTotal = new double[3];
        ShadowLongPeriodTotal = new double[2];
        NearPeriodTotal = new double[3];
        FarPeriodTotal = new double[3];
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlAdvanceBlockLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        ShadowShortPeriodTotal[2] = 0.0;
        ShadowShortPeriodTotal[1] = 0.0;
        ShadowShortPeriodTotal[0] = 0.0;
        ShadowShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod;
        ShadowLongPeriodTotal[1] = 0.0;
        ShadowLongPeriodTotal[0] = 0.0;
        ShadowLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod;
        NearPeriodTotal[2] = 0.0;
        NearPeriodTotal[1] = 0.0;
        NearPeriodTotal[0] = 0.0;
        NearTrailingIdx = startIdx - this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod;
        FarPeriodTotal[2] = 0.0;
        FarPeriodTotal[1] = 0.0;
        FarPeriodTotal[0] = 0.0;
        FarTrailingIdx = startIdx - this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod;
        BodyLongPeriodTotal = 0.0;
        BodyLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        i = ShadowShortTrailingIdx;
        while (i < startIdx) {
            ShadowShortPeriodTotal[2] = ShadowShortPeriodTotal[2] + (double)(this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f)));
            ShadowShortPeriodTotal[1] = ShadowShortPeriodTotal[1] + (double)(this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)));
            ShadowShortPeriodTotal[0] = ShadowShortPeriodTotal[0] + (double)(this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = ShadowLongTrailingIdx;
        while (i < startIdx) {
            ShadowLongPeriodTotal[1] = ShadowLongPeriodTotal[1] + (double)(this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)));
            ShadowLongPeriodTotal[0] = ShadowLongPeriodTotal[0] + (double)(this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = NearTrailingIdx;
        while (i < startIdx) {
            NearPeriodTotal[2] = NearPeriodTotal[2] + (double)(this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f)));
            NearPeriodTotal[1] = NearPeriodTotal[1] + (double)(this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)));
            ++i;
        }
        i = FarTrailingIdx;
        while (i < startIdx) {
            FarPeriodTotal[2] = FarPeriodTotal[2] + (double)(this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f)));
            FarPeriodTotal[1] = FarPeriodTotal[1] + (double)(this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)));
            ++i;
        }
        i = BodyLongTrailingIdx;
        while (i < startIdx) {
            BodyLongPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) != 1 || (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != 1 || (inClose[i] >= inOpen[i] ? 1 : -1) != 1 || !(inClose[i] > inClose[i - 1]) || !(inClose[i - 1] > inClose[i - 2]) || !(inOpen[i - 1] > inOpen[i - 2])) ** GOTO lbl-1000
            v0 = inOpen[i - 1];
            v1 = inClose[i - 2];
            v2 = this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal[2] / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))));
            v3 = this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 <= v1 + v2 / v3) || !(inOpen[i] > inOpen[i - 1])) ** GOTO lbl-1000
            v4 = inOpen[i];
            v5 = inClose[i - 1];
            v6 = this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v7 = this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v4 <= v5 + v6 / v7)) ** GOTO lbl-1000
            v8 = Math.abs(inClose[i - 2] - inOpen[i - 2]);
            v9 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))));
            v10 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v8 > v9 / v10)) ** GOTO lbl-1000
            v11 = inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]);
            v12 = this.candleSettings[CandleSettingType.ShadowShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod != 0.0 ? ShadowShortPeriodTotal[2] / (double)this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))));
            v13 = this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v11 < v12 / v13)) ** GOTO lbl-1000
            if ((double)Math.abs(inClose[i - 1] - inOpen[i - 1]) < (double)Math.abs(inClose[i - 2] - inOpen[i - 2]) - this.candleSettings[CandleSettingType.Far.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod != 0.0 ? FarPeriodTotal[2] / (double)this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f)))) / (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0) && (double)Math.abs(inClose[i] - inOpen[i]) < (double)Math.abs(inClose[i - 1] - inOpen[i - 1]) + this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)))) / (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0) || (double)Math.abs(inClose[i] - inOpen[i]) < (double)Math.abs(inClose[i - 1] - inOpen[i - 1]) - this.candleSettings[CandleSettingType.Far.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod != 0.0 ? FarPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.Far.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)))) / (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0) || Math.abs(inClose[i] - inOpen[i]) < Math.abs(inClose[i - 1] - inOpen[i - 1]) && Math.abs(inClose[i - 1] - inOpen[i - 1]) < Math.abs(inClose[i - 2] - inOpen[i - 2]) && ((double)(inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i])) > this.candleSettings[CandleSettingType.ShadowShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod != 0.0 ? ShadowShortPeriodTotal[0] / (double)this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)))) / (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0) || (double)(inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1])) > this.candleSettings[CandleSettingType.ShadowShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod != 0.0 ? ShadowShortPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)))) / (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0))) ** GOTO lbl-1000
            if (Math.abs(inClose[i] - inOpen[i]) < Math.abs(inClose[i - 1] - inOpen[i - 1])) {
                v14 = inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]);
                v15 = this.candleSettings[CandleSettingType.ShadowLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod != 0.0 ? ShadowLongPeriodTotal[0] / (double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
                v16 = this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
                ** if (!(v14 > v15 / v16)) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                outInteger[outIdx++] = -100;
                ** GOTO lbl95
            }
lbl-1000:
            // 7 sources

            {
                outInteger[outIdx++] = 0;
            }
lbl95:
            // 2 sources

            totIdx = 2;
            while (totIdx >= 0) {
                v17 = totIdx;
                ShadowShortPeriodTotal[v17] = ShadowShortPeriodTotal[v17] + (double)((this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0f))) - (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowShortTrailingIdx - totIdx] - inOpen[ShadowShortTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowShortTrailingIdx - totIdx] - inLow[ShadowShortTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowShortTrailingIdx - totIdx] - (inClose[ShadowShortTrailingIdx - totIdx] >= inOpen[ShadowShortTrailingIdx - totIdx] ? inClose[ShadowShortTrailingIdx - totIdx] : inOpen[ShadowShortTrailingIdx - totIdx]) + ((inClose[ShadowShortTrailingIdx - totIdx] >= inOpen[ShadowShortTrailingIdx - totIdx] ? inOpen[ShadowShortTrailingIdx - totIdx] : inClose[ShadowShortTrailingIdx - totIdx]) - inLow[ShadowShortTrailingIdx - totIdx]) : 0.0f))));
                --totIdx;
            }
            totIdx = 1;
            while (totIdx >= 0) {
                v18 = totIdx;
                ShadowLongPeriodTotal[v18] = ShadowLongPeriodTotal[v18] + (double)((this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0f))) - (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowLongTrailingIdx - totIdx] - inOpen[ShadowLongTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowLongTrailingIdx - totIdx] - inLow[ShadowLongTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowLongTrailingIdx - totIdx] - (inClose[ShadowLongTrailingIdx - totIdx] >= inOpen[ShadowLongTrailingIdx - totIdx] ? inClose[ShadowLongTrailingIdx - totIdx] : inOpen[ShadowLongTrailingIdx - totIdx]) + ((inClose[ShadowLongTrailingIdx - totIdx] >= inOpen[ShadowLongTrailingIdx - totIdx] ? inOpen[ShadowLongTrailingIdx - totIdx] : inClose[ShadowLongTrailingIdx - totIdx]) - inLow[ShadowLongTrailingIdx - totIdx]) : 0.0f))));
                --totIdx;
            }
            totIdx = 2;
            while (totIdx >= 1) {
                v19 = totIdx;
                FarPeriodTotal[v19] = FarPeriodTotal[v19] + (double)((this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0f))) - (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[FarTrailingIdx - totIdx] - inOpen[FarTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.HighLow ? inHigh[FarTrailingIdx - totIdx] - inLow[FarTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.Far.ordinal()].rangeType == RangeType.Shadows ? inHigh[FarTrailingIdx - totIdx] - (inClose[FarTrailingIdx - totIdx] >= inOpen[FarTrailingIdx - totIdx] ? inClose[FarTrailingIdx - totIdx] : inOpen[FarTrailingIdx - totIdx]) + ((inClose[FarTrailingIdx - totIdx] >= inOpen[FarTrailingIdx - totIdx] ? inOpen[FarTrailingIdx - totIdx] : inClose[FarTrailingIdx - totIdx]) - inLow[FarTrailingIdx - totIdx]) : 0.0f))));
                v20 = totIdx;
                NearPeriodTotal[v20] = NearPeriodTotal[v20] + (double)((this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0f))) - (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[NearTrailingIdx - totIdx] - inOpen[NearTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[NearTrailingIdx - totIdx] - inLow[NearTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[NearTrailingIdx - totIdx] - (inClose[NearTrailingIdx - totIdx] >= inOpen[NearTrailingIdx - totIdx] ? inClose[NearTrailingIdx - totIdx] : inOpen[NearTrailingIdx - totIdx]) + ((inClose[NearTrailingIdx - totIdx] >= inOpen[NearTrailingIdx - totIdx] ? inOpen[NearTrailingIdx - totIdx] : inClose[NearTrailingIdx - totIdx]) - inLow[NearTrailingIdx - totIdx]) : 0.0f))));
                --totIdx;
            }
            BodyLongPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx - 2] - inOpen[BodyLongTrailingIdx - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx - 2] - inLow[BodyLongTrailingIdx - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx - 2] - (inClose[BodyLongTrailingIdx - 2] >= inOpen[BodyLongTrailingIdx - 2] ? inClose[BodyLongTrailingIdx - 2] : inOpen[BodyLongTrailingIdx - 2]) + ((inClose[BodyLongTrailingIdx - 2] >= inOpen[BodyLongTrailingIdx - 2] ? inOpen[BodyLongTrailingIdx - 2] : inClose[BodyLongTrailingIdx - 2]) - inLow[BodyLongTrailingIdx - 2]) : 0.0f))));
            ++i;
            ++ShadowShortTrailingIdx;
            ++ShadowLongTrailingIdx;
            ++NearTrailingIdx;
            ++FarTrailingIdx;
            ++BodyLongTrailingIdx;
        } while (i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlBeltHoldLookback() {
        return this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlBeltHold(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlBeltHoldLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        BodyLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        ShadowVeryShortPeriodTotal = 0.0;
        ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        i = BodyLongTrailingIdx;
        while (i < startIdx) {
            BodyLongPeriodTotal += this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = ShadowVeryShortTrailingIdx;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal += this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i] - inOpen[i]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2)) ** GOTO lbl-1000
            if ((inClose[i] >= inOpen[i] ? 1 : -1) == 1 && (inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i] < this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0)))) / (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0)) ** GOTO lbl-1000
            if ((inClose[i] >= inOpen[i] ? 1 : -1) == -1) {
                v3 = inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]);
                v4 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
                v5 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
                ** if (!(v3 < v4 / v5)) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                outInteger[outIdx++] = (inClose[i] >= inOpen[i] ? 1 : -1) * 100;
                ** GOTO lbl42
            }
lbl-1000:
            // 3 sources

            {
                outInteger[outIdx++] = 0;
            }
lbl42:
            // 2 sources

            BodyLongPeriodTotal += (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx] - inOpen[BodyLongTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx] - inLow[BodyLongTrailingIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx] - (inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inClose[BodyLongTrailingIdx] : inOpen[BodyLongTrailingIdx]) + ((inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inOpen[BodyLongTrailingIdx] : inClose[BodyLongTrailingIdx]) - inLow[BodyLongTrailingIdx]) : 0.0)));
            ShadowVeryShortPeriodTotal += (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx] - inOpen[ShadowVeryShortTrailingIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx] - inLow[ShadowVeryShortTrailingIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx] - (inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inClose[ShadowVeryShortTrailingIdx] : inOpen[ShadowVeryShortTrailingIdx]) + ((inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inOpen[ShadowVeryShortTrailingIdx] : inClose[ShadowVeryShortTrailingIdx]) - inLow[ShadowVeryShortTrailingIdx]) : 0.0)));
            ++BodyLongTrailingIdx;
            ++ShadowVeryShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlBeltHold(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlBeltHoldLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        BodyLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        ShadowVeryShortPeriodTotal = 0.0;
        ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        i = BodyLongTrailingIdx;
        while (i < startIdx) {
            BodyLongPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = ShadowVeryShortTrailingIdx;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal += (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i] - inOpen[i]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2)) ** GOTO lbl-1000
            if ((inClose[i] >= inOpen[i] ? 1 : -1) == 1 && (double)((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) < this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)))) / (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0)) ** GOTO lbl-1000
            if ((inClose[i] >= inOpen[i] ? 1 : -1) == -1) {
                v3 = inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]);
                v4 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
                v5 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
                ** if (!(v3 < v4 / v5)) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                outInteger[outIdx++] = (inClose[i] >= inOpen[i] ? 1 : -1) * 100;
                ** GOTO lbl42
            }
lbl-1000:
            // 3 sources

            {
                outInteger[outIdx++] = 0;
            }
lbl42:
            // 2 sources

            BodyLongPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx] - inOpen[BodyLongTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx] - inLow[BodyLongTrailingIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx] - (inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inClose[BodyLongTrailingIdx] : inOpen[BodyLongTrailingIdx]) + ((inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inOpen[BodyLongTrailingIdx] : inClose[BodyLongTrailingIdx]) - inLow[BodyLongTrailingIdx]) : 0.0f))));
            ShadowVeryShortPeriodTotal += (double)((this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx] - inOpen[ShadowVeryShortTrailingIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx] - inLow[ShadowVeryShortTrailingIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx] - (inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inClose[ShadowVeryShortTrailingIdx] : inOpen[ShadowVeryShortTrailingIdx]) + ((inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inOpen[ShadowVeryShortTrailingIdx] : inClose[ShadowVeryShortTrailingIdx]) - inLow[ShadowVeryShortTrailingIdx]) : 0.0f))));
            ++BodyLongTrailingIdx;
            ++ShadowVeryShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlBreakawayLookback() {
        return this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod + 4;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlBreakaway(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlBreakawayLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        i = BodyLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        while (i < startIdx) {
            BodyLongPeriodTotal += this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 4] - inOpen[i - 4]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 4] - inLow[i - 4] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 4] - (inClose[i - 4] >= inOpen[i - 4] ? inClose[i - 4] : inOpen[i - 4]) + ((inClose[i - 4] >= inOpen[i - 4] ? inOpen[i - 4] : inClose[i - 4]) - inLow[i - 4]) : 0.0));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i - 4] - inOpen[i - 4]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 4] - inOpen[i - 4]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 4] - inLow[i - 4] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 4] - (inClose[i - 4] >= inOpen[i - 4] ? inClose[i - 4] : inOpen[i - 4]) + ((inClose[i - 4] >= inOpen[i - 4] ? inOpen[i - 4] : inClose[i - 4]) - inLow[i - 4]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2) || (inClose[i - 4] >= inOpen[i - 4] ? 1 : -1) != (inClose[i - 3] >= inOpen[i - 3] ? 1 : -1) || (inClose[i - 3] >= inOpen[i - 3] ? 1 : -1) != (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) || (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != -(inClose[i] >= inOpen[i] ? 1 : -1)) ** GOTO lbl-1000
            if ((inClose[i - 4] >= inOpen[i - 4] ? 1 : -1) == -1 && (inOpen[i - 3] > inClose[i - 3] ? inOpen[i - 3] : inClose[i - 3]) < (inOpen[i - 4] < inClose[i - 4] ? inOpen[i - 4] : inClose[i - 4]) && inHigh[i - 2] < inHigh[i - 3] && inLow[i - 2] < inLow[i - 3] && inHigh[i - 1] < inHigh[i - 2] && inLow[i - 1] < inLow[i - 2] && inClose[i] > inOpen[i - 3] && inClose[i] < inClose[i - 4]) ** GOTO lbl-1000
            if ((inClose[i - 4] >= inOpen[i - 4] ? 1 : -1) == 1) {
                v3 = inOpen[i - 3] < inClose[i - 3] ? inOpen[i - 3] : inClose[i - 3];
                v4 = inOpen[i - 4] > inClose[i - 4] ? inOpen[i - 4] : inClose[i - 4];
                ** if (!(v3 > v4) || !(inHigh[i - 2] > inHigh[i - 3]) || !(inLow[i - 2] > inLow[i - 3]) || !(inHigh[i - 1] > inHigh[i - 2]) || !(inLow[i - 1] > inLow[i - 2]) || !(inClose[i] < inOpen[i - 3]) || !(inClose[i] > inClose[i - 4])) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                outInteger[outIdx++] = (inClose[i] >= inOpen[i] ? 1 : -1) * 100;
                ** GOTO lbl34
            }
lbl-1000:
            // 3 sources

            {
                outInteger[outIdx++] = 0;
            }
lbl34:
            // 2 sources

            BodyLongPeriodTotal += (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 4] - inOpen[i - 4]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 4] - inLow[i - 4] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 4] - (inClose[i - 4] >= inOpen[i - 4] ? inClose[i - 4] : inOpen[i - 4]) + ((inClose[i - 4] >= inOpen[i - 4] ? inOpen[i - 4] : inClose[i - 4]) - inLow[i - 4]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx - 4] - inOpen[BodyLongTrailingIdx - 4]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx - 4] - inLow[BodyLongTrailingIdx - 4] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx - 4] - (inClose[BodyLongTrailingIdx - 4] >= inOpen[BodyLongTrailingIdx - 4] ? inClose[BodyLongTrailingIdx - 4] : inOpen[BodyLongTrailingIdx - 4]) + ((inClose[BodyLongTrailingIdx - 4] >= inOpen[BodyLongTrailingIdx - 4] ? inOpen[BodyLongTrailingIdx - 4] : inClose[BodyLongTrailingIdx - 4]) - inLow[BodyLongTrailingIdx - 4]) : 0.0)));
            ++BodyLongTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlBreakaway(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlBreakawayLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        i = BodyLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        while (i < startIdx) {
            BodyLongPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 4] - inOpen[i - 4]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 4] - inLow[i - 4] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 4] - (inClose[i - 4] >= inOpen[i - 4] ? inClose[i - 4] : inOpen[i - 4]) + ((inClose[i - 4] >= inOpen[i - 4] ? inOpen[i - 4] : inClose[i - 4]) - inLow[i - 4]) : 0.0f)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i - 4] - inOpen[i - 4]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 4] - inOpen[i - 4]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 4] - inLow[i - 4] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 4] - (inClose[i - 4] >= inOpen[i - 4] ? inClose[i - 4] : inOpen[i - 4]) + ((inClose[i - 4] >= inOpen[i - 4] ? inOpen[i - 4] : inClose[i - 4]) - inLow[i - 4]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2) || (inClose[i - 4] >= inOpen[i - 4] ? 1 : -1) != (inClose[i - 3] >= inOpen[i - 3] ? 1 : -1) || (inClose[i - 3] >= inOpen[i - 3] ? 1 : -1) != (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) || (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != -(inClose[i] >= inOpen[i] ? 1 : -1)) ** GOTO lbl-1000
            if ((inClose[i - 4] >= inOpen[i - 4] ? 1 : -1) == -1 && (inOpen[i - 3] > inClose[i - 3] ? inOpen[i - 3] : inClose[i - 3]) < (inOpen[i - 4] < inClose[i - 4] ? inOpen[i - 4] : inClose[i - 4]) && inHigh[i - 2] < inHigh[i - 3] && inLow[i - 2] < inLow[i - 3] && inHigh[i - 1] < inHigh[i - 2] && inLow[i - 1] < inLow[i - 2] && inClose[i] > inOpen[i - 3] && inClose[i] < inClose[i - 4]) ** GOTO lbl-1000
            if ((inClose[i - 4] >= inOpen[i - 4] ? 1 : -1) == 1) {
                v3 = inOpen[i - 3] < inClose[i - 3] ? inOpen[i - 3] : inClose[i - 3];
                v4 = inOpen[i - 4] > inClose[i - 4] ? inOpen[i - 4] : inClose[i - 4];
                ** if (!(v3 > v4) || !(inHigh[i - 2] > inHigh[i - 3]) || !(inLow[i - 2] > inLow[i - 3]) || !(inHigh[i - 1] > inHigh[i - 2]) || !(inLow[i - 1] > inLow[i - 2]) || !(inClose[i] < inOpen[i - 3]) || !(inClose[i] > inClose[i - 4])) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                outInteger[outIdx++] = (inClose[i] >= inOpen[i] ? 1 : -1) * 100;
                ** GOTO lbl34
            }
lbl-1000:
            // 3 sources

            {
                outInteger[outIdx++] = 0;
            }
lbl34:
            // 2 sources

            BodyLongPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 4] - inOpen[i - 4]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 4] - inLow[i - 4] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 4] - (inClose[i - 4] >= inOpen[i - 4] ? inClose[i - 4] : inOpen[i - 4]) + ((inClose[i - 4] >= inOpen[i - 4] ? inOpen[i - 4] : inClose[i - 4]) - inLow[i - 4]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx - 4] - inOpen[BodyLongTrailingIdx - 4]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx - 4] - inLow[BodyLongTrailingIdx - 4] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx - 4] - (inClose[BodyLongTrailingIdx - 4] >= inOpen[BodyLongTrailingIdx - 4] ? inClose[BodyLongTrailingIdx - 4] : inOpen[BodyLongTrailingIdx - 4]) + ((inClose[BodyLongTrailingIdx - 4] >= inOpen[BodyLongTrailingIdx - 4] ? inOpen[BodyLongTrailingIdx - 4] : inClose[BodyLongTrailingIdx - 4]) - inLow[BodyLongTrailingIdx - 4]) : 0.0f))));
            ++BodyLongTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlClosingMarubozuLookback() {
        return this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlClosingMarubozu(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlClosingMarubozuLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        BodyLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        ShadowVeryShortPeriodTotal = 0.0;
        ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        i = BodyLongTrailingIdx;
        while (i < startIdx) {
            BodyLongPeriodTotal += this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = ShadowVeryShortTrailingIdx;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal += this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i] - inOpen[i]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2)) ** GOTO lbl-1000
            if ((inClose[i] >= inOpen[i] ? 1 : -1) == 1 && inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) < this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0)))) / (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0)) ** GOTO lbl-1000
            if ((inClose[i] >= inOpen[i] ? 1 : -1) == -1) {
                v3 = (inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i];
                v4 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
                v5 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
                ** if (!(v3 < v4 / v5)) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                outInteger[outIdx++] = (inClose[i] >= inOpen[i] ? 1 : -1) * 100;
                ** GOTO lbl42
            }
lbl-1000:
            // 3 sources

            {
                outInteger[outIdx++] = 0;
            }
lbl42:
            // 2 sources

            BodyLongPeriodTotal += (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx] - inOpen[BodyLongTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx] - inLow[BodyLongTrailingIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx] - (inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inClose[BodyLongTrailingIdx] : inOpen[BodyLongTrailingIdx]) + ((inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inOpen[BodyLongTrailingIdx] : inClose[BodyLongTrailingIdx]) - inLow[BodyLongTrailingIdx]) : 0.0)));
            ShadowVeryShortPeriodTotal += (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx] - inOpen[ShadowVeryShortTrailingIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx] - inLow[ShadowVeryShortTrailingIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx] - (inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inClose[ShadowVeryShortTrailingIdx] : inOpen[ShadowVeryShortTrailingIdx]) + ((inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inOpen[ShadowVeryShortTrailingIdx] : inClose[ShadowVeryShortTrailingIdx]) - inLow[ShadowVeryShortTrailingIdx]) : 0.0)));
            ++BodyLongTrailingIdx;
            ++ShadowVeryShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlClosingMarubozu(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlClosingMarubozuLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        BodyLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        ShadowVeryShortPeriodTotal = 0.0;
        ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        i = BodyLongTrailingIdx;
        while (i < startIdx) {
            BodyLongPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = ShadowVeryShortTrailingIdx;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal += (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i] - inOpen[i]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2)) ** GOTO lbl-1000
            if ((inClose[i] >= inOpen[i] ? 1 : -1) == 1 && (double)(inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i])) < this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)))) / (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0)) ** GOTO lbl-1000
            if ((inClose[i] >= inOpen[i] ? 1 : -1) == -1) {
                v3 = (inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i];
                v4 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
                v5 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
                ** if (!(v3 < v4 / v5)) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                outInteger[outIdx++] = (inClose[i] >= inOpen[i] ? 1 : -1) * 100;
                ** GOTO lbl42
            }
lbl-1000:
            // 3 sources

            {
                outInteger[outIdx++] = 0;
            }
lbl42:
            // 2 sources

            BodyLongPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx] - inOpen[BodyLongTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx] - inLow[BodyLongTrailingIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx] - (inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inClose[BodyLongTrailingIdx] : inOpen[BodyLongTrailingIdx]) + ((inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inOpen[BodyLongTrailingIdx] : inClose[BodyLongTrailingIdx]) - inLow[BodyLongTrailingIdx]) : 0.0f))));
            ShadowVeryShortPeriodTotal += (double)((this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx] - inOpen[ShadowVeryShortTrailingIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx] - inLow[ShadowVeryShortTrailingIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx] - (inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inClose[ShadowVeryShortTrailingIdx] : inOpen[ShadowVeryShortTrailingIdx]) + ((inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inOpen[ShadowVeryShortTrailingIdx] : inClose[ShadowVeryShortTrailingIdx]) - inLow[ShadowVeryShortTrailingIdx]) : 0.0f))));
            ++BodyLongTrailingIdx;
            ++ShadowVeryShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlConcealBabysWallLookback() {
        return this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod + 3;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlConcealBabysWall(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        ShadowVeryShortPeriodTotal = new double[4];
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlConcealBabysWallLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        ShadowVeryShortPeriodTotal[3] = 0.0;
        ShadowVeryShortPeriodTotal[2] = 0.0;
        ShadowVeryShortPeriodTotal[1] = 0.0;
        i = ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal[3] = ShadowVeryShortPeriodTotal[3] + (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 3] - inOpen[i - 3]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 3] - inLow[i - 3] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 3] - (inClose[i - 3] >= inOpen[i - 3] ? inClose[i - 3] : inOpen[i - 3]) + ((inClose[i - 3] >= inOpen[i - 3] ? inOpen[i - 3] : inClose[i - 3]) - inLow[i - 3]) : 0.0)));
            ShadowVeryShortPeriodTotal[2] = ShadowVeryShortPeriodTotal[2] + (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0)));
            ShadowVeryShortPeriodTotal[1] = ShadowVeryShortPeriodTotal[1] + (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 3] >= inOpen[i - 3] ? 1 : -1) != -1 || (inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) != -1 || (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != -1 || (inClose[i] >= inOpen[i] ? 1 : -1) != -1) ** GOTO lbl-1000
            v0 = (inClose[i - 3] >= inOpen[i - 3] ? inOpen[i - 3] : inClose[i - 3]) - inLow[i - 3];
            v1 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[3] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 3] - inOpen[i - 3]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 3] - inLow[i - 3] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 3] - (inClose[i - 3] >= inOpen[i - 3] ? inClose[i - 3] : inOpen[i - 3]) + ((inClose[i - 3] >= inOpen[i - 3] ? inOpen[i - 3] : inClose[i - 3]) - inLow[i - 3]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 < v1 / v2)) ** GOTO lbl-1000
            v3 = inHigh[i - 3] - (inClose[i - 3] >= inOpen[i - 3] ? inClose[i - 3] : inOpen[i - 3]);
            v4 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[3] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 3] - inOpen[i - 3]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 3] - inLow[i - 3] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 3] - (inClose[i - 3] >= inOpen[i - 3] ? inClose[i - 3] : inOpen[i - 3]) + ((inClose[i - 3] >= inOpen[i - 3] ? inOpen[i - 3] : inClose[i - 3]) - inLow[i - 3]) : 0.0))));
            v5 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 < v4 / v5)) ** GOTO lbl-1000
            v6 = (inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2];
            v7 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[2] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))));
            v8 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v6 < v7 / v8)) ** GOTO lbl-1000
            v9 = inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]);
            v10 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[2] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))));
            v11 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v9 < v10 / v11)) ** GOTO lbl-1000
            v12 = inOpen[i - 1] > inClose[i - 1] ? inOpen[i - 1] : inClose[i - 1];
            v13 = inOpen[i - 2] < inClose[i - 2] ? inOpen[i - 2] : inClose[i - 2];
            if (!(v12 < v13)) ** GOTO lbl-1000
            v14 = inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]);
            v15 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v16 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v14 > v15 / v16 && inHigh[i - 1] > inClose[i - 2] && inHigh[i] > inHigh[i - 1] && inLow[i] < inLow[i - 1]) {
                outInteger[outIdx++] = 100;
            } else lbl-1000:
            // 7 sources

            {
                outInteger[outIdx++] = 0;
            }
            totIdx = 3;
            while (totIdx >= 1) {
                v17 = totIdx;
                ShadowVeryShortPeriodTotal[v17] = ShadowVeryShortPeriodTotal[v17] + ((this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx - totIdx] - inOpen[ShadowVeryShortTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx - totIdx] - inLow[ShadowVeryShortTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx - totIdx] - (inClose[ShadowVeryShortTrailingIdx - totIdx] >= inOpen[ShadowVeryShortTrailingIdx - totIdx] ? inClose[ShadowVeryShortTrailingIdx - totIdx] : inOpen[ShadowVeryShortTrailingIdx - totIdx]) + ((inClose[ShadowVeryShortTrailingIdx - totIdx] >= inOpen[ShadowVeryShortTrailingIdx - totIdx] ? inOpen[ShadowVeryShortTrailingIdx - totIdx] : inClose[ShadowVeryShortTrailingIdx - totIdx]) - inLow[ShadowVeryShortTrailingIdx - totIdx]) : 0.0))));
                --totIdx;
            }
            ++ShadowVeryShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlConcealBabysWall(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        ShadowVeryShortPeriodTotal = new double[4];
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlConcealBabysWallLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        ShadowVeryShortPeriodTotal[3] = 0.0;
        ShadowVeryShortPeriodTotal[2] = 0.0;
        ShadowVeryShortPeriodTotal[1] = 0.0;
        i = ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal[3] = ShadowVeryShortPeriodTotal[3] + (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 3] - inOpen[i - 3]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 3] - inLow[i - 3] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 3] - (inClose[i - 3] >= inOpen[i - 3] ? inClose[i - 3] : inOpen[i - 3]) + ((inClose[i - 3] >= inOpen[i - 3] ? inOpen[i - 3] : inClose[i - 3]) - inLow[i - 3]) : 0.0f)));
            ShadowVeryShortPeriodTotal[2] = ShadowVeryShortPeriodTotal[2] + (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f)));
            ShadowVeryShortPeriodTotal[1] = ShadowVeryShortPeriodTotal[1] + (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 3] >= inOpen[i - 3] ? 1 : -1) != -1 || (inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) != -1 || (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != -1 || (inClose[i] >= inOpen[i] ? 1 : -1) != -1) ** GOTO lbl-1000
            v0 = (inClose[i - 3] >= inOpen[i - 3] ? inOpen[i - 3] : inClose[i - 3]) - inLow[i - 3];
            v1 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[3] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 3] - inOpen[i - 3]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 3] - inLow[i - 3] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 3] - (inClose[i - 3] >= inOpen[i - 3] ? inClose[i - 3] : inOpen[i - 3]) + ((inClose[i - 3] >= inOpen[i - 3] ? inOpen[i - 3] : inClose[i - 3]) - inLow[i - 3]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 < v1 / v2)) ** GOTO lbl-1000
            v3 = inHigh[i - 3] - (inClose[i - 3] >= inOpen[i - 3] ? inClose[i - 3] : inOpen[i - 3]);
            v4 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[3] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 3] - inOpen[i - 3]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 3] - inLow[i - 3] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 3] - (inClose[i - 3] >= inOpen[i - 3] ? inClose[i - 3] : inOpen[i - 3]) + ((inClose[i - 3] >= inOpen[i - 3] ? inOpen[i - 3] : inClose[i - 3]) - inLow[i - 3]) : 0.0f))));
            v5 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 < v4 / v5)) ** GOTO lbl-1000
            v6 = (inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2];
            v7 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[2] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))));
            v8 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v6 < v7 / v8)) ** GOTO lbl-1000
            v9 = inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]);
            v10 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[2] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))));
            v11 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v9 < v10 / v11)) ** GOTO lbl-1000
            v12 = inOpen[i - 1] > inClose[i - 1] ? inOpen[i - 1] : inClose[i - 1];
            v13 = inOpen[i - 2] < inClose[i - 2] ? inOpen[i - 2] : inClose[i - 2];
            if (!(v12 < v13)) ** GOTO lbl-1000
            v14 = inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]);
            v15 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v16 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v14 > v15 / v16 && inHigh[i - 1] > inClose[i - 2] && inHigh[i] > inHigh[i - 1] && inLow[i] < inLow[i - 1]) {
                outInteger[outIdx++] = 100;
            } else lbl-1000:
            // 7 sources

            {
                outInteger[outIdx++] = 0;
            }
            totIdx = 3;
            while (totIdx >= 1) {
                v17 = totIdx;
                ShadowVeryShortPeriodTotal[v17] = ShadowVeryShortPeriodTotal[v17] + (double)((this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0f))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx - totIdx] - inOpen[ShadowVeryShortTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx - totIdx] - inLow[ShadowVeryShortTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx - totIdx] - (inClose[ShadowVeryShortTrailingIdx - totIdx] >= inOpen[ShadowVeryShortTrailingIdx - totIdx] ? inClose[ShadowVeryShortTrailingIdx - totIdx] : inOpen[ShadowVeryShortTrailingIdx - totIdx]) + ((inClose[ShadowVeryShortTrailingIdx - totIdx] >= inOpen[ShadowVeryShortTrailingIdx - totIdx] ? inOpen[ShadowVeryShortTrailingIdx - totIdx] : inClose[ShadowVeryShortTrailingIdx - totIdx]) - inLow[ShadowVeryShortTrailingIdx - totIdx]) : 0.0f))));
                --totIdx;
            }
            ++ShadowVeryShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlCounterAttackLookback() {
        return (this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod) + 1;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlCounterAttack(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        BodyLongPeriodTotal = new double[2];
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlCounterAttackLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        EqualPeriodTotal = 0.0;
        EqualTrailingIdx = startIdx - this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod;
        BodyLongPeriodTotal[1] = 0.0;
        BodyLongPeriodTotal[0] = 0.0;
        BodyLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        i = EqualTrailingIdx;
        while (i < startIdx) {
            EqualPeriodTotal += this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0));
            ++i;
        }
        i = BodyLongTrailingIdx;
        while (i < startIdx) {
            BodyLongPeriodTotal[1] = BodyLongPeriodTotal[1] + (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0)));
            BodyLongPeriodTotal[0] = BodyLongPeriodTotal[0] + (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != -(inClose[i] >= inOpen[i] ? 1 : -1)) ** GOTO lbl-1000
            v0 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2)) ** GOTO lbl-1000
            v3 = Math.abs(inClose[i] - inOpen[i]);
            v4 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal[0] / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v5 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 > v4 / v5)) ** GOTO lbl-1000
            v6 = inClose[i];
            v7 = inClose[i - 1];
            v8 = this.candleSettings[CandleSettingType.Equal.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod != 0.0 ? EqualPeriodTotal / (double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v9 = this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v6 <= v7 + v8 / v9)) ** GOTO lbl-1000
            v10 = inClose[i];
            v11 = inClose[i - 1];
            v12 = this.candleSettings[CandleSettingType.Equal.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod != 0.0 ? EqualPeriodTotal / (double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v13 = this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v10 >= v11 - v12 / v13) {
                outInteger[outIdx++] = (inClose[i] >= inOpen[i] ? 1 : -1) * 100;
            } else lbl-1000:
            // 5 sources

            {
                outInteger[outIdx++] = 0;
            }
            EqualPeriodTotal += (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))) - (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[EqualTrailingIdx - 1] - inOpen[EqualTrailingIdx - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[EqualTrailingIdx - 1] - inLow[EqualTrailingIdx - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[EqualTrailingIdx - 1] - (inClose[EqualTrailingIdx - 1] >= inOpen[EqualTrailingIdx - 1] ? inClose[EqualTrailingIdx - 1] : inOpen[EqualTrailingIdx - 1]) + ((inClose[EqualTrailingIdx - 1] >= inOpen[EqualTrailingIdx - 1] ? inOpen[EqualTrailingIdx - 1] : inClose[EqualTrailingIdx - 1]) - inLow[EqualTrailingIdx - 1]) : 0.0)));
            totIdx = 1;
            while (totIdx >= 0) {
                v14 = totIdx;
                BodyLongPeriodTotal[v14] = BodyLongPeriodTotal[v14] + ((this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx - totIdx] - inOpen[BodyLongTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx - totIdx] - inLow[BodyLongTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx - totIdx] - (inClose[BodyLongTrailingIdx - totIdx] >= inOpen[BodyLongTrailingIdx - totIdx] ? inClose[BodyLongTrailingIdx - totIdx] : inOpen[BodyLongTrailingIdx - totIdx]) + ((inClose[BodyLongTrailingIdx - totIdx] >= inOpen[BodyLongTrailingIdx - totIdx] ? inOpen[BodyLongTrailingIdx - totIdx] : inClose[BodyLongTrailingIdx - totIdx]) - inLow[BodyLongTrailingIdx - totIdx]) : 0.0))));
                --totIdx;
            }
            ++EqualTrailingIdx;
            ++BodyLongTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlCounterAttack(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        BodyLongPeriodTotal = new double[2];
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlCounterAttackLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        EqualPeriodTotal = 0.0;
        EqualTrailingIdx = startIdx - this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod;
        BodyLongPeriodTotal[1] = 0.0;
        BodyLongPeriodTotal[0] = 0.0;
        BodyLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        i = EqualTrailingIdx;
        while (i < startIdx) {
            EqualPeriodTotal += (double)(this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)));
            ++i;
        }
        i = BodyLongTrailingIdx;
        while (i < startIdx) {
            BodyLongPeriodTotal[1] = BodyLongPeriodTotal[1] + (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)));
            BodyLongPeriodTotal[0] = BodyLongPeriodTotal[0] + (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != -(inClose[i] >= inOpen[i] ? 1 : -1)) ** GOTO lbl-1000
            v0 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2)) ** GOTO lbl-1000
            v3 = Math.abs(inClose[i] - inOpen[i]);
            v4 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal[0] / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v5 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 > v4 / v5)) ** GOTO lbl-1000
            v6 = inClose[i];
            v7 = inClose[i - 1];
            v8 = this.candleSettings[CandleSettingType.Equal.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod != 0.0 ? EqualPeriodTotal / (double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v9 = this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v6 <= v7 + v8 / v9)) ** GOTO lbl-1000
            v10 = inClose[i];
            v11 = inClose[i - 1];
            v12 = this.candleSettings[CandleSettingType.Equal.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod != 0.0 ? EqualPeriodTotal / (double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v13 = this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v10 >= v11 - v12 / v13) {
                outInteger[outIdx++] = (inClose[i] >= inOpen[i] ? 1 : -1) * 100;
            } else lbl-1000:
            // 5 sources

            {
                outInteger[outIdx++] = 0;
            }
            EqualPeriodTotal += (double)((this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))) - (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[EqualTrailingIdx - 1] - inOpen[EqualTrailingIdx - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[EqualTrailingIdx - 1] - inLow[EqualTrailingIdx - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[EqualTrailingIdx - 1] - (inClose[EqualTrailingIdx - 1] >= inOpen[EqualTrailingIdx - 1] ? inClose[EqualTrailingIdx - 1] : inOpen[EqualTrailingIdx - 1]) + ((inClose[EqualTrailingIdx - 1] >= inOpen[EqualTrailingIdx - 1] ? inOpen[EqualTrailingIdx - 1] : inClose[EqualTrailingIdx - 1]) - inLow[EqualTrailingIdx - 1]) : 0.0f))));
            totIdx = 1;
            while (totIdx >= 0) {
                v14 = totIdx;
                BodyLongPeriodTotal[v14] = BodyLongPeriodTotal[v14] + (double)((this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx - totIdx] - inOpen[BodyLongTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx - totIdx] - inLow[BodyLongTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx - totIdx] - (inClose[BodyLongTrailingIdx - totIdx] >= inOpen[BodyLongTrailingIdx - totIdx] ? inClose[BodyLongTrailingIdx - totIdx] : inOpen[BodyLongTrailingIdx - totIdx]) + ((inClose[BodyLongTrailingIdx - totIdx] >= inOpen[BodyLongTrailingIdx - totIdx] ? inOpen[BodyLongTrailingIdx - totIdx] : inClose[BodyLongTrailingIdx - totIdx]) - inLow[BodyLongTrailingIdx - totIdx]) : 0.0f))));
                --totIdx;
            }
            ++EqualTrailingIdx;
            ++BodyLongTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlDarkCloudCoverLookback(double optInPenetration) {
        if (optInPenetration == -4.0E37) {
            optInPenetration = 0.5;
        } else if (optInPenetration < 0.0 || optInPenetration > 3.0E37) {
            return -1;
        }
        return this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod + 1;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlDarkCloudCover(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, double optInPenetration, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInPenetration == -4.0E37) {
            optInPenetration = 0.5;
        } else if (optInPenetration < 0.0 || optInPenetration > 3.0E37) {
            return RetCode.BadParam;
        }
        lookbackTotal = this.cdlDarkCloudCoverLookback(optInPenetration);
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        i = BodyLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        while (i < startIdx) {
            BodyLongPeriodTotal += this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != 1) ** GOTO lbl-1000
            v0 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v0 > v1 / v2 && (inClose[i] >= inOpen[i] ? 1 : -1) == -1 && inOpen[i] > inHigh[i - 1] && inClose[i] > inOpen[i - 1] && inClose[i] < inClose[i - 1] - Math.abs(inClose[i - 1] - inOpen[i - 1]) * optInPenetration) {
                outInteger[outIdx++] = -100;
            } else lbl-1000:
            // 2 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyLongPeriodTotal += (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx - 1] - inOpen[BodyLongTrailingIdx - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx - 1] - inLow[BodyLongTrailingIdx - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx - 1] - (inClose[BodyLongTrailingIdx - 1] >= inOpen[BodyLongTrailingIdx - 1] ? inClose[BodyLongTrailingIdx - 1] : inOpen[BodyLongTrailingIdx - 1]) + ((inClose[BodyLongTrailingIdx - 1] >= inOpen[BodyLongTrailingIdx - 1] ? inOpen[BodyLongTrailingIdx - 1] : inClose[BodyLongTrailingIdx - 1]) - inLow[BodyLongTrailingIdx - 1]) : 0.0)));
            ++BodyLongTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlDarkCloudCover(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, double optInPenetration, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInPenetration == -4.0E37) {
            optInPenetration = 0.5;
        } else if (optInPenetration < 0.0 || optInPenetration > 3.0E37) {
            return RetCode.BadParam;
        }
        lookbackTotal = this.cdlDarkCloudCoverLookback(optInPenetration);
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        i = BodyLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        while (i < startIdx) {
            BodyLongPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != 1) ** GOTO lbl-1000
            v0 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v0 > v1 / v2 && (inClose[i] >= inOpen[i] ? 1 : -1) == -1 && inOpen[i] > inHigh[i - 1] && inClose[i] > inOpen[i - 1] && (double)inClose[i] < (double)inClose[i - 1] - (double)Math.abs(inClose[i - 1] - inOpen[i - 1]) * optInPenetration) {
                outInteger[outIdx++] = -100;
            } else lbl-1000:
            // 2 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyLongPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx - 1] - inOpen[BodyLongTrailingIdx - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx - 1] - inLow[BodyLongTrailingIdx - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx - 1] - (inClose[BodyLongTrailingIdx - 1] >= inOpen[BodyLongTrailingIdx - 1] ? inClose[BodyLongTrailingIdx - 1] : inOpen[BodyLongTrailingIdx - 1]) + ((inClose[BodyLongTrailingIdx - 1] >= inOpen[BodyLongTrailingIdx - 1] ? inOpen[BodyLongTrailingIdx - 1] : inClose[BodyLongTrailingIdx - 1]) - inLow[BodyLongTrailingIdx - 1]) : 0.0f))));
            ++BodyLongTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlDojiLookback() {
        return this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod;
    }

    public RetCode cdlDoji(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        int BodyDojiTrailingIdx;
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        int lookbackTotal = this.cdlDojiLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        double BodyDojiPeriodTotal = 0.0;
        int i = BodyDojiTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod;
        while (i < startIdx) {
            BodyDojiPeriodTotal += this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        int outIdx = 0;
        do {
            outInteger[outIdx++] = Math.abs(inClose[i] - inOpen[i]) <= this.candleSettings[CandleSettingType.BodyDoji.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod != 0.0 ? BodyDojiPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0)))) / (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0) ? 100 : 0;
            BodyDojiPeriodTotal += (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyDojiTrailingIdx] - inOpen[BodyDojiTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyDojiTrailingIdx] - inLow[BodyDojiTrailingIdx] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyDojiTrailingIdx] - (inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inClose[BodyDojiTrailingIdx] : inOpen[BodyDojiTrailingIdx]) + ((inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inOpen[BodyDojiTrailingIdx] : inClose[BodyDojiTrailingIdx]) - inLow[BodyDojiTrailingIdx]) : 0.0)));
            ++BodyDojiTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public RetCode cdlDoji(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        int BodyDojiTrailingIdx;
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        int lookbackTotal = this.cdlDojiLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        double BodyDojiPeriodTotal = 0.0;
        int i = BodyDojiTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod;
        while (i < startIdx) {
            BodyDojiPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        int outIdx = 0;
        do {
            outInteger[outIdx++] = (double)Math.abs(inClose[i] - inOpen[i]) <= this.candleSettings[CandleSettingType.BodyDoji.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod != 0.0 ? BodyDojiPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)))) / (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0) ? 100 : 0;
            BodyDojiPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyDojiTrailingIdx] - inOpen[BodyDojiTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyDojiTrailingIdx] - inLow[BodyDojiTrailingIdx] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyDojiTrailingIdx] - (inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inClose[BodyDojiTrailingIdx] : inOpen[BodyDojiTrailingIdx]) + ((inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inOpen[BodyDojiTrailingIdx] : inClose[BodyDojiTrailingIdx]) - inLow[BodyDojiTrailingIdx]) : 0.0f))));
            ++BodyDojiTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlDojiStarLookback() {
        return (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod) + 1;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlDojiStar(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlDojiStarLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        BodyDojiPeriodTotal = 0.0;
        BodyLongTrailingIdx = startIdx - 1 - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        BodyDojiTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod;
        i = BodyLongTrailingIdx;
        while (i < startIdx - 1) {
            BodyLongPeriodTotal += this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = BodyDojiTrailingIdx;
        while (i < startIdx) {
            BodyDojiPeriodTotal += this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2)) ** GOTO lbl-1000
            v3 = Math.abs(inClose[i] - inOpen[i]);
            v4 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod != 0.0 ? BodyDojiPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v5 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 <= v4 / v5)) ** GOTO lbl-1000
            if ((inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) == 1 && (inOpen[i] < inClose[i] ? inOpen[i] : inClose[i]) > (inOpen[i - 1] > inClose[i - 1] ? inOpen[i - 1] : inClose[i - 1])) ** GOTO lbl-1000
            if ((inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) == -1) {
                v6 = inOpen[i] > inClose[i] ? inOpen[i] : inClose[i];
                v7 = inOpen[i - 1] < inClose[i - 1] ? inOpen[i - 1] : inClose[i - 1];
                ** if (!(v6 < v7)) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                outInteger[outIdx++] = -(inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) * 100;
                ** GOTO lbl45
            }
lbl-1000:
            // 4 sources

            {
                outInteger[outIdx++] = 0;
            }
lbl45:
            // 2 sources

            BodyLongPeriodTotal += (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx] - inOpen[BodyLongTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx] - inLow[BodyLongTrailingIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx] - (inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inClose[BodyLongTrailingIdx] : inOpen[BodyLongTrailingIdx]) + ((inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inOpen[BodyLongTrailingIdx] : inClose[BodyLongTrailingIdx]) - inLow[BodyLongTrailingIdx]) : 0.0)));
            BodyDojiPeriodTotal += (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyDojiTrailingIdx] - inOpen[BodyDojiTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyDojiTrailingIdx] - inLow[BodyDojiTrailingIdx] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyDojiTrailingIdx] - (inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inClose[BodyDojiTrailingIdx] : inOpen[BodyDojiTrailingIdx]) + ((inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inOpen[BodyDojiTrailingIdx] : inClose[BodyDojiTrailingIdx]) - inLow[BodyDojiTrailingIdx]) : 0.0)));
            ++BodyLongTrailingIdx;
            ++BodyDojiTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlDojiStar(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlDojiStarLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        BodyDojiPeriodTotal = 0.0;
        BodyLongTrailingIdx = startIdx - 1 - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        BodyDojiTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod;
        i = BodyLongTrailingIdx;
        while (i < startIdx - 1) {
            BodyLongPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = BodyDojiTrailingIdx;
        while (i < startIdx) {
            BodyDojiPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2)) ** GOTO lbl-1000
            v3 = Math.abs(inClose[i] - inOpen[i]);
            v4 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod != 0.0 ? BodyDojiPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v5 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 <= v4 / v5)) ** GOTO lbl-1000
            if ((inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) == 1 && (inOpen[i] < inClose[i] ? inOpen[i] : inClose[i]) > (inOpen[i - 1] > inClose[i - 1] ? inOpen[i - 1] : inClose[i - 1])) ** GOTO lbl-1000
            if ((inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) == -1) {
                v6 = inOpen[i] > inClose[i] ? inOpen[i] : inClose[i];
                v7 = inOpen[i - 1] < inClose[i - 1] ? inOpen[i - 1] : inClose[i - 1];
                ** if (!(v6 < v7)) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                outInteger[outIdx++] = -(inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) * 100;
                ** GOTO lbl45
            }
lbl-1000:
            // 4 sources

            {
                outInteger[outIdx++] = 0;
            }
lbl45:
            // 2 sources

            BodyLongPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx] - inOpen[BodyLongTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx] - inLow[BodyLongTrailingIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx] - (inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inClose[BodyLongTrailingIdx] : inOpen[BodyLongTrailingIdx]) + ((inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inOpen[BodyLongTrailingIdx] : inClose[BodyLongTrailingIdx]) - inLow[BodyLongTrailingIdx]) : 0.0f))));
            BodyDojiPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyDojiTrailingIdx] - inOpen[BodyDojiTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyDojiTrailingIdx] - inLow[BodyDojiTrailingIdx] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyDojiTrailingIdx] - (inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inClose[BodyDojiTrailingIdx] : inOpen[BodyDojiTrailingIdx]) + ((inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inOpen[BodyDojiTrailingIdx] : inClose[BodyDojiTrailingIdx]) - inLow[BodyDojiTrailingIdx]) : 0.0f))));
            ++BodyLongTrailingIdx;
            ++BodyDojiTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlDragonflyDojiLookback() {
        return this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlDragonflyDoji(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlDragonflyDojiLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyDojiPeriodTotal = 0.0;
        BodyDojiTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod;
        ShadowVeryShortPeriodTotal = 0.0;
        ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        i = BodyDojiTrailingIdx;
        while (i < startIdx) {
            BodyDojiPeriodTotal += this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = ShadowVeryShortTrailingIdx;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal += this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i] - inOpen[i]);
            v1 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod != 0.0 ? BodyDojiPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 <= v1 / v2)) ** GOTO lbl-1000
            v3 = inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]);
            v4 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v5 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 < v4 / v5)) ** GOTO lbl-1000
            v6 = (inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i];
            v7 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v8 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v6 > v7 / v8) {
                outInteger[outIdx++] = 100;
            } else lbl-1000:
            // 3 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyDojiPeriodTotal += (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyDojiTrailingIdx] - inOpen[BodyDojiTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyDojiTrailingIdx] - inLow[BodyDojiTrailingIdx] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyDojiTrailingIdx] - (inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inClose[BodyDojiTrailingIdx] : inOpen[BodyDojiTrailingIdx]) + ((inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inOpen[BodyDojiTrailingIdx] : inClose[BodyDojiTrailingIdx]) - inLow[BodyDojiTrailingIdx]) : 0.0)));
            ShadowVeryShortPeriodTotal += (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx] - inOpen[ShadowVeryShortTrailingIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx] - inLow[ShadowVeryShortTrailingIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx] - (inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inClose[ShadowVeryShortTrailingIdx] : inOpen[ShadowVeryShortTrailingIdx]) + ((inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inOpen[ShadowVeryShortTrailingIdx] : inClose[ShadowVeryShortTrailingIdx]) - inLow[ShadowVeryShortTrailingIdx]) : 0.0)));
            ++BodyDojiTrailingIdx;
            ++ShadowVeryShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlDragonflyDoji(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlDragonflyDojiLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyDojiPeriodTotal = 0.0;
        BodyDojiTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod;
        ShadowVeryShortPeriodTotal = 0.0;
        ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        i = BodyDojiTrailingIdx;
        while (i < startIdx) {
            BodyDojiPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = ShadowVeryShortTrailingIdx;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal += (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i] - inOpen[i]);
            v1 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod != 0.0 ? BodyDojiPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 <= v1 / v2)) ** GOTO lbl-1000
            v3 = inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]);
            v4 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v5 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 < v4 / v5)) ** GOTO lbl-1000
            v6 = (inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i];
            v7 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v8 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v6 > v7 / v8) {
                outInteger[outIdx++] = 100;
            } else lbl-1000:
            // 3 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyDojiPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyDojiTrailingIdx] - inOpen[BodyDojiTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyDojiTrailingIdx] - inLow[BodyDojiTrailingIdx] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyDojiTrailingIdx] - (inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inClose[BodyDojiTrailingIdx] : inOpen[BodyDojiTrailingIdx]) + ((inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inOpen[BodyDojiTrailingIdx] : inClose[BodyDojiTrailingIdx]) - inLow[BodyDojiTrailingIdx]) : 0.0f))));
            ShadowVeryShortPeriodTotal += (double)((this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx] - inOpen[ShadowVeryShortTrailingIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx] - inLow[ShadowVeryShortTrailingIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx] - (inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inClose[ShadowVeryShortTrailingIdx] : inOpen[ShadowVeryShortTrailingIdx]) + ((inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inOpen[ShadowVeryShortTrailingIdx] : inClose[ShadowVeryShortTrailingIdx]) - inLow[ShadowVeryShortTrailingIdx]) : 0.0f))));
            ++BodyDojiTrailingIdx;
            ++ShadowVeryShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlEngulfingLookback() {
        return 2;
    }

    public RetCode cdlEngulfing(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        int lookbackTotal = this.cdlEngulfingLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        int i = startIdx;
        int outIdx = 0;
        do {
            outInteger[outIdx++] = (inClose[i] >= inOpen[i] ? 1 : -1) == 1 && (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) == -1 && inClose[i] > inOpen[i - 1] && inOpen[i] < inClose[i - 1] || (inClose[i] >= inOpen[i] ? 1 : -1) == -1 && (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) == 1 && inOpen[i] > inClose[i - 1] && inClose[i] < inOpen[i - 1] ? (inClose[i] >= inOpen[i] ? 1 : -1) * 100 : 0;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public RetCode cdlEngulfing(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        int lookbackTotal = this.cdlEngulfingLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        int i = startIdx;
        int outIdx = 0;
        do {
            outInteger[outIdx++] = (inClose[i] >= inOpen[i] ? 1 : -1) == 1 && (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) == -1 && inClose[i] > inOpen[i - 1] && inOpen[i] < inClose[i - 1] || (inClose[i] >= inOpen[i] ? 1 : -1) == -1 && (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) == 1 && inOpen[i] > inClose[i - 1] && inClose[i] < inOpen[i - 1] ? (inClose[i] >= inOpen[i] ? 1 : -1) * 100 : 0;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlEveningDojiStarLookback(double optInPenetration) {
        if (optInPenetration == -4.0E37) {
            optInPenetration = 0.3;
        } else if (optInPenetration < 0.0 || optInPenetration > 3.0E37) {
            return -1;
        }
        return ((this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod) > this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod ? (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod) : this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod) + 2;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlEveningDojiStar(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, double optInPenetration, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInPenetration == -4.0E37) {
            optInPenetration = 0.3;
        } else if (optInPenetration < 0.0 || optInPenetration > 3.0E37) {
            return RetCode.BadParam;
        }
        lookbackTotal = this.cdlEveningDojiStarLookback(optInPenetration);
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        BodyDojiPeriodTotal = 0.0;
        BodyShortPeriodTotal = 0.0;
        BodyLongTrailingIdx = startIdx - 2 - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        BodyDojiTrailingIdx = startIdx - 1 - this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod;
        BodyShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod;
        i = BodyLongTrailingIdx;
        while (i < startIdx - 2) {
            BodyLongPeriodTotal += this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = BodyDojiTrailingIdx;
        while (i < startIdx - 1) {
            BodyDojiPeriodTotal += this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = BodyShortTrailingIdx;
        while (i < startIdx) {
            BodyShortPeriodTotal += this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i - 2] - inOpen[i - 2]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2) || (inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) != 1) ** GOTO lbl-1000
            v3 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v4 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod != 0.0 ? BodyDojiPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v5 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 <= v4 / v5)) ** GOTO lbl-1000
            v6 = inOpen[i - 1] < inClose[i - 1] ? inOpen[i - 1] : inClose[i - 1];
            v7 = inOpen[i - 2] > inClose[i - 2] ? inOpen[i - 2] : inClose[i - 2];
            if (!(v6 > v7)) ** GOTO lbl-1000
            v8 = Math.abs(inClose[i] - inOpen[i]);
            v9 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyShortPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v10 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v8 > v9 / v10 && (inClose[i] >= inOpen[i] ? 1 : -1) == -1 && inClose[i] < inClose[i - 2] - Math.abs(inClose[i - 2] - inOpen[i - 2]) * optInPenetration) {
                outInteger[outIdx++] = -100;
            } else lbl-1000:
            // 4 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyLongPeriodTotal += (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx] - inOpen[BodyLongTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx] - inLow[BodyLongTrailingIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx] - (inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inClose[BodyLongTrailingIdx] : inOpen[BodyLongTrailingIdx]) + ((inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inOpen[BodyLongTrailingIdx] : inClose[BodyLongTrailingIdx]) - inLow[BodyLongTrailingIdx]) : 0.0)));
            BodyDojiPeriodTotal += (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyDojiTrailingIdx] - inOpen[BodyDojiTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyDojiTrailingIdx] - inLow[BodyDojiTrailingIdx] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyDojiTrailingIdx] - (inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inClose[BodyDojiTrailingIdx] : inOpen[BodyDojiTrailingIdx]) + ((inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inOpen[BodyDojiTrailingIdx] : inClose[BodyDojiTrailingIdx]) - inLow[BodyDojiTrailingIdx]) : 0.0)));
            BodyShortPeriodTotal += (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyShortTrailingIdx] - inOpen[BodyShortTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyShortTrailingIdx] - inLow[BodyShortTrailingIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyShortTrailingIdx] - (inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inClose[BodyShortTrailingIdx] : inOpen[BodyShortTrailingIdx]) + ((inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inOpen[BodyShortTrailingIdx] : inClose[BodyShortTrailingIdx]) - inLow[BodyShortTrailingIdx]) : 0.0)));
            ++BodyLongTrailingIdx;
            ++BodyDojiTrailingIdx;
            ++BodyShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlEveningDojiStar(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, double optInPenetration, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInPenetration == -4.0E37) {
            optInPenetration = 0.3;
        } else if (optInPenetration < 0.0 || optInPenetration > 3.0E37) {
            return RetCode.BadParam;
        }
        lookbackTotal = this.cdlEveningDojiStarLookback(optInPenetration);
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        BodyDojiPeriodTotal = 0.0;
        BodyShortPeriodTotal = 0.0;
        BodyLongTrailingIdx = startIdx - 2 - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        BodyDojiTrailingIdx = startIdx - 1 - this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod;
        BodyShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod;
        i = BodyLongTrailingIdx;
        while (i < startIdx - 2) {
            BodyLongPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = BodyDojiTrailingIdx;
        while (i < startIdx - 1) {
            BodyDojiPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = BodyShortTrailingIdx;
        while (i < startIdx) {
            BodyShortPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i - 2] - inOpen[i - 2]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2) || (inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) != 1) ** GOTO lbl-1000
            v3 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v4 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod != 0.0 ? BodyDojiPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v5 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 <= v4 / v5)) ** GOTO lbl-1000
            v6 = inOpen[i - 1] < inClose[i - 1] ? inOpen[i - 1] : inClose[i - 1];
            v7 = inOpen[i - 2] > inClose[i - 2] ? inOpen[i - 2] : inClose[i - 2];
            if (!(v6 > v7)) ** GOTO lbl-1000
            v8 = Math.abs(inClose[i] - inOpen[i]);
            v9 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyShortPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v10 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v8 > v9 / v10 && (inClose[i] >= inOpen[i] ? 1 : -1) == -1 && (double)inClose[i] < (double)inClose[i - 2] - (double)Math.abs(inClose[i - 2] - inOpen[i - 2]) * optInPenetration) {
                outInteger[outIdx++] = -100;
            } else lbl-1000:
            // 4 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyLongPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx] - inOpen[BodyLongTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx] - inLow[BodyLongTrailingIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx] - (inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inClose[BodyLongTrailingIdx] : inOpen[BodyLongTrailingIdx]) + ((inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inOpen[BodyLongTrailingIdx] : inClose[BodyLongTrailingIdx]) - inLow[BodyLongTrailingIdx]) : 0.0f))));
            BodyDojiPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyDojiTrailingIdx] - inOpen[BodyDojiTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyDojiTrailingIdx] - inLow[BodyDojiTrailingIdx] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyDojiTrailingIdx] - (inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inClose[BodyDojiTrailingIdx] : inOpen[BodyDojiTrailingIdx]) + ((inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inOpen[BodyDojiTrailingIdx] : inClose[BodyDojiTrailingIdx]) - inLow[BodyDojiTrailingIdx]) : 0.0f))));
            BodyShortPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyShortTrailingIdx] - inOpen[BodyShortTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyShortTrailingIdx] - inLow[BodyShortTrailingIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyShortTrailingIdx] - (inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inClose[BodyShortTrailingIdx] : inOpen[BodyShortTrailingIdx]) + ((inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inOpen[BodyShortTrailingIdx] : inClose[BodyShortTrailingIdx]) - inLow[BodyShortTrailingIdx]) : 0.0f))));
            ++BodyLongTrailingIdx;
            ++BodyDojiTrailingIdx;
            ++BodyShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlEveningStarLookback(double optInPenetration) {
        if (optInPenetration == -4.0E37) {
            optInPenetration = 0.3;
        } else if (optInPenetration < 0.0 || optInPenetration > 3.0E37) {
            return -1;
        }
        return (this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod) + 2;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlEveningStar(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, double optInPenetration, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInPenetration == -4.0E37) {
            optInPenetration = 0.3;
        } else if (optInPenetration < 0.0 || optInPenetration > 3.0E37) {
            return RetCode.BadParam;
        }
        lookbackTotal = this.cdlEveningStarLookback(optInPenetration);
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        BodyShortPeriodTotal = 0.0;
        BodyShortPeriodTotal2 = 0.0;
        BodyLongTrailingIdx = startIdx - 2 - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        BodyShortTrailingIdx = startIdx - 1 - this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod;
        i = BodyLongTrailingIdx;
        while (i < startIdx - 2) {
            BodyLongPeriodTotal += this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = BodyShortTrailingIdx;
        while (i < startIdx - 1) {
            BodyShortPeriodTotal += this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            BodyShortPeriodTotal2 += this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i + 1] - inOpen[i + 1]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i + 1] - inLow[i + 1] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i + 1] - (inClose[i + 1] >= inOpen[i + 1] ? inClose[i + 1] : inOpen[i + 1]) + ((inClose[i + 1] >= inOpen[i + 1] ? inOpen[i + 1] : inClose[i + 1]) - inLow[i + 1]) : 0.0));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i - 2] - inOpen[i - 2]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2) || (inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) != 1) ** GOTO lbl-1000
            v3 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v4 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyShortPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v5 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 <= v4 / v5)) ** GOTO lbl-1000
            v6 = inOpen[i - 1] < inClose[i - 1] ? inOpen[i - 1] : inClose[i - 1];
            v7 = inOpen[i - 2] > inClose[i - 2] ? inOpen[i - 2] : inClose[i - 2];
            if (!(v6 > v7)) ** GOTO lbl-1000
            v8 = Math.abs(inClose[i] - inOpen[i]);
            v9 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyShortPeriodTotal2 / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v10 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v8 > v9 / v10 && (inClose[i] >= inOpen[i] ? 1 : -1) == -1 && inClose[i] < inClose[i - 2] - Math.abs(inClose[i - 2] - inOpen[i - 2]) * optInPenetration) {
                outInteger[outIdx++] = -100;
            } else lbl-1000:
            // 4 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyLongPeriodTotal += (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx] - inOpen[BodyLongTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx] - inLow[BodyLongTrailingIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx] - (inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inClose[BodyLongTrailingIdx] : inOpen[BodyLongTrailingIdx]) + ((inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inOpen[BodyLongTrailingIdx] : inClose[BodyLongTrailingIdx]) - inLow[BodyLongTrailingIdx]) : 0.0)));
            BodyShortPeriodTotal += (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyShortTrailingIdx] - inOpen[BodyShortTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyShortTrailingIdx] - inLow[BodyShortTrailingIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyShortTrailingIdx] - (inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inClose[BodyShortTrailingIdx] : inOpen[BodyShortTrailingIdx]) + ((inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inOpen[BodyShortTrailingIdx] : inClose[BodyShortTrailingIdx]) - inLow[BodyShortTrailingIdx]) : 0.0)));
            BodyShortPeriodTotal2 += (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyShortTrailingIdx + 1] - inOpen[BodyShortTrailingIdx + 1]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyShortTrailingIdx + 1] - inLow[BodyShortTrailingIdx + 1] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyShortTrailingIdx + 1] - (inClose[BodyShortTrailingIdx + 1] >= inOpen[BodyShortTrailingIdx + 1] ? inClose[BodyShortTrailingIdx + 1] : inOpen[BodyShortTrailingIdx + 1]) + ((inClose[BodyShortTrailingIdx + 1] >= inOpen[BodyShortTrailingIdx + 1] ? inOpen[BodyShortTrailingIdx + 1] : inClose[BodyShortTrailingIdx + 1]) - inLow[BodyShortTrailingIdx + 1]) : 0.0)));
            ++BodyLongTrailingIdx;
            ++BodyShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlEveningStar(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, double optInPenetration, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInPenetration == -4.0E37) {
            optInPenetration = 0.3;
        } else if (optInPenetration < 0.0 || optInPenetration > 3.0E37) {
            return RetCode.BadParam;
        }
        lookbackTotal = this.cdlEveningStarLookback(optInPenetration);
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        BodyShortPeriodTotal = 0.0;
        BodyShortPeriodTotal2 = 0.0;
        BodyLongTrailingIdx = startIdx - 2 - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        BodyShortTrailingIdx = startIdx - 1 - this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod;
        i = BodyLongTrailingIdx;
        while (i < startIdx - 2) {
            BodyLongPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = BodyShortTrailingIdx;
        while (i < startIdx - 1) {
            BodyShortPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            BodyShortPeriodTotal2 += (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i + 1] - inOpen[i + 1]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i + 1] - inLow[i + 1] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i + 1] - (inClose[i + 1] >= inOpen[i + 1] ? inClose[i + 1] : inOpen[i + 1]) + ((inClose[i + 1] >= inOpen[i + 1] ? inOpen[i + 1] : inClose[i + 1]) - inLow[i + 1]) : 0.0f)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i - 2] - inOpen[i - 2]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2) || (inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) != 1) ** GOTO lbl-1000
            v3 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v4 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyShortPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v5 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 <= v4 / v5)) ** GOTO lbl-1000
            v6 = inOpen[i - 1] < inClose[i - 1] ? inOpen[i - 1] : inClose[i - 1];
            v7 = inOpen[i - 2] > inClose[i - 2] ? inOpen[i - 2] : inClose[i - 2];
            if (!(v6 > v7)) ** GOTO lbl-1000
            v8 = Math.abs(inClose[i] - inOpen[i]);
            v9 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyShortPeriodTotal2 / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v10 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v8 > v9 / v10 && (inClose[i] >= inOpen[i] ? 1 : -1) == -1 && (double)inClose[i] < (double)inClose[i - 2] - (double)Math.abs(inClose[i - 2] - inOpen[i - 2]) * optInPenetration) {
                outInteger[outIdx++] = -100;
            } else lbl-1000:
            // 4 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyLongPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx] - inOpen[BodyLongTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx] - inLow[BodyLongTrailingIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx] - (inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inClose[BodyLongTrailingIdx] : inOpen[BodyLongTrailingIdx]) + ((inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inOpen[BodyLongTrailingIdx] : inClose[BodyLongTrailingIdx]) - inLow[BodyLongTrailingIdx]) : 0.0f))));
            BodyShortPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyShortTrailingIdx] - inOpen[BodyShortTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyShortTrailingIdx] - inLow[BodyShortTrailingIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyShortTrailingIdx] - (inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inClose[BodyShortTrailingIdx] : inOpen[BodyShortTrailingIdx]) + ((inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inOpen[BodyShortTrailingIdx] : inClose[BodyShortTrailingIdx]) - inLow[BodyShortTrailingIdx]) : 0.0f))));
            BodyShortPeriodTotal2 += (double)((this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyShortTrailingIdx + 1] - inOpen[BodyShortTrailingIdx + 1]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyShortTrailingIdx + 1] - inLow[BodyShortTrailingIdx + 1] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyShortTrailingIdx + 1] - (inClose[BodyShortTrailingIdx + 1] >= inOpen[BodyShortTrailingIdx + 1] ? inClose[BodyShortTrailingIdx + 1] : inOpen[BodyShortTrailingIdx + 1]) + ((inClose[BodyShortTrailingIdx + 1] >= inOpen[BodyShortTrailingIdx + 1] ? inOpen[BodyShortTrailingIdx + 1] : inClose[BodyShortTrailingIdx + 1]) - inLow[BodyShortTrailingIdx + 1]) : 0.0f))));
            ++BodyLongTrailingIdx;
            ++BodyShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlGapSideSideWhiteLookback() {
        return (this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod) + 2;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlGapSideSideWhite(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlGapSideSideWhiteLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        NearPeriodTotal = 0.0;
        EqualPeriodTotal = 0.0;
        NearTrailingIdx = startIdx - this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod;
        EqualTrailingIdx = startIdx - this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod;
        i = NearTrailingIdx;
        while (i < startIdx) {
            NearPeriodTotal += this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0));
            ++i;
        }
        i = EqualTrailingIdx;
        while (i < startIdx) {
            EqualPeriodTotal += this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            block9: {
                if ((inOpen[i - 1] < inClose[i - 1] ? inOpen[i - 1] : inClose[i - 1]) > (inOpen[i - 2] > inClose[i - 2] ? inOpen[i - 2] : inClose[i - 2]) && (inOpen[i] < inClose[i] ? inOpen[i] : inClose[i]) > (inOpen[i - 2] > inClose[i - 2] ? inOpen[i - 2] : inClose[i - 2])) break block9;
                v0 = inOpen[i - 1] > inClose[i - 1] ? inOpen[i - 1] : inClose[i - 1];
                v1 = inOpen[i - 2] < inClose[i - 2] ? inOpen[i - 2] : inClose[i - 2];
                if (!(v0 < v1)) ** GOTO lbl-1000
                v2 = inOpen[i] > inClose[i] ? inOpen[i] : inClose[i];
                v3 = inOpen[i - 2] < inClose[i - 2] ? inOpen[i - 2] : inClose[i - 2];
                if (!(v2 < v3)) ** GOTO lbl-1000
            }
            if ((inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != 1 || (inClose[i] >= inOpen[i] ? 1 : -1) != 1) ** GOTO lbl-1000
            v4 = Math.abs(inClose[i] - inOpen[i]);
            v5 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v6 = this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v7 = this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v4 >= v5 - v6 / v7)) ** GOTO lbl-1000
            v8 = Math.abs(inClose[i] - inOpen[i]);
            v9 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v10 = this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v11 = this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v8 <= v9 + v10 / v11)) ** GOTO lbl-1000
            v12 = inOpen[i];
            v13 = inOpen[i - 1];
            v14 = this.candleSettings[CandleSettingType.Equal.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod != 0.0 ? EqualPeriodTotal / (double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v15 = this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v12 >= v13 - v14 / v15)) ** GOTO lbl-1000
            v16 = inOpen[i];
            v17 = inOpen[i - 1];
            v18 = this.candleSettings[CandleSettingType.Equal.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod != 0.0 ? EqualPeriodTotal / (double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v19 = this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v16 <= v17 + v18 / v19) {
                outInteger[outIdx++] = (inOpen[i - 1] < inClose[i - 1] ? inOpen[i - 1] : inClose[i - 1]) > (inOpen[i - 2] > inClose[i - 2] ? inOpen[i - 2] : inClose[i - 2]) ? 100 : -100;
            } else lbl-1000:
            // 7 sources

            {
                outInteger[outIdx++] = 0;
            }
            NearPeriodTotal += (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))) - (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[NearTrailingIdx - 1] - inOpen[NearTrailingIdx - 1]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[NearTrailingIdx - 1] - inLow[NearTrailingIdx - 1] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[NearTrailingIdx - 1] - (inClose[NearTrailingIdx - 1] >= inOpen[NearTrailingIdx - 1] ? inClose[NearTrailingIdx - 1] : inOpen[NearTrailingIdx - 1]) + ((inClose[NearTrailingIdx - 1] >= inOpen[NearTrailingIdx - 1] ? inOpen[NearTrailingIdx - 1] : inClose[NearTrailingIdx - 1]) - inLow[NearTrailingIdx - 1]) : 0.0)));
            EqualPeriodTotal += (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))) - (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[EqualTrailingIdx - 1] - inOpen[EqualTrailingIdx - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[EqualTrailingIdx - 1] - inLow[EqualTrailingIdx - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[EqualTrailingIdx - 1] - (inClose[EqualTrailingIdx - 1] >= inOpen[EqualTrailingIdx - 1] ? inClose[EqualTrailingIdx - 1] : inOpen[EqualTrailingIdx - 1]) + ((inClose[EqualTrailingIdx - 1] >= inOpen[EqualTrailingIdx - 1] ? inOpen[EqualTrailingIdx - 1] : inClose[EqualTrailingIdx - 1]) - inLow[EqualTrailingIdx - 1]) : 0.0)));
            ++NearTrailingIdx;
            ++EqualTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlGapSideSideWhite(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlGapSideSideWhiteLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        NearPeriodTotal = 0.0;
        EqualPeriodTotal = 0.0;
        NearTrailingIdx = startIdx - this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod;
        EqualTrailingIdx = startIdx - this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod;
        i = NearTrailingIdx;
        while (i < startIdx) {
            NearPeriodTotal += (double)(this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)));
            ++i;
        }
        i = EqualTrailingIdx;
        while (i < startIdx) {
            EqualPeriodTotal += (double)(this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            block9: {
                if ((inOpen[i - 1] < inClose[i - 1] ? inOpen[i - 1] : inClose[i - 1]) > (inOpen[i - 2] > inClose[i - 2] ? inOpen[i - 2] : inClose[i - 2]) && (inOpen[i] < inClose[i] ? inOpen[i] : inClose[i]) > (inOpen[i - 2] > inClose[i - 2] ? inOpen[i - 2] : inClose[i - 2])) break block9;
                v0 = inOpen[i - 1] > inClose[i - 1] ? inOpen[i - 1] : inClose[i - 1];
                v1 = inOpen[i - 2] < inClose[i - 2] ? inOpen[i - 2] : inClose[i - 2];
                if (!(v0 < v1)) ** GOTO lbl-1000
                v2 = inOpen[i] > inClose[i] ? inOpen[i] : inClose[i];
                v3 = inOpen[i - 2] < inClose[i - 2] ? inOpen[i - 2] : inClose[i - 2];
                if (!(v2 < v3)) ** GOTO lbl-1000
            }
            if ((inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != 1 || (inClose[i] >= inOpen[i] ? 1 : -1) != 1) ** GOTO lbl-1000
            v4 = Math.abs(inClose[i] - inOpen[i]);
            v5 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v6 = this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v7 = this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v4 >= v5 - v6 / v7)) ** GOTO lbl-1000
            v8 = Math.abs(inClose[i] - inOpen[i]);
            v9 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v10 = this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v11 = this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v8 <= v9 + v10 / v11)) ** GOTO lbl-1000
            v12 = inOpen[i];
            v13 = inOpen[i - 1];
            v14 = this.candleSettings[CandleSettingType.Equal.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod != 0.0 ? EqualPeriodTotal / (double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v15 = this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v12 >= v13 - v14 / v15)) ** GOTO lbl-1000
            v16 = inOpen[i];
            v17 = inOpen[i - 1];
            v18 = this.candleSettings[CandleSettingType.Equal.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod != 0.0 ? EqualPeriodTotal / (double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v19 = this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v16 <= v17 + v18 / v19) {
                outInteger[outIdx++] = (inOpen[i - 1] < inClose[i - 1] ? inOpen[i - 1] : inClose[i - 1]) > (inOpen[i - 2] > inClose[i - 2] ? inOpen[i - 2] : inClose[i - 2]) ? 100 : -100;
            } else lbl-1000:
            // 7 sources

            {
                outInteger[outIdx++] = 0;
            }
            NearPeriodTotal += (double)((this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))) - (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[NearTrailingIdx - 1] - inOpen[NearTrailingIdx - 1]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[NearTrailingIdx - 1] - inLow[NearTrailingIdx - 1] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[NearTrailingIdx - 1] - (inClose[NearTrailingIdx - 1] >= inOpen[NearTrailingIdx - 1] ? inClose[NearTrailingIdx - 1] : inOpen[NearTrailingIdx - 1]) + ((inClose[NearTrailingIdx - 1] >= inOpen[NearTrailingIdx - 1] ? inOpen[NearTrailingIdx - 1] : inClose[NearTrailingIdx - 1]) - inLow[NearTrailingIdx - 1]) : 0.0f))));
            EqualPeriodTotal += (double)((this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))) - (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[EqualTrailingIdx - 1] - inOpen[EqualTrailingIdx - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[EqualTrailingIdx - 1] - inLow[EqualTrailingIdx - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[EqualTrailingIdx - 1] - (inClose[EqualTrailingIdx - 1] >= inOpen[EqualTrailingIdx - 1] ? inClose[EqualTrailingIdx - 1] : inOpen[EqualTrailingIdx - 1]) + ((inClose[EqualTrailingIdx - 1] >= inOpen[EqualTrailingIdx - 1] ? inOpen[EqualTrailingIdx - 1] : inClose[EqualTrailingIdx - 1]) - inLow[EqualTrailingIdx - 1]) : 0.0f))));
            ++NearTrailingIdx;
            ++EqualTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlGravestoneDojiLookback() {
        return this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlGravestoneDoji(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlGravestoneDojiLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyDojiPeriodTotal = 0.0;
        BodyDojiTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod;
        ShadowVeryShortPeriodTotal = 0.0;
        ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        i = BodyDojiTrailingIdx;
        while (i < startIdx) {
            BodyDojiPeriodTotal += this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = ShadowVeryShortTrailingIdx;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal += this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i] - inOpen[i]);
            v1 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod != 0.0 ? BodyDojiPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 <= v1 / v2)) ** GOTO lbl-1000
            v3 = (inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i];
            v4 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v5 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 < v4 / v5)) ** GOTO lbl-1000
            v6 = inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]);
            v7 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v8 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v6 > v7 / v8) {
                outInteger[outIdx++] = 100;
            } else lbl-1000:
            // 3 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyDojiPeriodTotal += (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyDojiTrailingIdx] - inOpen[BodyDojiTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyDojiTrailingIdx] - inLow[BodyDojiTrailingIdx] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyDojiTrailingIdx] - (inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inClose[BodyDojiTrailingIdx] : inOpen[BodyDojiTrailingIdx]) + ((inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inOpen[BodyDojiTrailingIdx] : inClose[BodyDojiTrailingIdx]) - inLow[BodyDojiTrailingIdx]) : 0.0)));
            ShadowVeryShortPeriodTotal += (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx] - inOpen[ShadowVeryShortTrailingIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx] - inLow[ShadowVeryShortTrailingIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx] - (inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inClose[ShadowVeryShortTrailingIdx] : inOpen[ShadowVeryShortTrailingIdx]) + ((inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inOpen[ShadowVeryShortTrailingIdx] : inClose[ShadowVeryShortTrailingIdx]) - inLow[ShadowVeryShortTrailingIdx]) : 0.0)));
            ++BodyDojiTrailingIdx;
            ++ShadowVeryShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlGravestoneDoji(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlGravestoneDojiLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyDojiPeriodTotal = 0.0;
        BodyDojiTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod;
        ShadowVeryShortPeriodTotal = 0.0;
        ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        i = BodyDojiTrailingIdx;
        while (i < startIdx) {
            BodyDojiPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = ShadowVeryShortTrailingIdx;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal += (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i] - inOpen[i]);
            v1 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod != 0.0 ? BodyDojiPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 <= v1 / v2)) ** GOTO lbl-1000
            v3 = (inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i];
            v4 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v5 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 < v4 / v5)) ** GOTO lbl-1000
            v6 = inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]);
            v7 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v8 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v6 > v7 / v8) {
                outInteger[outIdx++] = 100;
            } else lbl-1000:
            // 3 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyDojiPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyDojiTrailingIdx] - inOpen[BodyDojiTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyDojiTrailingIdx] - inLow[BodyDojiTrailingIdx] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyDojiTrailingIdx] - (inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inClose[BodyDojiTrailingIdx] : inOpen[BodyDojiTrailingIdx]) + ((inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inOpen[BodyDojiTrailingIdx] : inClose[BodyDojiTrailingIdx]) - inLow[BodyDojiTrailingIdx]) : 0.0f))));
            ShadowVeryShortPeriodTotal += (double)((this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx] - inOpen[ShadowVeryShortTrailingIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx] - inLow[ShadowVeryShortTrailingIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx] - (inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inClose[ShadowVeryShortTrailingIdx] : inOpen[ShadowVeryShortTrailingIdx]) + ((inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inOpen[ShadowVeryShortTrailingIdx] : inClose[ShadowVeryShortTrailingIdx]) - inLow[ShadowVeryShortTrailingIdx]) : 0.0f))));
            ++BodyDojiTrailingIdx;
            ++ShadowVeryShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlHammerLookback() {
        return (((this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod) > this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod ? (this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod) : this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod) > this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod ? ((this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod) > this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod ? (this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod) : this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod) : this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod) + 1;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlHammer(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlHammerLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyPeriodTotal = 0.0;
        BodyTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod;
        ShadowLongPeriodTotal = 0.0;
        ShadowLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod;
        ShadowVeryShortPeriodTotal = 0.0;
        ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        NearPeriodTotal = 0.0;
        NearTrailingIdx = startIdx - 1 - this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod;
        i = BodyTrailingIdx;
        while (i < startIdx) {
            BodyPeriodTotal += this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = ShadowLongTrailingIdx;
        while (i < startIdx) {
            ShadowLongPeriodTotal += this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = ShadowVeryShortTrailingIdx;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal += this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = NearTrailingIdx;
        while (i < startIdx - 1) {
            NearPeriodTotal += this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i] - inOpen[i]);
            v1 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 < v1 / v2)) ** GOTO lbl-1000
            v3 = (inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i];
            v4 = this.candleSettings[CandleSettingType.ShadowLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod != 0.0 ? ShadowLongPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v5 = this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 > v4 / v5)) ** GOTO lbl-1000
            v6 = inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]);
            v7 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v8 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v6 < v7 / v8)) ** GOTO lbl-1000
            v9 = inClose[i] < inOpen[i] ? inClose[i] : inOpen[i];
            v10 = inLow[i - 1];
            v11 = this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v12 = this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v9 <= v10 + v11 / v12) {
                outInteger[outIdx++] = 100;
            } else lbl-1000:
            // 4 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyPeriodTotal += (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyTrailingIdx] - inOpen[BodyTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyTrailingIdx] - inLow[BodyTrailingIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyTrailingIdx] - (inClose[BodyTrailingIdx] >= inOpen[BodyTrailingIdx] ? inClose[BodyTrailingIdx] : inOpen[BodyTrailingIdx]) + ((inClose[BodyTrailingIdx] >= inOpen[BodyTrailingIdx] ? inOpen[BodyTrailingIdx] : inClose[BodyTrailingIdx]) - inLow[BodyTrailingIdx]) : 0.0)));
            ShadowLongPeriodTotal += (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowLongTrailingIdx] - inOpen[ShadowLongTrailingIdx]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowLongTrailingIdx] - inLow[ShadowLongTrailingIdx] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowLongTrailingIdx] - (inClose[ShadowLongTrailingIdx] >= inOpen[ShadowLongTrailingIdx] ? inClose[ShadowLongTrailingIdx] : inOpen[ShadowLongTrailingIdx]) + ((inClose[ShadowLongTrailingIdx] >= inOpen[ShadowLongTrailingIdx] ? inOpen[ShadowLongTrailingIdx] : inClose[ShadowLongTrailingIdx]) - inLow[ShadowLongTrailingIdx]) : 0.0)));
            ShadowVeryShortPeriodTotal += (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx] - inOpen[ShadowVeryShortTrailingIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx] - inLow[ShadowVeryShortTrailingIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx] - (inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inClose[ShadowVeryShortTrailingIdx] : inOpen[ShadowVeryShortTrailingIdx]) + ((inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inOpen[ShadowVeryShortTrailingIdx] : inClose[ShadowVeryShortTrailingIdx]) - inLow[ShadowVeryShortTrailingIdx]) : 0.0)));
            NearPeriodTotal += (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))) - (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[NearTrailingIdx] - inOpen[NearTrailingIdx]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[NearTrailingIdx] - inLow[NearTrailingIdx] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[NearTrailingIdx] - (inClose[NearTrailingIdx] >= inOpen[NearTrailingIdx] ? inClose[NearTrailingIdx] : inOpen[NearTrailingIdx]) + ((inClose[NearTrailingIdx] >= inOpen[NearTrailingIdx] ? inOpen[NearTrailingIdx] : inClose[NearTrailingIdx]) - inLow[NearTrailingIdx]) : 0.0)));
            ++BodyTrailingIdx;
            ++ShadowLongTrailingIdx;
            ++ShadowVeryShortTrailingIdx;
            ++NearTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlHammer(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlHammerLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyPeriodTotal = 0.0;
        BodyTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod;
        ShadowLongPeriodTotal = 0.0;
        ShadowLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod;
        ShadowVeryShortPeriodTotal = 0.0;
        ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        NearPeriodTotal = 0.0;
        NearTrailingIdx = startIdx - 1 - this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod;
        i = BodyTrailingIdx;
        while (i < startIdx) {
            BodyPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = ShadowLongTrailingIdx;
        while (i < startIdx) {
            ShadowLongPeriodTotal += (double)(this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = ShadowVeryShortTrailingIdx;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal += (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = NearTrailingIdx;
        while (i < startIdx - 1) {
            NearPeriodTotal += (double)(this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i] - inOpen[i]);
            v1 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 < v1 / v2)) ** GOTO lbl-1000
            v3 = (inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i];
            v4 = this.candleSettings[CandleSettingType.ShadowLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod != 0.0 ? ShadowLongPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v5 = this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 > v4 / v5)) ** GOTO lbl-1000
            v6 = inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]);
            v7 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v8 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v6 < v7 / v8)) ** GOTO lbl-1000
            v9 = inClose[i] < inOpen[i] ? inClose[i] : inOpen[i];
            v10 = inLow[i - 1];
            v11 = this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v12 = this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v9 <= v10 + v11 / v12) {
                outInteger[outIdx++] = 100;
            } else lbl-1000:
            // 4 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyTrailingIdx] - inOpen[BodyTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyTrailingIdx] - inLow[BodyTrailingIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyTrailingIdx] - (inClose[BodyTrailingIdx] >= inOpen[BodyTrailingIdx] ? inClose[BodyTrailingIdx] : inOpen[BodyTrailingIdx]) + ((inClose[BodyTrailingIdx] >= inOpen[BodyTrailingIdx] ? inOpen[BodyTrailingIdx] : inClose[BodyTrailingIdx]) - inLow[BodyTrailingIdx]) : 0.0f))));
            ShadowLongPeriodTotal += (double)((this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowLongTrailingIdx] - inOpen[ShadowLongTrailingIdx]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowLongTrailingIdx] - inLow[ShadowLongTrailingIdx] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowLongTrailingIdx] - (inClose[ShadowLongTrailingIdx] >= inOpen[ShadowLongTrailingIdx] ? inClose[ShadowLongTrailingIdx] : inOpen[ShadowLongTrailingIdx]) + ((inClose[ShadowLongTrailingIdx] >= inOpen[ShadowLongTrailingIdx] ? inOpen[ShadowLongTrailingIdx] : inClose[ShadowLongTrailingIdx]) - inLow[ShadowLongTrailingIdx]) : 0.0f))));
            ShadowVeryShortPeriodTotal += (double)((this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx] - inOpen[ShadowVeryShortTrailingIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx] - inLow[ShadowVeryShortTrailingIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx] - (inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inClose[ShadowVeryShortTrailingIdx] : inOpen[ShadowVeryShortTrailingIdx]) + ((inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inOpen[ShadowVeryShortTrailingIdx] : inClose[ShadowVeryShortTrailingIdx]) - inLow[ShadowVeryShortTrailingIdx]) : 0.0f))));
            NearPeriodTotal += (double)((this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))) - (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[NearTrailingIdx] - inOpen[NearTrailingIdx]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[NearTrailingIdx] - inLow[NearTrailingIdx] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[NearTrailingIdx] - (inClose[NearTrailingIdx] >= inOpen[NearTrailingIdx] ? inClose[NearTrailingIdx] : inOpen[NearTrailingIdx]) + ((inClose[NearTrailingIdx] >= inOpen[NearTrailingIdx] ? inOpen[NearTrailingIdx] : inClose[NearTrailingIdx]) - inLow[NearTrailingIdx]) : 0.0f))));
            ++BodyTrailingIdx;
            ++ShadowLongTrailingIdx;
            ++ShadowVeryShortTrailingIdx;
            ++NearTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlHangingManLookback() {
        return (((this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod) > this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod ? (this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod) : this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod) > this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod ? ((this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod) > this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod ? (this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod) : this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod) : this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod) + 1;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlHangingMan(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlHangingManLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyPeriodTotal = 0.0;
        BodyTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod;
        ShadowLongPeriodTotal = 0.0;
        ShadowLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod;
        ShadowVeryShortPeriodTotal = 0.0;
        ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        NearPeriodTotal = 0.0;
        NearTrailingIdx = startIdx - 1 - this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod;
        i = BodyTrailingIdx;
        while (i < startIdx) {
            BodyPeriodTotal += this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = ShadowLongTrailingIdx;
        while (i < startIdx) {
            ShadowLongPeriodTotal += this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = ShadowVeryShortTrailingIdx;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal += this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = NearTrailingIdx;
        while (i < startIdx - 1) {
            NearPeriodTotal += this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i] - inOpen[i]);
            v1 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 < v1 / v2)) ** GOTO lbl-1000
            v3 = (inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i];
            v4 = this.candleSettings[CandleSettingType.ShadowLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod != 0.0 ? ShadowLongPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v5 = this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 > v4 / v5)) ** GOTO lbl-1000
            v6 = inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]);
            v7 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v8 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v6 < v7 / v8)) ** GOTO lbl-1000
            v9 = inClose[i] < inOpen[i] ? inClose[i] : inOpen[i];
            v10 = inHigh[i - 1];
            v11 = this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v12 = this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v9 >= v10 - v11 / v12) {
                outInteger[outIdx++] = -100;
            } else lbl-1000:
            // 4 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyPeriodTotal += (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyTrailingIdx] - inOpen[BodyTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyTrailingIdx] - inLow[BodyTrailingIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyTrailingIdx] - (inClose[BodyTrailingIdx] >= inOpen[BodyTrailingIdx] ? inClose[BodyTrailingIdx] : inOpen[BodyTrailingIdx]) + ((inClose[BodyTrailingIdx] >= inOpen[BodyTrailingIdx] ? inOpen[BodyTrailingIdx] : inClose[BodyTrailingIdx]) - inLow[BodyTrailingIdx]) : 0.0)));
            ShadowLongPeriodTotal += (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowLongTrailingIdx] - inOpen[ShadowLongTrailingIdx]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowLongTrailingIdx] - inLow[ShadowLongTrailingIdx] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowLongTrailingIdx] - (inClose[ShadowLongTrailingIdx] >= inOpen[ShadowLongTrailingIdx] ? inClose[ShadowLongTrailingIdx] : inOpen[ShadowLongTrailingIdx]) + ((inClose[ShadowLongTrailingIdx] >= inOpen[ShadowLongTrailingIdx] ? inOpen[ShadowLongTrailingIdx] : inClose[ShadowLongTrailingIdx]) - inLow[ShadowLongTrailingIdx]) : 0.0)));
            ShadowVeryShortPeriodTotal += (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx] - inOpen[ShadowVeryShortTrailingIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx] - inLow[ShadowVeryShortTrailingIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx] - (inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inClose[ShadowVeryShortTrailingIdx] : inOpen[ShadowVeryShortTrailingIdx]) + ((inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inOpen[ShadowVeryShortTrailingIdx] : inClose[ShadowVeryShortTrailingIdx]) - inLow[ShadowVeryShortTrailingIdx]) : 0.0)));
            NearPeriodTotal += (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))) - (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[NearTrailingIdx] - inOpen[NearTrailingIdx]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[NearTrailingIdx] - inLow[NearTrailingIdx] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[NearTrailingIdx] - (inClose[NearTrailingIdx] >= inOpen[NearTrailingIdx] ? inClose[NearTrailingIdx] : inOpen[NearTrailingIdx]) + ((inClose[NearTrailingIdx] >= inOpen[NearTrailingIdx] ? inOpen[NearTrailingIdx] : inClose[NearTrailingIdx]) - inLow[NearTrailingIdx]) : 0.0)));
            ++BodyTrailingIdx;
            ++ShadowLongTrailingIdx;
            ++ShadowVeryShortTrailingIdx;
            ++NearTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlHangingMan(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlHangingManLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyPeriodTotal = 0.0;
        BodyTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod;
        ShadowLongPeriodTotal = 0.0;
        ShadowLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod;
        ShadowVeryShortPeriodTotal = 0.0;
        ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        NearPeriodTotal = 0.0;
        NearTrailingIdx = startIdx - 1 - this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod;
        i = BodyTrailingIdx;
        while (i < startIdx) {
            BodyPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = ShadowLongTrailingIdx;
        while (i < startIdx) {
            ShadowLongPeriodTotal += (double)(this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = ShadowVeryShortTrailingIdx;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal += (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = NearTrailingIdx;
        while (i < startIdx - 1) {
            NearPeriodTotal += (double)(this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i] - inOpen[i]);
            v1 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 < v1 / v2)) ** GOTO lbl-1000
            v3 = (inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i];
            v4 = this.candleSettings[CandleSettingType.ShadowLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod != 0.0 ? ShadowLongPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v5 = this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 > v4 / v5)) ** GOTO lbl-1000
            v6 = inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]);
            v7 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v8 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v6 < v7 / v8)) ** GOTO lbl-1000
            v9 = inClose[i] < inOpen[i] ? inClose[i] : inOpen[i];
            v10 = inHigh[i - 1];
            v11 = this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v12 = this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v9 >= v10 - v11 / v12) {
                outInteger[outIdx++] = -100;
            } else lbl-1000:
            // 4 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyTrailingIdx] - inOpen[BodyTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyTrailingIdx] - inLow[BodyTrailingIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyTrailingIdx] - (inClose[BodyTrailingIdx] >= inOpen[BodyTrailingIdx] ? inClose[BodyTrailingIdx] : inOpen[BodyTrailingIdx]) + ((inClose[BodyTrailingIdx] >= inOpen[BodyTrailingIdx] ? inOpen[BodyTrailingIdx] : inClose[BodyTrailingIdx]) - inLow[BodyTrailingIdx]) : 0.0f))));
            ShadowLongPeriodTotal += (double)((this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowLongTrailingIdx] - inOpen[ShadowLongTrailingIdx]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowLongTrailingIdx] - inLow[ShadowLongTrailingIdx] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowLongTrailingIdx] - (inClose[ShadowLongTrailingIdx] >= inOpen[ShadowLongTrailingIdx] ? inClose[ShadowLongTrailingIdx] : inOpen[ShadowLongTrailingIdx]) + ((inClose[ShadowLongTrailingIdx] >= inOpen[ShadowLongTrailingIdx] ? inOpen[ShadowLongTrailingIdx] : inClose[ShadowLongTrailingIdx]) - inLow[ShadowLongTrailingIdx]) : 0.0f))));
            ShadowVeryShortPeriodTotal += (double)((this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx] - inOpen[ShadowVeryShortTrailingIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx] - inLow[ShadowVeryShortTrailingIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx] - (inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inClose[ShadowVeryShortTrailingIdx] : inOpen[ShadowVeryShortTrailingIdx]) + ((inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inOpen[ShadowVeryShortTrailingIdx] : inClose[ShadowVeryShortTrailingIdx]) - inLow[ShadowVeryShortTrailingIdx]) : 0.0f))));
            NearPeriodTotal += (double)((this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))) - (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[NearTrailingIdx] - inOpen[NearTrailingIdx]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[NearTrailingIdx] - inLow[NearTrailingIdx] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[NearTrailingIdx] - (inClose[NearTrailingIdx] >= inOpen[NearTrailingIdx] ? inClose[NearTrailingIdx] : inOpen[NearTrailingIdx]) + ((inClose[NearTrailingIdx] >= inOpen[NearTrailingIdx] ? inOpen[NearTrailingIdx] : inClose[NearTrailingIdx]) - inLow[NearTrailingIdx]) : 0.0f))));
            ++BodyTrailingIdx;
            ++ShadowLongTrailingIdx;
            ++ShadowVeryShortTrailingIdx;
            ++NearTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlHaramiLookback() {
        return (this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod) + 1;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlHarami(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlHaramiLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        BodyShortPeriodTotal = 0.0;
        BodyLongTrailingIdx = startIdx - 1 - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        BodyShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod;
        i = BodyLongTrailingIdx;
        while (i < startIdx - 1) {
            BodyLongPeriodTotal += this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = BodyShortTrailingIdx;
        while (i < startIdx) {
            BodyShortPeriodTotal += this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2)) ** GOTO lbl-1000
            v3 = Math.abs(inClose[i] - inOpen[i]);
            v4 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyShortPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v5 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 <= v4 / v5)) ** GOTO lbl-1000
            v6 = inClose[i] > inOpen[i] ? inClose[i] : inOpen[i];
            v7 = inClose[i - 1] > inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1];
            if (!(v6 < v7)) ** GOTO lbl-1000
            v8 = inClose[i] < inOpen[i] ? inClose[i] : inOpen[i];
            v9 = inClose[i - 1] < inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1];
            if (v8 > v9) {
                outInteger[outIdx++] = -(inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) * 100;
            } else lbl-1000:
            // 4 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyLongPeriodTotal += (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx] - inOpen[BodyLongTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx] - inLow[BodyLongTrailingIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx] - (inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inClose[BodyLongTrailingIdx] : inOpen[BodyLongTrailingIdx]) + ((inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inOpen[BodyLongTrailingIdx] : inClose[BodyLongTrailingIdx]) - inLow[BodyLongTrailingIdx]) : 0.0)));
            BodyShortPeriodTotal += (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyShortTrailingIdx] - inOpen[BodyShortTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyShortTrailingIdx] - inLow[BodyShortTrailingIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyShortTrailingIdx] - (inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inClose[BodyShortTrailingIdx] : inOpen[BodyShortTrailingIdx]) + ((inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inOpen[BodyShortTrailingIdx] : inClose[BodyShortTrailingIdx]) - inLow[BodyShortTrailingIdx]) : 0.0)));
            ++BodyLongTrailingIdx;
            ++BodyShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlHarami(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlHaramiLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        BodyShortPeriodTotal = 0.0;
        BodyLongTrailingIdx = startIdx - 1 - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        BodyShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod;
        i = BodyLongTrailingIdx;
        while (i < startIdx - 1) {
            BodyLongPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = BodyShortTrailingIdx;
        while (i < startIdx) {
            BodyShortPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2)) ** GOTO lbl-1000
            v3 = Math.abs(inClose[i] - inOpen[i]);
            v4 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyShortPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v5 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 <= v4 / v5)) ** GOTO lbl-1000
            v6 = inClose[i] > inOpen[i] ? inClose[i] : inOpen[i];
            v7 = inClose[i - 1] > inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1];
            if (!(v6 < v7)) ** GOTO lbl-1000
            v8 = inClose[i] < inOpen[i] ? inClose[i] : inOpen[i];
            v9 = inClose[i - 1] < inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1];
            if (v8 > v9) {
                outInteger[outIdx++] = -(inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) * 100;
            } else lbl-1000:
            // 4 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyLongPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx] - inOpen[BodyLongTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx] - inLow[BodyLongTrailingIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx] - (inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inClose[BodyLongTrailingIdx] : inOpen[BodyLongTrailingIdx]) + ((inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inOpen[BodyLongTrailingIdx] : inClose[BodyLongTrailingIdx]) - inLow[BodyLongTrailingIdx]) : 0.0f))));
            BodyShortPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyShortTrailingIdx] - inOpen[BodyShortTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyShortTrailingIdx] - inLow[BodyShortTrailingIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyShortTrailingIdx] - (inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inClose[BodyShortTrailingIdx] : inOpen[BodyShortTrailingIdx]) + ((inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inOpen[BodyShortTrailingIdx] : inClose[BodyShortTrailingIdx]) - inLow[BodyShortTrailingIdx]) : 0.0f))));
            ++BodyLongTrailingIdx;
            ++BodyShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlHaramiCrossLookback() {
        return (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod) + 1;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlHaramiCross(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlHaramiCrossLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        BodyDojiPeriodTotal = 0.0;
        BodyLongTrailingIdx = startIdx - 1 - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        BodyDojiTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod;
        i = BodyLongTrailingIdx;
        while (i < startIdx - 1) {
            BodyLongPeriodTotal += this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = BodyDojiTrailingIdx;
        while (i < startIdx) {
            BodyDojiPeriodTotal += this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2)) ** GOTO lbl-1000
            v3 = Math.abs(inClose[i] - inOpen[i]);
            v4 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod != 0.0 ? BodyDojiPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v5 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 <= v4 / v5)) ** GOTO lbl-1000
            v6 = inClose[i] > inOpen[i] ? inClose[i] : inOpen[i];
            v7 = inClose[i - 1] > inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1];
            if (!(v6 < v7)) ** GOTO lbl-1000
            v8 = inClose[i] < inOpen[i] ? inClose[i] : inOpen[i];
            v9 = inClose[i - 1] < inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1];
            if (v8 > v9) {
                outInteger[outIdx++] = -(inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) * 100;
            } else lbl-1000:
            // 4 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyLongPeriodTotal += (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx] - inOpen[BodyLongTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx] - inLow[BodyLongTrailingIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx] - (inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inClose[BodyLongTrailingIdx] : inOpen[BodyLongTrailingIdx]) + ((inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inOpen[BodyLongTrailingIdx] : inClose[BodyLongTrailingIdx]) - inLow[BodyLongTrailingIdx]) : 0.0)));
            BodyDojiPeriodTotal += (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyDojiTrailingIdx] - inOpen[BodyDojiTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyDojiTrailingIdx] - inLow[BodyDojiTrailingIdx] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyDojiTrailingIdx] - (inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inClose[BodyDojiTrailingIdx] : inOpen[BodyDojiTrailingIdx]) + ((inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inOpen[BodyDojiTrailingIdx] : inClose[BodyDojiTrailingIdx]) - inLow[BodyDojiTrailingIdx]) : 0.0)));
            ++BodyLongTrailingIdx;
            ++BodyDojiTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlHaramiCross(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlHaramiCrossLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        BodyDojiPeriodTotal = 0.0;
        BodyLongTrailingIdx = startIdx - 1 - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        BodyDojiTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod;
        i = BodyLongTrailingIdx;
        while (i < startIdx - 1) {
            BodyLongPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = BodyDojiTrailingIdx;
        while (i < startIdx) {
            BodyDojiPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2)) ** GOTO lbl-1000
            v3 = Math.abs(inClose[i] - inOpen[i]);
            v4 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod != 0.0 ? BodyDojiPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v5 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 <= v4 / v5)) ** GOTO lbl-1000
            v6 = inClose[i] > inOpen[i] ? inClose[i] : inOpen[i];
            v7 = inClose[i - 1] > inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1];
            if (!(v6 < v7)) ** GOTO lbl-1000
            v8 = inClose[i] < inOpen[i] ? inClose[i] : inOpen[i];
            v9 = inClose[i - 1] < inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1];
            if (v8 > v9) {
                outInteger[outIdx++] = -(inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) * 100;
            } else lbl-1000:
            // 4 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyLongPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx] - inOpen[BodyLongTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx] - inLow[BodyLongTrailingIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx] - (inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inClose[BodyLongTrailingIdx] : inOpen[BodyLongTrailingIdx]) + ((inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inOpen[BodyLongTrailingIdx] : inClose[BodyLongTrailingIdx]) - inLow[BodyLongTrailingIdx]) : 0.0f))));
            BodyDojiPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyDojiTrailingIdx] - inOpen[BodyDojiTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyDojiTrailingIdx] - inLow[BodyDojiTrailingIdx] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyDojiTrailingIdx] - (inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inClose[BodyDojiTrailingIdx] : inOpen[BodyDojiTrailingIdx]) + ((inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inOpen[BodyDojiTrailingIdx] : inClose[BodyDojiTrailingIdx]) - inLow[BodyDojiTrailingIdx]) : 0.0f))));
            ++BodyLongTrailingIdx;
            ++BodyDojiTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlHignWaveLookback() {
        return this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].avgPeriod;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlHignWave(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlHignWaveLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyPeriodTotal = 0.0;
        BodyTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod;
        ShadowPeriodTotal = 0.0;
        ShadowTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].avgPeriod;
        i = BodyTrailingIdx;
        while (i < startIdx) {
            BodyPeriodTotal += this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = ShadowTrailingIdx;
        while (i < startIdx) {
            ShadowPeriodTotal += this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i] - inOpen[i]);
            v1 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 < v1 / v2)) ** GOTO lbl-1000
            v3 = inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]);
            v4 = this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].avgPeriod != 0.0 ? ShadowPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v5 = this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 > v4 / v5)) ** GOTO lbl-1000
            v6 = (inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i];
            v7 = this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].avgPeriod != 0.0 ? ShadowPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v8 = this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v6 > v7 / v8) {
                outInteger[outIdx++] = (inClose[i] >= inOpen[i] ? 1 : -1) * 100;
            } else lbl-1000:
            // 3 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyPeriodTotal += (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyTrailingIdx] - inOpen[BodyTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyTrailingIdx] - inLow[BodyTrailingIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyTrailingIdx] - (inClose[BodyTrailingIdx] >= inOpen[BodyTrailingIdx] ? inClose[BodyTrailingIdx] : inOpen[BodyTrailingIdx]) + ((inClose[BodyTrailingIdx] >= inOpen[BodyTrailingIdx] ? inOpen[BodyTrailingIdx] : inClose[BodyTrailingIdx]) - inLow[BodyTrailingIdx]) : 0.0)));
            ShadowPeriodTotal += (this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowTrailingIdx] - inOpen[ShadowTrailingIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowTrailingIdx] - inLow[ShadowTrailingIdx] : (this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowTrailingIdx] - (inClose[ShadowTrailingIdx] >= inOpen[ShadowTrailingIdx] ? inClose[ShadowTrailingIdx] : inOpen[ShadowTrailingIdx]) + ((inClose[ShadowTrailingIdx] >= inOpen[ShadowTrailingIdx] ? inOpen[ShadowTrailingIdx] : inClose[ShadowTrailingIdx]) - inLow[ShadowTrailingIdx]) : 0.0)));
            ++BodyTrailingIdx;
            ++ShadowTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlHignWave(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlHignWaveLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyPeriodTotal = 0.0;
        BodyTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod;
        ShadowPeriodTotal = 0.0;
        ShadowTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].avgPeriod;
        i = BodyTrailingIdx;
        while (i < startIdx) {
            BodyPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = ShadowTrailingIdx;
        while (i < startIdx) {
            ShadowPeriodTotal += (double)(this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i] - inOpen[i]);
            v1 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 < v1 / v2)) ** GOTO lbl-1000
            v3 = inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]);
            v4 = this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].avgPeriod != 0.0 ? ShadowPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v5 = this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 > v4 / v5)) ** GOTO lbl-1000
            v6 = (inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i];
            v7 = this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].avgPeriod != 0.0 ? ShadowPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v8 = this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v6 > v7 / v8) {
                outInteger[outIdx++] = (inClose[i] >= inOpen[i] ? 1 : -1) * 100;
            } else lbl-1000:
            // 3 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyTrailingIdx] - inOpen[BodyTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyTrailingIdx] - inLow[BodyTrailingIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyTrailingIdx] - (inClose[BodyTrailingIdx] >= inOpen[BodyTrailingIdx] ? inClose[BodyTrailingIdx] : inOpen[BodyTrailingIdx]) + ((inClose[BodyTrailingIdx] >= inOpen[BodyTrailingIdx] ? inOpen[BodyTrailingIdx] : inClose[BodyTrailingIdx]) - inLow[BodyTrailingIdx]) : 0.0f))));
            ShadowPeriodTotal += (double)((this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowTrailingIdx] - inOpen[ShadowTrailingIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowTrailingIdx] - inLow[ShadowTrailingIdx] : (this.candleSettings[CandleSettingType.ShadowVeryLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowTrailingIdx] - (inClose[ShadowTrailingIdx] >= inOpen[ShadowTrailingIdx] ? inClose[ShadowTrailingIdx] : inOpen[ShadowTrailingIdx]) + ((inClose[ShadowTrailingIdx] >= inOpen[ShadowTrailingIdx] ? inOpen[ShadowTrailingIdx] : inClose[ShadowTrailingIdx]) - inLow[ShadowTrailingIdx]) : 0.0f))));
            ++BodyTrailingIdx;
            ++ShadowTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlHikkakeLookback() {
        return 5;
    }

    public RetCode cdlHikkake(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        int lookbackTotal = this.cdlHikkakeLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        int patternIdx = 0;
        int patternResult = 0;
        int i = startIdx - 3;
        while (i < startIdx) {
            if (inHigh[i - 1] < inHigh[i - 2] && inLow[i - 1] > inLow[i - 2] && (inHigh[i] < inHigh[i - 1] && inLow[i] < inLow[i - 1] || inHigh[i] > inHigh[i - 1] && inLow[i] > inLow[i - 1])) {
                patternResult = 100 * (inHigh[i] < inHigh[i - 1] ? 1 : -1);
                patternIdx = i;
            } else if (i <= patternIdx + 3 && (patternResult > 0 && inClose[i] > inHigh[patternIdx - 1] || patternResult < 0 && inClose[i] < inLow[patternIdx - 1])) {
                patternIdx = 0;
            }
            ++i;
        }
        i = startIdx;
        int outIdx = 0;
        do {
            if (inHigh[i - 1] < inHigh[i - 2] && inLow[i - 1] > inLow[i - 2] && (inHigh[i] < inHigh[i - 1] && inLow[i] < inLow[i - 1] || inHigh[i] > inHigh[i - 1] && inLow[i] > inLow[i - 1])) {
                patternResult = 100 * (inHigh[i] < inHigh[i - 1] ? 1 : -1);
                patternIdx = i;
                outInteger[outIdx++] = patternResult;
                continue;
            }
            if (i <= patternIdx + 3 && (patternResult > 0 && inClose[i] > inHigh[patternIdx - 1] || patternResult < 0 && inClose[i] < inLow[patternIdx - 1])) {
                outInteger[outIdx++] = patternResult + 100 * (patternResult > 0 ? 1 : -1);
                patternIdx = 0;
                continue;
            }
            outInteger[outIdx++] = 0;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public RetCode cdlHikkake(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        int lookbackTotal = this.cdlHikkakeLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        int patternIdx = 0;
        int patternResult = 0;
        int i = startIdx - 3;
        while (i < startIdx) {
            if (inHigh[i - 1] < inHigh[i - 2] && inLow[i - 1] > inLow[i - 2] && (inHigh[i] < inHigh[i - 1] && inLow[i] < inLow[i - 1] || inHigh[i] > inHigh[i - 1] && inLow[i] > inLow[i - 1])) {
                patternResult = 100 * (inHigh[i] < inHigh[i - 1] ? 1 : -1);
                patternIdx = i;
            } else if (i <= patternIdx + 3 && (patternResult > 0 && inClose[i] > inHigh[patternIdx - 1] || patternResult < 0 && inClose[i] < inLow[patternIdx - 1])) {
                patternIdx = 0;
            }
            ++i;
        }
        i = startIdx;
        int outIdx = 0;
        do {
            if (inHigh[i - 1] < inHigh[i - 2] && inLow[i - 1] > inLow[i - 2] && (inHigh[i] < inHigh[i - 1] && inLow[i] < inLow[i - 1] || inHigh[i] > inHigh[i - 1] && inLow[i] > inLow[i - 1])) {
                patternResult = 100 * (inHigh[i] < inHigh[i - 1] ? 1 : -1);
                patternIdx = i;
                outInteger[outIdx++] = patternResult;
                continue;
            }
            if (i <= patternIdx + 3 && (patternResult > 0 && inClose[i] > inHigh[patternIdx - 1] || patternResult < 0 && inClose[i] < inLow[patternIdx - 1])) {
                outInteger[outIdx++] = patternResult + 100 * (patternResult > 0 ? 1 : -1);
                patternIdx = 0;
                continue;
            }
            outInteger[outIdx++] = 0;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlHikkakeModLookback() {
        return (1 > this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod ? 1 : this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod) + 5;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlHikkakeMod(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlHikkakeModLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        NearPeriodTotal = 0.0;
        i = NearTrailingIdx = startIdx - 3 - this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod;
        while (i < startIdx - 3) {
            NearPeriodTotal += this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0));
            ++i;
        }
        patternIdx = 0;
        patternResult = 0;
        i = startIdx - 3;
        while (i < startIdx) {
            if (!(inHigh[i - 2] < inHigh[i - 3]) || !(inLow[i - 2] > inLow[i - 3]) || !(inHigh[i - 1] < inHigh[i - 2]) || !(inLow[i - 1] > inLow[i - 2])) ** GOTO lbl-1000
            if (inHigh[i] < inHigh[i - 1] && inLow[i] < inLow[i - 1] && inClose[i - 2] <= inLow[i - 2] + this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0)))) / (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0)) ** GOTO lbl-1000
            if (inHigh[i] > inHigh[i - 1] && inLow[i] > inLow[i - 1]) {
                v0 = inClose[i - 2];
                v1 = inHigh[i - 2];
                v2 = this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))));
                v3 = this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
                ** if (!(v0 >= v1 - v2 / v3)) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                patternResult = 100 * (inHigh[i] < inHigh[i - 1] ? 1 : -1);
                patternIdx = i;
                ** GOTO lbl36
            }
lbl-1000:
            // 3 sources

            {
                if (i <= patternIdx + 3 && (patternResult > 0 && inClose[i] > inHigh[patternIdx - 1] || patternResult < 0 && inClose[i] < inLow[patternIdx - 1])) {
                    patternIdx = 0;
                }
            }
lbl36:
            // 4 sources

            NearPeriodTotal += (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))) - (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[NearTrailingIdx - 2] - inOpen[NearTrailingIdx - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[NearTrailingIdx - 2] - inLow[NearTrailingIdx - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[NearTrailingIdx - 2] - (inClose[NearTrailingIdx - 2] >= inOpen[NearTrailingIdx - 2] ? inClose[NearTrailingIdx - 2] : inOpen[NearTrailingIdx - 2]) + ((inClose[NearTrailingIdx - 2] >= inOpen[NearTrailingIdx - 2] ? inOpen[NearTrailingIdx - 2] : inClose[NearTrailingIdx - 2]) - inLow[NearTrailingIdx - 2]) : 0.0)));
            ++NearTrailingIdx;
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if (!(inHigh[i - 2] < inHigh[i - 3]) || !(inLow[i - 2] > inLow[i - 3]) || !(inHigh[i - 1] < inHigh[i - 2]) || !(inLow[i - 1] > inLow[i - 2])) ** GOTO lbl-1000
            if (inHigh[i] < inHigh[i - 1] && inLow[i] < inLow[i - 1] && inClose[i - 2] <= inLow[i - 2] + this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0)))) / (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0)) ** GOTO lbl-1000
            if (inHigh[i] > inHigh[i - 1] && inLow[i] > inLow[i - 1]) {
                v4 = inClose[i - 2];
                v5 = inHigh[i - 2];
                v6 = this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))));
                v7 = this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
                ** if (!(v4 >= v5 - v6 / v7)) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                patternResult = 100 * (inHigh[i] < inHigh[i - 1] ? 1 : -1);
                patternIdx = i;
                outInteger[outIdx++] = patternResult;
                ** GOTO lbl61
            }
lbl-1000:
            // 3 sources

            {
                if (i <= patternIdx + 3 && (patternResult > 0 && inClose[i] > inHigh[patternIdx - 1] || patternResult < 0 && inClose[i] < inLow[patternIdx - 1])) {
                    outInteger[outIdx++] = patternResult + 100 * (patternResult > 0 ? 1 : -1);
                    patternIdx = 0;
                } else {
                    outInteger[outIdx++] = 0;
                }
            }
lbl61:
            // 3 sources

            NearPeriodTotal += (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))) - (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[NearTrailingIdx - 2] - inOpen[NearTrailingIdx - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[NearTrailingIdx - 2] - inLow[NearTrailingIdx - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[NearTrailingIdx - 2] - (inClose[NearTrailingIdx - 2] >= inOpen[NearTrailingIdx - 2] ? inClose[NearTrailingIdx - 2] : inOpen[NearTrailingIdx - 2]) + ((inClose[NearTrailingIdx - 2] >= inOpen[NearTrailingIdx - 2] ? inOpen[NearTrailingIdx - 2] : inClose[NearTrailingIdx - 2]) - inLow[NearTrailingIdx - 2]) : 0.0)));
            ++NearTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlHikkakeMod(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlHikkakeModLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        NearPeriodTotal = 0.0;
        i = NearTrailingIdx = startIdx - 3 - this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod;
        while (i < startIdx - 3) {
            NearPeriodTotal += (double)(this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f)));
            ++i;
        }
        patternIdx = 0;
        patternResult = 0;
        i = startIdx - 3;
        while (i < startIdx) {
            if (!(inHigh[i - 2] < inHigh[i - 3]) || !(inLow[i - 2] > inLow[i - 3]) || !(inHigh[i - 1] < inHigh[i - 2]) || !(inLow[i - 1] > inLow[i - 2])) ** GOTO lbl-1000
            if (inHigh[i] < inHigh[i - 1] && inLow[i] < inLow[i - 1] && (double)inClose[i - 2] <= (double)inLow[i - 2] + this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f)))) / (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0)) ** GOTO lbl-1000
            if (inHigh[i] > inHigh[i - 1] && inLow[i] > inLow[i - 1]) {
                v0 = inClose[i - 2];
                v1 = inHigh[i - 2];
                v2 = this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))));
                v3 = this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
                ** if (!(v0 >= v1 - v2 / v3)) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                patternResult = 100 * (inHigh[i] < inHigh[i - 1] ? 1 : -1);
                patternIdx = i;
                ** GOTO lbl36
            }
lbl-1000:
            // 3 sources

            {
                if (i <= patternIdx + 3 && (patternResult > 0 && inClose[i] > inHigh[patternIdx - 1] || patternResult < 0 && inClose[i] < inLow[patternIdx - 1])) {
                    patternIdx = 0;
                }
            }
lbl36:
            // 4 sources

            NearPeriodTotal += (double)((this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))) - (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[NearTrailingIdx - 2] - inOpen[NearTrailingIdx - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[NearTrailingIdx - 2] - inLow[NearTrailingIdx - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[NearTrailingIdx - 2] - (inClose[NearTrailingIdx - 2] >= inOpen[NearTrailingIdx - 2] ? inClose[NearTrailingIdx - 2] : inOpen[NearTrailingIdx - 2]) + ((inClose[NearTrailingIdx - 2] >= inOpen[NearTrailingIdx - 2] ? inOpen[NearTrailingIdx - 2] : inClose[NearTrailingIdx - 2]) - inLow[NearTrailingIdx - 2]) : 0.0f))));
            ++NearTrailingIdx;
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if (!(inHigh[i - 2] < inHigh[i - 3]) || !(inLow[i - 2] > inLow[i - 3]) || !(inHigh[i - 1] < inHigh[i - 2]) || !(inLow[i - 1] > inLow[i - 2])) ** GOTO lbl-1000
            if (inHigh[i] < inHigh[i - 1] && inLow[i] < inLow[i - 1] && (double)inClose[i - 2] <= (double)inLow[i - 2] + this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f)))) / (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0)) ** GOTO lbl-1000
            if (inHigh[i] > inHigh[i - 1] && inLow[i] > inLow[i - 1]) {
                v4 = inClose[i - 2];
                v5 = inHigh[i - 2];
                v6 = this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))));
                v7 = this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
                ** if (!(v4 >= v5 - v6 / v7)) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                patternResult = 100 * (inHigh[i] < inHigh[i - 1] ? 1 : -1);
                patternIdx = i;
                outInteger[outIdx++] = patternResult;
                ** GOTO lbl61
            }
lbl-1000:
            // 3 sources

            {
                if (i <= patternIdx + 3 && (patternResult > 0 && inClose[i] > inHigh[patternIdx - 1] || patternResult < 0 && inClose[i] < inLow[patternIdx - 1])) {
                    outInteger[outIdx++] = patternResult + 100 * (patternResult > 0 ? 1 : -1);
                    patternIdx = 0;
                } else {
                    outInteger[outIdx++] = 0;
                }
            }
lbl61:
            // 3 sources

            NearPeriodTotal += (double)((this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))) - (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[NearTrailingIdx - 2] - inOpen[NearTrailingIdx - 2]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[NearTrailingIdx - 2] - inLow[NearTrailingIdx - 2] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[NearTrailingIdx - 2] - (inClose[NearTrailingIdx - 2] >= inOpen[NearTrailingIdx - 2] ? inClose[NearTrailingIdx - 2] : inOpen[NearTrailingIdx - 2]) + ((inClose[NearTrailingIdx - 2] >= inOpen[NearTrailingIdx - 2] ? inOpen[NearTrailingIdx - 2] : inClose[NearTrailingIdx - 2]) - inLow[NearTrailingIdx - 2]) : 0.0f))));
            ++NearTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlHomingPigeonLookback() {
        return (this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod) + 1;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlHomingPigeon(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlHomingPigeonLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        BodyShortPeriodTotal = 0.0;
        BodyLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        BodyShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod;
        i = BodyLongTrailingIdx;
        while (i < startIdx) {
            BodyLongPeriodTotal += this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0));
            ++i;
        }
        i = BodyShortTrailingIdx;
        while (i < startIdx) {
            BodyShortPeriodTotal += this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != -1 || (inClose[i] >= inOpen[i] ? 1 : -1) != -1) ** GOTO lbl-1000
            v0 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2)) ** GOTO lbl-1000
            v3 = Math.abs(inClose[i] - inOpen[i]);
            v4 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyShortPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v5 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v3 <= v4 / v5 && inOpen[i] < inOpen[i - 1] && inClose[i] > inClose[i - 1]) {
                outInteger[outIdx++] = 100;
            } else lbl-1000:
            // 3 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyLongPeriodTotal += (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx - 1] - inOpen[BodyLongTrailingIdx - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx - 1] - inLow[BodyLongTrailingIdx - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx - 1] - (inClose[BodyLongTrailingIdx - 1] >= inOpen[BodyLongTrailingIdx - 1] ? inClose[BodyLongTrailingIdx - 1] : inOpen[BodyLongTrailingIdx - 1]) + ((inClose[BodyLongTrailingIdx - 1] >= inOpen[BodyLongTrailingIdx - 1] ? inOpen[BodyLongTrailingIdx - 1] : inClose[BodyLongTrailingIdx - 1]) - inLow[BodyLongTrailingIdx - 1]) : 0.0)));
            BodyShortPeriodTotal += (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyShortTrailingIdx] - inOpen[BodyShortTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyShortTrailingIdx] - inLow[BodyShortTrailingIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyShortTrailingIdx] - (inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inClose[BodyShortTrailingIdx] : inOpen[BodyShortTrailingIdx]) + ((inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inOpen[BodyShortTrailingIdx] : inClose[BodyShortTrailingIdx]) - inLow[BodyShortTrailingIdx]) : 0.0)));
            ++BodyLongTrailingIdx;
            ++BodyShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlHomingPigeon(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlHomingPigeonLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        BodyShortPeriodTotal = 0.0;
        BodyLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        BodyShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod;
        i = BodyLongTrailingIdx;
        while (i < startIdx) {
            BodyLongPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)));
            ++i;
        }
        i = BodyShortTrailingIdx;
        while (i < startIdx) {
            BodyShortPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != -1 || (inClose[i] >= inOpen[i] ? 1 : -1) != -1) ** GOTO lbl-1000
            v0 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2)) ** GOTO lbl-1000
            v3 = Math.abs(inClose[i] - inOpen[i]);
            v4 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyShortPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v5 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v3 <= v4 / v5 && inOpen[i] < inOpen[i - 1] && inClose[i] > inClose[i - 1]) {
                outInteger[outIdx++] = 100;
            } else lbl-1000:
            // 3 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyLongPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx - 1] - inOpen[BodyLongTrailingIdx - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx - 1] - inLow[BodyLongTrailingIdx - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx - 1] - (inClose[BodyLongTrailingIdx - 1] >= inOpen[BodyLongTrailingIdx - 1] ? inClose[BodyLongTrailingIdx - 1] : inOpen[BodyLongTrailingIdx - 1]) + ((inClose[BodyLongTrailingIdx - 1] >= inOpen[BodyLongTrailingIdx - 1] ? inOpen[BodyLongTrailingIdx - 1] : inClose[BodyLongTrailingIdx - 1]) - inLow[BodyLongTrailingIdx - 1]) : 0.0f))));
            BodyShortPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyShortTrailingIdx] - inOpen[BodyShortTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyShortTrailingIdx] - inLow[BodyShortTrailingIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyShortTrailingIdx] - (inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inClose[BodyShortTrailingIdx] : inOpen[BodyShortTrailingIdx]) + ((inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inOpen[BodyShortTrailingIdx] : inClose[BodyShortTrailingIdx]) - inLow[BodyShortTrailingIdx]) : 0.0f))));
            ++BodyLongTrailingIdx;
            ++BodyShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlIdentical3CrowsLookback() {
        return (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod) + 2;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlIdentical3Crows(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        ShadowVeryShortPeriodTotal = new double[3];
        EqualPeriodTotal = new double[3];
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlIdentical3CrowsLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        ShadowVeryShortPeriodTotal[2] = 0.0;
        ShadowVeryShortPeriodTotal[1] = 0.0;
        ShadowVeryShortPeriodTotal[0] = 0.0;
        ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        EqualPeriodTotal[2] = 0.0;
        EqualPeriodTotal[1] = 0.0;
        EqualPeriodTotal[0] = 0.0;
        EqualTrailingIdx = startIdx - this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod;
        i = ShadowVeryShortTrailingIdx;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal[2] = ShadowVeryShortPeriodTotal[2] + (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0)));
            ShadowVeryShortPeriodTotal[1] = ShadowVeryShortPeriodTotal[1] + (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0)));
            ShadowVeryShortPeriodTotal[0] = ShadowVeryShortPeriodTotal[0] + (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0)));
            ++i;
        }
        i = EqualTrailingIdx;
        while (i < startIdx) {
            EqualPeriodTotal[2] = EqualPeriodTotal[2] + (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0)));
            EqualPeriodTotal[1] = EqualPeriodTotal[1] + (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) != -1) ** GOTO lbl-1000
            v0 = (inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2];
            v1 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[2] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 < v1 / v2) || (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != -1) ** GOTO lbl-1000
            v3 = (inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1];
            v4 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v5 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 < v4 / v5) || (inClose[i] >= inOpen[i] ? 1 : -1) != -1) ** GOTO lbl-1000
            v6 = (inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i];
            v7 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[0] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v8 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v6 < v7 / v8) || !(inClose[i - 2] > inClose[i - 1]) || !(inClose[i - 1] > inClose[i])) ** GOTO lbl-1000
            v9 = inOpen[i - 1];
            v10 = inClose[i - 2];
            v11 = this.candleSettings[CandleSettingType.Equal.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod != 0.0 ? EqualPeriodTotal[2] / (double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))));
            v12 = this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v9 <= v10 + v11 / v12)) ** GOTO lbl-1000
            v13 = inOpen[i - 1];
            v14 = inClose[i - 2];
            v15 = this.candleSettings[CandleSettingType.Equal.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod != 0.0 ? EqualPeriodTotal[2] / (double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))));
            v16 = this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v13 >= v14 - v15 / v16)) ** GOTO lbl-1000
            v17 = inOpen[i];
            v18 = inClose[i - 1];
            v19 = this.candleSettings[CandleSettingType.Equal.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod != 0.0 ? EqualPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v20 = this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v17 <= v18 + v19 / v20)) ** GOTO lbl-1000
            v21 = inOpen[i];
            v22 = inClose[i - 1];
            v23 = this.candleSettings[CandleSettingType.Equal.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod != 0.0 ? EqualPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v24 = this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v21 >= v22 - v23 / v24) {
                outInteger[outIdx++] = -100;
            } else lbl-1000:
            // 8 sources

            {
                outInteger[outIdx++] = 0;
            }
            totIdx = 2;
            while (totIdx >= 0) {
                v25 = totIdx;
                ShadowVeryShortPeriodTotal[v25] = ShadowVeryShortPeriodTotal[v25] + ((this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx - totIdx] - inOpen[ShadowVeryShortTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx - totIdx] - inLow[ShadowVeryShortTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx - totIdx] - (inClose[ShadowVeryShortTrailingIdx - totIdx] >= inOpen[ShadowVeryShortTrailingIdx - totIdx] ? inClose[ShadowVeryShortTrailingIdx - totIdx] : inOpen[ShadowVeryShortTrailingIdx - totIdx]) + ((inClose[ShadowVeryShortTrailingIdx - totIdx] >= inOpen[ShadowVeryShortTrailingIdx - totIdx] ? inOpen[ShadowVeryShortTrailingIdx - totIdx] : inClose[ShadowVeryShortTrailingIdx - totIdx]) - inLow[ShadowVeryShortTrailingIdx - totIdx]) : 0.0))));
                --totIdx;
            }
            totIdx = 2;
            while (totIdx >= 1) {
                v26 = totIdx;
                EqualPeriodTotal[v26] = EqualPeriodTotal[v26] + ((this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0))) - (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[EqualTrailingIdx - totIdx] - inOpen[EqualTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[EqualTrailingIdx - totIdx] - inLow[EqualTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[EqualTrailingIdx - totIdx] - (inClose[EqualTrailingIdx - totIdx] >= inOpen[EqualTrailingIdx - totIdx] ? inClose[EqualTrailingIdx - totIdx] : inOpen[EqualTrailingIdx - totIdx]) + ((inClose[EqualTrailingIdx - totIdx] >= inOpen[EqualTrailingIdx - totIdx] ? inOpen[EqualTrailingIdx - totIdx] : inClose[EqualTrailingIdx - totIdx]) - inLow[EqualTrailingIdx - totIdx]) : 0.0))));
                --totIdx;
            }
            ++ShadowVeryShortTrailingIdx;
            ++EqualTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlIdentical3Crows(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        ShadowVeryShortPeriodTotal = new double[3];
        EqualPeriodTotal = new double[3];
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlIdentical3CrowsLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        ShadowVeryShortPeriodTotal[2] = 0.0;
        ShadowVeryShortPeriodTotal[1] = 0.0;
        ShadowVeryShortPeriodTotal[0] = 0.0;
        ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        EqualPeriodTotal[2] = 0.0;
        EqualPeriodTotal[1] = 0.0;
        EqualPeriodTotal[0] = 0.0;
        EqualTrailingIdx = startIdx - this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod;
        i = ShadowVeryShortTrailingIdx;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal[2] = ShadowVeryShortPeriodTotal[2] + (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f)));
            ShadowVeryShortPeriodTotal[1] = ShadowVeryShortPeriodTotal[1] + (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)));
            ShadowVeryShortPeriodTotal[0] = ShadowVeryShortPeriodTotal[0] + (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = EqualTrailingIdx;
        while (i < startIdx) {
            EqualPeriodTotal[2] = EqualPeriodTotal[2] + (double)(this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f)));
            EqualPeriodTotal[1] = EqualPeriodTotal[1] + (double)(this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) != -1) ** GOTO lbl-1000
            v0 = (inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2];
            v1 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[2] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 < v1 / v2) || (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != -1) ** GOTO lbl-1000
            v3 = (inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1];
            v4 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v5 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 < v4 / v5) || (inClose[i] >= inOpen[i] ? 1 : -1) != -1) ** GOTO lbl-1000
            v6 = (inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i];
            v7 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[0] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v8 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v6 < v7 / v8) || !(inClose[i - 2] > inClose[i - 1]) || !(inClose[i - 1] > inClose[i])) ** GOTO lbl-1000
            v9 = inOpen[i - 1];
            v10 = inClose[i - 2];
            v11 = this.candleSettings[CandleSettingType.Equal.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod != 0.0 ? EqualPeriodTotal[2] / (double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))));
            v12 = this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v9 <= v10 + v11 / v12)) ** GOTO lbl-1000
            v13 = inOpen[i - 1];
            v14 = inClose[i - 2];
            v15 = this.candleSettings[CandleSettingType.Equal.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod != 0.0 ? EqualPeriodTotal[2] / (double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))));
            v16 = this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v13 >= v14 - v15 / v16)) ** GOTO lbl-1000
            v17 = inOpen[i];
            v18 = inClose[i - 1];
            v19 = this.candleSettings[CandleSettingType.Equal.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod != 0.0 ? EqualPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v20 = this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v17 <= v18 + v19 / v20)) ** GOTO lbl-1000
            v21 = inOpen[i];
            v22 = inClose[i - 1];
            v23 = this.candleSettings[CandleSettingType.Equal.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod != 0.0 ? EqualPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v24 = this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v21 >= v22 - v23 / v24) {
                outInteger[outIdx++] = -100;
            } else lbl-1000:
            // 8 sources

            {
                outInteger[outIdx++] = 0;
            }
            totIdx = 2;
            while (totIdx >= 0) {
                v25 = totIdx;
                ShadowVeryShortPeriodTotal[v25] = ShadowVeryShortPeriodTotal[v25] + (double)((this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0f))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx - totIdx] - inOpen[ShadowVeryShortTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx - totIdx] - inLow[ShadowVeryShortTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx - totIdx] - (inClose[ShadowVeryShortTrailingIdx - totIdx] >= inOpen[ShadowVeryShortTrailingIdx - totIdx] ? inClose[ShadowVeryShortTrailingIdx - totIdx] : inOpen[ShadowVeryShortTrailingIdx - totIdx]) + ((inClose[ShadowVeryShortTrailingIdx - totIdx] >= inOpen[ShadowVeryShortTrailingIdx - totIdx] ? inOpen[ShadowVeryShortTrailingIdx - totIdx] : inClose[ShadowVeryShortTrailingIdx - totIdx]) - inLow[ShadowVeryShortTrailingIdx - totIdx]) : 0.0f))));
                --totIdx;
            }
            totIdx = 2;
            while (totIdx >= 1) {
                v26 = totIdx;
                EqualPeriodTotal[v26] = EqualPeriodTotal[v26] + (double)((this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0f))) - (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[EqualTrailingIdx - totIdx] - inOpen[EqualTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[EqualTrailingIdx - totIdx] - inLow[EqualTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[EqualTrailingIdx - totIdx] - (inClose[EqualTrailingIdx - totIdx] >= inOpen[EqualTrailingIdx - totIdx] ? inClose[EqualTrailingIdx - totIdx] : inOpen[EqualTrailingIdx - totIdx]) + ((inClose[EqualTrailingIdx - totIdx] >= inOpen[EqualTrailingIdx - totIdx] ? inOpen[EqualTrailingIdx - totIdx] : inClose[EqualTrailingIdx - totIdx]) - inLow[EqualTrailingIdx - totIdx]) : 0.0f))));
                --totIdx;
            }
            ++ShadowVeryShortTrailingIdx;
            ++EqualTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlInNeckLookback() {
        return (this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod) + 1;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlInNeck(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlInNeckLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        EqualPeriodTotal = 0.0;
        EqualTrailingIdx = startIdx - this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod;
        BodyLongPeriodTotal = 0.0;
        BodyLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        i = EqualTrailingIdx;
        while (i < startIdx) {
            EqualPeriodTotal += this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0));
            ++i;
        }
        i = BodyLongTrailingIdx;
        while (i < startIdx) {
            BodyLongPeriodTotal += this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != -1) ** GOTO lbl-1000
            v0 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2) || (inClose[i] >= inOpen[i] ? 1 : -1) != 1 || !(inOpen[i] < inLow[i - 1])) ** GOTO lbl-1000
            v3 = inClose[i];
            v4 = inClose[i - 1];
            v5 = this.candleSettings[CandleSettingType.Equal.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod != 0.0 ? EqualPeriodTotal / (double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v6 = this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v3 <= v4 + v5 / v6 && inClose[i] >= inClose[i - 1]) {
                outInteger[outIdx++] = -100;
            } else lbl-1000:
            // 3 sources

            {
                outInteger[outIdx++] = 0;
            }
            EqualPeriodTotal += (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))) - (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[EqualTrailingIdx - 1] - inOpen[EqualTrailingIdx - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[EqualTrailingIdx - 1] - inLow[EqualTrailingIdx - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[EqualTrailingIdx - 1] - (inClose[EqualTrailingIdx - 1] >= inOpen[EqualTrailingIdx - 1] ? inClose[EqualTrailingIdx - 1] : inOpen[EqualTrailingIdx - 1]) + ((inClose[EqualTrailingIdx - 1] >= inOpen[EqualTrailingIdx - 1] ? inOpen[EqualTrailingIdx - 1] : inClose[EqualTrailingIdx - 1]) - inLow[EqualTrailingIdx - 1]) : 0.0)));
            BodyLongPeriodTotal += (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx - 1] - inOpen[BodyLongTrailingIdx - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx - 1] - inLow[BodyLongTrailingIdx - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx - 1] - (inClose[BodyLongTrailingIdx - 1] >= inOpen[BodyLongTrailingIdx - 1] ? inClose[BodyLongTrailingIdx - 1] : inOpen[BodyLongTrailingIdx - 1]) + ((inClose[BodyLongTrailingIdx - 1] >= inOpen[BodyLongTrailingIdx - 1] ? inOpen[BodyLongTrailingIdx - 1] : inClose[BodyLongTrailingIdx - 1]) - inLow[BodyLongTrailingIdx - 1]) : 0.0)));
            ++EqualTrailingIdx;
            ++BodyLongTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlInNeck(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlInNeckLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        EqualPeriodTotal = 0.0;
        EqualTrailingIdx = startIdx - this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod;
        BodyLongPeriodTotal = 0.0;
        BodyLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        i = EqualTrailingIdx;
        while (i < startIdx) {
            EqualPeriodTotal += (double)(this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)));
            ++i;
        }
        i = BodyLongTrailingIdx;
        while (i < startIdx) {
            BodyLongPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != -1) ** GOTO lbl-1000
            v0 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2) || (inClose[i] >= inOpen[i] ? 1 : -1) != 1 || !(inOpen[i] < inLow[i - 1])) ** GOTO lbl-1000
            v3 = inClose[i];
            v4 = inClose[i - 1];
            v5 = this.candleSettings[CandleSettingType.Equal.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod != 0.0 ? EqualPeriodTotal / (double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v6 = this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v3 <= v4 + v5 / v6 && inClose[i] >= inClose[i - 1]) {
                outInteger[outIdx++] = -100;
            } else lbl-1000:
            // 3 sources

            {
                outInteger[outIdx++] = 0;
            }
            EqualPeriodTotal += (double)((this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))) - (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[EqualTrailingIdx - 1] - inOpen[EqualTrailingIdx - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[EqualTrailingIdx - 1] - inLow[EqualTrailingIdx - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[EqualTrailingIdx - 1] - (inClose[EqualTrailingIdx - 1] >= inOpen[EqualTrailingIdx - 1] ? inClose[EqualTrailingIdx - 1] : inOpen[EqualTrailingIdx - 1]) + ((inClose[EqualTrailingIdx - 1] >= inOpen[EqualTrailingIdx - 1] ? inOpen[EqualTrailingIdx - 1] : inClose[EqualTrailingIdx - 1]) - inLow[EqualTrailingIdx - 1]) : 0.0f))));
            BodyLongPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx - 1] - inOpen[BodyLongTrailingIdx - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx - 1] - inLow[BodyLongTrailingIdx - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx - 1] - (inClose[BodyLongTrailingIdx - 1] >= inOpen[BodyLongTrailingIdx - 1] ? inClose[BodyLongTrailingIdx - 1] : inOpen[BodyLongTrailingIdx - 1]) + ((inClose[BodyLongTrailingIdx - 1] >= inOpen[BodyLongTrailingIdx - 1] ? inOpen[BodyLongTrailingIdx - 1] : inClose[BodyLongTrailingIdx - 1]) - inLow[BodyLongTrailingIdx - 1]) : 0.0f))));
            ++EqualTrailingIdx;
            ++BodyLongTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlInvertedHammerLookback() {
        return ((this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod) > this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod ? (this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod) : this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod) + 1;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlInvertedHammer(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlInvertedHammerLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyPeriodTotal = 0.0;
        BodyTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod;
        ShadowLongPeriodTotal = 0.0;
        ShadowLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod;
        ShadowVeryShortPeriodTotal = 0.0;
        ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        i = BodyTrailingIdx;
        while (i < startIdx) {
            BodyPeriodTotal += this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = ShadowLongTrailingIdx;
        while (i < startIdx) {
            ShadowLongPeriodTotal += this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = ShadowVeryShortTrailingIdx;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal += this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i] - inOpen[i]);
            v1 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 < v1 / v2)) ** GOTO lbl-1000
            v3 = inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]);
            v4 = this.candleSettings[CandleSettingType.ShadowLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod != 0.0 ? ShadowLongPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v5 = this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 > v4 / v5)) ** GOTO lbl-1000
            v6 = (inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i];
            v7 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v8 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v6 < v7 / v8)) ** GOTO lbl-1000
            v9 = inOpen[i] > inClose[i] ? inOpen[i] : inClose[i];
            v10 = inOpen[i - 1] < inClose[i - 1] ? inOpen[i - 1] : inClose[i - 1];
            if (v9 < v10) {
                outInteger[outIdx++] = 100;
            } else lbl-1000:
            // 4 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyPeriodTotal += (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyTrailingIdx] - inOpen[BodyTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyTrailingIdx] - inLow[BodyTrailingIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyTrailingIdx] - (inClose[BodyTrailingIdx] >= inOpen[BodyTrailingIdx] ? inClose[BodyTrailingIdx] : inOpen[BodyTrailingIdx]) + ((inClose[BodyTrailingIdx] >= inOpen[BodyTrailingIdx] ? inOpen[BodyTrailingIdx] : inClose[BodyTrailingIdx]) - inLow[BodyTrailingIdx]) : 0.0)));
            ShadowLongPeriodTotal += (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowLongTrailingIdx] - inOpen[ShadowLongTrailingIdx]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowLongTrailingIdx] - inLow[ShadowLongTrailingIdx] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowLongTrailingIdx] - (inClose[ShadowLongTrailingIdx] >= inOpen[ShadowLongTrailingIdx] ? inClose[ShadowLongTrailingIdx] : inOpen[ShadowLongTrailingIdx]) + ((inClose[ShadowLongTrailingIdx] >= inOpen[ShadowLongTrailingIdx] ? inOpen[ShadowLongTrailingIdx] : inClose[ShadowLongTrailingIdx]) - inLow[ShadowLongTrailingIdx]) : 0.0)));
            ShadowVeryShortPeriodTotal += (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx] - inOpen[ShadowVeryShortTrailingIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx] - inLow[ShadowVeryShortTrailingIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx] - (inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inClose[ShadowVeryShortTrailingIdx] : inOpen[ShadowVeryShortTrailingIdx]) + ((inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inOpen[ShadowVeryShortTrailingIdx] : inClose[ShadowVeryShortTrailingIdx]) - inLow[ShadowVeryShortTrailingIdx]) : 0.0)));
            ++BodyTrailingIdx;
            ++ShadowLongTrailingIdx;
            ++ShadowVeryShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlInvertedHammer(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlInvertedHammerLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyPeriodTotal = 0.0;
        BodyTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod;
        ShadowLongPeriodTotal = 0.0;
        ShadowLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod;
        ShadowVeryShortPeriodTotal = 0.0;
        ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        i = BodyTrailingIdx;
        while (i < startIdx) {
            BodyPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = ShadowLongTrailingIdx;
        while (i < startIdx) {
            ShadowLongPeriodTotal += (double)(this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = ShadowVeryShortTrailingIdx;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal += (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i] - inOpen[i]);
            v1 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 < v1 / v2)) ** GOTO lbl-1000
            v3 = inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]);
            v4 = this.candleSettings[CandleSettingType.ShadowLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod != 0.0 ? ShadowLongPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v5 = this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 > v4 / v5)) ** GOTO lbl-1000
            v6 = (inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i];
            v7 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v8 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v6 < v7 / v8)) ** GOTO lbl-1000
            v9 = inOpen[i] > inClose[i] ? inOpen[i] : inClose[i];
            v10 = inOpen[i - 1] < inClose[i - 1] ? inOpen[i - 1] : inClose[i - 1];
            if (v9 < v10) {
                outInteger[outIdx++] = 100;
            } else lbl-1000:
            // 4 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyTrailingIdx] - inOpen[BodyTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyTrailingIdx] - inLow[BodyTrailingIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyTrailingIdx] - (inClose[BodyTrailingIdx] >= inOpen[BodyTrailingIdx] ? inClose[BodyTrailingIdx] : inOpen[BodyTrailingIdx]) + ((inClose[BodyTrailingIdx] >= inOpen[BodyTrailingIdx] ? inOpen[BodyTrailingIdx] : inClose[BodyTrailingIdx]) - inLow[BodyTrailingIdx]) : 0.0f))));
            ShadowLongPeriodTotal += (double)((this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowLongTrailingIdx] - inOpen[ShadowLongTrailingIdx]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowLongTrailingIdx] - inLow[ShadowLongTrailingIdx] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowLongTrailingIdx] - (inClose[ShadowLongTrailingIdx] >= inOpen[ShadowLongTrailingIdx] ? inClose[ShadowLongTrailingIdx] : inOpen[ShadowLongTrailingIdx]) + ((inClose[ShadowLongTrailingIdx] >= inOpen[ShadowLongTrailingIdx] ? inOpen[ShadowLongTrailingIdx] : inClose[ShadowLongTrailingIdx]) - inLow[ShadowLongTrailingIdx]) : 0.0f))));
            ShadowVeryShortPeriodTotal += (double)((this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx] - inOpen[ShadowVeryShortTrailingIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx] - inLow[ShadowVeryShortTrailingIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx] - (inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inClose[ShadowVeryShortTrailingIdx] : inOpen[ShadowVeryShortTrailingIdx]) + ((inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inOpen[ShadowVeryShortTrailingIdx] : inClose[ShadowVeryShortTrailingIdx]) - inLow[ShadowVeryShortTrailingIdx]) : 0.0f))));
            ++BodyTrailingIdx;
            ++ShadowLongTrailingIdx;
            ++ShadowVeryShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlKickingLookback() {
        return (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod) + 1;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlKicking(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        ShadowVeryShortPeriodTotal = new double[2];
        BodyLongPeriodTotal = new double[2];
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlKickingLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        ShadowVeryShortPeriodTotal[1] = 0.0;
        ShadowVeryShortPeriodTotal[0] = 0.0;
        ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        BodyLongPeriodTotal[1] = 0.0;
        BodyLongPeriodTotal[0] = 0.0;
        BodyLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        i = ShadowVeryShortTrailingIdx;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal[1] = ShadowVeryShortPeriodTotal[1] + (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0)));
            ShadowVeryShortPeriodTotal[0] = ShadowVeryShortPeriodTotal[0] + (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0)));
            ++i;
        }
        i = BodyLongTrailingIdx;
        while (i < startIdx) {
            BodyLongPeriodTotal[1] = BodyLongPeriodTotal[1] + (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0)));
            BodyLongPeriodTotal[0] = BodyLongPeriodTotal[0] + (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != -(inClose[i] >= inOpen[i] ? 1 : -1)) ** GOTO lbl-1000
            v0 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2)) ** GOTO lbl-1000
            v3 = inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]);
            v4 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v5 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 < v4 / v5)) ** GOTO lbl-1000
            v6 = (inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1];
            v7 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v8 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v6 < v7 / v8)) ** GOTO lbl-1000
            v9 = Math.abs(inClose[i] - inOpen[i]);
            v10 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal[0] / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v11 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v9 > v10 / v11)) ** GOTO lbl-1000
            v12 = inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]);
            v13 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[0] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v14 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v12 < v13 / v14)) ** GOTO lbl-1000
            v15 = (inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i];
            v16 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[0] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v17 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v15 < v16 / v17 && ((inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) == -1 && inLow[i] > inHigh[i - 1] || (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) == 1 && inHigh[i] < inLow[i - 1])) {
                outInteger[outIdx++] = (inClose[i] >= inOpen[i] ? 1 : -1) * 100;
            } else lbl-1000:
            // 7 sources

            {
                outInteger[outIdx++] = 0;
            }
            totIdx = 1;
            while (totIdx >= 0) {
                v18 = totIdx;
                BodyLongPeriodTotal[v18] = BodyLongPeriodTotal[v18] + ((this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx - totIdx] - inOpen[BodyLongTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx - totIdx] - inLow[BodyLongTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx - totIdx] - (inClose[BodyLongTrailingIdx - totIdx] >= inOpen[BodyLongTrailingIdx - totIdx] ? inClose[BodyLongTrailingIdx - totIdx] : inOpen[BodyLongTrailingIdx - totIdx]) + ((inClose[BodyLongTrailingIdx - totIdx] >= inOpen[BodyLongTrailingIdx - totIdx] ? inOpen[BodyLongTrailingIdx - totIdx] : inClose[BodyLongTrailingIdx - totIdx]) - inLow[BodyLongTrailingIdx - totIdx]) : 0.0))));
                v19 = totIdx;
                ShadowVeryShortPeriodTotal[v19] = ShadowVeryShortPeriodTotal[v19] + ((this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx - totIdx] - inOpen[ShadowVeryShortTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx - totIdx] - inLow[ShadowVeryShortTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx - totIdx] - (inClose[ShadowVeryShortTrailingIdx - totIdx] >= inOpen[ShadowVeryShortTrailingIdx - totIdx] ? inClose[ShadowVeryShortTrailingIdx - totIdx] : inOpen[ShadowVeryShortTrailingIdx - totIdx]) + ((inClose[ShadowVeryShortTrailingIdx - totIdx] >= inOpen[ShadowVeryShortTrailingIdx - totIdx] ? inOpen[ShadowVeryShortTrailingIdx - totIdx] : inClose[ShadowVeryShortTrailingIdx - totIdx]) - inLow[ShadowVeryShortTrailingIdx - totIdx]) : 0.0))));
                --totIdx;
            }
            ++ShadowVeryShortTrailingIdx;
            ++BodyLongTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlKicking(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        ShadowVeryShortPeriodTotal = new double[2];
        BodyLongPeriodTotal = new double[2];
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlKickingLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        ShadowVeryShortPeriodTotal[1] = 0.0;
        ShadowVeryShortPeriodTotal[0] = 0.0;
        ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        BodyLongPeriodTotal[1] = 0.0;
        BodyLongPeriodTotal[0] = 0.0;
        BodyLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        i = ShadowVeryShortTrailingIdx;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal[1] = ShadowVeryShortPeriodTotal[1] + (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)));
            ShadowVeryShortPeriodTotal[0] = ShadowVeryShortPeriodTotal[0] + (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = BodyLongTrailingIdx;
        while (i < startIdx) {
            BodyLongPeriodTotal[1] = BodyLongPeriodTotal[1] + (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)));
            BodyLongPeriodTotal[0] = BodyLongPeriodTotal[0] + (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != -(inClose[i] >= inOpen[i] ? 1 : -1)) ** GOTO lbl-1000
            v0 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2)) ** GOTO lbl-1000
            v3 = inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]);
            v4 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v5 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 < v4 / v5)) ** GOTO lbl-1000
            v6 = (inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1];
            v7 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v8 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v6 < v7 / v8)) ** GOTO lbl-1000
            v9 = Math.abs(inClose[i] - inOpen[i]);
            v10 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal[0] / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v11 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v9 > v10 / v11)) ** GOTO lbl-1000
            v12 = inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]);
            v13 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[0] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v14 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v12 < v13 / v14)) ** GOTO lbl-1000
            v15 = (inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i];
            v16 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[0] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v17 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v15 < v16 / v17 && ((inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) == -1 && inLow[i] > inHigh[i - 1] || (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) == 1 && inHigh[i] < inLow[i - 1])) {
                outInteger[outIdx++] = (inClose[i] >= inOpen[i] ? 1 : -1) * 100;
            } else lbl-1000:
            // 7 sources

            {
                outInteger[outIdx++] = 0;
            }
            totIdx = 1;
            while (totIdx >= 0) {
                v18 = totIdx;
                BodyLongPeriodTotal[v18] = BodyLongPeriodTotal[v18] + (double)((this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx - totIdx] - inOpen[BodyLongTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx - totIdx] - inLow[BodyLongTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx - totIdx] - (inClose[BodyLongTrailingIdx - totIdx] >= inOpen[BodyLongTrailingIdx - totIdx] ? inClose[BodyLongTrailingIdx - totIdx] : inOpen[BodyLongTrailingIdx - totIdx]) + ((inClose[BodyLongTrailingIdx - totIdx] >= inOpen[BodyLongTrailingIdx - totIdx] ? inOpen[BodyLongTrailingIdx - totIdx] : inClose[BodyLongTrailingIdx - totIdx]) - inLow[BodyLongTrailingIdx - totIdx]) : 0.0f))));
                v19 = totIdx;
                ShadowVeryShortPeriodTotal[v19] = ShadowVeryShortPeriodTotal[v19] + (double)((this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0f))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx - totIdx] - inOpen[ShadowVeryShortTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx - totIdx] - inLow[ShadowVeryShortTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx - totIdx] - (inClose[ShadowVeryShortTrailingIdx - totIdx] >= inOpen[ShadowVeryShortTrailingIdx - totIdx] ? inClose[ShadowVeryShortTrailingIdx - totIdx] : inOpen[ShadowVeryShortTrailingIdx - totIdx]) + ((inClose[ShadowVeryShortTrailingIdx - totIdx] >= inOpen[ShadowVeryShortTrailingIdx - totIdx] ? inOpen[ShadowVeryShortTrailingIdx - totIdx] : inClose[ShadowVeryShortTrailingIdx - totIdx]) - inLow[ShadowVeryShortTrailingIdx - totIdx]) : 0.0f))));
                --totIdx;
            }
            ++ShadowVeryShortTrailingIdx;
            ++BodyLongTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlKickingByLengthLookback() {
        return (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod) + 1;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlKickingByLength(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        ShadowVeryShortPeriodTotal = new double[2];
        BodyLongPeriodTotal = new double[2];
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlKickingByLengthLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        ShadowVeryShortPeriodTotal[1] = 0.0;
        ShadowVeryShortPeriodTotal[0] = 0.0;
        ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        BodyLongPeriodTotal[1] = 0.0;
        BodyLongPeriodTotal[0] = 0.0;
        BodyLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        i = ShadowVeryShortTrailingIdx;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal[1] = ShadowVeryShortPeriodTotal[1] + (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0)));
            ShadowVeryShortPeriodTotal[0] = ShadowVeryShortPeriodTotal[0] + (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0)));
            ++i;
        }
        i = BodyLongTrailingIdx;
        while (i < startIdx) {
            BodyLongPeriodTotal[1] = BodyLongPeriodTotal[1] + (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0)));
            BodyLongPeriodTotal[0] = BodyLongPeriodTotal[0] + (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != -(inClose[i] >= inOpen[i] ? 1 : -1)) ** GOTO lbl-1000
            v0 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2)) ** GOTO lbl-1000
            v3 = inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]);
            v4 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v5 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 < v4 / v5)) ** GOTO lbl-1000
            v6 = (inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1];
            v7 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v8 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v6 < v7 / v8)) ** GOTO lbl-1000
            v9 = Math.abs(inClose[i] - inOpen[i]);
            v10 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal[0] / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v11 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v9 > v10 / v11)) ** GOTO lbl-1000
            v12 = inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]);
            v13 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[0] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v14 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v12 < v13 / v14)) ** GOTO lbl-1000
            v15 = (inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i];
            v16 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[0] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v17 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v15 < v16 / v17 && ((inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) == -1 && inLow[i] > inHigh[i - 1] || (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) == 1 && inHigh[i] < inLow[i - 1])) {
                outInteger[outIdx++] = (inClose[Math.abs(inClose[i] - inOpen[i]) > Math.abs(inClose[i - 1] - inOpen[i - 1]) ? i : i - 1] >= inOpen[Math.abs(inClose[i] - inOpen[i]) > Math.abs(inClose[i - 1] - inOpen[i - 1]) ? i : i - 1] ? 1 : -1) * 100;
            } else lbl-1000:
            // 7 sources

            {
                outInteger[outIdx++] = 0;
            }
            totIdx = 1;
            while (totIdx >= 0) {
                v18 = totIdx;
                BodyLongPeriodTotal[v18] = BodyLongPeriodTotal[v18] + ((this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx - totIdx] - inOpen[BodyLongTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx - totIdx] - inLow[BodyLongTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx - totIdx] - (inClose[BodyLongTrailingIdx - totIdx] >= inOpen[BodyLongTrailingIdx - totIdx] ? inClose[BodyLongTrailingIdx - totIdx] : inOpen[BodyLongTrailingIdx - totIdx]) + ((inClose[BodyLongTrailingIdx - totIdx] >= inOpen[BodyLongTrailingIdx - totIdx] ? inOpen[BodyLongTrailingIdx - totIdx] : inClose[BodyLongTrailingIdx - totIdx]) - inLow[BodyLongTrailingIdx - totIdx]) : 0.0))));
                v19 = totIdx;
                ShadowVeryShortPeriodTotal[v19] = ShadowVeryShortPeriodTotal[v19] + ((this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx - totIdx] - inOpen[ShadowVeryShortTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx - totIdx] - inLow[ShadowVeryShortTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx - totIdx] - (inClose[ShadowVeryShortTrailingIdx - totIdx] >= inOpen[ShadowVeryShortTrailingIdx - totIdx] ? inClose[ShadowVeryShortTrailingIdx - totIdx] : inOpen[ShadowVeryShortTrailingIdx - totIdx]) + ((inClose[ShadowVeryShortTrailingIdx - totIdx] >= inOpen[ShadowVeryShortTrailingIdx - totIdx] ? inOpen[ShadowVeryShortTrailingIdx - totIdx] : inClose[ShadowVeryShortTrailingIdx - totIdx]) - inLow[ShadowVeryShortTrailingIdx - totIdx]) : 0.0))));
                --totIdx;
            }
            ++ShadowVeryShortTrailingIdx;
            ++BodyLongTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlKickingByLength(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        ShadowVeryShortPeriodTotal = new double[2];
        BodyLongPeriodTotal = new double[2];
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlKickingByLengthLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        ShadowVeryShortPeriodTotal[1] = 0.0;
        ShadowVeryShortPeriodTotal[0] = 0.0;
        ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        BodyLongPeriodTotal[1] = 0.0;
        BodyLongPeriodTotal[0] = 0.0;
        BodyLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        i = ShadowVeryShortTrailingIdx;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal[1] = ShadowVeryShortPeriodTotal[1] + (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)));
            ShadowVeryShortPeriodTotal[0] = ShadowVeryShortPeriodTotal[0] + (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = BodyLongTrailingIdx;
        while (i < startIdx) {
            BodyLongPeriodTotal[1] = BodyLongPeriodTotal[1] + (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)));
            BodyLongPeriodTotal[0] = BodyLongPeriodTotal[0] + (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != -(inClose[i] >= inOpen[i] ? 1 : -1)) ** GOTO lbl-1000
            v0 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2)) ** GOTO lbl-1000
            v3 = inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]);
            v4 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v5 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 < v4 / v5)) ** GOTO lbl-1000
            v6 = (inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1];
            v7 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v8 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v6 < v7 / v8)) ** GOTO lbl-1000
            v9 = Math.abs(inClose[i] - inOpen[i]);
            v10 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal[0] / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v11 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v9 > v10 / v11)) ** GOTO lbl-1000
            v12 = inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]);
            v13 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[0] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v14 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v12 < v13 / v14)) ** GOTO lbl-1000
            v15 = (inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i];
            v16 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal[0] / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v17 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v15 < v16 / v17 && ((inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) == -1 && inLow[i] > inHigh[i - 1] || (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) == 1 && inHigh[i] < inLow[i - 1])) {
                outInteger[outIdx++] = (inClose[Math.abs(inClose[i] - inOpen[i]) > Math.abs(inClose[i - 1] - inOpen[i - 1]) ? i : i - 1] >= inOpen[Math.abs(inClose[i] - inOpen[i]) > Math.abs(inClose[i - 1] - inOpen[i - 1]) ? i : i - 1] ? 1 : -1) * 100;
            } else lbl-1000:
            // 7 sources

            {
                outInteger[outIdx++] = 0;
            }
            totIdx = 1;
            while (totIdx >= 0) {
                v18 = totIdx;
                BodyLongPeriodTotal[v18] = BodyLongPeriodTotal[v18] + (double)((this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx - totIdx] - inOpen[BodyLongTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx - totIdx] - inLow[BodyLongTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx - totIdx] - (inClose[BodyLongTrailingIdx - totIdx] >= inOpen[BodyLongTrailingIdx - totIdx] ? inClose[BodyLongTrailingIdx - totIdx] : inOpen[BodyLongTrailingIdx - totIdx]) + ((inClose[BodyLongTrailingIdx - totIdx] >= inOpen[BodyLongTrailingIdx - totIdx] ? inOpen[BodyLongTrailingIdx - totIdx] : inClose[BodyLongTrailingIdx - totIdx]) - inLow[BodyLongTrailingIdx - totIdx]) : 0.0f))));
                v19 = totIdx;
                ShadowVeryShortPeriodTotal[v19] = ShadowVeryShortPeriodTotal[v19] + (double)((this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0f))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx - totIdx] - inOpen[ShadowVeryShortTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx - totIdx] - inLow[ShadowVeryShortTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx - totIdx] - (inClose[ShadowVeryShortTrailingIdx - totIdx] >= inOpen[ShadowVeryShortTrailingIdx - totIdx] ? inClose[ShadowVeryShortTrailingIdx - totIdx] : inOpen[ShadowVeryShortTrailingIdx - totIdx]) + ((inClose[ShadowVeryShortTrailingIdx - totIdx] >= inOpen[ShadowVeryShortTrailingIdx - totIdx] ? inOpen[ShadowVeryShortTrailingIdx - totIdx] : inClose[ShadowVeryShortTrailingIdx - totIdx]) - inLow[ShadowVeryShortTrailingIdx - totIdx]) : 0.0f))));
                --totIdx;
            }
            ++ShadowVeryShortTrailingIdx;
            ++BodyLongTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlLadderBottomLookback() {
        return this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod + 4;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlLadderBottom(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlLadderBottomLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        ShadowVeryShortPeriodTotal = 0.0;
        i = ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal += this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 4] >= inOpen[i - 4] ? 1 : -1) != -1 || (inClose[i - 3] >= inOpen[i - 3] ? 1 : -1) != -1 || (inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) != -1 || !(inOpen[i - 4] > inOpen[i - 3]) || !(inOpen[i - 3] > inOpen[i - 2]) || !(inClose[i - 4] > inClose[i - 3]) || !(inClose[i - 3] > inClose[i - 2]) || (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != -1) ** GOTO lbl-1000
            v0 = inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]);
            v1 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v0 > v1 / v2 && (inClose[i] >= inOpen[i] ? 1 : -1) == 1 && inOpen[i] > inOpen[i - 1] && inClose[i] > inHigh[i - 1]) {
                outInteger[outIdx++] = 100;
            } else lbl-1000:
            // 2 sources

            {
                outInteger[outIdx++] = 0;
            }
            ShadowVeryShortPeriodTotal += (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx - 1] - inOpen[ShadowVeryShortTrailingIdx - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx - 1] - inLow[ShadowVeryShortTrailingIdx - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx - 1] - (inClose[ShadowVeryShortTrailingIdx - 1] >= inOpen[ShadowVeryShortTrailingIdx - 1] ? inClose[ShadowVeryShortTrailingIdx - 1] : inOpen[ShadowVeryShortTrailingIdx - 1]) + ((inClose[ShadowVeryShortTrailingIdx - 1] >= inOpen[ShadowVeryShortTrailingIdx - 1] ? inOpen[ShadowVeryShortTrailingIdx - 1] : inClose[ShadowVeryShortTrailingIdx - 1]) - inLow[ShadowVeryShortTrailingIdx - 1]) : 0.0)));
            ++ShadowVeryShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlLadderBottom(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlLadderBottomLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        ShadowVeryShortPeriodTotal = 0.0;
        i = ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal += (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 4] >= inOpen[i - 4] ? 1 : -1) != -1 || (inClose[i - 3] >= inOpen[i - 3] ? 1 : -1) != -1 || (inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) != -1 || !(inOpen[i - 4] > inOpen[i - 3]) || !(inOpen[i - 3] > inOpen[i - 2]) || !(inClose[i - 4] > inClose[i - 3]) || !(inClose[i - 3] > inClose[i - 2]) || (inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != -1) ** GOTO lbl-1000
            v0 = inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]);
            v1 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v0 > v1 / v2 && (inClose[i] >= inOpen[i] ? 1 : -1) == 1 && inOpen[i] > inOpen[i - 1] && inClose[i] > inHigh[i - 1]) {
                outInteger[outIdx++] = 100;
            } else lbl-1000:
            // 2 sources

            {
                outInteger[outIdx++] = 0;
            }
            ShadowVeryShortPeriodTotal += (double)((this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx - 1] - inOpen[ShadowVeryShortTrailingIdx - 1]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx - 1] - inLow[ShadowVeryShortTrailingIdx - 1] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx - 1] - (inClose[ShadowVeryShortTrailingIdx - 1] >= inOpen[ShadowVeryShortTrailingIdx - 1] ? inClose[ShadowVeryShortTrailingIdx - 1] : inOpen[ShadowVeryShortTrailingIdx - 1]) + ((inClose[ShadowVeryShortTrailingIdx - 1] >= inOpen[ShadowVeryShortTrailingIdx - 1] ? inOpen[ShadowVeryShortTrailingIdx - 1] : inClose[ShadowVeryShortTrailingIdx - 1]) - inLow[ShadowVeryShortTrailingIdx - 1]) : 0.0f))));
            ++ShadowVeryShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlLongLeggedDojiLookback() {
        return this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlLongLeggedDoji(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlLongLeggedDojiLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyDojiPeriodTotal = 0.0;
        BodyDojiTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod;
        ShadowLongPeriodTotal = 0.0;
        ShadowLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod;
        i = BodyDojiTrailingIdx;
        while (i < startIdx) {
            BodyDojiPeriodTotal += this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = ShadowLongTrailingIdx;
        while (i < startIdx) {
            ShadowLongPeriodTotal += this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i] - inOpen[i]);
            v1 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod != 0.0 ? BodyDojiPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 <= v1 / v2)) ** GOTO lbl-1000
            if ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i] > this.candleSettings[CandleSettingType.ShadowLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod != 0.0 ? ShadowLongPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0)))) / (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0)) ** GOTO lbl-1000
            v3 = inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]);
            v4 = this.candleSettings[CandleSettingType.ShadowLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod != 0.0 ? ShadowLongPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v5 = this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v3 > v4 / v5) lbl-1000:
            // 2 sources

            {
                outInteger[outIdx++] = 100;
            } else lbl-1000:
            // 2 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyDojiPeriodTotal += (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyDojiTrailingIdx] - inOpen[BodyDojiTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyDojiTrailingIdx] - inLow[BodyDojiTrailingIdx] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyDojiTrailingIdx] - (inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inClose[BodyDojiTrailingIdx] : inOpen[BodyDojiTrailingIdx]) + ((inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inOpen[BodyDojiTrailingIdx] : inClose[BodyDojiTrailingIdx]) - inLow[BodyDojiTrailingIdx]) : 0.0)));
            ShadowLongPeriodTotal += (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowLongTrailingIdx] - inOpen[ShadowLongTrailingIdx]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowLongTrailingIdx] - inLow[ShadowLongTrailingIdx] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowLongTrailingIdx] - (inClose[ShadowLongTrailingIdx] >= inOpen[ShadowLongTrailingIdx] ? inClose[ShadowLongTrailingIdx] : inOpen[ShadowLongTrailingIdx]) + ((inClose[ShadowLongTrailingIdx] >= inOpen[ShadowLongTrailingIdx] ? inOpen[ShadowLongTrailingIdx] : inClose[ShadowLongTrailingIdx]) - inLow[ShadowLongTrailingIdx]) : 0.0)));
            ++BodyDojiTrailingIdx;
            ++ShadowLongTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlLongLeggedDoji(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlLongLeggedDojiLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyDojiPeriodTotal = 0.0;
        BodyDojiTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod;
        ShadowLongPeriodTotal = 0.0;
        ShadowLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod;
        i = BodyDojiTrailingIdx;
        while (i < startIdx) {
            BodyDojiPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = ShadowLongTrailingIdx;
        while (i < startIdx) {
            ShadowLongPeriodTotal += (double)(this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i] - inOpen[i]);
            v1 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod != 0.0 ? BodyDojiPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 <= v1 / v2)) ** GOTO lbl-1000
            if ((double)((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) > this.candleSettings[CandleSettingType.ShadowLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod != 0.0 ? ShadowLongPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)))) / (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0)) ** GOTO lbl-1000
            v3 = inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]);
            v4 = this.candleSettings[CandleSettingType.ShadowLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod != 0.0 ? ShadowLongPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v5 = this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v3 > v4 / v5) lbl-1000:
            // 2 sources

            {
                outInteger[outIdx++] = 100;
            } else lbl-1000:
            // 2 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyDojiPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyDojiTrailingIdx] - inOpen[BodyDojiTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyDojiTrailingIdx] - inLow[BodyDojiTrailingIdx] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyDojiTrailingIdx] - (inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inClose[BodyDojiTrailingIdx] : inOpen[BodyDojiTrailingIdx]) + ((inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inOpen[BodyDojiTrailingIdx] : inClose[BodyDojiTrailingIdx]) - inLow[BodyDojiTrailingIdx]) : 0.0f))));
            ShadowLongPeriodTotal += (double)((this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowLongTrailingIdx] - inOpen[ShadowLongTrailingIdx]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowLongTrailingIdx] - inLow[ShadowLongTrailingIdx] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowLongTrailingIdx] - (inClose[ShadowLongTrailingIdx] >= inOpen[ShadowLongTrailingIdx] ? inClose[ShadowLongTrailingIdx] : inOpen[ShadowLongTrailingIdx]) + ((inClose[ShadowLongTrailingIdx] >= inOpen[ShadowLongTrailingIdx] ? inOpen[ShadowLongTrailingIdx] : inClose[ShadowLongTrailingIdx]) - inLow[ShadowLongTrailingIdx]) : 0.0f))));
            ++BodyDojiTrailingIdx;
            ++ShadowLongTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlLongLineLookback() {
        return this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlLongLine(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlLongLineLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyPeriodTotal = 0.0;
        BodyTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        ShadowPeriodTotal = 0.0;
        ShadowTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod;
        i = BodyTrailingIdx;
        while (i < startIdx) {
            BodyPeriodTotal += this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = ShadowTrailingIdx;
        while (i < startIdx) {
            ShadowPeriodTotal += this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i] - inOpen[i]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2)) ** GOTO lbl-1000
            v3 = inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]);
            v4 = this.candleSettings[CandleSettingType.ShadowShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod != 0.0 ? ShadowPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v5 = this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 < v4 / v5)) ** GOTO lbl-1000
            v6 = (inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i];
            v7 = this.candleSettings[CandleSettingType.ShadowShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod != 0.0 ? ShadowPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v8 = this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v6 < v7 / v8) {
                outInteger[outIdx++] = (inClose[i] >= inOpen[i] ? 1 : -1) * 100;
            } else lbl-1000:
            // 3 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyPeriodTotal += (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyTrailingIdx] - inOpen[BodyTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyTrailingIdx] - inLow[BodyTrailingIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyTrailingIdx] - (inClose[BodyTrailingIdx] >= inOpen[BodyTrailingIdx] ? inClose[BodyTrailingIdx] : inOpen[BodyTrailingIdx]) + ((inClose[BodyTrailingIdx] >= inOpen[BodyTrailingIdx] ? inOpen[BodyTrailingIdx] : inClose[BodyTrailingIdx]) - inLow[BodyTrailingIdx]) : 0.0)));
            ShadowPeriodTotal += (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowTrailingIdx] - inOpen[ShadowTrailingIdx]) : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowTrailingIdx] - inLow[ShadowTrailingIdx] : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowTrailingIdx] - (inClose[ShadowTrailingIdx] >= inOpen[ShadowTrailingIdx] ? inClose[ShadowTrailingIdx] : inOpen[ShadowTrailingIdx]) + ((inClose[ShadowTrailingIdx] >= inOpen[ShadowTrailingIdx] ? inOpen[ShadowTrailingIdx] : inClose[ShadowTrailingIdx]) - inLow[ShadowTrailingIdx]) : 0.0)));
            ++BodyTrailingIdx;
            ++ShadowTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlLongLine(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlLongLineLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyPeriodTotal = 0.0;
        BodyTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        ShadowPeriodTotal = 0.0;
        ShadowTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod;
        i = BodyTrailingIdx;
        while (i < startIdx) {
            BodyPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = ShadowTrailingIdx;
        while (i < startIdx) {
            ShadowPeriodTotal += (double)(this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i] - inOpen[i]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2)) ** GOTO lbl-1000
            v3 = inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]);
            v4 = this.candleSettings[CandleSettingType.ShadowShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod != 0.0 ? ShadowPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v5 = this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 < v4 / v5)) ** GOTO lbl-1000
            v6 = (inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i];
            v7 = this.candleSettings[CandleSettingType.ShadowShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod != 0.0 ? ShadowPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v8 = this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v6 < v7 / v8) {
                outInteger[outIdx++] = (inClose[i] >= inOpen[i] ? 1 : -1) * 100;
            } else lbl-1000:
            // 3 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyTrailingIdx] - inOpen[BodyTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyTrailingIdx] - inLow[BodyTrailingIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyTrailingIdx] - (inClose[BodyTrailingIdx] >= inOpen[BodyTrailingIdx] ? inClose[BodyTrailingIdx] : inOpen[BodyTrailingIdx]) + ((inClose[BodyTrailingIdx] >= inOpen[BodyTrailingIdx] ? inOpen[BodyTrailingIdx] : inClose[BodyTrailingIdx]) - inLow[BodyTrailingIdx]) : 0.0f))));
            ShadowPeriodTotal += (double)((this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowTrailingIdx] - inOpen[ShadowTrailingIdx]) : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowTrailingIdx] - inLow[ShadowTrailingIdx] : (this.candleSettings[CandleSettingType.ShadowShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowTrailingIdx] - (inClose[ShadowTrailingIdx] >= inOpen[ShadowTrailingIdx] ? inClose[ShadowTrailingIdx] : inOpen[ShadowTrailingIdx]) + ((inClose[ShadowTrailingIdx] >= inOpen[ShadowTrailingIdx] ? inOpen[ShadowTrailingIdx] : inClose[ShadowTrailingIdx]) - inLow[ShadowTrailingIdx]) : 0.0f))));
            ++BodyTrailingIdx;
            ++ShadowTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlMarubozuLookback() {
        return this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlMarubozu(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlMarubozuLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        BodyLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        ShadowVeryShortPeriodTotal = 0.0;
        ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        i = BodyLongTrailingIdx;
        while (i < startIdx) {
            BodyLongPeriodTotal += this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = ShadowVeryShortTrailingIdx;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal += this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i] - inOpen[i]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2)) ** GOTO lbl-1000
            v3 = inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]);
            v4 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v5 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 < v4 / v5)) ** GOTO lbl-1000
            v6 = (inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i];
            v7 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v8 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v6 < v7 / v8) {
                outInteger[outIdx++] = (inClose[i] >= inOpen[i] ? 1 : -1) * 100;
            } else lbl-1000:
            // 3 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyLongPeriodTotal += (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx] - inOpen[BodyLongTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx] - inLow[BodyLongTrailingIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx] - (inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inClose[BodyLongTrailingIdx] : inOpen[BodyLongTrailingIdx]) + ((inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inOpen[BodyLongTrailingIdx] : inClose[BodyLongTrailingIdx]) - inLow[BodyLongTrailingIdx]) : 0.0)));
            ShadowVeryShortPeriodTotal += (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx] - inOpen[ShadowVeryShortTrailingIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx] - inLow[ShadowVeryShortTrailingIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx] - (inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inClose[ShadowVeryShortTrailingIdx] : inOpen[ShadowVeryShortTrailingIdx]) + ((inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inOpen[ShadowVeryShortTrailingIdx] : inClose[ShadowVeryShortTrailingIdx]) - inLow[ShadowVeryShortTrailingIdx]) : 0.0)));
            ++BodyLongTrailingIdx;
            ++ShadowVeryShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlMarubozu(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlMarubozuLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        BodyLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        ShadowVeryShortPeriodTotal = 0.0;
        ShadowVeryShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod;
        i = BodyLongTrailingIdx;
        while (i < startIdx) {
            BodyLongPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = ShadowVeryShortTrailingIdx;
        while (i < startIdx) {
            ShadowVeryShortPeriodTotal += (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i] - inOpen[i]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2)) ** GOTO lbl-1000
            v3 = inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]);
            v4 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v5 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 < v4 / v5)) ** GOTO lbl-1000
            v6 = (inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i];
            v7 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod != 0.0 ? ShadowVeryShortPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v8 = this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v6 < v7 / v8) {
                outInteger[outIdx++] = (inClose[i] >= inOpen[i] ? 1 : -1) * 100;
            } else lbl-1000:
            // 3 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyLongPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx] - inOpen[BodyLongTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx] - inLow[BodyLongTrailingIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx] - (inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inClose[BodyLongTrailingIdx] : inOpen[BodyLongTrailingIdx]) + ((inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inOpen[BodyLongTrailingIdx] : inClose[BodyLongTrailingIdx]) - inLow[BodyLongTrailingIdx]) : 0.0f))));
            ShadowVeryShortPeriodTotal += (double)((this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowVeryShortTrailingIdx] - inOpen[ShadowVeryShortTrailingIdx]) : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowVeryShortTrailingIdx] - inLow[ShadowVeryShortTrailingIdx] : (this.candleSettings[CandleSettingType.ShadowVeryShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowVeryShortTrailingIdx] - (inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inClose[ShadowVeryShortTrailingIdx] : inOpen[ShadowVeryShortTrailingIdx]) + ((inClose[ShadowVeryShortTrailingIdx] >= inOpen[ShadowVeryShortTrailingIdx] ? inOpen[ShadowVeryShortTrailingIdx] : inClose[ShadowVeryShortTrailingIdx]) - inLow[ShadowVeryShortTrailingIdx]) : 0.0f))));
            ++BodyLongTrailingIdx;
            ++ShadowVeryShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlMatchingLowLookback() {
        return this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod + 1;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlMatchingLow(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlMatchingLowLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        EqualPeriodTotal = 0.0;
        i = EqualTrailingIdx = startIdx - this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod;
        while (i < startIdx) {
            EqualPeriodTotal += this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != -1 || (inClose[i] >= inOpen[i] ? 1 : -1) != -1) ** GOTO lbl-1000
            v0 = inClose[i];
            v1 = inClose[i - 1];
            v2 = this.candleSettings[CandleSettingType.Equal.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod != 0.0 ? EqualPeriodTotal / (double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v3 = this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 <= v1 + v2 / v3)) ** GOTO lbl-1000
            v4 = inClose[i];
            v5 = inClose[i - 1];
            v6 = this.candleSettings[CandleSettingType.Equal.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod != 0.0 ? EqualPeriodTotal / (double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v7 = this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v4 >= v5 - v6 / v7) {
                outInteger[outIdx++] = 100;
            } else lbl-1000:
            // 3 sources

            {
                outInteger[outIdx++] = 0;
            }
            EqualPeriodTotal += (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))) - (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[EqualTrailingIdx - 1] - inOpen[EqualTrailingIdx - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[EqualTrailingIdx - 1] - inLow[EqualTrailingIdx - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[EqualTrailingIdx - 1] - (inClose[EqualTrailingIdx - 1] >= inOpen[EqualTrailingIdx - 1] ? inClose[EqualTrailingIdx - 1] : inOpen[EqualTrailingIdx - 1]) + ((inClose[EqualTrailingIdx - 1] >= inOpen[EqualTrailingIdx - 1] ? inOpen[EqualTrailingIdx - 1] : inClose[EqualTrailingIdx - 1]) - inLow[EqualTrailingIdx - 1]) : 0.0)));
            ++EqualTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlMatchingLow(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlMatchingLowLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        EqualPeriodTotal = 0.0;
        i = EqualTrailingIdx = startIdx - this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod;
        while (i < startIdx) {
            EqualPeriodTotal += (double)(this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != -1 || (inClose[i] >= inOpen[i] ? 1 : -1) != -1) ** GOTO lbl-1000
            v0 = inClose[i];
            v1 = inClose[i - 1];
            v2 = this.candleSettings[CandleSettingType.Equal.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod != 0.0 ? EqualPeriodTotal / (double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v3 = this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 <= v1 + v2 / v3)) ** GOTO lbl-1000
            v4 = inClose[i];
            v5 = inClose[i - 1];
            v6 = this.candleSettings[CandleSettingType.Equal.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod != 0.0 ? EqualPeriodTotal / (double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v7 = this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v4 >= v5 - v6 / v7) {
                outInteger[outIdx++] = 100;
            } else lbl-1000:
            // 3 sources

            {
                outInteger[outIdx++] = 0;
            }
            EqualPeriodTotal += (double)((this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))) - (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[EqualTrailingIdx - 1] - inOpen[EqualTrailingIdx - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[EqualTrailingIdx - 1] - inLow[EqualTrailingIdx - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[EqualTrailingIdx - 1] - (inClose[EqualTrailingIdx - 1] >= inOpen[EqualTrailingIdx - 1] ? inClose[EqualTrailingIdx - 1] : inOpen[EqualTrailingIdx - 1]) + ((inClose[EqualTrailingIdx - 1] >= inOpen[EqualTrailingIdx - 1] ? inOpen[EqualTrailingIdx - 1] : inClose[EqualTrailingIdx - 1]) - inLow[EqualTrailingIdx - 1]) : 0.0f))));
            ++EqualTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlMatHoldLookback(double optInPenetration) {
        if (optInPenetration == -4.0E37) {
            optInPenetration = 0.5;
        } else if (optInPenetration < 0.0 || optInPenetration > 3.0E37) {
            return -1;
        }
        return (this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod) + 4;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlMatHold(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, double optInPenetration, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        BodyPeriodTotal = new double[5];
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInPenetration == -4.0E37) {
            optInPenetration = 0.5;
        } else if (optInPenetration < 0.0 || optInPenetration > 3.0E37) {
            return RetCode.BadParam;
        }
        lookbackTotal = this.cdlMatHoldLookback(optInPenetration);
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyPeriodTotal[4] = 0.0;
        BodyPeriodTotal[3] = 0.0;
        BodyPeriodTotal[2] = 0.0;
        BodyPeriodTotal[1] = 0.0;
        BodyPeriodTotal[0] = 0.0;
        BodyShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod;
        BodyLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        i = BodyShortTrailingIdx;
        while (i < startIdx) {
            BodyPeriodTotal[3] = BodyPeriodTotal[3] + (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 3] - inOpen[i - 3]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 3] - inLow[i - 3] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 3] - (inClose[i - 3] >= inOpen[i - 3] ? inClose[i - 3] : inOpen[i - 3]) + ((inClose[i - 3] >= inOpen[i - 3] ? inOpen[i - 3] : inClose[i - 3]) - inLow[i - 3]) : 0.0)));
            BodyPeriodTotal[2] = BodyPeriodTotal[2] + (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0)));
            BodyPeriodTotal[1] = BodyPeriodTotal[1] + (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0)));
            ++i;
        }
        i = BodyLongTrailingIdx;
        while (i < startIdx) {
            BodyPeriodTotal[4] = BodyPeriodTotal[4] + (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 4] - inOpen[i - 4]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 4] - inLow[i - 4] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 4] - (inClose[i - 4] >= inOpen[i - 4] ? inClose[i - 4] : inOpen[i - 4]) + ((inClose[i - 4] >= inOpen[i - 4] ? inOpen[i - 4] : inClose[i - 4]) - inLow[i - 4]) : 0.0)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i - 4] - inOpen[i - 4]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyPeriodTotal[4] / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 4] - inOpen[i - 4]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 4] - inLow[i - 4] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 4] - (inClose[i - 4] >= inOpen[i - 4] ? inClose[i - 4] : inOpen[i - 4]) + ((inClose[i - 4] >= inOpen[i - 4] ? inOpen[i - 4] : inClose[i - 4]) - inLow[i - 4]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2)) ** GOTO lbl-1000
            v3 = Math.abs(inClose[i - 3] - inOpen[i - 3]);
            v4 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyPeriodTotal[3] / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 3] - inOpen[i - 3]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 3] - inLow[i - 3] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 3] - (inClose[i - 3] >= inOpen[i - 3] ? inClose[i - 3] : inOpen[i - 3]) + ((inClose[i - 3] >= inOpen[i - 3] ? inOpen[i - 3] : inClose[i - 3]) - inLow[i - 3]) : 0.0))));
            v5 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 < v4 / v5)) ** GOTO lbl-1000
            v6 = Math.abs(inClose[i - 2] - inOpen[i - 2]);
            v7 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyPeriodTotal[2] / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))));
            v8 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v6 < v7 / v8)) ** GOTO lbl-1000
            v9 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v10 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v11 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v9 < v10 / v11) || (inClose[i - 4] >= inOpen[i - 4] ? 1 : -1) != 1 || (inClose[i - 3] >= inOpen[i - 3] ? 1 : -1) != -1 || (inClose[i] >= inOpen[i] ? 1 : -1) != 1) ** GOTO lbl-1000
            v12 = inOpen[i - 3] < inClose[i - 3] ? inOpen[i - 3] : inClose[i - 3];
            v13 = inOpen[i - 4] > inClose[i - 4] ? inOpen[i - 4] : inClose[i - 4];
            if (!(v12 > v13)) ** GOTO lbl-1000
            v14 = inOpen[i - 2] < inClose[i - 2] ? inOpen[i - 2] : inClose[i - 2];
            if (!(v14 < inClose[i - 4])) ** GOTO lbl-1000
            v15 = inOpen[i - 1] < inClose[i - 1] ? inOpen[i - 1] : inClose[i - 1];
            if (!(v15 < inClose[i - 4])) ** GOTO lbl-1000
            v16 = inOpen[i - 2] < inClose[i - 2] ? inOpen[i - 2] : inClose[i - 2];
            if (!(v16 > inClose[i - 4] - Math.abs(inClose[i - 4] - inOpen[i - 4]) * optInPenetration)) ** GOTO lbl-1000
            v17 = inOpen[i - 1] < inClose[i - 1] ? inOpen[i - 1] : inClose[i - 1];
            if (!(v17 > inClose[i - 4] - Math.abs(inClose[i - 4] - inOpen[i - 4]) * optInPenetration)) ** GOTO lbl-1000
            v18 = inClose[i - 2] > inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2];
            if (!(v18 < inOpen[i - 3])) ** GOTO lbl-1000
            v19 = inClose[i - 1] > inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1];
            v20 = inClose[i - 2] > inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2];
            if (!(v19 < v20) || !(inOpen[i] > inClose[i - 1])) ** GOTO lbl-1000
            v21 = inClose[i];
            v22 = (inHigh[i - 3] > inHigh[i - 2] ? inHigh[i - 3] : inHigh[i - 2]) > inHigh[i - 1] ? (inHigh[i - 3] > inHigh[i - 2] ? inHigh[i - 3] : inHigh[i - 2]) : inHigh[i - 1];
            if (v21 > v22) {
                outInteger[outIdx++] = 100;
            } else lbl-1000:
            // 12 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyPeriodTotal[4] = BodyPeriodTotal[4] + ((this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 4] - inOpen[i - 4]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 4] - inLow[i - 4] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 4] - (inClose[i - 4] >= inOpen[i - 4] ? inClose[i - 4] : inOpen[i - 4]) + ((inClose[i - 4] >= inOpen[i - 4] ? inOpen[i - 4] : inClose[i - 4]) - inLow[i - 4]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx - 4] - inOpen[BodyLongTrailingIdx - 4]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx - 4] - inLow[BodyLongTrailingIdx - 4] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx - 4] - (inClose[BodyLongTrailingIdx - 4] >= inOpen[BodyLongTrailingIdx - 4] ? inClose[BodyLongTrailingIdx - 4] : inOpen[BodyLongTrailingIdx - 4]) + ((inClose[BodyLongTrailingIdx - 4] >= inOpen[BodyLongTrailingIdx - 4] ? inOpen[BodyLongTrailingIdx - 4] : inClose[BodyLongTrailingIdx - 4]) - inLow[BodyLongTrailingIdx - 4]) : 0.0))));
            totIdx = 3;
            while (totIdx >= 1) {
                v23 = totIdx;
                BodyPeriodTotal[v23] = BodyPeriodTotal[v23] + ((this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyShortTrailingIdx - totIdx] - inOpen[BodyShortTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyShortTrailingIdx - totIdx] - inLow[BodyShortTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyShortTrailingIdx - totIdx] - (inClose[BodyShortTrailingIdx - totIdx] >= inOpen[BodyShortTrailingIdx - totIdx] ? inClose[BodyShortTrailingIdx - totIdx] : inOpen[BodyShortTrailingIdx - totIdx]) + ((inClose[BodyShortTrailingIdx - totIdx] >= inOpen[BodyShortTrailingIdx - totIdx] ? inOpen[BodyShortTrailingIdx - totIdx] : inClose[BodyShortTrailingIdx - totIdx]) - inLow[BodyShortTrailingIdx - totIdx]) : 0.0))));
                --totIdx;
            }
            ++BodyShortTrailingIdx;
            ++BodyLongTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlMatHold(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, double optInPenetration, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        BodyPeriodTotal = new double[5];
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInPenetration == -4.0E37) {
            optInPenetration = 0.5;
        } else if (optInPenetration < 0.0 || optInPenetration > 3.0E37) {
            return RetCode.BadParam;
        }
        lookbackTotal = this.cdlMatHoldLookback(optInPenetration);
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyPeriodTotal[4] = 0.0;
        BodyPeriodTotal[3] = 0.0;
        BodyPeriodTotal[2] = 0.0;
        BodyPeriodTotal[1] = 0.0;
        BodyPeriodTotal[0] = 0.0;
        BodyShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod;
        BodyLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        i = BodyShortTrailingIdx;
        while (i < startIdx) {
            BodyPeriodTotal[3] = BodyPeriodTotal[3] + (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 3] - inOpen[i - 3]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 3] - inLow[i - 3] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 3] - (inClose[i - 3] >= inOpen[i - 3] ? inClose[i - 3] : inOpen[i - 3]) + ((inClose[i - 3] >= inOpen[i - 3] ? inOpen[i - 3] : inClose[i - 3]) - inLow[i - 3]) : 0.0f)));
            BodyPeriodTotal[2] = BodyPeriodTotal[2] + (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f)));
            BodyPeriodTotal[1] = BodyPeriodTotal[1] + (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)));
            ++i;
        }
        i = BodyLongTrailingIdx;
        while (i < startIdx) {
            BodyPeriodTotal[4] = BodyPeriodTotal[4] + (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 4] - inOpen[i - 4]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 4] - inLow[i - 4] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 4] - (inClose[i - 4] >= inOpen[i - 4] ? inClose[i - 4] : inOpen[i - 4]) + ((inClose[i - 4] >= inOpen[i - 4] ? inOpen[i - 4] : inClose[i - 4]) - inLow[i - 4]) : 0.0f)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i - 4] - inOpen[i - 4]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyPeriodTotal[4] / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 4] - inOpen[i - 4]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 4] - inLow[i - 4] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 4] - (inClose[i - 4] >= inOpen[i - 4] ? inClose[i - 4] : inOpen[i - 4]) + ((inClose[i - 4] >= inOpen[i - 4] ? inOpen[i - 4] : inClose[i - 4]) - inLow[i - 4]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2)) ** GOTO lbl-1000
            v3 = Math.abs(inClose[i - 3] - inOpen[i - 3]);
            v4 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyPeriodTotal[3] / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 3] - inOpen[i - 3]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 3] - inLow[i - 3] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 3] - (inClose[i - 3] >= inOpen[i - 3] ? inClose[i - 3] : inOpen[i - 3]) + ((inClose[i - 3] >= inOpen[i - 3] ? inOpen[i - 3] : inClose[i - 3]) - inLow[i - 3]) : 0.0f))));
            v5 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 < v4 / v5)) ** GOTO lbl-1000
            v6 = Math.abs(inClose[i - 2] - inOpen[i - 2]);
            v7 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyPeriodTotal[2] / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))));
            v8 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v6 < v7 / v8)) ** GOTO lbl-1000
            v9 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v10 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v11 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v9 < v10 / v11) || (inClose[i - 4] >= inOpen[i - 4] ? 1 : -1) != 1 || (inClose[i - 3] >= inOpen[i - 3] ? 1 : -1) != -1 || (inClose[i] >= inOpen[i] ? 1 : -1) != 1) ** GOTO lbl-1000
            v12 = inOpen[i - 3] < inClose[i - 3] ? inOpen[i - 3] : inClose[i - 3];
            v13 = inOpen[i - 4] > inClose[i - 4] ? inOpen[i - 4] : inClose[i - 4];
            if (!(v12 > v13)) ** GOTO lbl-1000
            v14 = inOpen[i - 2] < inClose[i - 2] ? inOpen[i - 2] : inClose[i - 2];
            if (!(v14 < inClose[i - 4])) ** GOTO lbl-1000
            v15 = inOpen[i - 1] < inClose[i - 1] ? inOpen[i - 1] : inClose[i - 1];
            if (!(v15 < inClose[i - 4])) ** GOTO lbl-1000
            v16 = inOpen[i - 2] < inClose[i - 2] ? inOpen[i - 2] : inClose[i - 2];
            if (!((double)v16 > (double)inClose[i - 4] - (double)Math.abs(inClose[i - 4] - inOpen[i - 4]) * optInPenetration)) ** GOTO lbl-1000
            v17 = inOpen[i - 1] < inClose[i - 1] ? inOpen[i - 1] : inClose[i - 1];
            if (!((double)v17 > (double)inClose[i - 4] - (double)Math.abs(inClose[i - 4] - inOpen[i - 4]) * optInPenetration)) ** GOTO lbl-1000
            v18 = inClose[i - 2] > inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2];
            if (!(v18 < inOpen[i - 3])) ** GOTO lbl-1000
            v19 = inClose[i - 1] > inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1];
            v20 = inClose[i - 2] > inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2];
            if (!(v19 < v20) || !(inOpen[i] > inClose[i - 1])) ** GOTO lbl-1000
            v21 = inClose[i];
            v22 = (inHigh[i - 3] > inHigh[i - 2] ? inHigh[i - 3] : inHigh[i - 2]) > inHigh[i - 1] ? (inHigh[i - 3] > inHigh[i - 2] ? inHigh[i - 3] : inHigh[i - 2]) : inHigh[i - 1];
            if (v21 > v22) {
                outInteger[outIdx++] = 100;
            } else lbl-1000:
            // 12 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyPeriodTotal[4] = BodyPeriodTotal[4] + (double)((this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 4] - inOpen[i - 4]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 4] - inLow[i - 4] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 4] - (inClose[i - 4] >= inOpen[i - 4] ? inClose[i - 4] : inOpen[i - 4]) + ((inClose[i - 4] >= inOpen[i - 4] ? inOpen[i - 4] : inClose[i - 4]) - inLow[i - 4]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx - 4] - inOpen[BodyLongTrailingIdx - 4]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx - 4] - inLow[BodyLongTrailingIdx - 4] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx - 4] - (inClose[BodyLongTrailingIdx - 4] >= inOpen[BodyLongTrailingIdx - 4] ? inClose[BodyLongTrailingIdx - 4] : inOpen[BodyLongTrailingIdx - 4]) + ((inClose[BodyLongTrailingIdx - 4] >= inOpen[BodyLongTrailingIdx - 4] ? inOpen[BodyLongTrailingIdx - 4] : inClose[BodyLongTrailingIdx - 4]) - inLow[BodyLongTrailingIdx - 4]) : 0.0f))));
            totIdx = 3;
            while (totIdx >= 1) {
                v23 = totIdx;
                BodyPeriodTotal[v23] = BodyPeriodTotal[v23] + (double)((this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyShortTrailingIdx - totIdx] - inOpen[BodyShortTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyShortTrailingIdx - totIdx] - inLow[BodyShortTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyShortTrailingIdx - totIdx] - (inClose[BodyShortTrailingIdx - totIdx] >= inOpen[BodyShortTrailingIdx - totIdx] ? inClose[BodyShortTrailingIdx - totIdx] : inOpen[BodyShortTrailingIdx - totIdx]) + ((inClose[BodyShortTrailingIdx - totIdx] >= inOpen[BodyShortTrailingIdx - totIdx] ? inOpen[BodyShortTrailingIdx - totIdx] : inClose[BodyShortTrailingIdx - totIdx]) - inLow[BodyShortTrailingIdx - totIdx]) : 0.0f))));
                --totIdx;
            }
            ++BodyShortTrailingIdx;
            ++BodyLongTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlMorningDojiStarLookback(double optInPenetration) {
        if (optInPenetration == -4.0E37) {
            optInPenetration = 0.3;
        } else if (optInPenetration < 0.0 || optInPenetration > 3.0E37) {
            return -1;
        }
        return ((this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod) > this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod ? (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod) : this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod) + 2;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlMorningDojiStar(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, double optInPenetration, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInPenetration == -4.0E37) {
            optInPenetration = 0.3;
        } else if (optInPenetration < 0.0 || optInPenetration > 3.0E37) {
            return RetCode.BadParam;
        }
        lookbackTotal = this.cdlMorningDojiStarLookback(optInPenetration);
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        BodyDojiPeriodTotal = 0.0;
        BodyShortPeriodTotal = 0.0;
        BodyLongTrailingIdx = startIdx - 2 - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        BodyDojiTrailingIdx = startIdx - 1 - this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod;
        BodyShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod;
        i = BodyLongTrailingIdx;
        while (i < startIdx - 2) {
            BodyLongPeriodTotal += this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = BodyDojiTrailingIdx;
        while (i < startIdx - 1) {
            BodyDojiPeriodTotal += this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = BodyShortTrailingIdx;
        while (i < startIdx) {
            BodyShortPeriodTotal += this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i - 2] - inOpen[i - 2]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2) || (inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) != -1) ** GOTO lbl-1000
            v3 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v4 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod != 0.0 ? BodyDojiPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v5 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 <= v4 / v5)) ** GOTO lbl-1000
            v6 = inOpen[i - 1] > inClose[i - 1] ? inOpen[i - 1] : inClose[i - 1];
            v7 = inOpen[i - 2] < inClose[i - 2] ? inOpen[i - 2] : inClose[i - 2];
            if (!(v6 < v7)) ** GOTO lbl-1000
            v8 = Math.abs(inClose[i] - inOpen[i]);
            v9 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyShortPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v10 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v8 > v9 / v10 && (inClose[i] >= inOpen[i] ? 1 : -1) == 1 && inClose[i] > inClose[i - 2] + Math.abs(inClose[i - 2] - inOpen[i - 2]) * optInPenetration) {
                outInteger[outIdx++] = 100;
            } else lbl-1000:
            // 4 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyLongPeriodTotal += (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx] - inOpen[BodyLongTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx] - inLow[BodyLongTrailingIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx] - (inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inClose[BodyLongTrailingIdx] : inOpen[BodyLongTrailingIdx]) + ((inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inOpen[BodyLongTrailingIdx] : inClose[BodyLongTrailingIdx]) - inLow[BodyLongTrailingIdx]) : 0.0)));
            BodyDojiPeriodTotal += (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyDojiTrailingIdx] - inOpen[BodyDojiTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyDojiTrailingIdx] - inLow[BodyDojiTrailingIdx] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyDojiTrailingIdx] - (inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inClose[BodyDojiTrailingIdx] : inOpen[BodyDojiTrailingIdx]) + ((inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inOpen[BodyDojiTrailingIdx] : inClose[BodyDojiTrailingIdx]) - inLow[BodyDojiTrailingIdx]) : 0.0)));
            BodyShortPeriodTotal += (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyShortTrailingIdx] - inOpen[BodyShortTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyShortTrailingIdx] - inLow[BodyShortTrailingIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyShortTrailingIdx] - (inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inClose[BodyShortTrailingIdx] : inOpen[BodyShortTrailingIdx]) + ((inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inOpen[BodyShortTrailingIdx] : inClose[BodyShortTrailingIdx]) - inLow[BodyShortTrailingIdx]) : 0.0)));
            ++BodyLongTrailingIdx;
            ++BodyDojiTrailingIdx;
            ++BodyShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlMorningDojiStar(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, double optInPenetration, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInPenetration == -4.0E37) {
            optInPenetration = 0.3;
        } else if (optInPenetration < 0.0 || optInPenetration > 3.0E37) {
            return RetCode.BadParam;
        }
        lookbackTotal = this.cdlMorningDojiStarLookback(optInPenetration);
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        BodyDojiPeriodTotal = 0.0;
        BodyShortPeriodTotal = 0.0;
        BodyLongTrailingIdx = startIdx - 2 - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        BodyDojiTrailingIdx = startIdx - 1 - this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod;
        BodyShortTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod;
        i = BodyLongTrailingIdx;
        while (i < startIdx - 2) {
            BodyLongPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = BodyDojiTrailingIdx;
        while (i < startIdx - 1) {
            BodyDojiPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = BodyShortTrailingIdx;
        while (i < startIdx) {
            BodyShortPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i - 2] - inOpen[i - 2]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2) || (inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) != -1) ** GOTO lbl-1000
            v3 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v4 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod != 0.0 ? BodyDojiPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v5 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 <= v4 / v5)) ** GOTO lbl-1000
            v6 = inOpen[i - 1] > inClose[i - 1] ? inOpen[i - 1] : inClose[i - 1];
            v7 = inOpen[i - 2] < inClose[i - 2] ? inOpen[i - 2] : inClose[i - 2];
            if (!(v6 < v7)) ** GOTO lbl-1000
            v8 = Math.abs(inClose[i] - inOpen[i]);
            v9 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyShortPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v10 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v8 > v9 / v10 && (inClose[i] >= inOpen[i] ? 1 : -1) == 1 && (double)inClose[i] > (double)inClose[i - 2] + (double)Math.abs(inClose[i - 2] - inOpen[i - 2]) * optInPenetration) {
                outInteger[outIdx++] = 100;
            } else lbl-1000:
            // 4 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyLongPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx] - inOpen[BodyLongTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx] - inLow[BodyLongTrailingIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx] - (inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inClose[BodyLongTrailingIdx] : inOpen[BodyLongTrailingIdx]) + ((inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inOpen[BodyLongTrailingIdx] : inClose[BodyLongTrailingIdx]) - inLow[BodyLongTrailingIdx]) : 0.0f))));
            BodyDojiPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyDojiTrailingIdx] - inOpen[BodyDojiTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyDojiTrailingIdx] - inLow[BodyDojiTrailingIdx] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyDojiTrailingIdx] - (inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inClose[BodyDojiTrailingIdx] : inOpen[BodyDojiTrailingIdx]) + ((inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inOpen[BodyDojiTrailingIdx] : inClose[BodyDojiTrailingIdx]) - inLow[BodyDojiTrailingIdx]) : 0.0f))));
            BodyShortPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyShortTrailingIdx] - inOpen[BodyShortTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyShortTrailingIdx] - inLow[BodyShortTrailingIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyShortTrailingIdx] - (inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inClose[BodyShortTrailingIdx] : inOpen[BodyShortTrailingIdx]) + ((inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inOpen[BodyShortTrailingIdx] : inClose[BodyShortTrailingIdx]) - inLow[BodyShortTrailingIdx]) : 0.0f))));
            ++BodyLongTrailingIdx;
            ++BodyDojiTrailingIdx;
            ++BodyShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlMorningStarLookback(double optInPenetration) {
        if (optInPenetration == -4.0E37) {
            optInPenetration = 0.3;
        } else if (optInPenetration < 0.0 || optInPenetration > 3.0E37) {
            return -1;
        }
        return (this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod) + 2;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlMorningStar(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, double optInPenetration, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInPenetration == -4.0E37) {
            optInPenetration = 0.3;
        } else if (optInPenetration < 0.0 || optInPenetration > 3.0E37) {
            return RetCode.BadParam;
        }
        lookbackTotal = this.cdlMorningStarLookback(optInPenetration);
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        BodyShortPeriodTotal = 0.0;
        BodyShortPeriodTotal2 = 0.0;
        BodyLongTrailingIdx = startIdx - 2 - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        BodyShortTrailingIdx = startIdx - 1 - this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod;
        i = BodyLongTrailingIdx;
        while (i < startIdx - 2) {
            BodyLongPeriodTotal += this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = BodyShortTrailingIdx;
        while (i < startIdx - 1) {
            BodyShortPeriodTotal += this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            BodyShortPeriodTotal2 += this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i + 1] - inOpen[i + 1]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i + 1] - inLow[i + 1] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i + 1] - (inClose[i + 1] >= inOpen[i + 1] ? inClose[i + 1] : inOpen[i + 1]) + ((inClose[i + 1] >= inOpen[i + 1] ? inOpen[i + 1] : inClose[i + 1]) - inLow[i + 1]) : 0.0));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i - 2] - inOpen[i - 2]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2) || (inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) != -1) ** GOTO lbl-1000
            v3 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v4 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyShortPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v5 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 <= v4 / v5)) ** GOTO lbl-1000
            v6 = inOpen[i - 1] > inClose[i - 1] ? inOpen[i - 1] : inClose[i - 1];
            v7 = inOpen[i - 2] < inClose[i - 2] ? inOpen[i - 2] : inClose[i - 2];
            if (!(v6 < v7)) ** GOTO lbl-1000
            v8 = Math.abs(inClose[i] - inOpen[i]);
            v9 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyShortPeriodTotal2 / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v10 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v8 > v9 / v10 && (inClose[i] >= inOpen[i] ? 1 : -1) == 1 && inClose[i] > inClose[i - 2] + Math.abs(inClose[i - 2] - inOpen[i - 2]) * optInPenetration) {
                outInteger[outIdx++] = 100;
            } else lbl-1000:
            // 4 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyLongPeriodTotal += (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx] - inOpen[BodyLongTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx] - inLow[BodyLongTrailingIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx] - (inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inClose[BodyLongTrailingIdx] : inOpen[BodyLongTrailingIdx]) + ((inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inOpen[BodyLongTrailingIdx] : inClose[BodyLongTrailingIdx]) - inLow[BodyLongTrailingIdx]) : 0.0)));
            BodyShortPeriodTotal += (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyShortTrailingIdx] - inOpen[BodyShortTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyShortTrailingIdx] - inLow[BodyShortTrailingIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyShortTrailingIdx] - (inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inClose[BodyShortTrailingIdx] : inOpen[BodyShortTrailingIdx]) + ((inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inOpen[BodyShortTrailingIdx] : inClose[BodyShortTrailingIdx]) - inLow[BodyShortTrailingIdx]) : 0.0)));
            BodyShortPeriodTotal2 += (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyShortTrailingIdx + 1] - inOpen[BodyShortTrailingIdx + 1]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyShortTrailingIdx + 1] - inLow[BodyShortTrailingIdx + 1] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyShortTrailingIdx + 1] - (inClose[BodyShortTrailingIdx + 1] >= inOpen[BodyShortTrailingIdx + 1] ? inClose[BodyShortTrailingIdx + 1] : inOpen[BodyShortTrailingIdx + 1]) + ((inClose[BodyShortTrailingIdx + 1] >= inOpen[BodyShortTrailingIdx + 1] ? inOpen[BodyShortTrailingIdx + 1] : inClose[BodyShortTrailingIdx + 1]) - inLow[BodyShortTrailingIdx + 1]) : 0.0)));
            ++BodyLongTrailingIdx;
            ++BodyShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlMorningStar(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, double optInPenetration, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        if (optInPenetration == -4.0E37) {
            optInPenetration = 0.3;
        } else if (optInPenetration < 0.0 || optInPenetration > 3.0E37) {
            return RetCode.BadParam;
        }
        lookbackTotal = this.cdlMorningStarLookback(optInPenetration);
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal = 0.0;
        BodyShortPeriodTotal = 0.0;
        BodyShortPeriodTotal2 = 0.0;
        BodyLongTrailingIdx = startIdx - 2 - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        BodyShortTrailingIdx = startIdx - 1 - this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod;
        i = BodyLongTrailingIdx;
        while (i < startIdx - 2) {
            BodyLongPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = BodyShortTrailingIdx;
        while (i < startIdx - 1) {
            BodyShortPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            BodyShortPeriodTotal2 += (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i + 1] - inOpen[i + 1]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i + 1] - inLow[i + 1] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i + 1] - (inClose[i + 1] >= inOpen[i + 1] ? inClose[i + 1] : inOpen[i + 1]) + ((inClose[i + 1] >= inOpen[i + 1] ? inOpen[i + 1] : inClose[i + 1]) - inLow[i + 1]) : 0.0f)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i - 2] - inOpen[i - 2]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2) || (inClose[i - 2] >= inOpen[i - 2] ? 1 : -1) != -1) ** GOTO lbl-1000
            v3 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v4 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyShortPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v5 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 <= v4 / v5)) ** GOTO lbl-1000
            v6 = inOpen[i - 1] > inClose[i - 1] ? inOpen[i - 1] : inClose[i - 1];
            v7 = inOpen[i - 2] < inClose[i - 2] ? inOpen[i - 2] : inClose[i - 2];
            if (!(v6 < v7)) ** GOTO lbl-1000
            v8 = Math.abs(inClose[i] - inOpen[i]);
            v9 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod != 0.0 ? BodyShortPeriodTotal2 / (double)this.candleSettings[CandleSettingType.BodyShort.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v10 = this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v8 > v9 / v10 && (inClose[i] >= inOpen[i] ? 1 : -1) == 1 && (double)inClose[i] > (double)inClose[i - 2] + (double)Math.abs(inClose[i - 2] - inOpen[i - 2]) * optInPenetration) {
                outInteger[outIdx++] = 100;
            } else lbl-1000:
            // 4 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyLongPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 2] - inOpen[i - 2]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 2] - inLow[i - 2] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 2] - (inClose[i - 2] >= inOpen[i - 2] ? inClose[i - 2] : inOpen[i - 2]) + ((inClose[i - 2] >= inOpen[i - 2] ? inOpen[i - 2] : inClose[i - 2]) - inLow[i - 2]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx] - inOpen[BodyLongTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx] - inLow[BodyLongTrailingIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx] - (inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inClose[BodyLongTrailingIdx] : inOpen[BodyLongTrailingIdx]) + ((inClose[BodyLongTrailingIdx] >= inOpen[BodyLongTrailingIdx] ? inOpen[BodyLongTrailingIdx] : inClose[BodyLongTrailingIdx]) - inLow[BodyLongTrailingIdx]) : 0.0f))));
            BodyShortPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyShortTrailingIdx] - inOpen[BodyShortTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyShortTrailingIdx] - inLow[BodyShortTrailingIdx] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyShortTrailingIdx] - (inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inClose[BodyShortTrailingIdx] : inOpen[BodyShortTrailingIdx]) + ((inClose[BodyShortTrailingIdx] >= inOpen[BodyShortTrailingIdx] ? inOpen[BodyShortTrailingIdx] : inClose[BodyShortTrailingIdx]) - inLow[BodyShortTrailingIdx]) : 0.0f))));
            BodyShortPeriodTotal2 += (double)((this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyShortTrailingIdx + 1] - inOpen[BodyShortTrailingIdx + 1]) : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyShortTrailingIdx + 1] - inLow[BodyShortTrailingIdx + 1] : (this.candleSettings[CandleSettingType.BodyShort.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyShortTrailingIdx + 1] - (inClose[BodyShortTrailingIdx + 1] >= inOpen[BodyShortTrailingIdx + 1] ? inClose[BodyShortTrailingIdx + 1] : inOpen[BodyShortTrailingIdx + 1]) + ((inClose[BodyShortTrailingIdx + 1] >= inOpen[BodyShortTrailingIdx + 1] ? inOpen[BodyShortTrailingIdx + 1] : inClose[BodyShortTrailingIdx + 1]) - inLow[BodyShortTrailingIdx + 1]) : 0.0f))));
            ++BodyLongTrailingIdx;
            ++BodyShortTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlOnNeckLookback() {
        return (this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod) + 1;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlOnNeck(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlOnNeckLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        EqualPeriodTotal = 0.0;
        EqualTrailingIdx = startIdx - this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod;
        BodyLongPeriodTotal = 0.0;
        BodyLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        i = EqualTrailingIdx;
        while (i < startIdx) {
            EqualPeriodTotal += this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0));
            ++i;
        }
        i = BodyLongTrailingIdx;
        while (i < startIdx) {
            BodyLongPeriodTotal += this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != -1) ** GOTO lbl-1000
            v0 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2) || (inClose[i] >= inOpen[i] ? 1 : -1) != 1 || !(inOpen[i] < inLow[i - 1])) ** GOTO lbl-1000
            v3 = inClose[i];
            v4 = inLow[i - 1];
            v5 = this.candleSettings[CandleSettingType.Equal.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod != 0.0 ? EqualPeriodTotal / (double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v6 = this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 <= v4 + v5 / v6)) ** GOTO lbl-1000
            v7 = inClose[i];
            v8 = inLow[i - 1];
            v9 = this.candleSettings[CandleSettingType.Equal.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod != 0.0 ? EqualPeriodTotal / (double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v10 = this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v7 >= v8 - v9 / v10) {
                outInteger[outIdx++] = -100;
            } else lbl-1000:
            // 4 sources

            {
                outInteger[outIdx++] = 0;
            }
            EqualPeriodTotal += (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))) - (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[EqualTrailingIdx - 1] - inOpen[EqualTrailingIdx - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[EqualTrailingIdx - 1] - inLow[EqualTrailingIdx - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[EqualTrailingIdx - 1] - (inClose[EqualTrailingIdx - 1] >= inOpen[EqualTrailingIdx - 1] ? inClose[EqualTrailingIdx - 1] : inOpen[EqualTrailingIdx - 1]) + ((inClose[EqualTrailingIdx - 1] >= inOpen[EqualTrailingIdx - 1] ? inOpen[EqualTrailingIdx - 1] : inClose[EqualTrailingIdx - 1]) - inLow[EqualTrailingIdx - 1]) : 0.0)));
            BodyLongPeriodTotal += (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx - 1] - inOpen[BodyLongTrailingIdx - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx - 1] - inLow[BodyLongTrailingIdx - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx - 1] - (inClose[BodyLongTrailingIdx - 1] >= inOpen[BodyLongTrailingIdx - 1] ? inClose[BodyLongTrailingIdx - 1] : inOpen[BodyLongTrailingIdx - 1]) + ((inClose[BodyLongTrailingIdx - 1] >= inOpen[BodyLongTrailingIdx - 1] ? inOpen[BodyLongTrailingIdx - 1] : inClose[BodyLongTrailingIdx - 1]) - inLow[BodyLongTrailingIdx - 1]) : 0.0)));
            ++EqualTrailingIdx;
            ++BodyLongTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlOnNeck(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlOnNeckLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        EqualPeriodTotal = 0.0;
        EqualTrailingIdx = startIdx - this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod;
        BodyLongPeriodTotal = 0.0;
        BodyLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        i = EqualTrailingIdx;
        while (i < startIdx) {
            EqualPeriodTotal += (double)(this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)));
            ++i;
        }
        i = BodyLongTrailingIdx;
        while (i < startIdx) {
            BodyLongPeriodTotal += (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != -1) ** GOTO lbl-1000
            v0 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2) || (inClose[i] >= inOpen[i] ? 1 : -1) != 1 || !(inOpen[i] < inLow[i - 1])) ** GOTO lbl-1000
            v3 = inClose[i];
            v4 = inLow[i - 1];
            v5 = this.candleSettings[CandleSettingType.Equal.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod != 0.0 ? EqualPeriodTotal / (double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v6 = this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 <= v4 + v5 / v6)) ** GOTO lbl-1000
            v7 = inClose[i];
            v8 = inLow[i - 1];
            v9 = this.candleSettings[CandleSettingType.Equal.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod != 0.0 ? EqualPeriodTotal / (double)this.candleSettings[CandleSettingType.Equal.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v10 = this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v7 >= v8 - v9 / v10) {
                outInteger[outIdx++] = -100;
            } else lbl-1000:
            // 4 sources

            {
                outInteger[outIdx++] = 0;
            }
            EqualPeriodTotal += (double)((this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))) - (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[EqualTrailingIdx - 1] - inOpen[EqualTrailingIdx - 1]) : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.HighLow ? inHigh[EqualTrailingIdx - 1] - inLow[EqualTrailingIdx - 1] : (this.candleSettings[CandleSettingType.Equal.ordinal()].rangeType == RangeType.Shadows ? inHigh[EqualTrailingIdx - 1] - (inClose[EqualTrailingIdx - 1] >= inOpen[EqualTrailingIdx - 1] ? inClose[EqualTrailingIdx - 1] : inOpen[EqualTrailingIdx - 1]) + ((inClose[EqualTrailingIdx - 1] >= inOpen[EqualTrailingIdx - 1] ? inOpen[EqualTrailingIdx - 1] : inClose[EqualTrailingIdx - 1]) - inLow[EqualTrailingIdx - 1]) : 0.0f))));
            BodyLongPeriodTotal += (double)((this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx - 1] - inOpen[BodyLongTrailingIdx - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx - 1] - inLow[BodyLongTrailingIdx - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx - 1] - (inClose[BodyLongTrailingIdx - 1] >= inOpen[BodyLongTrailingIdx - 1] ? inClose[BodyLongTrailingIdx - 1] : inOpen[BodyLongTrailingIdx - 1]) + ((inClose[BodyLongTrailingIdx - 1] >= inOpen[BodyLongTrailingIdx - 1] ? inOpen[BodyLongTrailingIdx - 1] : inClose[BodyLongTrailingIdx - 1]) - inLow[BodyLongTrailingIdx - 1]) : 0.0f))));
            ++EqualTrailingIdx;
            ++BodyLongTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlPiercingLookback() {
        return this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod + 1;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlPiercing(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        BodyLongPeriodTotal = new double[2];
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlPiercingLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal[1] = 0.0;
        BodyLongPeriodTotal[0] = 0.0;
        i = BodyLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        while (i < startIdx) {
            BodyLongPeriodTotal[1] = BodyLongPeriodTotal[1] + (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0)));
            BodyLongPeriodTotal[0] = BodyLongPeriodTotal[0] + (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != -1) ** GOTO lbl-1000
            v0 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2) || (inClose[i] >= inOpen[i] ? 1 : -1) != 1) ** GOTO lbl-1000
            v3 = Math.abs(inClose[i] - inOpen[i]);
            v4 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal[0] / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v5 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v3 > v4 / v5 && inOpen[i] < inLow[i - 1] && inClose[i] < inOpen[i - 1] && inClose[i] > inClose[i - 1] + Math.abs(inClose[i - 1] - inOpen[i - 1]) * 0.5) {
                outInteger[outIdx++] = 100;
            } else lbl-1000:
            // 3 sources

            {
                outInteger[outIdx++] = 0;
            }
            totIdx = 1;
            while (totIdx >= 0) {
                v6 = totIdx;
                BodyLongPeriodTotal[v6] = BodyLongPeriodTotal[v6] + ((this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx - totIdx] - inOpen[BodyLongTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx - totIdx] - inLow[BodyLongTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx - totIdx] - (inClose[BodyLongTrailingIdx - totIdx] >= inOpen[BodyLongTrailingIdx - totIdx] ? inClose[BodyLongTrailingIdx - totIdx] : inOpen[BodyLongTrailingIdx - totIdx]) + ((inClose[BodyLongTrailingIdx - totIdx] >= inOpen[BodyLongTrailingIdx - totIdx] ? inOpen[BodyLongTrailingIdx - totIdx] : inClose[BodyLongTrailingIdx - totIdx]) - inLow[BodyLongTrailingIdx - totIdx]) : 0.0))));
                --totIdx;
            }
            ++BodyLongTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlPiercing(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        BodyLongPeriodTotal = new double[2];
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlPiercingLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyLongPeriodTotal[1] = 0.0;
        BodyLongPeriodTotal[0] = 0.0;
        i = BodyLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod;
        while (i < startIdx) {
            BodyLongPeriodTotal[1] = BodyLongPeriodTotal[1] + (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f)));
            BodyLongPeriodTotal[0] = BodyLongPeriodTotal[0] + (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f)));
            ++i;
        }
        i = startIdx;
        outIdx = 0;
        do {
            if ((inClose[i - 1] >= inOpen[i - 1] ? 1 : -1) != -1) ** GOTO lbl-1000
            v0 = Math.abs(inClose[i - 1] - inOpen[i - 1]);
            v1 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal[1] / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - 1] - inOpen[i - 1]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - 1] - inLow[i - 1] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - 1] - (inClose[i - 1] >= inOpen[i - 1] ? inClose[i - 1] : inOpen[i - 1]) + ((inClose[i - 1] >= inOpen[i - 1] ? inOpen[i - 1] : inClose[i - 1]) - inLow[i - 1]) : 0.0f))));
            v2 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 > v1 / v2) || (inClose[i] >= inOpen[i] ? 1 : -1) != 1) ** GOTO lbl-1000
            v3 = Math.abs(inClose[i] - inOpen[i]);
            v4 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod != 0.0 ? BodyLongPeriodTotal[0] / (double)this.candleSettings[CandleSettingType.BodyLong.ordinal()].avgPeriod : (double)(this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0f))));
            v5 = this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v3 > v4 / v5 && inOpen[i] < inLow[i - 1] && inClose[i] < inOpen[i - 1] && (double)inClose[i] > (double)inClose[i - 1] + (double)Math.abs(inClose[i - 1] - inOpen[i - 1]) * 0.5) {
                outInteger[outIdx++] = 100;
            } else lbl-1000:
            // 3 sources

            {
                outInteger[outIdx++] = 0;
            }
            totIdx = 1;
            while (totIdx >= 0) {
                v6 = totIdx;
                BodyLongPeriodTotal[v6] = BodyLongPeriodTotal[v6] + (double)((this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i - totIdx] - inOpen[i - totIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i - totIdx] - inLow[i - totIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i - totIdx] - (inClose[i - totIdx] >= inOpen[i - totIdx] ? inClose[i - totIdx] : inOpen[i - totIdx]) + ((inClose[i - totIdx] >= inOpen[i - totIdx] ? inOpen[i - totIdx] : inClose[i - totIdx]) - inLow[i - totIdx]) : 0.0f))) - (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyLongTrailingIdx - totIdx] - inOpen[BodyLongTrailingIdx - totIdx]) : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyLongTrailingIdx - totIdx] - inLow[BodyLongTrailingIdx - totIdx] : (this.candleSettings[CandleSettingType.BodyLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyLongTrailingIdx - totIdx] - (inClose[BodyLongTrailingIdx - totIdx] >= inOpen[BodyLongTrailingIdx - totIdx] ? inClose[BodyLongTrailingIdx - totIdx] : inOpen[BodyLongTrailingIdx - totIdx]) + ((inClose[BodyLongTrailingIdx - totIdx] >= inOpen[BodyLongTrailingIdx - totIdx] ? inOpen[BodyLongTrailingIdx - totIdx] : inClose[BodyLongTrailingIdx - totIdx]) - inLow[BodyLongTrailingIdx - totIdx]) : 0.0f))));
                --totIdx;
            }
            ++BodyLongTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    public int cdlRickshawManLookback() {
        return (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod) > this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod ? (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod > this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod ? this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod) : this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlRickshawMan(int startIdx, int endIdx, double[] inOpen, double[] inHigh, double[] inLow, double[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlRickshawManLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyDojiPeriodTotal = 0.0;
        BodyDojiTrailingIdx = startIdx - this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod;
        ShadowLongPeriodTotal = 0.0;
        ShadowLongTrailingIdx = startIdx - this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod;
        NearPeriodTotal = 0.0;
        NearTrailingIdx = startIdx - this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod;
        i = BodyDojiTrailingIdx;
        while (i < startIdx) {
            BodyDojiPeriodTotal += this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = ShadowLongTrailingIdx;
        while (i < startIdx) {
            ShadowLongPeriodTotal += this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        i = NearTrailingIdx;
        while (i < startIdx) {
            NearPeriodTotal += this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0));
            ++i;
        }
        outIdx = 0;
        do {
            v0 = Math.abs(inClose[i] - inOpen[i]);
            v1 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod != 0.0 ? BodyDojiPeriodTotal / (double)this.candleSettings[CandleSettingType.BodyDoji.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v2 = this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v0 <= v1 / v2)) ** GOTO lbl-1000
            v3 = (inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i];
            v4 = this.candleSettings[CandleSettingType.ShadowLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod != 0.0 ? ShadowLongPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v5 = this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v3 > v4 / v5)) ** GOTO lbl-1000
            v6 = inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]);
            v7 = this.candleSettings[CandleSettingType.ShadowLong.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod != 0.0 ? ShadowLongPeriodTotal / (double)this.candleSettings[CandleSettingType.ShadowLong.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v8 = this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v6 > v7 / v8)) ** GOTO lbl-1000
            v9 = inOpen[i] < inClose[i] ? inOpen[i] : inClose[i];
            v10 = inLow[i] + (inHigh[i] - inLow[i]) / 2.0;
            v11 = this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v12 = this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (!(v9 <= v10 + v11 / v12)) ** GOTO lbl-1000
            v13 = inOpen[i] > inClose[i] ? inOpen[i] : inClose[i];
            v14 = inLow[i] + (inHigh[i] - inLow[i]) / 2.0;
            v15 = this.candleSettings[CandleSettingType.Near.ordinal()].factor * ((double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod != 0.0 ? NearPeriodTotal / (double)this.candleSettings[CandleSettingType.Near.ordinal()].avgPeriod : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))));
            v16 = this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? 2.0 : 1.0;
            if (v13 >= v14 - v15 / v16) {
                outInteger[outIdx++] = 100;
            } else lbl-1000:
            // 5 sources

            {
                outInteger[outIdx++] = 0;
            }
            BodyDojiPeriodTotal += (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[BodyDojiTrailingIdx] - inOpen[BodyDojiTrailingIdx]) : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.HighLow ? inHigh[BodyDojiTrailingIdx] - inLow[BodyDojiTrailingIdx] : (this.candleSettings[CandleSettingType.BodyDoji.ordinal()].rangeType == RangeType.Shadows ? inHigh[BodyDojiTrailingIdx] - (inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inClose[BodyDojiTrailingIdx] : inOpen[BodyDojiTrailingIdx]) + ((inClose[BodyDojiTrailingIdx] >= inOpen[BodyDojiTrailingIdx] ? inOpen[BodyDojiTrailingIdx] : inClose[BodyDojiTrailingIdx]) - inLow[BodyDojiTrailingIdx]) : 0.0)));
            ShadowLongPeriodTotal += (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[ShadowLongTrailingIdx] - inOpen[ShadowLongTrailingIdx]) : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.HighLow ? inHigh[ShadowLongTrailingIdx] - inLow[ShadowLongTrailingIdx] : (this.candleSettings[CandleSettingType.ShadowLong.ordinal()].rangeType == RangeType.Shadows ? inHigh[ShadowLongTrailingIdx] - (inClose[ShadowLongTrailingIdx] >= inOpen[ShadowLongTrailingIdx] ? inClose[ShadowLongTrailingIdx] : inOpen[ShadowLongTrailingIdx]) + ((inClose[ShadowLongTrailingIdx] >= inOpen[ShadowLongTrailingIdx] ? inOpen[ShadowLongTrailingIdx] : inClose[ShadowLongTrailingIdx]) - inLow[ShadowLongTrailingIdx]) : 0.0)));
            NearPeriodTotal += (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[i] - inOpen[i]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[i] - inLow[i] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[i] - (inClose[i] >= inOpen[i] ? inClose[i] : inOpen[i]) + ((inClose[i] >= inOpen[i] ? inOpen[i] : inClose[i]) - inLow[i]) : 0.0))) - (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.RealBody ? Math.abs(inClose[NearTrailingIdx] - inOpen[NearTrailingIdx]) : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.HighLow ? inHigh[NearTrailingIdx] - inLow[NearTrailingIdx] : (this.candleSettings[CandleSettingType.Near.ordinal()].rangeType == RangeType.Shadows ? inHigh[NearTrailingIdx] - (inClose[NearTrailingIdx] >= inOpen[NearTrailingIdx] ? inClose[NearTrailingIdx] : inOpen[NearTrailingIdx]) + ((inClose[NearTrailingIdx] >= inOpen[NearTrailingIdx] ? inOpen[NearTrailingIdx] : inClose[NearTrailingIdx]) - inLow[NearTrailingIdx]) : 0.0)));
            ++BodyDojiTrailingIdx;
            ++ShadowLongTrailingIdx;
            ++NearTrailingIdx;
        } while (++i <= endIdx);
        outNBElement.value = outIdx;
        outBegIdx.value = startIdx;
        return RetCode.Success;
    }

    /*
     * Unable to fully structure code
     */
    public RetCode cdlRickshawMan(int startIdx, int endIdx, float[] inOpen, float[] inHigh, float[] inLow, float[] inClose, MInteger outBegIdx, MInteger outNBElement, int[] outInteger) {
        if (startIdx < 0) {
            return RetCode.OutOfRangeStartIndex;
        }
        if (endIdx < 0 || endIdx < startIdx) {
            return RetCode.OutOfRangeEndIndex;
        }
        lookbackTotal = this.cdlRickshawManLookback();
        if (startIdx < lookbackTotal) {
            startIdx = lookbackTotal;
        }
        if (startIdx > endIdx) {
            outBegIdx.value = 0;
            outNBElement.value = 0;
            return RetCode.Success;
        }
        BodyDojiPeriodT