/*
 * Decompiled with CFR 0.152.
 */
package com.boxysystems.jgoogleanalytics;

import com.boxysystems.jgoogleanalytics.FocusPoint;
import com.boxysystems.jgoogleanalytics.GoogleAnalytics_v1_URLBuildingStrategy;
import com.boxysystems.jgoogleanalytics.HTTPGetMethod;
import com.boxysystems.jgoogleanalytics.LoggingAdapter;
import com.boxysystems.jgoogleanalytics.URLBuildingStrategy;

public class JGoogleAnalyticsTracker {
    private URLBuildingStrategy urlBuildingStrategy = null;
    private HTTPGetMethod httpRequest = new HTTPGetMethod();
    private LoggingAdapter loggingAdapter;

    public JGoogleAnalyticsTracker(String appName, String googleAnalyticsTrackingCode) {
        this.urlBuildingStrategy = new GoogleAnalytics_v1_URLBuildingStrategy(appName, googleAnalyticsTrackingCode);
    }

    public JGoogleAnalyticsTracker(String appName, String appVersion, String googleAnalyticsTrackingCode) {
        this.urlBuildingStrategy = new GoogleAnalytics_v1_URLBuildingStrategy(appName, appVersion, googleAnalyticsTrackingCode);
    }

    public void setUrlBuildingStrategy(URLBuildingStrategy urlBuildingStrategy) {
        this.urlBuildingStrategy = urlBuildingStrategy;
    }

    public void setLoggingAdapter(LoggingAdapter loggingAdapter) {
        this.loggingAdapter = loggingAdapter;
        this.httpRequest.setLoggingAdapter(loggingAdapter);
    }

    public void trackSynchronously(FocusPoint focusPoint) {
        this.logMessage("JGoogleAnalytics: Tracking synchronously focusPoint=" + focusPoint.getContentTitle());
        this.httpRequest.request(this.urlBuildingStrategy.buildURL(focusPoint));
    }

    public void trackAsynchronously(FocusPoint focusPoint) {
        this.logMessage("JGoogleAnalytics: Tracking Asynchronously focusPoint=" + focusPoint.getContentTitle());
        new TrackingThread(focusPoint).start();
    }

    private void logMessage(String message) {
        if (this.loggingAdapter != null) {
            this.loggingAdapter.logMessage(message);
        }
    }

    private class TrackingThread
    extends Thread {
        private FocusPoint focusPoint;

        public TrackingThread(FocusPoint focusPoint) {
            this.focusPoint = focusPoint;
            this.setPriority(1);
        }

        public void run() {
            JGoogleAnalyticsTracker.this.httpRequest.request(JGoogleAnalyticsTracker.this.urlBuildingStrategy.buildURL(this.focusPoint));
        }
    }
}

