/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.odg.io;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.IXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLException;
import net.n3.nanoxml.XMLParserFactory;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.samples.odg.ODGAttributeKeys;
import org.jhotdraw.samples.odg.ODGConstants;

public class ODGStylesReader {
    private static final boolean DEBUG = false;
    private HashMap<String, Style> commonStyles;
    private HashMap<String, Style> masterStyles;
    private HashMap<String, Style> automaticStyles;

    public ODGStylesReader() {
        this.reset();
    }

    public Map<AttributeKey, Object> getAttributes(String styleName, String familyName) {
        String key = styleName;
        Style style = this.commonStyles.containsKey(key) ? this.commonStyles.get(key) : (this.automaticStyles.containsKey(key) ? this.automaticStyles.get(key) : (this.masterStyles.containsKey(key) ? this.masterStyles.get(key) : new Style()));
        if (style.parentName == null) {
            return style;
        }
        HashMap<AttributeKey, Object> a = new HashMap<AttributeKey, Object>();
        Map<AttributeKey, Object> parentAttributes = this.getAttributes(style.parentName, familyName);
        a.putAll(parentAttributes);
        a.putAll(style);
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(File file) throws IOException {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            this.read(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public void read(InputStream in) throws IOException {
        IXMLElement document;
        IXMLParser parser;
        try {
            parser = XMLParserFactory.createDefaultXMLParser();
        }
        catch (Exception ex) {
            InternalError e = new InternalError("Unable to instantiate NanoXML Parser");
            e.initCause(ex);
            throw e;
        }
        StdXMLReader reader = new StdXMLReader(in);
        parser.setReader(reader);
        try {
            document = (IXMLElement)parser.parse();
        }
        catch (XMLException ex) {
            IOException e = new IOException(ex.getMessage());
            e.initCause(ex);
            throw e;
        }
        this.read(document);
    }

    private void reset() {
        this.commonStyles = new HashMap();
        this.automaticStyles = new HashMap();
        this.masterStyles = new HashMap();
    }

    public void read(IXMLElement root) throws IOException {
        String name = root.getName();
        String ns = root.getNamespace();
        if (name.equals("document-content") && (ns == null || ns.equals("urn:oasis:names:tc:opendocument:xmlns:office:1.0"))) {
            this.readDocumentContentElement(root);
        } else if (name.equals("document-styles") && (ns == null || ns.equals("urn:oasis:names:tc:opendocument:xmlns:office:1.0"))) {
            this.readDocumentStylesElement(root);
        }
    }

    private void readDefaultStyleElement(IXMLElement elem, HashMap<String, Style> styles) throws IOException {
        String styleName = elem.getAttribute("family", "urn:oasis:names:tc:opendocument:xmlns:style:1.0", null);
        String family = elem.getAttribute("family", "urn:oasis:names:tc:opendocument:xmlns:style:1.0", null);
        String parentStyleName = elem.getAttribute("parent-style-name", "urn:oasis:names:tc:opendocument:xmlns:style:1.0", null);
        if (styleName != null) {
            Style a = styles.get(styleName);
            if (a == null) {
                a = new Style();
                a.name = styleName;
                a.family = family;
                a.parentName = parentStyleName;
                styles.put(styleName, a);
            }
            for (IXMLElement child : elem.getChildren()) {
                String ns = child.getNamespace();
                String name = child.getName();
                if (name.equals("drawing-page-properties") && (ns == null || ns.equals("urn:oasis:names:tc:opendocument:xmlns:style:1.0"))) {
                    this.readDrawingPagePropertiesElement(child, a);
                    continue;
                }
                if (name.equals("graphic-properties") && (ns == null || ns.equals("urn:oasis:names:tc:opendocument:xmlns:style:1.0"))) {
                    this.readGraphicPropertiesElement(child, a);
                    continue;
                }
                if (name.equals("paragraph-properties") && (ns == null || ns.equals("urn:oasis:names:tc:opendocument:xmlns:style:1.0"))) {
                    this.readParagraphPropertiesElement(child, a);
                    continue;
                }
                if (!name.equals("text-properties") || ns != null && !ns.equals("urn:oasis:names:tc:opendocument:xmlns:style:1.0")) continue;
                this.readTextPropertiesElement(child, a);
            }
        }
    }

    private void readDocumentContentElement(IXMLElement elem) throws IOException {
        for (IXMLElement child : elem.getChildren()) {
            String ns = child.getNamespace();
            String name = child.getName();
            if (name.equals("automatic-styles") && (ns == null || ns.equals("urn:oasis:names:tc:opendocument:xmlns:office:1.0"))) {
                this.readAutomaticStylesElement(child);
                continue;
            }
            if (name.equals("master-styles") && (ns == null || ns.equals("urn:oasis:names:tc:opendocument:xmlns:office:1.0"))) {
                this.readStylesElement(child);
                continue;
            }
            if (!name.equals("styles") || ns != null && !ns.equals("urn:oasis:names:tc:opendocument:xmlns:office:1.0")) continue;
            this.readStylesElement(child);
        }
    }

    private void readDocumentStylesElement(IXMLElement elem) throws IOException {
        for (IXMLElement child : elem.getChildren()) {
            String ns = child.getNamespace();
            String name = child.getName();
            if (name.equals("styles") && (ns == null || ns.equals("urn:oasis:names:tc:opendocument:xmlns:office:1.0"))) {
                this.readStylesElement(child);
                continue;
            }
            if (name.equals("automatic-styles") && (ns == null || ns.equals("urn:oasis:names:tc:opendocument:xmlns:office:1.0"))) {
                this.readAutomaticStylesElement(child);
                continue;
            }
            if (!name.equals("master-styles") || ns != null && !ns.equals("urn:oasis:names:tc:opendocument:xmlns:office:1.0")) continue;
            this.readMasterStylesElement(child);
        }
    }

    private void readDrawingPagePropertiesElement(IXMLElement elem, HashMap<AttributeKey, Object> a) throws IOException {
    }

    private void readGraphicPropertiesElement(IXMLElement elem, HashMap<AttributeKey, Object> a) throws IOException {
        if (elem.hasAttribute("stroke", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0")) {
            ODGAttributeKeys.STROKE_STYLE.set(a, (ODGConstants.StrokeStyle)((Object)elem.getAttribute("stroke", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", ODGConstants.STROKE_STYLES, null)));
        }
        if (elem.hasAttribute("stroke-width", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0")) {
            ODGAttributeKeys.STROKE_WIDTH.set(a, Double.valueOf(this.toLength(elem.getAttribute("stroke-width", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", null))));
        }
        if (elem.hasAttribute("stroke-color", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0")) {
            ODGAttributeKeys.STROKE_COLOR.set(a, this.toColor(elem.getAttribute("stroke-color", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", null)));
        }
        if (elem.hasAttribute("fill", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0")) {
            ODGAttributeKeys.FILL_STYLE.set(a, (ODGConstants.FillStyle)((Object)elem.getAttribute("fill", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", ODGConstants.FILL_STYLES, null)));
        }
        if (elem.hasAttribute("fill-color", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0")) {
            ODGAttributeKeys.FILL_COLOR.set(a, this.toColor(elem.getAttribute("fill-color", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", null)));
        }
        for (IXMLElement child : elem.getChildren()) {
            String ns = child.getNamespace();
            String name = child.getName();
        }
    }

    private void readStyleElement(IXMLElement elem, HashMap<String, Style> styles) throws IOException {
        String styleName = elem.getAttribute("name", "urn:oasis:names:tc:opendocument:xmlns:style:1.0", null);
        String family = elem.getAttribute("family", "urn:oasis:names:tc:opendocument:xmlns:style:1.0", null);
        String parentStyleName = elem.getAttribute("parent-style-name", "urn:oasis:names:tc:opendocument:xmlns:style:1.0", null);
        if (styleName != null) {
            Style a = styles.get(styleName);
            if (a == null) {
                a = new Style();
                a.name = styleName;
                a.family = family;
                a.parentName = parentStyleName;
                styles.put(styleName, a);
            }
            for (IXMLElement child : elem.getChildren()) {
                String ns = child.getNamespace();
                String name = child.getName();
                if (name.equals("drawing-page-properties") && (ns == null || ns.equals("urn:oasis:names:tc:opendocument:xmlns:style:1.0"))) {
                    this.readDrawingPagePropertiesElement(child, a);
                    continue;
                }
                if (name.equals("graphic-properties") && (ns == null || ns.equals("urn:oasis:names:tc:opendocument:xmlns:style:1.0"))) {
                    this.readGraphicPropertiesElement(child, a);
                    continue;
                }
                if (name.equals("paragraph-properties") && (ns == null || ns.equals("urn:oasis:names:tc:opendocument:xmlns:style:1.0"))) {
                    this.readParagraphPropertiesElement(child, a);
                    continue;
                }
                if (!name.equals("text-properties") || ns != null && !ns.equals("urn:oasis:names:tc:opendocument:xmlns:style:1.0")) continue;
                this.readTextPropertiesElement(child, a);
            }
        }
    }

    private void readStylesElement(IXMLElement elem) throws IOException {
        this.readStylesChildren(elem, this.commonStyles);
    }

    private void readStylesChildren(IXMLElement elem, HashMap<String, Style> styles) throws IOException {
        for (IXMLElement child : elem.getChildren()) {
            String ns = child.getNamespace();
            String name = child.getName();
            if (name.equals("default-style") && (ns == null || ns.equals("urn:oasis:names:tc:opendocument:xmlns:style:1.0"))) {
                this.readDefaultStyleElement(child, styles);
                continue;
            }
            if (name.equals("layer-set") && (ns == null || ns.equals("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0"))) {
                this.readLayerSetElement(child, styles);
                continue;
            }
            if (name.equals("list-style") && (ns == null || ns.equals("urn:oasis:names:tc:opendocument:xmlns:text:1.0"))) {
                this.readListStyleElement(child, styles);
                continue;
            }
            if (name.equals("marker") && (ns == null || ns.equals("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0"))) {
                this.readMarkerElement(child, styles);
                continue;
            }
            if (name.equals("master-page") && (ns == null || ns.equals("urn:oasis:names:tc:opendocument:xmlns:style:1.0"))) {
                this.readMasterPageElement(child, styles);
                continue;
            }
            if (name.equals("page-layout") && (ns == null || ns.equals("urn:oasis:names:tc:opendocument:xmlns:style:1.0"))) {
                this.readPageLayoutElement(child, styles);
                continue;
            }
            if (!name.equals("style") || ns != null && !ns.equals("urn:oasis:names:tc:opendocument:xmlns:style:1.0")) continue;
            this.readStyleElement(child, styles);
        }
    }

    private void readAutomaticStylesElement(IXMLElement elem) throws IOException {
        this.readStylesChildren(elem, this.automaticStyles);
    }

    private void readLayerSetElement(IXMLElement elem, HashMap<String, Style> styles) throws IOException {
    }

    private void readListStyleElement(IXMLElement elem, HashMap<String, Style> styles) throws IOException {
    }

    private void readMasterStylesElement(IXMLElement elem) throws IOException {
        this.readStylesChildren(elem, this.masterStyles);
    }

    private void readMarkerElement(IXMLElement elem, HashMap<String, Style> styles) throws IOException {
    }

    private void readMasterPageElement(IXMLElement elem, HashMap<String, Style> styles) throws IOException {
    }

    private void readPageLayoutElement(IXMLElement elem, HashMap<String, Style> styles) throws IOException {
    }

    private void readParagraphPropertiesElement(IXMLElement elem, HashMap<AttributeKey, Object> a) throws IOException {
    }

    private void readTextPropertiesElement(IXMLElement elem, HashMap<AttributeKey, Object> a) throws IOException {
    }

    private double toLength(String str) throws IOException {
        double scaleFactor = 1.0;
        if (str == null || str.length() == 0) {
            return 0.0;
        }
        if (str.endsWith("cm")) {
            str = str.substring(0, str.length() - 2);
            scaleFactor = 35.43307;
        } else if (str.endsWith("mm")) {
            str = str.substring(0, str.length() - 2);
            scaleFactor = 3.543307;
        } else if (str.endsWith("in")) {
            str = str.substring(0, str.length() - 2);
            scaleFactor = 90.0;
        } else if (str.endsWith("pt")) {
            str = str.substring(0, str.length() - 2);
            scaleFactor = 1.25;
        } else if (str.endsWith("pc")) {
            str = str.substring(0, str.length() - 2);
            scaleFactor = 15.0;
        } else if (str.endsWith("px")) {
            str = str.substring(0, str.length() - 2);
        }
        return Double.parseDouble(str) * scaleFactor;
    }

    private Color toColor(String value) throws IOException {
        String str = value;
        if (str == null) {
            return null;
        }
        if (str.startsWith("#") && str.length() == 7) {
            return new Color(Integer.decode(str));
        }
        return null;
    }

    private static class Style
    extends HashMap<AttributeKey, Object> {
        public String name;
        public String family;
        public String parentName;

        private Style() {
        }
    }
}

