/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.Point2D;
import java.awt.image.ImageProducer;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.ImageHolderFigure;
import org.jhotdraw.draw.InputFormat;
import org.jhotdraw.io.ExtensionFileFilter;
import org.jhotdraw.util.Images;

public class PictImageInputFormat
implements InputFormat {
    private ImageHolderFigure prototype;
    private String description;
    private String fileExtension;
    private String formatName;
    private int imageType;
    public static final DataFlavor PICT_FLAVOR;

    public PictImageInputFormat(ImageHolderFigure prototype) {
        this(prototype, "PICT", "PICT (pct)", "pct", 2);
    }

    private PictImageInputFormat(ImageHolderFigure prototype, String formatName, String description, String fileExtension, int bufferedImageType) {
        this.prototype = prototype;
        this.formatName = formatName;
        this.description = description;
        this.fileExtension = fileExtension;
        this.imageType = bufferedImageType;
    }

    @Override
    public FileFilter getFileFilter() {
        return new ExtensionFileFilter(this.description, this.fileExtension);
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    @Override
    public JComponent getInputFormatAccessory() {
        return null;
    }

    @Override
    public void read(File file, Drawing drawing) throws IOException {
        this.read(file, drawing, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(File file, Drawing drawing, boolean replace) throws IOException {
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            Image img = PictImageInputFormat.getImageFromPictStream(in);
            if (img == null) {
                throw new IOException("Couldn't read pict image");
            }
            ImageHolderFigure figure = (ImageHolderFigure)this.prototype.clone();
            figure.setBufferedImage(Images.toBufferedImage(img));
            figure.setBounds(new Point2D.Double(0.0, 0.0), new Point2D.Double(figure.getBufferedImage().getWidth(), figure.getBufferedImage().getHeight()));
            if (replace) {
                drawing.removeAllChildren();
            }
            drawing.basicAdd(figure);
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(InputStream in, Drawing drawing, boolean replace) throws IOException {
        try {
            Image img = PictImageInputFormat.getImageFromPictStream(in);
            if (img == null) {
                throw new IOException("Couldn't read pict image");
            }
            ImageHolderFigure figure = (ImageHolderFigure)this.prototype.clone();
            figure.setBufferedImage(Images.toBufferedImage(img));
            figure.setBounds(new Point2D.Double(0.0, 0.0), new Point2D.Double(figure.getBufferedImage().getWidth(), figure.getBufferedImage().getHeight()));
            if (replace) {
                drawing.removeAllChildren();
            }
            drawing.basicAdd(figure);
        }
        finally {
            in.close();
        }
    }

    public ImageHolderFigure createImageHolder(InputStream in) throws IOException {
        ImageHolderFigure figure = (ImageHolderFigure)this.prototype.clone();
        figure.setBufferedImage(Images.toBufferedImage(PictImageInputFormat.getImageFromPictStream(in)));
        figure.setBounds(new Point2D.Double(0.0, 0.0), new Point2D.Double(figure.getBufferedImage().getWidth(), figure.getBufferedImage().getHeight()));
        return figure;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(PICT_FLAVOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(Transferable t, Drawing drawing, boolean replace) throws UnsupportedFlavorException, IOException {
        Object data = t.getTransferData(PICT_FLAVOR);
        if (data instanceof InputStream) {
            InputStream in = null;
            try {
                in = (InputStream)data;
                Image img = PictImageInputFormat.getImageFromPictStream(in);
                if (img == null) {
                    throw new IOException("Couldn't read pict image");
                }
                ImageHolderFigure figure = (ImageHolderFigure)this.prototype.clone();
                figure.setBufferedImage(Images.toBufferedImage(img));
                figure.setBounds(new Point2D.Double(0.0, 0.0), new Point2D.Double(figure.getBufferedImage().getWidth(), figure.getBufferedImage().getHeight()));
                if (replace) {
                    drawing.removeAllChildren();
                }
                drawing.add(figure);
            }
            finally {
                in.close();
            }
        }
    }

    private static Image getImageFromPictStream(InputStream is) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] header = new byte[512];
            byte[] buf = new byte[4096];
            int retval = 0;
            int size = 0;
            baos.write(header, 0, 512);
            while ((retval = is.read(buf, 0, 4096)) > 0) {
                baos.write(buf, 0, retval);
            }
            baos.close();
            size = baos.size();
            if (size <= 0) {
                return null;
            }
            byte[] imgBytes = baos.toByteArray();
            Class<?> c = Class.forName("quicktime.QTSession");
            Method m = c.getMethod("isInitialized", new Class[0]);
            Boolean b = (Boolean)m.invoke(null, (Object[])null);
            if (!b.booleanValue()) {
                m = c.getMethod("open", new Class[0]);
                m.invoke(null, new Object[0]);
            }
            c = Class.forName("quicktime.util.QTHandle");
            Constructor<?> con = c.getConstructor(imgBytes.getClass());
            Object handle = con.newInstance(new Object[]{imgBytes});
            String s = new String("PICT");
            c = Class.forName("quicktime.util.QTUtils");
            m = c.getMethod("toOSType", s.getClass());
            Integer type = (Integer)m.invoke(null, s);
            c = Class.forName("quicktime.std.image.GraphicsImporter");
            Class[] classArray = new Class[1];
            classArray[0] = Integer.TYPE;
            con = c.getConstructor(classArray);
            Object importer = con.newInstance(type);
            m = c.getMethod("setDataHandle", Class.forName("quicktime.util.QTHandleRef"));
            m.invoke(importer, handle);
            m = c.getMethod("getNaturalBounds", new Class[0]);
            Object rect = m.invoke(importer, new Object[0]);
            c = Class.forName("quicktime.app.view.GraphicsImporterDrawer");
            con = c.getConstructor(importer.getClass());
            Object iDrawer = con.newInstance(importer);
            m = rect.getClass().getMethod("getWidth", new Class[0]);
            Integer width = (Integer)m.invoke(rect, new Object[0]);
            m = rect.getClass().getMethod("getHeight", new Class[0]);
            Integer height = (Integer)m.invoke(rect, new Object[0]);
            Dimension d = new Dimension(width, height);
            c = Class.forName("quicktime.app.view.QTImageProducer");
            con = c.getConstructor(iDrawer.getClass(), d.getClass());
            Object producer = con.newInstance(iDrawer, d);
            if (producer instanceof ImageProducer) {
                return Toolkit.getDefaultToolkit().createImage((ImageProducer)producer);
            }
        }
        catch (Exception e) {
            IOException error = new IOException("Couldn't read PICT image");
            error.initCause(e);
            throw error;
        }
        IOException error = new IOException("Couldn't read PICT image");
        throw error;
    }

    static {
        try {
            PICT_FLAVOR = new DataFlavor("image/x-pict");
        }
        catch (ClassNotFoundException e) {
            throw new InternalError("Unable to create data flavor image/x-pict");
        }
    }
}

