/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.color;

import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import javax.swing.BoundedRangeModel;
import org.jhotdraw.color.ColorSliderModel;
import org.jhotdraw.color.ColorSystem;
import org.jhotdraw.color.DefaultColorSliderModel;
import org.jhotdraw.color.RGBColorSystem;

public class ColorTrackImageProducer
extends MemoryImageSource {
    private int[] pixels;
    private int w;
    private int h;
    private float[] baseComponents;
    private int component;
    private int trackBuffer;
    private ColorSliderModel colorizer = new DefaultColorSliderModel(new RGBColorSystem());
    private boolean isDirty = true;
    private int componentIndex = 0;
    private boolean isHorizontal;

    public ColorTrackImageProducer(int w, int h, int trackBuffer, boolean isHorizontal) {
        super(w, h, null, 0, w);
        this.pixels = new int[w * h];
        this.w = w;
        this.h = h;
        this.trackBuffer = trackBuffer % 2 == 1 ? trackBuffer - 1 : trackBuffer;
        this.componentIndex = this.componentIndex;
        this.isHorizontal = isHorizontal;
        this.newPixels(this.pixels, (ColorModel)new DirectColorModel(24, 0xFF0000, 65280, 255), 0, w);
        this.setAnimated(true);
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public void markAsDirty() {
        this.isDirty = true;
    }

    public boolean needsGeneration() {
        return this.isDirty;
    }

    public void regenerateColorTrack() {
        if (this.isDirty) {
            this.generateColorTrack();
        }
    }

    public void generateColorTrack() {
        if (this.isHorizontal) {
            this.generateHorizontalColorTrack();
        } else {
            this.generateVerticalColorTrack();
        }
        this.newPixels();
        this.isDirty = false;
    }

    private void generateHorizontalColorTrack() {
        int x;
        float[] components = this.colorizer.getCompositeColor().getComponents();
        ColorSystem sys = this.colorizer.getColorSystem();
        int offset = this.trackBuffer / 2;
        int n = this.w - this.trackBuffer - 1;
        for (x = 0; x <= n; ++x) {
            components[this.componentIndex] = (float)x / (float)n;
            this.pixels[x + offset] = sys.toRGB(components);
        }
        for (x = 0; x < offset; ++x) {
            this.pixels[x] = this.pixels[offset];
            this.pixels[this.w - x - 1] = this.pixels[this.w - offset - 1];
        }
        n = this.w * this.h;
        for (int y = this.w; y < n; y += this.w) {
            System.arraycopy(this.pixels, 0, this.pixels, y, this.w);
        }
    }

    private void generateVerticalColorTrack() {
        int y;
        float[] components = this.colorizer.getCompositeColor().getComponents();
        ColorSystem sys = this.colorizer.getColorSystem();
        int offset = this.trackBuffer / 2;
        int n = this.h - this.trackBuffer - 1;
        for (y = 0; y <= n; ++y) {
            components[this.componentIndex] = 1.0f - (float)y / (float)n;
            this.pixels[(y + offset) * this.w] = sys.toRGB(components);
        }
        for (y = 0; y < offset; ++y) {
            this.pixels[y * this.w] = this.pixels[offset * this.w];
            this.pixels[(this.h - y - 1) * this.w] = this.pixels[(this.h - offset - 1) * this.w];
        }
        for (int x = 1; x < this.w; ++x) {
            int n2 = this.w * this.h;
            for (int y2 = 0; y2 < n2; y2 += this.w) {
                this.pixels[x + y2] = this.pixels[x - 1 + y2];
            }
        }
    }

    public void setBaseComponents(BoundedRangeModel[] components) {
        this.isDirty = true;
        for (int i = 0; i < components.length; ++i) {
            this.baseComponents[i] = (float)components[i].getValue() / (float)components[i].getMaximum();
        }
    }

    public void setColorSliderModel(ColorSliderModel colorizer) {
        this.colorizer = colorizer;
        this.isDirty = true;
    }

    public void setColorComponentIndex(int index) {
        this.componentIndex = index;
        this.isDirty = true;
    }

    public void componentChanged(int index) {
        this.isDirty |= this.componentIndex != index;
    }
}

