/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.spans.ContainSpans;
import org.apache.lucene.search.spans.SpanContainQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;

public class SpanContainingQuery
extends SpanContainQuery {
    public SpanContainingQuery(SpanQuery big, SpanQuery little) {
        super(big, little, big.getBoost());
    }

    @Override
    public String toString(String field) {
        return this.toString(field, "SpanContaining");
    }

    @Override
    public SpanContainingQuery clone() {
        return new SpanContainingQuery((SpanQuery)this.big.clone(), (SpanQuery)this.little.clone());
    }

    @Override
    public Spans getSpans(LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        ArrayList<Spans> containerContained = this.prepareConjunction(context, acceptDocs, termContexts);
        if (containerContained == null) {
            return null;
        }
        Spans big = containerContained.get(0);
        Spans little = containerContained.get(1);
        return new ContainSpans(big, little, big){

            @Override
            boolean twoPhaseCurrentDocMatches() throws IOException {
                this.oneExhaustedInCurrentDoc = false;
                assert (this.littleSpans.startPosition() == -1);
                while (this.bigSpans.nextStartPosition() != Integer.MAX_VALUE) {
                    while (this.littleSpans.startPosition() < this.bigSpans.startPosition()) {
                        if (this.littleSpans.nextStartPosition() != Integer.MAX_VALUE) continue;
                        this.oneExhaustedInCurrentDoc = true;
                        return false;
                    }
                    if (this.bigSpans.endPosition() < this.littleSpans.endPosition()) continue;
                    this.atFirstInCurrentDoc = true;
                    return true;
                }
                this.oneExhaustedInCurrentDoc = true;
                return false;
            }

            @Override
            public int nextStartPosition() throws IOException {
                if (this.atFirstInCurrentDoc) {
                    this.atFirstInCurrentDoc = false;
                    return this.bigSpans.startPosition();
                }
                while (this.bigSpans.nextStartPosition() != Integer.MAX_VALUE) {
                    while (this.littleSpans.startPosition() < this.bigSpans.startPosition()) {
                        if (this.littleSpans.nextStartPosition() != Integer.MAX_VALUE) continue;
                        this.oneExhaustedInCurrentDoc = true;
                        return Integer.MAX_VALUE;
                    }
                    if (this.bigSpans.endPosition() < this.littleSpans.endPosition()) continue;
                    return this.bigSpans.startPosition();
                }
                this.oneExhaustedInCurrentDoc = true;
                return Integer.MAX_VALUE;
            }
        };
    }
}

