/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.history;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.auth.ActivityRecord;
import org.apache.guacamole.net.auth.ActivityRecordSet;
import org.apache.guacamole.net.auth.ConnectionRecord;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.rest.history.APIActivityRecord;
import org.apache.guacamole.rest.history.APIConnectionRecord;
import org.apache.guacamole.rest.history.APISortPredicate;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class HistoryResource {
    private static final int MAXIMUM_HISTORY_SIZE = 1000;
    private final UserContext userContext;

    public HistoryResource(UserContext userContext) {
        this.userContext = userContext;
    }

    @GET
    @Path(value="connections")
    public List<APIConnectionRecord> getConnectionHistory(@QueryParam(value="contains") List<String> requiredContents, @QueryParam(value="order") List<APISortPredicate> sortPredicates) throws GuacamoleException {
        ActivityRecordSet history = this.userContext.getConnectionHistory();
        for (String required : requiredContents) {
            if (required.isEmpty()) continue;
            history = history.contains(required);
        }
        for (APISortPredicate predicate : sortPredicates) {
            history = history.sort(predicate.getProperty(), predicate.isDescending());
        }
        history = history.limit(1000);
        ArrayList<APIConnectionRecord> apiRecords = new ArrayList<APIConnectionRecord>();
        for (ConnectionRecord record : history.asCollection()) {
            apiRecords.add(new APIConnectionRecord(record));
        }
        return apiRecords;
    }

    @GET
    @Path(value="users")
    public List<APIActivityRecord> getUserHistory(@QueryParam(value="contains") List<String> requiredContents, @QueryParam(value="order") List<APISortPredicate> sortPredicates) throws GuacamoleException {
        ActivityRecordSet history = this.userContext.getUserHistory();
        for (String required : requiredContents) {
            if (required.isEmpty()) continue;
            history = history.contains(required);
        }
        for (APISortPredicate predicate : sortPredicates) {
            history = history.sort(predicate.getProperty(), predicate.isDescending());
        }
        history = history.limit(1000);
        ArrayList<APIActivityRecord> apiRecords = new ArrayList<APIActivityRecord>();
        for (ActivityRecord record : history.asCollection()) {
            apiRecords.add(new APIActivityRecord(record));
        }
        return apiRecords;
    }
}

