/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo.identity;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jdo.identity.SingleFieldIdentity;

public class LongIdentity
extends SingleFieldIdentity {
    private long key;

    private void construct(long l2) {
        this.key = l2;
        this.hashCode = this.hashClassName() ^ (int)l2;
    }

    public LongIdentity(Class clazz, long l2) {
        super(clazz);
        this.construct(l2);
    }

    public LongIdentity(Class clazz, Long l2) {
        super(clazz);
        this.setKeyAsObject(l2);
        this.construct(l2);
    }

    public LongIdentity(Class clazz, String string) {
        super(clazz);
        this.assertKeyNotNull(string);
        this.construct(Long.parseLong(string));
    }

    public LongIdentity() {
    }

    public long getKey() {
        return this.key;
    }

    public String toString() {
        return Long.toString(this.key);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        LongIdentity longIdentity = (LongIdentity)object;
        return this.key == longIdentity.key;
    }

    public int compareTo(Object object) {
        if (object instanceof LongIdentity) {
            LongIdentity longIdentity = (LongIdentity)object;
            int n = super.compare(longIdentity);
            if (n == 0) {
                long l2 = this.key - longIdentity.key;
                if (l2 == 0L) {
                    return 0;
                }
                if (l2 < 0L) {
                    return -1;
                }
                return 1;
            }
            return n;
        }
        if (object == null) {
            throw new ClassCastException("object is null");
        }
        throw new ClassCastException(this.getClass().getName() + " != " + object.getClass().getName());
    }

    protected Object createKeyAsObject() {
        return new Long(this.key);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeLong(this.key);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.key = objectInput.readLong();
    }
}

