/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsUtils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalToolTipUI;
import javax.swing.text.View;

public class PgsToolTipUI
extends MetalToolTipUI {
    private Font smallFont;

    public static ComponentUI createUI(JComponent c) {
        return new PgsToolTipUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        Font f = c.getFont();
        this.smallFont = new Font(f.getName(), f.getStyle(), f.getSize() - 2);
        c.putClientProperty("gradientStart", UIManager.getColor("Tooltip.gradientStart"));
        c.putClientProperty("gradientEnd", UIManager.getColor("Tooltip.gradientEnd"));
    }

    @Override
    public final void paint(Graphics g, JComponent c) {
        PgsUtils.installAntialiasing(g);
        JToolTip tip = (JToolTip)c;
        Dimension size = c.getSize();
        super.paint(g, c);
        PgsUtils.drawGradient(g, c);
        Font font = c.getFont();
        FontMetrics metrics = c.getFontMetrics(font);
        String keyText = this.getAcceleratorString();
        String tipText = tip.getTipText();
        if (tipText == null) {
            tipText = "";
        }
        g.setColor(c.getForeground());
        Insets insets = c.getInsets();
        Rectangle paintTextR = new Rectangle(insets.left, insets.top, size.width - (insets.left + insets.right), size.height - (insets.top + insets.bottom));
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            v.paint(g, paintTextR);
        } else {
            g.drawString(tipText, paintTextR.x + 3, paintTextR.y + metrics.getAscent());
        }
        if (!keyText.equals("")) {
            g.setFont(this.smallFont);
            g.setColor(MetalLookAndFeel.getBlack());
            g.drawString(keyText, metrics.stringWidth(tipText) + 12, 2 + metrics.getAscent());
        }
        PgsUtils.uninstallAntialiasing(g);
    }
}

