/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.crawl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import jlibs.core.io.ByteArrayOutputStream2;
import jlibs.core.io.FileNavigator;
import jlibs.core.io.FileUtil;
import jlibs.core.lang.ByteSequence;
import jlibs.core.lang.OS;
import jlibs.core.net.URLUtil;
import jlibs.xml.sax.SAXUtil;
import jlibs.xml.sax.crawl.CrawlerListener;
import jlibs.xml.sax.crawl.CrawlingRules;
import jlibs.xml.sax.crawl.DefaultCrawlerListener;
import jlibs.xml.sax.crawl.Element;
import jlibs.xml.xsl.TransformerUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class XMLCrawler
extends XMLFilterImpl {
    private CrawlingRules rules;
    private Element current;
    private int depth;
    private CrawlerListener listener;
    private URL url;
    private File file;
    private DelegatingOutputStream out;
    private Map<URL, File> crawled;

    public XMLCrawler() {
        this.rules = CrawlingRules.defaultRules();
        this.crawled = new HashMap<URL, File>();
    }

    public XMLCrawler(CrawlingRules rules) {
        this.rules = rules;
        this.crawled = new HashMap<URL, File>();
    }

    private XMLCrawler(XMLCrawler crawler) {
        this.rules = crawler.rules;
        this.crawled = crawler.crawled;
    }

    @Override
    public void startDocument() throws SAXException {
        this.current = this.rules.doc;
        super.startDocument();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes atts) throws SAXException {
        if (this.depth == 0) {
            elem = this.current.findChild(namespaceURI, localName);
            if (elem == null) {
                this.depth = 1;
            } else {
                this.current = elem;
                try {
                    if (this.file == null && this.current.extension != null) {
                        this.setFile(this.listener.toFile(this.url, this.current.extension));
                    }
                    if (this.current.attribute == null || (location = atts.getValue(this.current.attribute.getNamespaceURI(), this.current.attribute.getLocalPart())) == null) ** GOTO lbl27
                    location = URLUtil.toURI((URL)this.url).resolve(location).toString();
                    targetURL = URLUtil.toURL((String)location);
                    targetFile = null;
                    if (this.crawled != null) {
                        targetFile = this.crawled.get(targetURL);
                    }
                    if (targetFile == null && this.listener.doCrawl(targetURL)) {
                        targetFile = new XMLCrawler(this).crawl(new InputSource(location), this.listener, null);
                    }
                    href = targetFile == null ? location : FileNavigator.INSTANCE.getRelativePath(this.file.getParentFile(), targetFile);
                    newAtts = new AttributesImpl(atts);
                    index = atts.getIndex(this.current.attribute.getNamespaceURI(), this.current.attribute.getLocalPart());
                    newAtts.setValue(index, href);
                    atts = newAtts;
                }
                catch (IOException ex) {
                    throw new SAXException(ex);
                }
            }
        } else {
            ++this.depth;
        }
lbl27:
        // 4 sources

        super.startElement(namespaceURI, localName, qualifiedName, atts);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        if (this.depth == 0) {
            this.current = this.current.parent;
        } else {
            --this.depth;
        }
    }

    private void setFile(File file) throws IOException {
        this.file = file;
        this.out.setDelegate(new FileOutputStream(file));
        this.crawled.put(this.url, file);
    }

    public File crawl(InputSource document, CrawlerListener listener, File file) throws IOException {
        if (document.getSystemId() == null) {
            throw new IllegalArgumentException("InputSource without systemID can't be crawled");
        }
        this.listener = listener;
        this.url = URLUtil.toURL((String)document.getSystemId());
        try {
            this.setParent(SAXUtil.newSAXParser(true, false, false).getXMLReader());
            SAXSource source = new SAXSource(this, document);
            this.out = new DelegatingOutputStream();
            if (file != null) {
                this.setFile(file);
            }
            TransformerUtil.newTransformer(null, false, 4, null).transform(source, new StreamResult(this.out));
        }
        catch (SAXException ex) {
            throw new IOException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new IOException(ex);
        }
        catch (TransformerException ex) {
            throw new IOException(ex);
        }
        return this.file;
    }

    public File crawlInto(InputSource document, File dir) throws IOException {
        return this.crawl(document, new DefaultCrawlerListener(dir), null);
    }

    public void crawl(InputSource document, File file) throws IOException {
        this.crawl(document, new DefaultCrawlerListener(file.getParentFile()), file);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("usage: crawl-xml." + (OS.get().isWindows() ? "bat" : "sh") + " <url> <dir>");
            System.exit(1);
        }
        File dir = new File(args[1]);
        FileUtil.mkdirs((File)dir);
        new XMLCrawler().crawlInto(new InputSource(args[0]), dir);
    }

    private static class DelegatingOutputStream
    extends FilterOutputStream {
        public DelegatingOutputStream() {
            super((OutputStream)new ByteArrayOutputStream2());
        }

        public void setDelegate(OutputStream out) throws IOException {
            ByteSequence seq = ((ByteArrayOutputStream2)this.out).toByteSequence();
            out.write(seq.buffer(), seq.offset(), seq.length());
            this.out = out;
        }
    }
}

