/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.async;

import java.io.IOException;
import java.io.Reader;

class SpaceWrappedReader
extends Reader {
    private char[] data;
    private int index = -1;

    public SpaceWrappedReader(char[] data) {
        this.data = data;
    }

    @Override
    public int read(char[] buf, int off, int len) throws IOException {
        if (this.index == this.data.length + 1) {
            return -1;
        }
        int givenOff = off;
        if (this.index == -1) {
            buf[off] = 32;
            ++off;
            --len;
            ++this.index;
        }
        if (len > 0 && this.index < this.data.length) {
            int read = Math.min(this.data.length - this.index, len);
            System.arraycopy(this.data, this.index, buf, off, read);
            off += read;
            this.index += read;
            len -= read;
        }
        if (len > 0 && this.index == this.data.length) {
            buf[off] = 32;
            ++off;
            ++this.index;
        }
        return off - givenOff;
    }

    @Override
    public void close() throws IOException {
        this.index = this.data.length + 1;
    }
}

